#include	"dv_repeater.h"

int     init(int argc, char **argv);
void	NoRespReply(struct dv_header NoResp);
int	from_inet(void);
void	send_inet(void);
void	echo_server_send(struct echo *echo);
void	echo_server_last_ex (void);
void	echo_jitter_flush_ex(void);
void	send_echo (struct echo *echo);
void	send_pkt(void);

extern	char	lastframe[];

extern enum
{
        SKIP,
        SEND_WAIT_SET,
        SEND_WAIT_CHECK,
        HEADER_SET,
        HEADER_SEND_CHECK,
	SEND_PTT_ON,
        VOICE_SEND_CHECK,
        VOICE_SEND,
        SEND_LAST_CHECK,
        SEND_LAST,
        SEND_PTT_OFF
} response_state;

int main(int argc, char **argv)
{
	int	ret;
	struct	timeval	tmp_tm;
	struct	timeval	one_sec;
	struct	timeval	two_sec;

	one_sec.tv_sec = 1;
	one_sec.tv_usec = 0;
	two_sec.tv_sec = 2;
	two_sec.tv_usec = 0;
	memset (echo_server, 0x00, 8);
	struct	echo *echo_next;

	if (init(argc, (char **)argv))
	{
		while (1)
		{
			tv.tv_sec = 0;
			tv.tv_usec = 2000;	/* 2 m sec. */
			FD_ZERO (&rfds);
			FD_SET (in_sd, &rfds);
			if (dvap_sw && dvap_init) FD_SET (dvap_fd, &rfds);
			ret = select (FD_SETSIZE, &rfds, (fd_set *)NULL, (fd_set *)NULL, &tv);
			if (ret < 0)
			{
				time(&cur_time);
				fprintf (log_file, "%24.24s select error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			if (ret > 0)
			{
				if (FD_ISSET (in_sd, &rfds))
				{
					if (!from_inet()) break;
				}
				if (dvap_sw)
				{
					if (FD_ISSET (dvap_fd, &rfds))
					{
						dvap_read();
					}
				}
			}

                	/* read from rig (DV packket) */
			if (node_sw)
			{
				if (cos_check()) gettimeofday(&CosOffTime, NULL);
                		if (status & (HeaderDecodeDone | COS_OnOff)) 
                		{
                        		if (HeaderLength == 0) 
					{
						header_read_from_rig ();
					}
                        		else voice_read_from_rig();
                		}
                		else	/* last frame check */
                		{
				
                        		if (HeaderLength)
                        		{
                                		if (voice_read_from_rig() == 0)
						{
							if (node_last_frame_sw) node_last_frame_send();
							HeaderLength = 0;
							voice_pnt = 0;
							if (gw_resp_sw)
							{
								response_state = SEND_WAIT_SET;
							}	
						}
                        		}
                		}
				send_response();
			}
			if (dvap_sw)
			{
				dvap();
				time (&cur_time);
				if ((cur_time - dvap_keep_alive) >= 2)
						send_keep_alive(); 
			}
			/* device re check */
			if (!(node_sw && dvap_sw))
			{
				time(&cur_time);
				if ((cur_time - re_check) > RECHECK)
				{
					if (!node_sw) node_usb_init();
					if (!dvap_sw) dvap_open();
				}
			}
		
			gettimeofday (&tm1, NULL);
			timersub (&tm1, &InetInTime, &tmp_tm);
			if (timercmp(&tmp_tm, &two_sec,  >)) memset (node_save_frame_id, 0x00, 2);
			send_inet ();	/* sending to INET (dsgwd) */

			echo_next = echo_pnt;
			while (echo_next)
			{
				echo_server_send(echo_next);
				echo_next = echo_next->next;
			}
			
			timersub (&tm1, &CosOffTime, &tmp_tm);
			if (timercmp (&tmp_tm, &one_sec, >))
			{
				if (NoRespReply_sw)
				{
					response_state = SEND_WAIT_SET;	
				}
			}
			echo_jitter_flush_ex();
			send_pkt();

			if (sig_term) break;
			
		}
	}

	if (node_sw)
	{
		usb_reset (udev); 
		usb_close (udev);
	}
	if (dvap_sw)
	{
		dvap_close();
	}
	close(in_sd);
	time(&cur_time);
	fprintf (log_file, "%24.24s dv_repeater end\n", ctime(&cur_time));
	fclose (log_file);
	remove (PID_FILE);
	freeaddrinfo (gateway_in);
	freeaddrinfo (gateway_out);
	return 0;
}

