#include	"dv_repeater.h"

void	temp_file_close (struct echo *echo);
void	putFifo (int len, struct dv_packet pkt);
int	getFifo (int *len, struct dv_packet *pkt);

int     init(int argc, char **argv);
extern	char	lastframe[];
extern	char	echo_buff[];
int	buff_length;
struct	dv_packet buff_pkt;;


enum
{
	SEND_PACKET = 0,
	SEND_PACKET_WAIT,
	SEND_INIT,
	SEND_INIT_WAIT
} dv_packet = SEND_INIT; 
	
void	send_pkt(void)
{
	int	ret;

	switch (dv_packet)
	{
		case SEND_PACKET:
			if (getFifo (&buff_length, &buff_pkt))
			{
				buff_pkt.m[0] = m >> 8;
				buff_pkt.m[1] = m & 0xff;
				time (&cur_time);
          	    		ret = sendto(in_sd, &buff_pkt, buff_length, 0,
               				 gateway_out->ai_addr, gateway_out->ai_addrlen);
                        	if (ret < 0) {
                                	fprintf (log_file, "%24.24s packet sent error %s\n",
                                        	ctime(&cur_time), strerror(errno));
                                	fflush (log_file);
                                	break;
                        	}
				dv_packet = SEND_PACKET_WAIT;
			}
			break;

		case SEND_PACKET_WAIT:
                       	if (!recv_check()) break;
                        if (seq_check ())
                        {
                        	dv_packet = SEND_PACKET;
			}
	
			break;

		case SEND_INIT:
                        memcpy (posit.id, "DSTR", 4);
                        posit.sr = 's';
                        posit.c= 0x00;          /* null */
                        posit.length[0] = 0x00;
                        posit.length[1] = 0x00;         /* length 0 */
                        posit.m[0] = m >> 8;
                        posit.m[1] = m & 0xff;
                        ret = sendto(in_sd, &posit, 10, 0,
                                gateway_out->ai_addr, gateway_out->ai_addrlen);
                        if (ret < 0) {
                                fprintf (log_file, "%24.24s null(sync) packet sent error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
			dv_packet = SEND_INIT_WAIT;
			break;

		case SEND_INIT_WAIT:
                        if (!recv_check()) break;
                        if (seq_check ())
                        {
                                dv_packet = SEND_PACKET;
				init_sw = TRUE;
                        }
			else
			{
                                 if (debug)
                                 {
                                         time (&cur_time);
                                         fprintf (log_file, "%24.24s dsgwd sequence number changed from %d(0x%4.4x) to %d(0x%4.4x)\n",
                                         ctime (&cur_time), m, m & 0xffff, recv_m, recv_m & 0xffff);
                                         fflush (log_file);
                                 }
                        	m = recv_m;
                        	dv_packet = SEND_INIT;
			}
                        break;
	}
}


void	send_inet(void)
{
	struct	timeval	tmp_tm;

	/* sending to INET (dsgwd) */
	if (!init_sw) return;
	timersub (&tm1, &tm0, &tmp_tm);
	if (sys_timeout.tv_sec != 0)
	{
		if (timercmp (&tmp_tm, &sys_timeout, >))
		{
			timeradd (&tm0, &sys_timeout, &tmp_tm);
			tm0.tv_sec = tmp_tm.tv_sec;
			tm0.tv_usec = tmp_tm.tv_usec;
			if (debug)
			{
				time (&cur_time);
				fprintf (log_file, "%24.24s sent POSITION Info (seq:%d(0x%4.4x))\n", 
					ctime(&cur_time), m, m & 0xffff);
				fflush (log_file);
			}
                       	memcpy (posit.id, "DSTR", 4);
                       	posit.sr = 's';
                       	posit.c= 0x00;          /* null */
                       	posit.length[0] = 0x00;
                       	posit.length[1] = 0x00;		/* length 0 */

			putFifo (10, posit);


			memcpy (posit.id, "DSTR", 4);
			memcpy (posit.dstar.posit.call1, sys_call, 8);
			memcpy (posit.dstar.posit.call2, sys_call, 8);
			posit.sr = 's';
			posit.c = 0x21;		/* position */
			posit.length[0] = 0x00;
			posit.length[1] = 0x10;		/* length 16 */
			putFifo (26, posit);	

                        if (echo_server[0] == 0x00) return;
                        memcpy (echo_posit.id, "DSTR", 4);
                        memcpy (echo_posit.dstar.posit.call1, echo_server, 8);
                        memcpy (echo_posit.dstar.posit.call2, node_area_rep_callsign, 8);
                        echo_posit.sr = 's';
                        echo_posit.c= 0x21;          /* position */
                        echo_posit.length[0] = 0x00;
                        echo_posit.length[1] = 0x10;         /* length 16 */

                        putFifo (26, echo_posit);
		}
	}
}

