#include	"dv_repeater.h"

void    send_resp_voice(char msg[]);
int	cos_check(void);

char   NullVoice0[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16};
char   NullVoice1[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5};

enum
{
        SKIP = 0,
	SEND_WAIT_SET,
	SEND_WAIT_CHECK,
	HEADER_SET,
	HEADER_SEND_CHECK,
	SEND_PTT_ON,
	VOICE_SEND_CHECK,
	VOICE_SEND,
	SEND_LAST_CHECK,
	SEND_LAST,
	SEND_PTT_OFF
} response_state = SKIP;

struct	timeval	send_wait;
char	msg[20];
unsigned char	frame_seq = 0;
extern	char	lastframe[];


void	send_response(void)
{
	struct timeval	tm;
	struct timeval	tm_tmp;
	struct timeval	wait_timer;
	unsigned char	len;
	int	ret;
	

	char	msg_buf[15];

	if (!node_sw) return;

	if (!(gw_resp_sw || NoRespReply_sw) || cos_check())
	{
		if (response_state >= VOICE_SEND_CHECK)
			usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 200);		
		response_state = SKIP;
		return;
	}

	wait_timer.tv_sec = 1;
	wait_timer.tv_usec = 0;

	switch (response_state)
	{
		case SKIP:
			break;
		case SEND_WAIT_SET:
			gettimeofday(&send_wait, NULL);
			response_state = SEND_WAIT_CHECK;
			frame_seq = 0;
			break;
		case SEND_WAIT_CHECK:
			gettimeofday(&tm, NULL);
                        timersub (&tm, &send_wait, &tm_tmp);
                        if (timercmp(&tm_tmp, &wait_timer,  >)) response_state = HEADER_SET;
			break;
		case HEADER_SET:
			/* Callsign set */
			if (gw_resp_sw)
			{
				usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, gw_resp.MyCall, 8, 200);
				usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, gw_resp.MyCall2 , 4, 200);
				usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, gw_resp.YourCall, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, gw_resp.RPT1Call, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, gw_resp.RPT2Call, 8, 200);
				gw_resp.flags[0] &= 0x07;
				usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, gw_resp.flags, 3, 200);
			}
			else if (NoRespReply_sw)
			{
				usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, node_area_rep_callsign, 8, 200);
				usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, "    " , 4, 200);
				usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, NoResp.YourCall, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, NoResp.RPT1Call, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, NoResp.RPT2Call, 8, 200);
				NoResp.flags[0] = 0x02;
				NoResp.flags[1] = 0x00;
				NoResp.flags[2] = 0x00;
				usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, NoResp.flags, 3, 200);
			}
			response_state = HEADER_SEND_CHECK;
			break;
		case HEADER_SEND_CHECK:
			usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 200);
			if (len > 95) response_state = SEND_PTT_ON;
			break;
		case SEND_PTT_ON:
			usb_control_msg(udev, 0x40, SET_PTT, ON, 0, NULL, 0, 200);
			response_state = VOICE_SEND_CHECK;
			if (gw_resp_sw) memcpy (msg, "Dest. not found.    ", 20);
			else if (NoRespReply_sw) memcpy (msg, "No Response         ", 20);
			break;
		case VOICE_SEND_CHECK:
			usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 200);
			if (len > 12)
			{
				response_state = VOICE_SEND;
			}
			break;
		case VOICE_SEND:
			if (frame_seq == 0) ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, NullVoice0, 12, 200);
			else
			{
				memcpy (msg_buf, NullVoice1, 12);
				switch (frame_seq)
				{
                                	case 1:
                                        	msg_buf[9] = 0x40 ^ 0x70;
                                        	msg_buf[10] = msg[0] ^ 0x4f;
                                        	msg_buf[11] = msg[1] ^ 0x93;
                                        	break;
                                	case 2:
                                       		msg_buf[9] = msg[2] ^ 0x70;
                                        	msg_buf[10] = msg[3] ^ 0x4f;
                                        	msg_buf[11] = msg[4] ^ 0x93;
                                        	break;
                                	case 3:
                                        	msg_buf[9] = 0x41 ^ 0x70;
                                        	msg_buf[10] = msg[5] ^ 0x4f;
                                        	msg_buf[11] = msg[6] ^ 0x93;
                                        	break;
                                	case 4:
                                        	msg_buf[9] = msg[7] ^ 0x70;
                                        	msg_buf[10] = msg[8] ^ 0x4f;
                                        	msg_buf[11] = msg[9] ^ 0x93;
                                        	break;
                                	case 5:
                                        	msg_buf[9] = 0x42 ^ 0x70;
                                        	msg_buf[10] = msg[10] ^ 0x4f;
                                        	msg_buf[11] = msg[11] ^ 0x93;
                                        	break;
                                	case 6:
                                        	msg_buf[9] = msg[12] ^ 0x70;
                                        	msg_buf[10] = msg[13] ^ 0x4f;
                                        	msg_buf[11] = msg[14] ^ 0x93;
                                        	break;
                                	case 7:
                                        	msg_buf[9] = 0x43 ^ 0x70;
                                        	msg_buf[10] = msg[15] ^ 0x4f;
                                        	msg_buf[11] = msg[16] ^ 0x93;
                                        	break;
                                	case 8:
                                        	msg_buf[9] = msg[17] ^ 0x70;
                                        	msg_buf[10] = msg[18] ^ 0x4f;
                                        	msg_buf[11] = msg[19] ^ 0x93;
                                        	break;
                        	}
				ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, msg_buf, 12, 200);
			}
			if (ret < 0) break;
			frame_seq++;
			if (frame_seq == 11) response_state = SEND_LAST_CHECK;
			else response_state = VOICE_SEND_CHECK;
			break;
		case SEND_LAST_CHECK:
			usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 200);
			if (len > 15) response_state = SEND_LAST;
			break;	
		case SEND_LAST:
			memcpy (&msg_buf[9], lastframe, 6);
			ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, msg_buf, 15, 200);
			if (ret < 0) break;
			response_state = SEND_PTT_OFF;
			break;	
		case SEND_PTT_OFF:
			usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 200);
			response_state = SKIP;
			if (gw_resp_sw) gw_resp_sw = FALSE;
			if (NoRespReply_sw) NoRespReply_sw = FALSE;
			break;
	}
}

