#include	"dxchange.h"

void	capture_init (void)
{
	time_t	atime;
	char	filter_exp[16];

	cap_handler = pcap_open_live (ZR_NIC, 128, FALSE, 5, errbuff);
	if (cap_handler == NULL)
	{
		fprintf (log_file, "%24.24s %s pcap_open_live error %s\n", 
				ctime(&atime), ZR_NIC, errbuff);
		fflush (log_file);
	}

	sprintf (filter_exp, "udp port %d", zr_port);
	if (pcap_compile (cap_handler, &cap_fp, filter_exp, 0, 0) == -1)
	{
		fprintf (log_file, "%24.24s cap filter not conpiled %s\n", 
				ctime(&atime), filter_exp);
		fflush (log_file);
	}

	if (pcap_setfilter (cap_handler, &cap_fp) == -1)
	{
		fprintf (log_file, "%24.24s cap filer not setting %s\n", 
				ctime(&atime), filter_exp);
		fflush (log_file);
	}
	else
	{
		time(&atime);
		fprintf (log_file, "%24.24s Capture port (%s) open.\n", ctime(&atime), filter_exp);
		fflush (log_file);
	}
}

void	capture_read (void)
{
	int	res;
	time_t	atime;
	int	length;
	struct	dstar_packet	*pkt;
	struct	forward		*fwd_pnt;

	res = pcap_next_ex (cap_handler, &header,  &pkt_data);
	if (res == 0) return;
	else if (res == -1)
	{
		time(&atime);
		fprintf (log_file, "%24.24s pcap_next_ex error\n", ctime(&atime));
		fflush (log_file);
		return;
	}
	length = header->caplen - 42;
	pkt = (struct dstar_packet *)(pkt_data + 42);		// ip v4
	if (!memcmp (forward_packet_zr, pkt, 16)) return;	// skip forward -> zr_port
	if (!memcmp (forward_packet_gw, pkt, 16)) return;	// skip forward -> gw_port
	if (memcmp(pkt->id, "DSTR", 4)) return;
	fwd_pnt = forward_pnt;
	while (fwd_pnt)
	{
		sendto (fwd_sd, pkt, length, 0, 
			(struct sockaddr *)&fwd_pnt->sock_storage, 
			sizeof(struct sockaddr_storage));
		fwd_pnt->tx_packets++;
		fwd_pnt = fwd_pnt->f_chain;
	}
}
