#include	"dxchange.h"
#include	"config.h"

extern	void	handler(int sig);

#define CRCPOLY2 0xEDB88320

unsigned int crc32(int n, unsigned char c[])
{
	int i, j;
	unsigned int r;

	r = 0xFFFFFFFFUL;
	for (i = 0; i < n; i++) {
		r ^= c[i];
		for (j = 0; j < 8 ; j++)
			if (r & 1) r = (r >> 1) ^ CRCPOLY2;
			else       r >>= 1;
	}
	return r ^ 0xFFFFFFFF;
}

void	pselectSet(void)
{
	FD_ZERO (&fd_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}

struct ModuleTable *module_check (char call[])
{

	struct ModuleTable *pnt;

	pnt = module_pnt;

	while (pnt)
	{
		if (!memcmp (call, pnt->ModuleName, 8)) return pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}


struct 	ModuleTable *module_check_ex (char FrameID[], in_addr_t ip_addr, in_port_t port)
{
	struct ModuleTable *pnt;

	pnt = module_pnt;
	while (pnt)
	{
		if ((ip_addr == pnt->ipaddress) && (port == pnt->port))
		{
			if (!memcmp (FrameID, pnt->FrameID, 2)) return  pnt;
		}
		pnt = pnt->f_chain;
	}
	return NULL;
}

