/*
	from forward port  to  other port
*/

#include	"dxchange.h"

struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[], in_addr_t ipaddr, in_addr_t port);
int 	forward_login (struct dxchng pkt);
struct	forward *add_forward_port (struct dxchng pkt, struct sockaddr_storage storage);
void	forward_keep_alive (struct sockaddr_storage from);
struct	forward *forward_table_pnt (struct sockaddr_storage from);

void	forward_recv (void)
{
	union
	{
		struct	dxchng		dxchng_pkt;
		struct	dstar_packet	packet;
	} pkt;

	socklen_t	from_len;
	int		len;
	struct	forward	*pnt;
	struct	forward *t_pnt;
	struct sockaddr_storage from;
	time_t	atime;

	from_len = sizeof (struct sockaddr_storage);

	len = recvfrom (fwd_sd, &pkt.dxchng_pkt, sizeof(pkt),
			0, (struct sockaddr *)&from, &from_len);

	t_pnt = forward_table_pnt (from);
	if (!memcmp (pkt.dxchng_pkt.ID, "DXCHNG", 6)) // dxchange control packet
	{
		if (t_pnt) t_pnt->ctl_rx_packets++;
		if (len == 56) 	// Login
		{
			if (!memcmp (pkt.dxchng_pkt.Type, "00", 2))
			{
				if (forward_login (pkt.dxchng_pkt)) 
				{
                                	memcpy (pkt.dxchng_pkt.body.ack, "ACK", 3);
                                	memcpy (pkt.dxchng_pkt.Type, "10", 2);
                                	sendto (fwd_sd, &pkt, 27, 0, (struct sockaddr *)&from, 
							sizeof(struct sockaddr_storage));
					t_pnt = add_forward_port(pkt.dxchng_pkt, from);
					if (t_pnt) 
					{
						t_pnt->ctl_tx_packets++;
						t_pnt->ctl_rx_packets++;
					}
				}
				else
				{
                                	memcpy (pkt.dxchng_pkt.body.ack, "NAK", 3);
                                	memcpy (pkt.dxchng_pkt.Type, "10", 2);
                                	sendto (fwd_sd, &pkt, 27, 0, (struct sockaddr *)&from, 
							sizeof(struct sockaddr_storage));
				}
			}
		}
		else if (len == 24)	// Logout or Keepalive
		{
			if (t_pnt)
			{
				if (!memcmp (pkt.dxchng_pkt.Type, "99", 2))
				{
					forward_keep_alive(from);
					memset (pkt.dxchng_pkt.UserID, 0x20, 16);
					memcpy (pkt.dxchng_pkt.UserID, client_callsign, 7);
					sendto (fwd_sd, &pkt, 24, 0, (struct sockaddr *)&from, 
							sizeof(struct sockaddr_storage));
					t_pnt->ctl_tx_packets++;
				}
			}
		}
		return;
	}
	else if (!memcmp (pkt.packet.id, "DSTR", 4)) // d-star packet
	{
		if (t_pnt)
		{
			t_pnt->rx_packets++;
			if (len == 58)
			{
				if (debug_sw)
				{
					time (&atime);
					fprintf (log_file, "%24.24s rpt2:%8.8s urcll:%8.8s\n",
						ctime(&atime),
						pkt.packet.body.header.rpt2,
						pkt.packet.body.header.urcall);
					fflush (log_file);
				}
				if ((pkt.packet.body.header.rpt2[7] == 'G') 
					&& memcmp(pkt.packet.body.header.urcall, "CQCQCQ  ", 8))
					t_pnt->gw_fwd_sw = TRUE;
				else	t_pnt->gw_fwd_sw = FALSE;
			}

                        pnt = forward_pnt;
                        while (pnt)
                        {
                                if (memcmp(&from, &pnt->sock_storage, sizeof(struct sockaddr)))
                                {
                                        sendto (fwd_sd, &pkt.packet, len, 0,
                                                (struct sockaddr *)&pnt->sock_storage,
                                                sizeof (struct sockaddr_storage));
                                        pnt->tx_packets++;
                                }
                                pnt = pnt->f_chain;
                        }

			if (!memcmp (pkt.packet.body.header.rpt1, client_callsign, 7))
			{
				pkt.packet.sr = 's';
				memcpy (forward_packet_zr, &pkt.packet, 16);
				if (zr_port)
				{
					sendto (rpt_zr_sd, &pkt.packet, len, 0,
						zr_info->ai_addr, zr_info->ai_addrlen);
				}
			}

			if (gw_port && t_pnt->gw_fwd_sw) 
			{
				if (!memcmp (pkt.packet.body.header.rpt2, client_callsign, 7))
				{
					pkt.packet.sr = 'r';
					memcpy (forward_packet_gw, &pkt.packet, 16);
					sendto (rpt_gw_sd, &pkt.packet, len, 0, 
						gw_info->ai_addr, gw_info->ai_addrlen);
				}
			}
		}
	}
}

void	forward (struct dstar_packet ds_pkt, int length)
{
	time_t	atime;
	int	ret;
	struct	forward		*fwd_pnt;

	fwd_pnt = forward_pnt;
	while (fwd_pnt)
	{
		ret = sendto (fwd_sd, &ds_pkt, length, 0,
					fwd_pnt->fwd_info->ai_addr, fwd_pnt->fwd_info->ai_addrlen);
		if (ret < 0)
		{
			time (&atime);
			fprintf (log_file, "%24.24s forward send error %s\n", ctime(&atime), strerror(errno));
			fflush (log_file);
			FD_CLR (fwd_sd, &fd_save);
			close (fwd_sd);
			fwd_sd = 0;
		}
		else
			fwd_pnt->tx_packets++;

		fwd_pnt = fwd_pnt->f_chain;
	}
}

int	forward_login (struct dxchng pkt)
{
	FILE	*pwd_file;
	char	buff[512];
	char	user[17];
	int	i, k;
	int	len;

	pwd_file = fopen (PASSWORD_FILE, "r");

	while (fgets (buff, 512, pwd_file))
	{
		memset (user, 0x20, 17);
		k = 0;
		len = strlen (buff);
		while (buff[k] != ':')
		{
			if (k > 15)
			{
				user[15] = 0x00;
 			}
			else
			{
				user[k] = buff[k];
			}
			k++;
		}
		k++;
		i = k;
		if (!memcmp (pkt.UserID, user, 16))
		{
			while ((buff[i] != ':') && (buff[i] != '\n')) i++;
				
			buff[i] = 0x00;
			if (!strcmp ((char *)crypt(pkt.body.Password, &buff[k]), (char *)&buff[k]))
			{
				fclose (pwd_file);
				return TRUE;
			}
		} 
	}
	fclose (pwd_file);
	return FALSE;
}

struct	forward	*add_forward_port (struct dxchng pkt, struct sockaddr_storage sock_storage)
{
	time_t	atime;

	struct	forward	*pnt, *pnt_last, *pnt_cur;

	pnt = malloc (sizeof (struct forward));
	
	if (pnt == NULL)
	{
		time (&atime);
		fprintf (log_file, "%24.24s malloc error on add_forward_port\n", ctime(&atime));
		fflush (log_file);
		return NULL;
	}
	else
	{
		time(&pnt->KeepAlive);
		memcpy (&pnt->sock_storage, &sock_storage, sizeof (struct sockaddr_storage));
		memcpy (pnt->UserID, pkt.UserID, 16);
		pnt->f_chain = NULL;
		pnt->tx_packets = 0;
		pnt->rx_packets = 0;
		pnt->ctl_tx_packets = 0;
		pnt->ctl_rx_packets = 0;
		pnt->stream_id[0] = 0x00;
		pnt->stream_id[1] = 0x00;
		if (forward_pnt)
		{
			pnt_cur = forward_pnt;
			while (pnt_cur)
			{
				pnt_last = pnt_cur;
				pnt_cur = pnt_cur->f_chain;
			}
			pnt_last->f_chain = pnt;
		}
		else
		{
			forward_pnt = pnt;
		}
	}
	return pnt;
}

void	forward_keep_alive(struct sockaddr_storage from)
{
	struct	forward	*pnt;

	pnt = forward_pnt;

	while (pnt)
	{
		if (!memcmp (&from, &pnt->sock_storage, sizeof (struct sockaddr)))
		{
			time (&pnt->KeepAlive);
			break;
		}
		pnt = pnt->f_chain;
	}
}

void	forward_keep_check(void)
{
	struct	forward	*pnt, *save_pnt, *next_pnt;
	time_t	atime;
	
	time (&atime);	
	pnt = forward_pnt;
	save_pnt = NULL;
	while (pnt)
	{
		next_pnt = pnt->f_chain;
		if ((atime - pnt->KeepAlive)  >= 30)
		{
			free (pnt);
			if (save_pnt == NULL)
			{
				forward_pnt = next_pnt;
				pnt = forward_pnt;
			}
			else
			{
				save_pnt->f_chain = next_pnt;
				pnt = next_pnt;
			}
		}
		else
		{
			save_pnt = pnt;
			pnt = pnt->f_chain;
		}
	}
}		

struct forward *forward_table_pnt (struct sockaddr_storage from)
{
	struct forward	*pnt;

	pnt = forward_pnt;

	while (pnt)
	{
		if (!memcmp (&from, &pnt->sock_storage, sizeof (struct sockaddr))) return pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}
