#include	"init.h"
#include	"dxchange.h"
#include	"config.h"

void	pselectSet(void);
void	portSet(void);
void	aprs (void);
void    send_check_init(void);
void    lost_frame(void);
void    httpd_srv_recv(int sock);
void	httpd_srv_accept(void);
void    forward_recv (void);
void    repeater_gw(void);
int     repeater_zr(void);
int	repeater_mon(void);
int     repeater_init(void);
int     read_config(int argc, char **argv);
int     handler_init(void);
void	serial_read(void);
void    status_keep_alive_send(void);
void    BeaconSend(void);
void    status_logoff_send(void);
void	forward_keep_check (void);
void	capture_init(void);
void	capture_read(void);
int	dxchange_init(int argc, char** argv);

struct	ModuleTable	*module_check (char call[]);
struct	ModuleTable	*module_check_ex (char FrameID[], 
				in_addr_t ipaddr, in_port_t port);

extern	void	handler(int sig);

time_t			start_time;

struct	sockaddr_in	in_sock;
socklen_t		len_in_sock;

int main(int argc, char** argv)
{

	int	i;
	int	ret;

	time_t	atime;
	time_t	uptime;

	tzset();
	daemon (0, 0);

        uname(&uname_buf);

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}
	time (&start_time);

	fprintf (log_file, "%24.24s D-STAR X-change (dxchange) RP2C with D-PRS V%5.5s (%s  %s) Start\n", 
						ctime(&start_time), PACKAGE_VERSION, __DATE__, __TIME__);
	if (debug_sw)	fprintf (log_file, "                         %s %s %s\n",
						uname_buf.sysname, uname_buf.release, uname_buf.version);
	fflush (log_file);

	/* PID file open & write */
	pid_file = fopen(PID_FILE, "w");
	if (pid_file == NULL)
	{
		fprintf (log_file, "%24.24s Already running dxchange.\n", ctime(&atime));
		fclose (log_file);
		return -1;
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file); 

	time (&atime);
	if (debug_sw)
	{
		fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
		fflush (log_file);
	}

	/* default & initail value */
	if (!dxchange_init(argc, argv)) goto end;

	/* mail loop */
	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL, 
				(fd_set *)NULL, &timeout, &sigset);
		time (&atime);
		if (ret < 0) 
		{
                	fprintf (log_file, "%24.24s pselect error %s\n", 
						ctime(&atime), strerror(errno));
                	fflush (log_file);
			break;
		}
		else if (ret > 0)
		{
                	if (FD_ISSET (rpt_mon_sd, &read_set))
                	{
                        	if (!repeater_mon()) break;
                	}
			
			if (forward_recv_port)
			{
				if (FD_ISSET(fwd_sd, &read_set)) forward_recv();
			}

			if (FD_ISSET (serial_fd, &read_set)) serial_read();

			if (FD_ISSET (http_sd, &read_set)) httpd_srv_accept();

			if (http_port)
			{
				for (i = 0 ; i < FD_SETSIZE ; i++)
				{
					if (FD_ISSET (i, &read_set))
					{
						if ((i == aprs_sd) 
							|| (i == rpt_mon_sd)
							|| (i == serial_fd)
							|| (i == fwd_sd)
							|| (i == http_sd)) goto skip; 
						httpd_srv_recv(i);
					}
					skip:	continue;					
				}
			}
		}
		else
		{
			lost_frame();
		}

		if (forward_pnt != NULL)
		{
			capture_read();
			forward_keep_check();
		}	
		if ((status_pnt != NULL) && ((atime - status_keep_alive) >= status_start))
		{
							status_keep_alive_send();
							status_start = 300;
		}
		if (aprs_submit == 0) aprs();
		else
		{
                        if (BeaconInterval)
                        {
                                if (atime >= BeaconTime) BeaconSend();
                        }
		}
		if (sig_term) break;
	
	}

	// socket close
	if (rpt_mon_sd) close (rpt_mon_sd);
	if (rpt_gw_sd) close (rpt_gw_sd);
	if (rpt_zr_sd) close (rpt_zr_sd);
	if (fwd_sd) close (fwd_sd);
	if (aprs_sd) close (aprs_sd);
	if (serial_fd)
	{
		tcsetattr(serial_fd, TCSANOW, &termio_save);
		tcflush (serial_fd, TCIOFLUSH);
		close (serial_fd);
	}
end:
	if (status_pnt) status_logoff_send();
	time(&atime);
	uptime = atime - start_time;
	fprintf (log_file, 
		"%24.24s D-STAR X-change (dxchange) ID-RP2C Interface terminated (Up : %ldd%2ldh%2ldm%2lds)\n\n",
			ctime(&atime), 
			(uptime / 86400),
			((uptime % 86400) / 3600),
			(((uptime % 86400) % 3600) / 60),
			(((uptime % 86400) % 3600) % 60));
	fclose (log_file);
	if (http_port > 0) close (http_sd);
	remove (PID_FILE);
    	return 0;
}

int	dxchange_init(int argc, char** argv)
{
	time_t	atime;

	/* default & initail value */
	send_interval = SEND_INTERVAL;
	aprs_port = 0;
	aprs_submit = 0;
	aprs_cnt = 0;
	memset (aprs_name, 0x20, 128);
	mon_port = RECV_PORT;
	AutoReLink = 1;
	RetryCnt = RETRY_COUNT;
	BeaconLat = Latitude_Default; 
	BeaconLong = Longitude_Default;
	BeaconInterval = Beacon_Interval;
	time(&BeaconTime);
	reload = FALSE;
	sig_term = FALSE;
	debug_sw = FALSE;
	aprs_cnt = 0;
	forward_recv_port = 0;
	memset (forward_packet_zr, 0x00, 16);
	memset (forward_packet_gw, 0x00, 16);

	module_pnt = NULL;

	forward_pnt = NULL;
	status_pnt = NULL;
	verify_sw = FALSE;

	http_port = 0;
	zr_port = 0;
	mon_port = 0;
	gw_port = 0;

	http_sd = 0;
	serial_fd = 0;
	aprs_sd = 0;
	rpt_mon_sd = 0;
	rpt_gw_sd = 0;
	rpt_zr_sd = 0;

	baud	= 0;

	cap_handler = NULL;
	time (&status_keep_alive);

	memset (aprs_server, 0x00, 16);
	memset (ZR_NIC, 0x00, 8);
	memset (SERIAL_PORT, 0x00, 16);
	send_check_init();

	/* interrupt handler set */
	if (!handler_init()) return FALSE;

	/* config file read */
	if (!read_config (argc, (char **)argv)) return FALSE;

	srand (crc32(8, client_callsign));
	status_start = rand() % 300;
	
	time (&atime);
	if (debug_sw)
	{
		fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
		fflush (log_file);
	}

	pselectSet();	// FD & sig init

	if (!repeater_init()) return FALSE;

	portSet();

	if (forward_recv_port) capture_init();

	if (aprs_submit)
	{
		fprintf (log_file, "%24.24s APRS Server (SUBMIT) : %s:%d\n", 
						ctime(&atime), aprs_name, aprs_port);
		fflush (log_file);
	}
	return TRUE;
}

