/*
	D-STAR RF header and Voice packet
	
	Auth:	Satoshi Yasuda 7m3tjz/ad6gz
*/


struct	dstar_packet
{
	char	id[4];	/* DSTR */
	char	m[2];		// sequence 
	char	sr;		// GW ->   0x73 (s)     GW <- 0x72 (r)
	char	c;		// data 0x11  voice 0x12
	char	l[2];		// length  header 0x0030  voice 0x0013 last 0x0016
	struct
	{
		char	FrameType;	// data 0x40  voice 0x20
		char	dst_rpt_id;
		char	src_rpt_id;
		char	src_term_id;
		char	FrameID[2];
		unsigned char	FrameSeq;	// header 0x80  last frame | 0x40
	} trunk;
	union
	{
                struct
                {
                        char    flag[3];
                        char    rpt2[8];
                        char    rpt1[8];
                        char    urcall[8];
                        char    mycall[8];
                        char    mycall_ex[4];
                        unsigned char   crc[2];
                        unsigned char	ip[4];
                        unsigned char	port[2];
                } header;
		struct
		{
			char	voice[9];
			char	slowdata[3];
			unsigned char	ip[4];
			unsigned char	port[2];
		} voice;
		struct
		{
			char	voice[9];
			char	slowdata[3];
			char	dummy[3];
			unsigned char	ip[4];
			unsigned char	port[2];
		} last_voice;
	} body;
			
};

struct	dxchng
{
	char	ID[6];
	char	Type[2];
	char	UserID[16];
	union
	{
		char	Password[32];
		char	ack[3];
		char	nak[3];
	} body;
};
