#include	"dxchange.h"

void    rep_send (struct ModuleTable *pnt);
void    forward (struct dstar_packet ds_pkt, int length);

struct	ModuleTable	*module_check (char call[]);
struct	ModuleTable	*module_check_ex (char FrameID[], in_addr_t ipaddr, in_port_t port);

extern	struct	sockaddr_in	in_sock;
extern	socklen_t	len_in_sock;
struct	sockaddr_in	rpt_mon_addr;

struct	dstar_packet	d_packet;

int	repeater_mon(void)
{
	struct  ModuleTable     *m_pnt;
	int	length;
	time_t	atime;
	in_addr_t	ip_temp;
	in_port_t	port_temp;
	struct	timeval		time_21ms;
	struct	timeval		cur_time;

	m_pnt = NULL;
	len_in_sock = sizeof (in_sock);
    	length = recvfrom(rpt_mon_sd, &d_packet, sizeof(d_packet), 0, 
			(struct sockaddr *)&in_sock, &len_in_sock);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s Repeater data Reciv. error\n", ctime(&atime));
        	return FALSE;			// end
    	}

	if (!memcmp(d_packet.id, "DSTR", 4) && (d_packet.sr == 0x73) 
		&& (d_packet.c == 0x12) && (d_packet.trunk.FrameType == 0x20) 
		&& ((d_packet.trunk.FrameSeq & 0x3f) < 21))		// check D-STAR packet (DSTR)
	{
		if (length == 58)
		{
			m_pnt = module_check(d_packet.body.header.rpt1);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &d_packet, 58);
				m_pnt->rpt_save_length = 58;
				rep_send (m_pnt);
				m_pnt->FrameID[0] = d_packet.trunk.FrameID[0];
				m_pnt->FrameID[1] = d_packet.trunk.FrameID[1];
                        	memcpy (&m_pnt->ipaddress, &in_sock.sin_addr.s_addr, 4);
                        	memcpy (&m_pnt->port, &in_sock.sin_port, 2);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
				if ((d_packet.body.header.rpt2[7] == 'G')  
					&& memcmp(d_packet.body.header.urcall, "CQCQCQ  ", 8))
						m_pnt->gw_fwd_sw = TRUE;
				else		m_pnt->gw_fwd_sw = FALSE;
			}
		}
		else if (length == 29) // voice packet ICOM
		{
			memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
			memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (d_packet.trunk.FrameID, ip_temp, port_temp);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &d_packet, 29);
				m_pnt->rpt_save_length = 29;
				rep_send (m_pnt);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if (length == 32) // Last Frame ICOM
		{
                        memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
                        memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (d_packet.trunk.FrameID, ip_temp, port_temp); 
			if (m_pnt)
			{
                        	memcpy (&m_pnt->rpt_save, &d_packet, 32);
                        	m_pnt->rpt_save_length = 32;
				rep_send (m_pnt);
				m_pnt->rpt_save_length = 0;
				m_pnt->recv_time.tv_sec = 0;
				m_pnt->recv_time.tv_usec = 0;
			
			}
		}
		if (m_pnt->gw_fwd_sw)
		{
			if (m_pnt->gw_fwd_sw) forward (d_packet, length);
		}
	}
	return TRUE;
}

int	repeater_init(void)
{
	struct	ifreq	ifr;
	time_t	atime;
	struct	addrinfo	hints;
	char		PORT[10];
	int		err;


    	// IPv4 UDP socket
	// monitor port
    	if((rpt_mon_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
                time(&atime);
                fprintf (log_file, "%24.24s Zone Repeater socket(Monitor) not open\n", ctime(&atime));
        	return FALSE;	
    	}

        // 待ち受けるIPとポート番号を設定
        rpt_mon_addr.sin_family = AF_INET;
        rpt_mon_addr.sin_port = htons(mon_port);
        rpt_mon_addr.sin_addr.s_addr = INADDR_ANY;

	if (ZR_NIC[0] != 0x00)
	{
		ifr.ifr_addr.sa_family = AF_INET;
		strncpy (ifr.ifr_name, ZR_NIC, IFNAMSIZ-1);
		time (&atime);
		if (ioctl (rpt_mon_sd, SIOCGIFADDR, &ifr) >= 0)
		{
			rpt_mon_addr.sin_addr.s_addr = 
				((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
			fprintf (log_file, "%24.24s NIC (%s) Zone Repeater Monitor Port %d open.\n", 
					ctime(&atime), ZR_NIC, mon_port);
			
		}
		else
		{
			fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), ZR_NIC);
		}
		fflush (log_file);
	}	
	
	FD_SET (rpt_mon_sd, &fd_save);

    	// Bind
    	if(bind(rpt_mon_sd, (struct sockaddr *)&rpt_mon_addr, sizeof(rpt_mon_addr)) < 0) {
		time(&atime);
		fprintf (log_file, "%24.24s Zone Repeater Monitor socket not bind %s\n", ctime(&atime), strerror(errno));
        	return FALSE;
    	}

/* ========================================================== */

	if (zr_port)
	{
		memset (&hints, 0x00, sizeof(hints));
		hints.ai_socktype = SOCK_DGRAM;
		hints.ai_family = PF_UNSPEC;
		sprintf (PORT, "%d", zr_port);
		time(&atime);
		if ((err = getaddrinfo (zr_fqdn, PORT, &hints, &zr_info)) != 0)
		{	
			fprintf (log_file, "%24.24s getaddrinfo error (Zone repeater: %s:%d) %s\n",
				ctime(&atime), zr_fqdn, zr_port, gai_strerror(err));
			if (zr_info != NULL) freeaddrinfo (zr_info);
			fflush (log_file);
		}
        	if((rpt_zr_sd = socket(zr_info->ai_family, zr_info->ai_socktype, zr_info->ai_protocol)) < 0)
        	{
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket not open\n", ctime(&atime));
			zr_port = 0;
        	}
		else
		{
			fprintf (log_file, "%24.24s Zone Repeater Port %s:%d open.\n",
				ctime(&atime), zr_fqdn, mon_port);
		}
	}

/* ============================================================ */
	if (gw_port)
	{
        	memset (&hints, 0x00, sizeof(hints));
        	hints.ai_socktype = SOCK_DGRAM;
        	hints.ai_family = PF_UNSPEC;
       	 	sprintf (PORT, "%d", gw_port);
        	time(&atime);
        	if ((err = getaddrinfo (gw_fqdn, PORT, &hints, &gw_info)) != 0)
        	{
                	fprintf (log_file, "%24.24s getaddrinfo error (Gateway PC: %s:%d) %s\n",
                                ctime(&atime), gw_fqdn, gw_port, gai_strerror(err));
                	if (gw_info != NULL) freeaddrinfo (gw_info);
                	fflush (log_file);
        	}
        	if((rpt_gw_sd = socket(gw_info->ai_family, gw_info->ai_socktype, gw_info->ai_protocol)) < 0)
        	{
                	time(&atime);
                	fprintf (log_file, "%24.24s Gateway PC socket not open\n", ctime(&atime));
                	gw_port = 0;
        	}
        	else
        	{
                	fprintf (log_file, "%24.24s Gateway PC Port %s:%d open.\n",
                        	ctime(&atime), gw_fqdn, gw_port);
        	}

		fflush (log_file);
	}

	return TRUE;
}


