#include "dxchange.h"

int        send_check(char call_sign[]);
unsigned short int        update_crc_dstar( unsigned short int  crc, unsigned char c );
unsigned short int                result_crc_dstar(unsigned short int crc);

extern	int	aprs_sd;
extern	struct	addrinfo *aprs_addr;
extern	int	aprs_status;

int	GPS_A_SumCheck(unsigned char  string[])
{
	unsigned short int	crc_dstar_ffff, k, k0, k1, k2, k3;
	unsigned char	*pnt;
	
    	crc_dstar_ffff = 0xffff;	/* nornal value 0xffff */
	pnt = string + 10;

	while (*pnt != 0x0a)
	{
		if (*pnt == 0x00) return FALSE;
		crc_dstar_ffff = update_crc_dstar( crc_dstar_ffff, *pnt);
		pnt++;
	}

	crc_dstar_ffff = result_crc_dstar(crc_dstar_ffff);

	k0 = string[5] - '0';
	if (k0 > 16) k0 -= 7;
	k1 = string[6] - '0';
	if (k1 > 16) k1 -= 7;
	k2 = string[7] - '0';
	if (k2 > 16) k2 -= 7;
	k3 = string[8] - '0';
	if (k3 > 16) k3 -= 7;
	k1 += k0 * 16;
	k3 += k2 * 16;
    	k = k1 | (k3 << 8);

	if (k == crc_dstar_ffff) return TRUE;
	return	FALSE;
}

void	GPS_A_Send(unsigned char string[], struct ModuleTable *id)
{
	char	CallSign[9];
	int	i, k, n, tmp;
	int	len;
	time_t	atime;
	char	temp[20];

	memset (CallSign, 0x20, 9);
	for (i = 0 ; i < 9 ; i++)
	{
		if (string[i] == 0x00) return;
		if (string[i] == '>') break;
		CallSign[i] = string[i];	
	}
	if (CallSign[0] == 0x20)
	{
		id->AprsSend = APRS_INVALID;
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		return;	
	}

	len = strlen((char *)string);
	for (i = 0 ; i < len ; i++)
	{
		if ((string[i] == '!') || (string[i] == 'z') || (string[i] == 'h') 
			|| (string[i] == '='))
		{
			memset (temp, 0x00, 20);
			n = 0;
			for (k = i+1 ; k < len ; k++)
			{
				temp[n] = string[k];
				//if ((string[k] == '/') || (string[k] == '\\'))
				if (!(isdigit(string[k]) || (string[k] == '.')
					|| (string[k] == 'S') || (string[k] == 'N')))
				{
					temp[n] = 0x00;
					tmp = atof (&temp[2]) * 10000. / 60.;
					temp[2] = 0x00;
					tmp = tmp + (atoi(temp) * 10000);
					if (temp[7] == 'S') tmp = - tmp;
					id->STATUS_Frm.Latitude = tmp;
					break;
				}
				n++;
			}
			k++; 
                        memset (temp, 0x00, 20);
                        n = 0;
                        for ( ; k < len ; k++)
                        {
                                temp[n] = string[k];
				//if ((string[k] == '[') || (string[k] == '-') || (string[k] == '>'))
				if (!(isdigit(string[k]) || (string[k] == '.') 
					|| (string[k] == 'W') || (string[k] == 'E')))
                                {
                                        temp[n] = 0x00;
                                        tmp = atof (&temp[3]) * 10000. / 60.;
                                        temp[3] = 0x00;
                                        tmp = tmp + (atoi(temp) * 10000);
                                        if (temp[8] == 'W') tmp = - tmp;
                                        id->STATUS_Frm.Longitude = tmp;
                                        break;
                                }
                                n++;
                        }
			break;
		}
	}

        if (send_check(CallSign))
        {
                send (aprs_sd, string, strlen((char *)string), 0);
                time(&atime);
                fprintf (log_file, "%24.24s send : %s\n", ctime(&atime), string);
                fflush (log_file);
                id->AprsSend =  APRS_SEND;
                aprs_cnt++;
                memcpy (id->aprs_msg_save, id->aprs_msg, 256);
        }
        else
        {
                id->AprsSend = APRS_SHORT;
                memcpy (id->aprs_msg_save, id->aprs_msg, 256);
        }	
}

void    gps_a (unsigned char msg[], struct ModuleTable *id)
{
	time_t	atime;

	if (aprs_status < 0) return;

	time(&atime);
        if (debug_sw)
	{
		fprintf (log_file, "%24.24s gps_a: %s", ctime(&atime), msg);
		fflush (log_file);
	}
        if (!GPS_A_SumCheck(msg))
	{
		id->AprsSend = APRS_ERROR;
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		fprintf (log_file, "%24.24s CRC error : %s", ctime(&atime), msg);
		fflush (log_file);
		return;
	}
        if (!gps_only_skip || !id->RadioGpsSkip)
        {
	        if (verify_sw) GPS_A_Send (&msg[10], id);
	}
	else
	{
		if (debug_sw)
		{
			fprintf (log_file, "%24.24s Skip GPS Message Only\n", ctime(&atime));
			fflush (log_file);
		}
	}
}

