#include	"dxchange.h"

void    module_init(struct ModuleTable *module, unsigned char Module[], 
		int port);
void	forward_init (struct forward *fwd, unsigned char Fullname[], 
		int port);
void    status_init (struct status *sta, unsigned char Fullname[], int port);


int	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	len;
	int	k;
	int	n;
	int	m;
	int	j;
	unsigned char	Module[8];
	struct	ModuleTable	*module_next;
	int	field_sw;
	int	port;
	time_t	atime;
	int	false_ret;
	unsigned char	fqdn[128];
	struct	forward		*forward_next;
	struct	status		*status_next;

	FILE	*config_file;
	
	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&atime), argv[1]);
			fflush (log_file);
			return FALSE;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", 
						ctime(&atime), CONFIG_FILE);
			fflush (log_file);
			return FALSE;
		}
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "APRS_SERVER", 11))
				{
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (aprs_name, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (field_sw)
                                                {
							if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                }
                                                else
                                                {
                                                	if (*pnt == ':') field_sw = 1;
                                                        else
                                                        {
                                                                if (*pnt != 0x20) aprs_name[n++] = *pnt;
                                                                if (n > 127) n = 127;
                                                        }
                                                }
                                                pnt++;
                                        }
					if (n && (port > 0))
					{
                                                aprs_name[n] = 0x00;
                                                aprs_port = port;
					}
					else
					{
						time (&atime);
						fprintf (log_file, "%24.24s Invalid Format of APRS_SERVER\n", 
										ctime(&atime));
						fflush (log_file);
						aprs_port = 0;
					}
				}
				else if (!memcmp (p, "MON_PORT", 8) || !memcmp(p, "RECV_PORT", 9))
				{
					mon_port = atoi (pnt);
				}
                                else if (!memcmp (p, "ZR_PORT", 7))
                                {
                                        zr_port = atoi(pnt);
                                }
                                else if (!memcmp (p, "GW_PORT", 9))
                                {
                                        gw_port = atoi(pnt);
                                }
				else if (!memcmp (p, "CALLSIGN", 8))
				{
					memset (client_callsign, 0x20, 7);
					len = strlen(pnt);
					if (len > 7) len = 7;
					memcpy (client_callsign, pnt, len);
				}
				else if (!memcmp (p, "RADIO_ID", 8))
				{
					radio_id = *pnt;
				}
				else if (!memcmp (p, "AUTO_RELINK", 11))
				{
					AutoReLink = atoi (pnt);				
				}
				else if (!memcmp (p, "RETRY_COUNT", 11))
				{
					RetryCnt = atoi (pnt);
				} 
				else if (!memcmp (p, "SEND_INTERVAL", 13))
				{
					send_interval =  atoi (pnt);
				}
				else if (!memcmp (p, "GPS_MESSAGE_SKIP", 16))
				{
					gps_only_skip = atoi(pnt);
				}
				else if (!memcmp (p, "GPS_SKIP_BITS", 13))
				{
					gps_skip_bits = atoi(pnt);
				}
                	        else if (!memcmp (p, "BEACON_LAT", 10))
                        	{
                        	        BeaconLat = atof (pnt) * 10000.;
				}	
				else if (!memcmp (p, "BEACON_LONG", 11))
                        	{
                	                BeaconLong = atof (pnt) * 10000.;
                        	}
                	        else if (!memcmp (p, "BEACON_INTERVAL", 11))
                        	{
                                	BeaconInterval = atoi (pnt);
                                        if ((BeaconInterval > 0) && (BeaconInterval < 300))
                                        {
                                                time(&atime);
                                                fprintf (log_file, "%24.24s BEACON_INTERVAL too small %d. Assumed 300\n", ctime(&atime), BeaconInterval);
                                                BeaconInterval = 300;
                                        }                       	 	}
                        	else if (!memcmp (p, "BEACON_COMMENT", 14))
                        	{
                               		 memset (beacon_comment, 0x00, 64);
                                	len = strlen(pnt);
                                	if (len > 63) len = 63;
                                	memcpy (beacon_comment, pnt, len);
                        	}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug_sw = atoi(pnt);
				}
                                else if (!memcmp (p, "STATUS", 7))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt != ',')
                                                {
                                                        if (field_sw)
                                                        {
                                                                if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                        }
                                                        else
                                                        {
                                                                if (*pnt == ':') field_sw = 1;
                                                                else
                                                                {
                                                                        if (*pnt != 0x20) fqdn[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                }
                                                        }
                                                }
                                                else
                                                {
                                                        status_next = malloc (sizeof (struct status));
                                                        if (status_next != NULL)
                                                        {
                                                                fqdn[n] = 0x00;
                                                                status_init(status_next, fqdn, port);
                                                                if (status_pnt) status_last->f_chain = status_next;
                                                                else status_pnt = status_next;
                                                                status_last = status_next;
                                                                port = 0;
                                                                n = 0;
                                                                field_sw = 0;
                                                        }
                                                        else
                                                        {
                                                                time(&atime);
                                                                fprintf (log_file, "%24.24s Memoty not allocate (STATUS)\n",
										ctime(&atime));
                                                                fflush (log_file);
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n)
                                        {
                                                fqdn[n] = 0x00;
                                                status_next = malloc (sizeof (struct status));
                                                status_init(status_next, fqdn, port);
                                                if (status_pnt) status_last->f_chain = status_next;
                                                else status_pnt = status_next;
                                                status_last = status_next;
                                        }
                                }
				else if (!memcmp (p, "FORWARD", 7))
				{
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt != ',')
                                                {
                                                        if (field_sw)
                                                        {
                                                                if (isdigit(*pnt)) port = port * 10 + *pnt - '0';
                                                        }
                                                        else
                                                        {
                                                                if (*pnt == ':') field_sw = 1;
                                                                else
								{
									if (*pnt != 0x20) fqdn[n++] = *pnt;
									if (n > 127) n = 127;
								}
                                                        }
                                                }
                                                else
                                                {
                                                        forward_next = malloc (sizeof (struct forward));
                                                        if (forward_next != NULL)
                                                        {
								fqdn[n] = 0x00;
                                                                forward_init(forward_next, fqdn, port);
                                                                if (forward_pnt) forward_last->f_chain = forward_next;
                                                                else forward_pnt = forward_next;
                                                                forward_last = forward_next;
                                                                port = 0;
                                                                n = 0;
                                                                field_sw = 0;
                                                        }
                                                        else
                                                        {
                                                                time(&atime);
                                                                fprintf (log_file, "%24.24s Memoty not allocate (FORWARD)\n", ctime(&atime));
                                                                fflush (log_file);
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n)
                                        {
						fqdn[n] = 0x00;
                                                forward_next = malloc (sizeof (struct forward));
                                                forward_init(forward_next, fqdn, port);
                                                if (forward_pnt) forward_last->f_chain = forward_next;
                                                else forward_pnt = forward_next;
                                                forward_last = forward_next;
                                        }
				}
				else if (!memcmp (p, "MODULE_NAME", 11))
				{
					n = 0;
					m = 0;
					k = 0;
					j = 0;
					field_sw = 0;
					port = 0;
					memset (Module, 0x20, 8);
					while (*pnt)
					{
						if (*pnt != ',')
						{
							if (field_sw == 1)
							{
								if (*pnt == ':') field_sw++;
								else if (isdigit(*pnt)) port = port * 10 + *pnt - '0';
								 
							}
							else
							{
								if (*pnt == ':') field_sw++;
								else if (n < 8) 
								{
									if (n == 0)
									{
										if (*pnt != 0x20) Module[n++] = *pnt;
									}
									else
									{
										Module[n++] = *pnt;
									}
								}
							}
						}
						else
						{
							if (memcmp (Module, "XX0XXX", 6))
							{
								module_next = malloc (sizeof (struct ModuleTable));
								if (module_next != NULL)
								{
									module_init(module_next, Module, port);
									if (module_pnt) module_last->f_chain = module_next;
									else module_pnt = module_next;
									module_last = module_next;
								}
								else
								{
									time(&atime);
									fprintf (log_file, "%24.24s Memoty not allocate Module table (%s)\n", ctime(&atime), Module);
									fflush (log_file); 
								}
							}
							else
							{
								time (&atime);
								fprintf (log_file, "%24.24s Skip the invalide Module name (XX0XXX)\n", ctime(&atime));
								fflush (log_file);
							}
							port = 0;
							n = 0;
							m = 0;
							j = 0;
							field_sw = 0;
							memset (Module, 0x20, 8);
						}
						pnt++;	
					}
					if (n)
					{
						if (memcmp (Module, "XX0XXX", 6))
						{
                                                	module_next = malloc (sizeof (struct ModuleTable));
							module_init(module_next, Module, port);
                                                	if (module_pnt) module_last->f_chain = module_next;
                                                	else module_pnt = module_next;
                                                	module_last = module_next;
						}
						else
						{
							time (&atime);
							fprintf (log_file, "%24.24s Skip the invalide Module name (XX0XXX)\n", ctime(&atime));
							fflush (log_file);
						}
					}
				}
				else if (!memcmp (p, "HTTP_PORT", 9))
				{
					http_port = atoi(pnt);
				}
				else if (!memcmp (p, "ZR_NIC", 6))
				{
					memset (ZR_NIC, 0x00, 8);
					memcpy (ZR_NIC, pnt, strlen(pnt));
				}
                                else if (!memcmp (p, "RECV_NIC", 8))
                                {
                                        memset (ZR_NIC, 0x00, 8);
                                        memcpy (ZR_NIC, pnt, strlen(pnt));
                                }
				else if (!memcmp (p, "RPT_NIC", 7))
				{
					memset (ZR_NIC, 0x00, 8);
					memcpy (ZR_NIC, pnt, strlen(pnt));
				}
                                else if (!memcmp (p, "GW_NIC", 8))
                                {
                                        memset (GW_NIC, 0x00, 8);
                                        memcpy (GW_NIC, pnt, strlen(pnt));
                                }
				else if (!memcmp (p, "SERIAL_PORT" , 11))
				{
					memset (SERIAL_PORT, 0x00, 16);
                                        n = 0;
                                        field_sw = 0;
                                        baud = 0;
                                        while (*pnt)
                                        {
                                                if (field_sw)
                                                {
                                                        if (isdigit (*pnt)) baud = baud * 10 + *pnt - '0';
                                                }
                                                else
                                                {
                                                        if (*pnt == ':') field_sw = 1;
                                                        else
                                                        {
                                                                if (*pnt != 0x20) SERIAL_PORT[n++] = *pnt;
                                                                if (n > 15) n = 15;
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n <= 0)
                                        {
                                                time (&atime);
                                                fprintf (log_file, "%24.24s Invalid Format of SERIAL_PORT\n",
                                                                                ctime(&atime));
                                                fflush (log_file);
						
                                        }
					else
					{
						SERIAL_PORT[n] = 0x00;
                                        	module_next = malloc (sizeof (struct ModuleTable));
                                        	if (module_next != NULL)
                                        	{
                                        		module_init(module_next, "SERIAL  ", 0);
                                                	if (module_pnt) module_last->f_chain = module_next;
                                                	else module_pnt = module_next;
                                                	module_last = module_next;
                                        	}
                                        	else
                                        	{
                                        		time(&atime);
                                                	fprintf (log_file, "%24.24s Memoty not allocate Module table (SERIAL)\n", 
										ctime(&atime));
                                                	fflush (log_file);
                                      		} 
					}
				}
                                else if (!memcmp (p, "TRUST_SERVER", 12))
                                {
                                        time (&atime);
					fprintf (log_file, "%24.24s no more supprt \"TRUST_SERVER\" command\n", ctime(&atime));
					fflush (log_file);
                                }
				else
				{
					time (&atime);
					fprintf (log_file, "%24.24s Error on config file : %s\n",ctime(&atime), buff);
					fflush (log_file);
				}
			}
		}
	}

	fclose (config_file);

	false_ret = FALSE;
	time (&atime);
	if (module_pnt == NULL)
	{
		fprintf (log_file, "%24.24s Repeater Module name not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (mon_port <= 0)
	{
		fprintf (log_file, "%24.24s Zone Repeater Monitor port not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (aprs_port <= 0)
        {
                fprintf (log_file, "%24.24s APRS server port not assign.\n", ctime(&atime));
                false_ret - TRUE;
                fflush (log_file);
        }
	else
	{
		if (aprs_name[0] == 0x20)
		{	
			fprintf (log_file, "%24.24s APRS server name not assign.\n", ctime(&atime));
			false_ret - TRUE;
			fflush (log_file);
		}

	}
	
	if (!memcmp (client_callsign, "XX0XXX", 6))
	{
		fprintf (log_file, "%24.24s CALLSIGN not define.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	} 
	if (false_ret) return FALSE;
	return TRUE;
	
}

void	module_init(struct ModuleTable *module, unsigned char Module[], int port)
{
	module->AccessTime = 0;
	memcpy (module->ModuleName, Module, 8);
	memset (module->mycall, 0x20, 8);
	memset (module->mycall_ex, 0x20, 4);
	memset (module->rptcall, 0x20, 8);
	module->AprsSend = 0x00;
	module->RX_on = FALSE;
	module->aprs_msg_pnt = 0;
	module->packet_cnt = 0;
	module->HeaderCnt = 0;
	module->RadioVoicePacketCnt = 0;
	module->f_chain = NULL;
	module->port = 0;
	module->SendSeq = 0;
	module->rpt_save_length = 0;
	module->recv_time.tv_sec = 0;
	module->recv_time.tv_usec = 0;
	module->lost_cnt = 0;
}

void	forward_init (struct forward *fwd, unsigned char FullName[], int port)
{
	fwd->f_chain = NULL;
	fwd->port = port;
	memcpy (fwd->fqdn, FullName, 128);
	fwd->packets = 0;
}

void    status_init (struct status *sta, unsigned char FullName[], int port)
{
        sta->f_chain = NULL;
        sta->port = port;
        memcpy (sta->fqdn, FullName, 128);
        sta->packets = 0;
	memset (sta->userID, 0x00, 16);
	memset (sta->passwd, 0x00, 64);
	sta->status_info = NULL;
}

