unsigned char	dtmf_decode (unsigned char voice[])
{ 
	unsigned char	dtmf_mask[] = {0x82, 0x08, 0x20, 0x82, 0x00, 0x00, 0x82, 0x00, 0x00};
	unsigned char	dtmf_sig[]  = {0x82, 0x08, 0x20, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00};
	unsigned char	dtmf_sym_mask[] = {0x10, 0x40, 0x08, 0x20};
	unsigned char	dtmf_sym0[]     = {0x00, 0x40, 0x08, 0x20};
	unsigned char	dtmf_sym1[]     = {0x00, 0x00, 0x00, 0x00};
	unsigned char	dtmf_sym2[]     = {0x00, 0x40, 0x00, 0x00};
	unsigned char	dtmf_sym3[]     = {0x10, 0x00, 0x00, 0x00};
	unsigned char	dtmf_sym4[]     = {0x00, 0x00, 0x00, 0x20};
	unsigned char	dtmf_sym5[]     = {0x00, 0x40, 0x00, 0x20};
	unsigned char	dtmf_sym6[]     = {0x10, 0x00, 0x00, 0x20};
	unsigned char	dtmf_sym7[]     = {0x00, 0x00, 0x08, 0x00};
	unsigned char	dtmf_sym8[]     = {0x00, 0x40, 0x08, 0x00};
	unsigned char	dtmf_sym9[]     = {0x10, 0x00, 0x08, 0x00};
	unsigned char	dtmf_symA[]     = {0x10, 0x40, 0x00, 0x00};
	unsigned char	dtmf_symB[]     = {0x10, 0x40, 0x00, 0x20};
	unsigned char	dtmf_symC[]     = {0x10, 0x40, 0x08, 0x00};
	unsigned char	dtmf_symD[]     = {0x10, 0x40, 0x08, 0x20};
	unsigned char	dtmf_symS[]     = {0x00, 0x00, 0x08, 0x20};
	unsigned char	dtmf_symH[]     = {0x10, 0x00, 0x08, 0x20};
	unsigned char	temp[4], code;

	code = ' ';

	if (((voice[0] & dtmf_mask[0]) == dtmf_sig[0])
		&& ((voice[1] & dtmf_mask[1]) == dtmf_sig[1])
		&& ((voice[2] & dtmf_mask[2]) == dtmf_sig[2])
		&& ((voice[3] & dtmf_mask[3]) == dtmf_sig[3])
		&& ((voice[4] & dtmf_mask[4]) == dtmf_sig[4])
		&& ((voice[5] & dtmf_mask[5]) == dtmf_sig[5])
		&& ((voice[6] & dtmf_mask[6]) == dtmf_sig[6])
		&& ((voice[7] & dtmf_mask[7]) == dtmf_sig[7])
		&& ((voice[8] & dtmf_mask[8]) == dtmf_sig[8]))
	{
		temp[0] = voice[4] & dtmf_sym_mask[0];
		temp[1] = voice[5] & dtmf_sym_mask[1];
		temp[2] = voice[7] & dtmf_sym_mask[2];
		temp[3] = voice[8] & dtmf_sym_mask[3];

		if (!memcmp(temp, dtmf_sym0, 4)) code = '0';
		else if (!memcmp(temp, dtmf_sym1, 4)) code ='1';
		else if (!memcmp(temp, dtmf_sym2, 4)) code ='2';
		else if (!memcmp(temp, dtmf_sym3, 4)) code ='3';
		else if (!memcmp(temp, dtmf_sym4, 4)) code ='4';
		else if (!memcmp(temp, dtmf_sym5, 4)) code ='5';
		else if (!memcmp(temp, dtmf_sym6, 4)) code ='6';
		else if (!memcmp(temp, dtmf_sym7, 4)) code ='7';
		else if (!memcmp(temp, dtmf_sym8, 4)) code ='8';
		else if (!memcmp(temp, dtmf_sym9, 4)) code ='9';
		else if (!memcmp(temp, dtmf_symA, 4)) code ='A';
		else if (!memcmp(temp, dtmf_symB, 4)) code ='B';
		else if (!memcmp(temp, dtmf_symC, 4)) code ='C';
		else if (!memcmp(temp, dtmf_symD, 4)) code ='D';
		else if (!memcmp(temp, dtmf_symS, 4)) code ='*';
		else if (!memcmp(temp, dtmf_symH, 4)) code ='#';
	}
	return code;
}

