#include "dxchange.h"

void	handler (int sig)
{
	time_t	atime;

	if (sig == SIGTERM) sig_term = TRUE;
	else if (sig == SIGINT)  sig_term = TRUE;
        else if (sig == SIGUSR1)
        {
		aprs_link_start();
        }
	else if (sig == SIGUSR2)
	{
		time(&atime);
		if (debug_sw)
		{
			fprintf (log_file, "%24.24s Leave Debug Mode\n",ctime(&atime));
			debug_sw = FALSE;
		}
		else
		{
			fprintf (log_file, "%24.24s Enter Debug Mode\n",ctime(&atime));
			debug_sw = TRUE;
		}
		fflush (log_file);
	}
}

int	handler_init(void)
{
	time_t atime;

	time (&atime);
	if (signal(SIGUSR1, handler) == SIG_ERR)
	{
		fprintf (log_file, "%24.24s signal (SIGUSR1) error\n", ctime(&atime));
		fflush (log_file);
		return FALSE;
	}	
	if (signal(SIGUSR2, handler) == SIG_ERR)
	{
		fprintf (log_file, "%24.24s signal (SIGUSR2) error\n", ctime(&atime));
		fflush (log_file);
                return FALSE;
        }
        if (signal(SIGTERM, handler) == SIG_ERR)
        {
                fprintf (log_file, "%24.24s signal (SIGTERM) error\n", ctime(&atime));
                fflush (log_file);
                return FALSE;
        }
        if (signal(SIGINT, handler) == SIG_ERR)
        {
                fprintf (log_file, "%24.24s signal (SIGINT) error\n", ctime(&atime));
                fflush (log_file);
                return FALSE;
        }
	return TRUE;
}
