#include	"init.h"
#include	"dxchange.h"
#include	"config.h"

void	pselectSet(void);
void	portSet(void);
struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[], u_long ipaddr, u_short port);

extern	void	handler(int sig);

extern	int		rpt_sd;
extern	int		rpt_gw_sd;
sigset_t        	sigset;
sigset_t		save_sig;
struct  timespec        timeout;
time_t			start_time;

struct	sockaddr_in	in_sock;
int			len_in_sock;

int main(int argc, char** argv)
{

	int	ReDprsConnectCnt = 0;
	int	ReDprsConnectCount = 0;
	int	len;
	int	i;
	int	n;
	int	ret;
	unsigned char *tp;
	struct	forward	*fwd_pnt;
	struct	status	*sta_pnt;
	struct  ModuleTable     *module_next;

	time_t	atime;
	time_t	uptime;

	tzset();
	daemon (0, 0);

        uname(&uname_buf);

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}
	time (&start_time);
	fprintf (log_file, "%24.24s D-STAR X-change (dxchange) RP2C D-PRS V%5.5s (%s  %s) Start\n", 
						ctime(&start_time), PACKAGE_VERSION, __DATE__, __TIME__);
	if (debug_sw)	fprintf (log_file, "                         %s %s %s\n",
						uname_buf.sysname, uname_buf.release, uname_buf.version);
	fflush (log_file);

	pid_file = fopen(PID_FILE, "w");
	if (pid_file == NULL)
	{
		fprintf (log_file, "%24.24s Already running dxchange.\n", ctime(&atime));
		fclose (log_file);
		return -1;
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file); 

	/* default value */
	send_interval = SEND_INTERVAL;
	server_port = DPRS_PORT;
	strcpy (server_name, DPRS_SERVER);
	recv_port = RECV_PORT;
	AutoReLink = 1;
	RetryCnt = RETRY_COUNT;
	BeaconLat = Latitude_Default; 
	BeaconLong = Longitude_Default;
	BeaconInterval = Beacon_Interval;
	time(&BeaconTime);
	reload = FALSE;
	sig_term = FALSE;
	gps_only_skip = FALSE;
	gps_skip_bits = 2;
	debug_sw = FALSE;
	aprs_cnt = 0;

	module_pnt = NULL;

	forward_pnt = NULL;
	status_pnt = NULL;
	verify_sw = FALSE;

	http_port = 0;
	trust_port = 0;
	send_port = 0;

	memset (aprs_server, 0x00, 16);
	memset (xmit_pass_code, 0x00, 10);
	memset (RECV_NIC, 0x00, 8);
	memset (SEND_NIC, 0x00, 8);
	memset (GW_NIC, 0x00, 8);
	send_check_init();

	if (!handler_init()) goto end;

	if (!read_config (argc, (char **)argv)) goto end;

	time (&atime);
	if (debug_sw) fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
	fflush (log_file);

	pselectSet();	// FD & sig init

	if (!repeater_init()) goto end;

	portSet();

	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL, 
				(fd_set *)NULL, &timeout, &sigset);
		if (ret < 0) 
		{
                	time(&atime);
                	fprintf (log_file, "%24.24s pselect error\n", ctime(&atime));
                	fflush (log_file);
			break;
		}

		else if (ret > 0)
		{
                	if (FD_ISSET (rpt_sd, &read_set))
                	{
                        	if (!repeater()) break;
                	}
			
			if (FD_ISSET(rpt_gw_sd, &read_set))
			{
				repeater_gw();
			}

			fwd_pnt = forward_pnt;
			while (fwd_pnt)
			{
				if ((fwd_pnt->fwd_sd > 0) && FD_ISSET(fwd_pnt->fwd_sd, &read_set))
								forward_recv (fwd_pnt);
				fwd_pnt = fwd_pnt->f_chain;
			}
				

			if (FD_ISSET (http_sd, &read_set)) http_srv_accept();

			if (FD_ISSET (trust_sd, &read_set)) trust();

			if (http_port)
			{
				for (i = 0 ; i < FD_SETSIZE ; i++)
				{
					if (FD_ISSET (i, &read_set))
					{
						if ((i == aprs_sd) 
							|| (i == rpt_sd)
							|| (i == rpt_gw_sd)
							|| (i == http_sd) 
							|| (i == trust_sd)) goto skip;
						fwd_pnt = forward_pnt;
						while (fwd_pnt)
						{
							if (i == fwd_pnt->fwd_sd) goto skip;
							fwd_pnt = fwd_pnt->f_chain;
						}
						http_srv_recv(i);
					}
					skip:	continue;					
				}
			}
		}
		else
		{
			lost_frame();
		}

		if (!aprs()) break;
		if (sig_term) break;
	
	}

	// socket close
	if (rpt_sd) close (rpt_sd);
	if (aprs_sd) close (aprs_sd);
end:
	time(&atime);
	uptime = atime - start_time;
	fprintf (log_file, "%24.24s D-STAR X-change (dxchange) ID-RP2C Interface terminated (Up : %dd%2dh%2dm%2ds)\n\n",
			ctime(&atime), 
			(uptime / 86400),
			((uptime % 86400) / 3600),
			(((uptime % 86400) % 3600) / 60),
			(((uptime % 86400) % 3600) % 60));
	fclose (log_file);
	if (forward_pnt)
	{
		fwd_pnt = forward_pnt;
		while (fwd_pnt)
		{
		 	close (fwd_pnt->fwd_sd);
			fwd_pnt = fwd_pnt->f_chain;
		}
	}
	if (status_pnt)
	{
		sta_pnt = status_pnt;
		while (sta_pnt)
		{
			close (sta_pnt->status_sd);
			sta_pnt = sta_pnt->f_chain;
		}
	}
	if (http_port > 0) close (http_sd);
	remove (PID_FILE);
    	return 0;
}

void	pselectSet(void)
{
	FD_ZERO (&fd_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}

struct ModuleTable *module_check (unsigned char call[])
{

	struct ModuleTable *pnt;

	pnt = module_pnt;

	while (pnt)
	{
		if (!memcmp (call, pnt->ModuleName, 8)) return pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}


struct 	ModuleTable *module_check_ex (unsigned char FrameID[], u_long ip_addr, u_short port)
{
	struct ModuleTable *pnt;

	pnt = module_pnt;
	while (pnt)
	{
		if ((ip_addr == pnt->ipaddress) && (port == pnt->port))
		{
			if (!memcmp (FrameID, pnt->FrameID, 2)) return  pnt;
		}
		pnt = pnt->f_chain;
	}
	return NULL;
}

