#include	"dxchange.h"

struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[], u_long ipaddr, u_short port);

extern	struct	sockaddr_in	in_sock;
extern	int	len_in_sock;
struct	sockaddr_in	rpt_addr;
struct	sockaddr_in	rpt_gw_addr;

int	rpt_sd;
int	rpt_gw_sd;

struct	dstar_packet	d_packet;

void	repeater_gw(void)
{
	int	length;
	int	sock_len;
	struct	sockaddr_in	gw_sock;
	struct	forward		*pnt;

	sock_len= sizeof(gw_sock);
	length = recvfrom(rpt_gw_sd, &d_packet, sizeof(d_packet), 0, 
				(struct sockaddr *)&gw_sock, &sock_len);

        pnt = forward_pnt;
        while (pnt)
        {
                sendto (pnt->fwd_sd, &d_packet, length, 0,
                        (struct sockaddr *)&pnt->fwd_addr, sizeof(pnt->fwd_addr));
                pnt = pnt->f_chain;
        }
}


int	repeater(void)
{
	struct	ModuleTable	*m_pnt;
	int	length;
	int	send_length;
	int	data_length;
	time_t	atime;
	int	ret;
	struct	status		*sta_pnt;
	u_long	ip_temp;
	u_short	port_temp;
	int	frame_seq;
	struct	timeval		time_21ms;
	struct	timeval		cur_time;
	struct	timeval		time_temp;

	len_in_sock = sizeof (in_sock);
    	length = recvfrom(rpt_sd, &d_packet, sizeof(d_packet), 0, (struct sockaddr *)&in_sock, &len_in_sock);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s Repeater data Reciv. error\n", ctime(&atime));
        	return FALSE;			// end
    	}

	if (!memcmp(d_packet.id, "DSTR", 4) && (d_packet.sr == 0x73) 
		&& (d_packet.c == 0x12) && (d_packet.trunk.FrameType == 0x20) && ((d_packet.trunk.FrameSeq & 0x3f) < 21))		// check D-STAR packet (DSTR)
	{
		if (length == 58)
		{
			m_pnt = module_check(d_packet.body.header.rpt1);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &d_packet, 58);
				m_pnt->rpt_save_length = 58;
				rep_send (m_pnt);
				m_pnt->FrameID[0] = d_packet.trunk.FrameID[0];
				m_pnt->FrameID[1] = d_packet.trunk.FrameID[1];
                        	memcpy (&m_pnt->ipaddress, &in_sock.sin_addr.s_addr, 4);
                        	memcpy (&m_pnt->port, &in_sock.sin_port, 2);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if (length == 29) // voice packet ICOM
		{
			memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
			memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (d_packet.trunk.FrameID, ip_temp, port_temp);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &d_packet, 29);
				m_pnt->rpt_save_length = 29;
				rep_send (m_pnt);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if (length == 32) // Last Frame ICOM
		{
                        memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
                        memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (d_packet.trunk.FrameID, ip_temp, port_temp); 
			if (m_pnt)
			{
                        	memcpy (&m_pnt->rpt_save, &d_packet, 32);
                        	m_pnt->rpt_save_length = 32;
				rep_send (m_pnt);
				m_pnt->rpt_save_length = 0;
				m_pnt->recv_time.tv_sec = 0;
				m_pnt->recv_time.tv_usec = 0;
			
			}
		}
		if (forward_pnt) forward (d_packet, length);
	}
	return TRUE;
}

int	repeater_init(void)
{
	struct	ifreq	ifr;
	time_t	atime;

    	// IPv4 UDP socket
    	if((rpt_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
                time(&atime);
                fprintf (log_file, "%24.24s Repeater socket not open\n", ctime(&atime));
        	return FALSE;	
    	}

        // 待ち受けるIPとポート番号を設定
        rpt_addr.sin_family = AF_INET;
        rpt_addr.sin_port = htons(recv_port);
        rpt_addr.sin_addr.s_addr = INADDR_ANY;

	if (RECV_NIC[0] != 0x00)
	{
		ifr.ifr_addr.sa_family = AF_INET;
		strncpy (ifr.ifr_name, RECV_NIC, IFNAMSIZ-1);
		time (&atime);
		if (ioctl (rpt_sd, SIOCGIFADDR, &ifr) >= 0)
		{
			rpt_addr.sin_addr.s_addr = 
				((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
			fprintf (log_file, "%24.24s NIC (%s) Repeater Receive Port %d open.\n", 
					ctime(&atime), RECV_NIC, recv_port);
			
		}
		else
		{
			fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), RECV_NIC);
		}
		fflush (log_file);
	}	
	
	FD_SET (rpt_sd, &fd_save);

    	// Bind
    	if(bind(rpt_sd, (struct sockaddr *)&rpt_addr, sizeof(rpt_addr)) < 0) {
		time(&atime);
		fprintf (log_file, "%24.24s Repeater socket not bind %s\n", ctime(&atime), strerror(errno));
        	return FALSE;
    	}

/* ========================================================== */
	if (send_port == 0) return TRUE;
	
        if((rpt_gw_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        {
                time(&atime);
                fprintf (log_file, "%24.24s Repeater(GW) socket not open\n", ctime(&atime));
		send_port = 0;
                return TRUE;
        }

        // 待ち受けるIPとポート番号を設定
        rpt_gw_addr.sin_family = AF_INET;
        rpt_gw_addr.sin_port = htons(send_port);
        rpt_gw_addr.sin_addr.s_addr = INADDR_ANY;

        if (SEND_NIC[0] != 0x00)
        {
                ifr.ifr_addr.sa_family = AF_INET;
                strncpy (ifr.ifr_name, SEND_NIC, IFNAMSIZ-1);
                time (&atime);
                if (ioctl (rpt_sd, SIOCGIFADDR, &ifr) >= 0)
                {
                        rpt_gw_addr.sin_addr.s_addr =
                                ((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
                        fprintf (log_file, "%24.24s NIC (%s) Repeater Send Port %d open.\n",
                                        ctime(&atime), SEND_NIC, recv_port);

                }
                else
                {
                        fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), SEND_NIC);
                }
                fflush (log_file);
        }

        FD_SET (rpt_sd, &fd_save);

        // Bind
        if(bind(rpt_gw_sd, (struct sockaddr *)&rpt_gw_addr, sizeof(rpt_gw_addr)) < 0) {
                time(&atime);
                fprintf (log_file, "%24.24s Repeater(GW) socket not bind %s\n", ctime(&atime), strerror(errno));
                send_port = 0;
        }
	return TRUE;
}
