#include	"dxchange.h"
#include	"monitor.h"


void    dcs2dplus (void);
int	dcs_c2dcs (void);
void	dcs2icom (void);
void    dcs_send (struct ModuleTable *id);
void    dcs_connect (struct ModuleTable *pnt);

struct	DCS_MSG	DCS_Msg;

void	jarl2dcs_header (struct dstar_packet pkt, struct ModuleTable *id)
{
	memcpy (&id->DCS_Frm.FrameType[0], "0001", 4);
	memcpy (&id->DCS_Frm.flags[0], &pkt.body.header, 39);
	memcpy (&id->DCS_Frm.FrameID[0], &pkt.trunk.FrameID[0], 3);
	id->DCS_Frm.mycall[7] = 0x20;
	memset (&id->DCS_Frm.Message[0], 0x20, 20);
	id->DCS_Frm.FrameVer[0] = 0x01;
	id->DCS_Frm.FrameVer[1] = 0x00;
	id->DCS_Frm.Language = 0x21;
	id->DCS_FrameCounter = 0;
}

void	jarl2dcs_voice_send (struct dstar_packet pkt, struct ModuleTable *id)
{
	time_t	atime;
        struct  connected_table *pnt;

        id->DCS_Frm.FrameSeq = pkt.trunk.FrameSeq;

	memcpy (id->DCS_Frm.Voice, &pkt.body.voice, 12);
	dcs_send (id);
}

void	dcs_send (struct ModuleTable *id)
{
	time_t	atime;
	struct	connected_table	*pnt;

	id->DCS_Frm.FrameCnt[0] = id->DCS_FrameCounter & 0xff;
	id->DCS_Frm.FrameCnt[1] = (id->DCS_FrameCounter >> 8) & 0xff;
	id->DCS_Frm.FrameCnt[2] = (id->DCS_FrameCounter >> 16) & 0xff;
	id->DCS_Frm.Source = 0x33;
	id->DCS_FrameCounter++;

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->protocol == DCS)
		{
			if (!memcmp (id->ModuleName, pnt->module, 8))
			{
				memcpy (&id->DCS_Frm.rpt2, pnt->module, 8);
       	                	from.sin_addr.s_addr = pnt->ip_address;
                        	from.sin_port = pnt->port;
                        	if (sendto(pnt->sd, &id->DCS_Frm, 100,
                                	0, (struct sockaddr *)&from, sizeof(from)) < 0)
                        	{
					time (&atime);
                                	fprintf (log_file, "%24.24s sendto error %s\n", ctime(&atime), strerror(errno));
					fflush (log_file);
       	                	}
			}
			else
			{
                               if (id->DCS_Frm.FrameSeq == 20)
                               {
                                       memset (&DCS_Msg, 0x00, 35);
                                       memcpy (&DCS_Msg.call, id->DCS_Frm.mycall, 8);
                                       memcpy (&DCS_Msg.msg, "Talk on ", 8);
                                       memcpy (&DCS_Msg.module, id->ModuleName, 8);
                                       from.sin_addr.s_addr = pnt->ip_address;
                                       from.sin_port = pnt->port;
                                       sendto (pnt->sd, &DCS_Msg, 35, 0, (struct sockaddr *)&from, sizeof(from));
                               }

			}
		}
                pnt = pnt->f_chain;
        }
	memcpy (&id->DCS_Frm.rpt2, id->dcs_module, 8);
	sendto (id->dcs_sd, &id->DCS_Frm, 100, 0, (struct sockaddr *)&id->dcs_addr, sizeof(id->dcs_addr));
}

void	jarl2dcs_voice_last_send (struct dstar_packet pkt, struct ModuleTable *id)
{
	time_t	atime;
        struct  connected_table *pnt;

        id->DCS_Frm.FrameCnt[0] = id->DCS_FrameCounter & 0xff;
        id->DCS_Frm.FrameCnt[1] = (id->DCS_FrameCounter >> 8) & 0xff;
        id->DCS_Frm.FrameCnt[2] = (id->DCS_FrameCounter >> 16) & 0xff;
        id->DCS_Frm.Source = 0x33;
        id->DCS_FrameCounter++;
	id->DCS_Frm.FrameSeq = pkt.trunk.FrameSeq;
        memcpy (&id->DCS_Frm.Voice[0], &pkt.body, 12);
	memset (&id->DCS_Frm.SlowData, 0x55, 3);

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (!memcmp(id->ModuleName, pnt->module, 8))
		{
			if (pnt->protocol == DCS)
			{
                       		from.sin_addr.s_addr = pnt->ip_address;
                       		from.sin_port = pnt->port;
                       		if (sendto(pnt->sd, &id->DCS_Frm, 100,
                               		0, (struct sockaddr *)&from, sizeof(from)) < 0)
                       		{
					time (&atime);
                               		fprintf (log_file, "%24.24s sendto errori %s\n", ctime(&atime), strerror(errno));
					fflush (log_file);
                       		}
			}
		}
               	pnt = pnt->f_chain;
        }
	memcpy (&id->DCS_Frm.rpt2, id->dcs_module, 8);
	sendto (id->dcs_sd, &id->DCS_Frm, 100, 0, (struct sockaddr *)&id->dcs_addr, sizeof(id->dcs_addr));
}

void	dcs2icom (void)
{
	unsigned short int	dstar_crc;
	struct	ModuleTable	*pnt;
	struct	dstar_packet		icom_pkt;
	struct	icom_inet_packet	icom_inet_pkt;
	time_t atime;
	int	len;

	pnt = module_pnt;

	while (pnt)
	{
		if (pnt->port && pnt->voice_port)
		{
			if (!memcmp(pnt->ModuleName, packet.DCS_Frame.rpt1, 8) || !memcmp(pnt->ModuleName, packet.DCS_Frame.rpt2, 8))
			{ 
				if (pnt->voice_port == 40000)
				{
					if (memcmp(pnt->FrameID, packet.DCS_Frame.FrameID, 2))
					{
						memcpy (icom_inet_pkt.id, "DSVT", 4);
						icom_inet_pkt.type = 0x10;
						icom_inet_pkt.resv[0] = 0x00;
						icom_inet_pkt.resv[1] = 0x00;
						icom_inet_pkt.resv[2] = 0x00;
						icom_inet_pkt.trunk.FrameType = 0x20;
						icom_inet_pkt.trunk.dst_rpt_id = 0x00;
						icom_inet_pkt.trunk.src_rpt_id = 0x01;
						icom_inet_pkt.trunk.src_term_id = 0x02;
						memcpy (&icom_inet_pkt.trunk.FrameID, packet.DCS_Frame.FrameID, 2);
						icom_inet_pkt.trunk.FrameSeq = 0x80;
						memcpy (&icom_inet_pkt.body, packet.DCS_Frame.flags, 39);
						memcpy (icom_inet_pkt.body.header.rpt1, pnt->ModuleName, 8);
						memcpy (icom_inet_pkt.body.header.rpt2, pnt->ModuleName, 8);
						icom_inet_pkt.body.header.rpt1[7] = 'G';
						dstar_crc = crc_calc (&icom_inet_pkt.body, 39);
						icom_inet_pkt.body.header.crc[0] = dstar_crc >> 8;
						icom_inet_pkt.body.header.crc[1] = dstar_crc & 0xff;
						memcpy (pnt->FrameID, packet.DCS_Frame.FrameID, 2);
						voice_addr.sin_addr.s_addr = pnt->ipaddress;
						voice_addr.sin_port = htons(pnt->voice_port);
						sendto (voice_sd, &icom_inet_pkt, 56, 0, 
							(struct sockaddr *)&voice_addr, sizeof(voice_addr));
					}
					if (!memcmp(pnt->FrameID, packet.DCS_Frame.FrameID, 2))
					{
						memcpy (icom_inet_pkt.id, "DSVT", 4);
						icom_inet_pkt.type = 0x20;
						icom_inet_pkt.resv[0] = 0x00;
						icom_inet_pkt.resv[1] = 0x00;
						icom_inet_pkt.resv[2] = 0x00;
						icom_inet_pkt.trunk.FrameType = 0x20;
						icom_inet_pkt.trunk.dst_rpt_id = 0x00;
						icom_inet_pkt.trunk.src_rpt_id = 0x01;
						icom_inet_pkt.trunk.src_term_id = 0x02;
						memcpy (&icom_inet_pkt.trunk.FrameID, packet.DCS_Frame.FrameID, 2);
						icom_inet_pkt.trunk.FrameSeq = packet.DCS_Frame.FrameSeq;
						memcpy (&icom_inet_pkt.body, packet.DCS_Frame.Voice, 12);
						voice_addr.sin_addr.s_addr = pnt->ipaddress;
						voice_addr.sin_port = htons(pnt->voice_port);
						sendto (voice_sd, &icom_inet_pkt, 27, 0, (struct sockaddr *)&voice_addr, sizeof(voice_addr));
						if (icom_inet_pkt.trunk.FrameSeq & 0x40) memset (pnt->FrameID, 0x00, 2); 
					}
					
				}
				else
				{
					if (memcmp(pnt->FrameID, packet.DCS_Frame.FrameID, 2))
					{
						memcpy (&icom_pkt.id, "DSTR", 4);
						icom_pkt.m[0] = (pnt->SendSeq >> 8) & 0xff;
						icom_pkt.m[1] = pnt->SendSeq & 0xff;
						pnt->SendSeq++;
						icom_pkt.sr = 'r';
						icom_pkt.c = 0x11;
						icom_pkt.l[0] = 0x00;
						icom_pkt.l[1] = 0x30;
						
						memcpy (&icom_pkt.body, packet.DCS_Frame.flags, 39);
						icom_pkt.trunk.FrameID[0] = packet.DCS_Frame.FrameID[0];
						icom_pkt.trunk.FrameID[1] = packet.DCS_Frame.FrameID[1];
						icom_pkt.trunk.FrameSeq = 0x80;
						icom_pkt.trunk.FrameType = 0x20;	// voice
						dstar_crc = crc_calc (&icom_pkt.body, 39);
						icom_pkt.body.header.crc[0] = dstar_crc >> 8;
						icom_pkt.body.header.crc[1] = dstar_crc & 0xff;
						icom_pkt.trunk.dst_rpt_id = 0x00;
						icom_pkt.trunk.src_rpt_id = 0x01;
						icom_pkt.trunk.src_term_id = 0x02;
						memcpy (pnt->FrameID, packet.DCS_Frame.FrameID, 2);
						voice_addr.sin_addr.s_addr = pnt->ipaddress;
						voice_addr.sin_port = htons(pnt->voice_port);
						sendto (voice_sd, &icom_pkt, 58, 0,
							(struct sockaddr *)&voice_addr, sizeof(voice_addr));
					}
					if (!memcmp(pnt->FrameID, packet.DCS_Frame.FrameID, 2))
					{
						memcpy (&icom_pkt.id, "DSTR", 4);
						icom_pkt.m[0] = (pnt->SendSeq >> 8) & 0xff;
						icom_pkt.m[1] = pnt->SendSeq & 0xff;
						pnt->SendSeq++;
						icom_pkt.sr = 'r';
						icom_pkt.c = 0x11;
						icom_pkt.l[0] = 0x00;
						if (packet.DCS_Frame.FrameSeq & 0x40)
						{
							icom_pkt.l[1] = 0x16;
							icom_pkt.body.last_voice.dummy[0] = 0x25;
							icom_pkt.body.last_voice.dummy[1] = 0x1a;
							icom_pkt.body.last_voice.dummy[2] = 0xc6;
							len = 32;
							pnt->SendSeq = 0;
						}	
						else
						{
							icom_pkt.l[1] = 0x13;
							len = 29;
						}

						memcpy (&icom_pkt.body, packet.DCS_Frame.Voice, 12);
						icom_pkt.trunk.FrameID[0] = packet.DCS_Frame.FrameID[0];
						icom_pkt.trunk.FrameID[1] = packet.DCS_Frame.FrameID[1];
						icom_pkt.trunk.FrameSeq = packet.DCS_Frame.FrameSeq;
						icom_pkt.trunk.FrameType = 0x20;        // voice
						icom_pkt.trunk.dst_rpt_id = 0x00;
						icom_pkt.trunk.src_rpt_id = 0x01;
						icom_pkt.trunk.src_term_id = 0x02;
						voice_addr.sin_addr.s_addr = pnt->ipaddress;
						voice_addr.sin_port = htons(pnt->voice_port);
						sendto (voice_sd, &icom_pkt, len, 0,
							(struct sockaddr *)&voice_addr, sizeof(voice_addr));
						if (icom_pkt.trunk.FrameSeq & 0x40) memset (pnt->FrameID, 0x00, 2);
					}

				}
			}
		}
		pnt = pnt->f_chain;
	}
	
	
}

int	dcs2dcs (void)
{
	struct	connected_table *pnt;
	u_long	ip_addr;
	int	port;
	time_t	atime;
	unsigned char	temp[10];
	int	i;

	if (xmit_pass_code[0] == 0x00) return FALSE;

	ip_addr = from.sin_addr.s_addr;
	port = from.sin_port;

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->protocol == DCS)
		{
			if (!memcmp(&pnt->module, packet.DCS_Frame.rpt2, 8))
			{
				if ((pnt->ip_address == ip_addr) && (pnt->port == port))
				{
					if (packet.DCS_Frame.FrameSeq & 0x40)
					{
						pnt->ptt = FALSE;
						if (dtmf_pos)
						{
							time(&atime);
							fprintf (log_file, "%24.24s DTMF CODE %s from %8.8s\n", 
									ctime(&atime), dtmf, pnt->callsign);
							fflush (log_file);
							if (!strcmp (dtmf, xmit_pass_code))
								pnt->re_xmit = TRUE;
							else
								pnt->re_xmit = FALSE;
						}
					}
					if (memcmp (&pnt->FrameID, &packet.DCS_Frame.FrameID, 2))
					{
						memcpy (&pnt->FrameID, &packet.DCS_Frame.FrameID, 2);
						memcpy (&pnt->mycall, &packet.DCS_Frame.mycall, 8);
						memcpy (&pnt->mycall_ex, &packet.DCS_Frame.mycall2, 4);
						time(&pnt->access_time);
						if (pnt->re_xmit) pnt->ptt = TRUE;
						dtmf_c_save = 0x20;
						dtmf_c_save1 = 0x00;
						dtmf_c_save2 = 0x00;
						dtmf_pos = 0;
						memset (dtmf, 0x00, 10);
					}
        				dtmf_c = dtmf_decode (packet.DCS_Frame.Voice);
        				if ((dtmf_c == dtmf_c_save1) && (dtmf_c == dtmf_c_save2))
        				{
						if (dtmf_c != dtmf_c_save)
						{
                					if (dtmf_c != 0x20) dtmf[dtmf_pos++] = dtmf_c;
                					if (dtmf_pos > 7) dtmf_pos = 7;
							dtmf_c_save = dtmf_c;
						}
        				}
					dtmf_c_save2 = dtmf_c_save1;
        				dtmf_c_save1 = dtmf_c;
					memset (temp, 0x00, 10);
					for (i = 0 ; i < 8 ; i++)
					{
						if (packet.DCS_Frame.urcall[i] == 0x20) break;
						temp[i] = packet.DCS_Frame.urcall[i];
					}
					if (!strcmp (temp, xmit_pass_code))
					{
						pnt->re_xmit = TRUE;
						memcpy (packet.DCS_Frame.urcall, "CQCQCQ  ", 8);
					}
					if (!pnt->re_xmit) return FALSE;
				}
			}
			else
			{
				if (packet.DCS_Frame.FrameSeq == 20)
				{
					memset (&DCS_Msg, 0x00, 35);
					memcpy (&DCS_Msg.call, packet.DCS_Frame.mycall, 8);
					memcpy (&DCS_Msg.msg, "Talk on ", 8);
					memcpy (&DCS_Msg.module, packet.DCS_Frame.rpt1, 8);
					from.sin_addr.s_addr = pnt->ip_address;
					from.sin_port = pnt->port;
					sendto (pnt->sd, &DCS_Msg, 35, 0, (struct sockaddr *)&from, sizeof(from));
				}
			}
		}
		pnt = pnt->f_chain;
	}

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->protocol == DCS)
		{
			if (!memcmp(&pnt->module, packet.DCS_Frame.rpt2, 8))
			{
				if ((ip_addr != pnt->ip_address) || (port != pnt->port))
				{
					from.sin_addr.s_addr = pnt->ip_address;
					from.sin_port = pnt->port;
					sendto (pnt->sd, &packet, 100, 0, (struct sockaddr *)&from, sizeof(from));
				}
			}
		}
		pnt = pnt->f_chain;
	}
	return TRUE;
}

void	dcs2dplus (void)
{
	struct	connected_table	*pnt;
	struct	Dplus	dplus_pkt;
	extern	unsigned char Dplus_ptt_off[];

	if (xmit_pass_code[0] == 0x00) return;
	dplus_pkt.reserve = 0x80;
	memcpy (&dplus_pkt.id, "DVST", 4);
	dplus_pkt.resv[1] = 0x00;
	dplus_pkt.resv[2] = 0x00;
	dplus_pkt.resv[3] = 0x00;
	dplus_pkt.trunk.id = 0x20;
	dplus_pkt.trunk.dst_rpt_id = 0x00;
	dplus_pkt.trunk.src_rpt_id = 0x01;
	dplus_pkt.trunk.src_term_id = 0x02;
	memcpy (dplus_pkt.trunk.FrameID, &packet.DCS_Frame.FrameID, 2);
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->protocol == DPLUS)
		{
			from.sin_addr.s_addr = pnt->ip_address;
			from.sin_port = pnt->port;
			if (memcmp(&pnt->ex_FrameID, &packet.DCS_Frame.FrameID,2))
			{
				dplus_pkt.length = 58;
				dplus_pkt.trunk.FrameSeq = 0x80;
				dplus_pkt.resv[0] = 0x10;		// header
				memcpy (&dplus_pkt.body.header, &packet.DCS_Frame.flags, 39);
				//memcpy (&dplus_pkt.body.header.rpt1, &dplus_pkt.body.header.rpt2, 8);
				sendto (pnt->sd, &dplus_pkt, 58, 0, (struct sockaddr *)&from, sizeof(from));
				memcpy (&pnt->ex_FrameID, &packet.DCS_Frame.FrameID, 2);
			}
			else
			{
				memcpy (&dplus_pkt.body.voice, &packet.DCS_Frame.Voice, 12);
				dplus_pkt.trunk.FrameSeq = packet.DCS_Frame.FrameSeq;
				if (dplus_pkt.trunk.FrameSeq & 0x40)
				{
					dplus_pkt.length = 32;
					dplus_pkt.resv[0] = 0x20;		// voice
					dplus_pkt.body.voice.voice[12] = 0x25;
					dplus_pkt.body.voice.voice[13] = 0x1a;
					dplus_pkt.body.voice.voice[14] = 0xc6;
					sendto (pnt->sd, &dplus_pkt, 32, 0, (struct sockaddr *)&from, sizeof(from));
					sendto (pnt->sd, &Dplus_ptt_off, 10, 0, (struct sockaddr *)&from, sizeof(from));
				}
				else
				{
					dplus_pkt.length = 29;
					dplus_pkt.resv[0] = 0x20;		// voice
					sendto (pnt->sd, &dplus_pkt, 29, 0, (struct sockaddr *)&from, sizeof(from));
				}
			}
				
		}
		pnt = pnt->f_chain;
	}
}

