#include	"dxchange.h"
#include	"monitor.h"
#include	"config.h"


void    dcs_c2dplus (struct ModuleTable *pnt);
int	dcs_c2dcs (void);
void	dcs2icom (void);
void    dcs_send (struct ModuleTable *id);
void    dcs_c_connect (struct ModuleTable *pnt);

struct	DCS_MSG	DCS_Msg;

enum
{
        DCS_OPEN = 0,
        DCS_LOOP,
        DCS_NG
} dcs_state = DCS_OPEN;

void	dcs_c (struct ModuleTable *pnt)
{
        int     length;
	int	err;
        socklen_t       from_len;
	char		temp[64];
	struct  addrinfo        hints, *res;
	time_t	atime;

	time (&atime);
	switch (pnt->dcs_state)
	{
		case DCS_OPEN:
			pnt->dcs_state = DCS_NG;
			if (pnt->dcs_port == 0) break;
                       	sprintf (temp, "%6.6s.xreflector.net", pnt->dcs_module);
                        memset (&hints, 0x00, sizeof(hints));
                        hints.ai_socktype = SOCK_DGRAM;
                        hints.ai_family = AF_INET;
                       	if ((err = getaddrinfo (temp, NULL, &hints, &res)) != 0)
                        {
                             	fprintf (log_file, "%24.24s getaddrinfo error \"%8.8s\" (DCS:%s:%0d) %s\n",
                                               ctime(&atime), pnt->dcs_module, temp, pnt->dcs_port, gai_strerror(err));
                                pnt->dcs_port = 0;
                                dcs_cnt--;
                        }
                        else
			{
                          	if ((pnt->dcs_sd = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
                               	{
                                        fprintf (log_file, "%24.24s DCS UDP Socket not open. Already used this port:%d\n", 
							ctime(&atime), trust_port);
                                        fflush (log_file);
                                        pnt->dcs_port = 0;
                                        dcs_cnt--;
                                 }
                                 else
                                 {
                                      	pnt->dcs_addr.sin_addr.s_addr = ((struct sockaddr_in *)(res->ai_addr))->sin_addr.s_addr;
                                        pnt->dcs_addr.sin_family = AF_INET;
                                        pnt->dcs_addr.sin_port = htons(pnt->dcs_port);
                                        fprintf (log_file, "%24.24s DCS Port \"%8.8s\" (%s:%0d) open.\n", 
							ctime(&atime), pnt->dcs_module, temp, pnt->dcs_port);
                                        FD_SET (pnt->dcs_sd, &fd_save);
                                        if (pnt->dcs_module[7] != 0x20) dcs_c_connect (pnt);
					time (&pnt->dcs_recv_time);
					pnt->dcs_state = DCS_LOOP;
                              	}
                               	freeaddrinfo (res);
                       	}
			break;

		case DCS_LOOP:
			if (FD_ISSET (pnt->dcs_sd, &read_set))
			{
        			from_len = sizeof(from);
        			memset(&from, 0, sizeof(from));
        			from.sin_family = AF_INET;
        			from.sin_port = htons(pnt->dcs_port);
        			from.sin_addr.s_addr = htonl(INADDR_ANY);
        			length = recvfrom (pnt->dcs_sd, &packet, 519,
                        	        0, (struct sockaddr *)&from, &from_len);
				if (length > 0) time (&pnt->dcs_recv_time);
				if (length == 22)	// heart beat (keep alive)
				{
					memcpy (temp, packet.DCS_Poll_Req.callsign, 8);
					packet.DCS_Poll_Req.filler = 0x00;
					memcpy (packet.DCS_Poll_Req.callsign, packet.DCS_Poll_Req.XrefName, 8);
					memcpy (packet.DCS_Poll_Req.XrefName, temp, 8);
					sendto (pnt->dcs_sd, &packet, 17, 0, (struct sockaddr *)&pnt->dcs_addr, sizeof(pnt->dcs_addr));
				}
				else if (length == 100)	// voice (include header & message)
				{
					if (dcs_c2dcs())
					{
						dcs_c2dplus(pnt);
						dcs2icom();
					}
				}
				else if (length == 15)	// info.
				{
				}
			}
			if ((atime - pnt->dcs_recv_time) > 20)
			{
				pnt->dcs_state = DCS_OPEN;
				FD_CLR (pnt->dcs_sd, &fd_save);
				close (pnt->dcs_sd);
                               	fprintf (log_file, "%24.24s %8.8s Disconnected\n", ctime(&atime), pnt->dcs_module);
                                fflush (log_file);
			}
			break;

		case DCS_NG:
			break;
	}
	
}

void	dcs_c_connect (struct ModuleTable *pnt)
{
	int	ret;

	memcpy (packet.DCS_Connect.callsign, pnt->ModuleName, 7);
	packet.DCS_Connect.callsign[7] = 0x20;
	packet.DCS_Connect.band = pnt->ModuleName[7];
	packet.DCS_Connect.module = pnt->dcs_module[7];
	memcpy (packet.DCS_Connect.XrefName, pnt->dcs_module, 7);
	memset (packet.DCS_Connect.html, 0x00, 500);
	sprintf (packet.DCS_Connect.html, "<table border=\"0\" width=\"95%\"><tr><td width=\"4%\"><img border=\"0\" src=http://www.d-star.asia/logo_jarl.png></td><td><font size=\"2\"><b> D-Xchange</b> V%5.5s %s<br><b>OS:</b> %s %s<br><b>HW:</b> %s</font></b></td></tr></table>", 
PACKAGE_VERSION, __DATE__, uname_buf.sysname, uname_buf.release, uname_buf.machine);


	ret = sendto (pnt->dcs_sd, &packet, 519, 0, (struct sockaddr *)&pnt->dcs_addr, sizeof(pnt->dcs_addr));

}

void	dcs2dcs_c (void)
{
	struct ModuleTable *pnt;

	pnt = module_pnt;
	while (pnt)
	{

		if (!memcmp(packet.DCS_Frame.rpt2, pnt->ModuleName, 8))
		{
        		if (pnt->dcs_module[0] != 0x20) 
			{
				memcpy (packet.DCS_Frame.rpt2, pnt->dcs_module, 8);
				sendto (pnt->dcs_sd, &packet, 100, 0, (struct sockaddr *)&pnt->dcs_addr, sizeof(pnt->dcs_addr));
			}
			break;
		}
		pnt = pnt->f_chain;
	}
}

int	dcs_c2dcs (void)
{
	struct  ModuleTable     *m_pnt;
	struct  connected_table *pnt;

	m_pnt = module_pnt;
	while (m_pnt)
	{
		if (!memcmp(m_pnt->dcs_module, packet.DCS_Frame.rpt2, 8))
		{
			memcpy (packet.DCS_Frame.rpt2, m_pnt->ModuleName, 8);
			break;
		}	
		m_pnt = m_pnt->f_chain;
		if (m_pnt == NULL) return FALSE;
	}

        pnt = first_pnt->f_chain;
        while (pnt)
        {
                if (pnt->protocol == DCS)
                {
			if (!memcmp(pnt->module, packet.DCS_Frame.rpt2, 8))
			{
                		from.sin_addr.s_addr = pnt->ip_address;
                        	from.sin_port = pnt->port;
                        	sendto (pnt->sd, &packet, 100, 0, (struct sockaddr *)&from, sizeof(from));
			}
                }
                pnt = pnt->f_chain;
        }
	return TRUE;
}

void	dcs_c2dplus (struct ModuleTable *m_pnt)
{
	struct	connected_table	*pnt;
	struct	Dplus	dplus_pkt;
	extern	unsigned char Dplus_ptt_off[];

	if (xmit_pass_code[0] == 0x00) return;
	dplus_pkt.reserve = 0x80;
	memcpy (&dplus_pkt.id, "DVST", 4);
	dplus_pkt.resv[1] = 0x00;
	dplus_pkt.resv[2] = 0x00;
	dplus_pkt.resv[3] = 0x00;
	dplus_pkt.trunk.id = 0x20;
	dplus_pkt.trunk.dst_rpt_id = 0x00;
	dplus_pkt.trunk.src_rpt_id = 0x01;
	dplus_pkt.trunk.src_term_id = 0x02;
	memcpy (dplus_pkt.trunk.FrameID, &packet.DCS_Frame.FrameID, 2);

	dplus_pkt.length = 58;
	dplus_pkt.trunk.FrameSeq = 0x80;
	dplus_pkt.resv[0] = 0x10;		// header
	memcpy (&dplus_pkt.body.header, &packet.DCS_Frame.flags, 39);
	//memcpy (&dplus_pkt.body.header.rpt1, &dplus_pkt.body.header.rpt2, 8);
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->protocol == DPLUS)
		{
			if (memcmp(&pnt->ex_FrameID, &packet.DCS_Frame.FrameID,2))
			{
				from.sin_addr.s_addr = pnt->ip_address;
				from.sin_port = pnt->port;
				sendto (pnt->sd, &dplus_pkt, 58, 0, (struct sockaddr *)&from, sizeof(from));
				memcpy (&pnt->ex_FrameID, &packet.DCS_Frame.FrameID, 2);
			}
		}
		pnt = pnt->f_chain;
	}
	memcpy (dplus_pkt.body.header.rpt2, m_pnt->ref_module, 8);
	if (m_pnt->ref_port && memcmp(m_pnt->ref_FrameID, &packet.DCS_Frame.FrameID, 2))
		{
			sendto (m_pnt->ref_sd, &dplus_pkt, 58, 0, (struct sockaddr *)&m_pnt->ref_addr, sizeof(m_pnt->ref_addr));
			memcpy(m_pnt->ref_FrameID, &packet.DCS_Frame.FrameID, 2);
		}

	memcpy (&dplus_pkt.body.voice, &packet.DCS_Frame.Voice, 12);
	dplus_pkt.trunk.FrameSeq = packet.DCS_Frame.FrameSeq;
	if (dplus_pkt.trunk.FrameSeq & 0x40)
	{
		dplus_pkt.length = 32;
		dplus_pkt.resv[0] = 0x20;		// voice
		dplus_pkt.body.voice.voice[12] = 0x25;
		dplus_pkt.body.voice.voice[13] = 0x1a;
		dplus_pkt.body.voice.voice[14] = 0xc6;
		pnt = first_pnt->f_chain;
		while (pnt)
		{
			if (pnt->protocol == DPLUS)
			{
				if (!memcmp(&pnt->ex_FrameID, &packet.DCS_Frame.FrameID, 2))
				{
					from.sin_addr.s_addr = pnt->ip_address;
					from.sin_port = pnt->port;
					sendto (pnt->sd, &dplus_pkt, 32, 0, (struct sockaddr *)&from, sizeof(from));
					sendto (pnt->sd, &Dplus_ptt_off, 10, 0, (struct sockaddr *)&from, sizeof(from));
				}
			}
			pnt = pnt->f_chain;
		}
		if (m_pnt->ref_port && !memcmp(m_pnt->ref_FrameID, &packet.DCS_Frame.FrameID, 2))
		{
			sendto (m_pnt->ref_sd, &dplus_pkt, 32, 0, (struct sockaddr *)&m_pnt->ref_addr, sizeof(m_pnt->ref_addr));
			sendto (m_pnt->ref_sd, &Dplus_ptt_off, 10, 0, (struct sockaddr *)&m_pnt->ref_addr, sizeof(m_pnt->ref_addr));
		}
	}
	else
	{
		dplus_pkt.length = 29;
		dplus_pkt.resv[0] = 0x20;		// voice
		pnt = first_pnt->f_chain;
		while (pnt)
		{
			if (pnt->protocol == DPLUS)
			{
				if (!memcmp(&pnt->ex_FrameID, &packet.DCS_Frame.FrameID, 2))
				{
					from.sin_addr.s_addr = pnt->ip_address;
					from.sin_port = pnt->port;
					sendto (pnt->sd, &dplus_pkt, 29, 0, (struct sockaddr *)&from, sizeof(from));
				}
			}
			pnt = pnt->f_chain;
		}
		if (m_pnt->ref_port && !memcmp(m_pnt->ref_FrameID, &packet.DCS_Frame.FrameID, 2))
			sendto (m_pnt->ref_sd, &dplus_pkt, 29, 0, (struct sockaddr *)&m_pnt->ref_addr, sizeof(m_pnt->ref_addr));
	}
}

