#include	"dxchange.h"
#include	"monitor.h"

void    ref_connect(struct ModuleTable *pnt);
void    dplus_verify_send(struct ModuleTable *pnt);



extern	char	Dplus_connect[];
extern	char	Dplus_verifyReq[];
extern	char	Dplus_verifyResp[];
extern	char	Dplus_keep_alive[];

void	dplus2icom(int length)
{

	unsigned short int	dstar_crc;
	struct	ModuleTable	*pnt;
	struct	dstar_packet		icom_pkt;
	time_t atime;
	int	len;

	pnt = module_pnt;

	while (pnt)
	{
		if (pnt->port && pnt->voice_port)
		{
			if (!memcmp(pnt->ModuleName, packet.dplus.body.header.rpt1, 8) 
					|| !memcmp(pnt->ModuleName, packet.dplus.body.header.rpt2, 8))
			{
				voice_addr.sin_addr.s_addr = pnt->ipaddress;
				voice_addr.sin_port = htons(pnt->voice_port);
				if (pnt->voice_port == 40000)
				{
					if (length == 58)
					{
						if (!memcmp (pnt->ModuleName, packet.dplus.body.header.rpt2, 8)
							|| !memcmp (pnt->ModuleName, packet.dplus.body.header.rpt1, 8))
						{
							if (memcmp (pnt->FrameID, packet.dplus.trunk.FrameID, 2))
							{
								memcpy (packet.dplus.body.header.rpt1, pnt->ModuleName, 8);
								memcpy (packet.dplus.body.header.rpt2, pnt->ModuleName, 8);
								memcpy (pnt->FrameID, packet.dplus.trunk.FrameID, 2);
								sendto (voice_sd, &packet+2, length-2, 0, 
									(struct sockaddr *)&voice_addr, sizeof(voice_addr));
							}
						}
					}
					else if (length == 29)
					{
						if (!memcmp (pnt->FrameID, packet.dplus.trunk.FrameID, 2))
						{
							sendto (voice_sd, &packet+2, length-2, 0, (struct sockaddr *)&voice_addr, sizeof(voice_addr));
						}
					}
					else if (length == 32)
					{
						if (!memcmp (pnt->FrameID, packet.dplus.trunk.FrameID, 2))
						{
							sendto (voice_sd, &packet+2, length-2, 0, (struct sockaddr *)&voice_addr, sizeof(voice_addr));
							memset (pnt->FrameID, 0x00, 2);
						}
					}
				}
				else
				{
					if (length == 58)
					{
						if (memcmp(pnt->FrameID, packet.dplus.trunk.FrameID, 2))
						{
							memcpy (&icom_pkt.id, "DSTR", 4);
							icom_pkt.m[0] = (pnt->SendSeq >> 8) & 0xff;
							icom_pkt.m[1] = pnt->SendSeq & 0xff;
							pnt->SendSeq++;
							icom_pkt.sr = 'r';
							icom_pkt.c = 0x11;
							icom_pkt.l[0] = 0x00;
							icom_pkt.l[1] = 0x30;
						
							memcpy (&icom_pkt.body, &packet.dplus.body, 39);
							icom_pkt.trunk.FrameID[0] = packet.dplus.trunk.FrameID[0];
							icom_pkt.trunk.FrameID[1] = packet.dplus.trunk.FrameID[1];
							icom_pkt.trunk.FrameSeq = 0x80;
							icom_pkt.trunk.FrameType = 0x20;	// voice
							dstar_crc = crc_calc (&icom_pkt.body, 39);
							icom_pkt.body.header.crc[0] = dstar_crc >> 8;
							icom_pkt.body.header.crc[1] = dstar_crc & 0xff;
							icom_pkt.trunk.dst_rpt_id = 0x00;
							icom_pkt.trunk.src_rpt_id = 0x01;
							icom_pkt.trunk.src_term_id = 0x02;
							memcpy (pnt->FrameID, packet.dplus.trunk.FrameID, 2);
							voice_addr.sin_addr.s_addr = pnt->ipaddress;
							voice_addr.sin_port = htons(pnt->voice_port);
							sendto (voice_sd, &icom_pkt, 58, 0,
								(struct sockaddr *)&voice_addr, sizeof(voice_addr));
						}
					}
					if ((length == 29) || (length == 32))
					{
						if (!memcmp(pnt->FrameID, packet.dplus.trunk.FrameID, 2))
						{
							memcpy (&icom_pkt.id, "DSTR", 4);
							icom_pkt.m[0] = (pnt->SendSeq >> 8) & 0xff;
							icom_pkt.m[1] = pnt->SendSeq & 0xff;
							pnt->SendSeq++;
							icom_pkt.sr = 'r';
							icom_pkt.c = 0x11;
							icom_pkt.l[0] = 0x00;
							if (packet.dplus.trunk.FrameSeq & 0x40)
							{
								icom_pkt.l[1] = 0x16;
								icom_pkt.body.last_voice.dummy[0] = 0x25;
								icom_pkt.body.last_voice.dummy[1] = 0x1a;
								icom_pkt.body.last_voice.dummy[2] = 0xc6;
								len = 32;
								pnt->SendSeq = 0;
								memset (pnt->FrameID, 0x00, 2);
							}	
							else
							{
								icom_pkt.l[1] = 0x13;
								len = 29;
							}
	
							memcpy (&icom_pkt.body, &packet.dplus.body, 12);
							icom_pkt.trunk.FrameID[0] = packet.dplus.trunk.FrameID[0];
							icom_pkt.trunk.FrameID[1] = packet.dplus.trunk.FrameID[1];
							icom_pkt.trunk.FrameSeq = packet.dplus.trunk.FrameSeq;
							icom_pkt.trunk.FrameType = 0x20;        // voice
							icom_pkt.trunk.dst_rpt_id = 0x00;
							icom_pkt.trunk.src_rpt_id = 0x01;
							icom_pkt.trunk.src_term_id = 0x02;
							voice_addr.sin_addr.s_addr = pnt->ipaddress;
							voice_addr.sin_port = htons(pnt->voice_port);
							sendto (voice_sd, &icom_pkt, len, 0,
								(struct sockaddr *)&voice_addr, sizeof(voice_addr));
						}
					}

				}
			}
		}
		pnt = pnt->f_chain;
	}
	
	
}

void    jarl2dplus_header_send (struct dstar_packet pkt, struct ModuleTable *id)
{
        struct  connected_table *pnt;
	time_t	atime;

        packet.dplus.length = 0x3a;
        packet.dplus.reserve  = 0x80;
        memcpy (packet.dplus.id, "DSVT", 4);
        packet.dplus.resv[0] = 0x10;
        packet.dplus.resv[1] = 0x00;
        packet.dplus.resv[2] = 0x00;
        packet.dplus.resv[3] = 0x00;
        memcpy (&packet.dplus.trunk, &pkt.trunk, 48);
        memcpy (&packet.dplus.body.header.rpt2, &id->ModuleName, 8);
        pnt = first_pnt->f_chain;
        while (pnt)
        {
                if (pnt->protocol == DPLUS)
                {

                        from.sin_addr.s_addr = pnt->ip_address;
                        from.sin_port = pnt->port;
                        if (sendto(pnt->sd, (char *)&packet, 58,
                                0, (struct sockaddr *)&from, sizeof(from)) < 0)
                        {
				time (&atime);
                                fprintf (log_file, "%24.24s sendto error\n", ctime(&atime));
				fflush (log_file);
                        }
                }
                pnt = pnt->f_chain;
        }
	if (id->ref_sd)
	{
		memcpy (packet.dplus.body.header.rpt2, id->ref_module, 8);
		sendto (id->ref_sd, &packet, 58, 0, (struct sockaddr *)&id->ref_addr, sizeof(id->ref_addr));
	}
}

void    jarl2dplus_voice_send (struct dstar_packet pkt, struct ModuleTable *id)
{
        struct  connected_table *pnt;

        packet.dplus.length = 0x1d;     // packet length
        packet.dplus.reserve = 0x80;
        memcpy (packet.dplus.id, "DSVT", 4);
        packet.dplus.resv[0] = 0x20;
        packet.dplus.resv[1] = 0x00;
        packet.dplus.resv[2] = 0x00;
        packet.dplus.resv[3] = 0x00;
        memcpy (&packet.dplus.trunk, &pkt.trunk, 19);

        pnt = first_pnt->f_chain;
	while (pnt)
        {
                if (pnt->protocol == DPLUS)
                {
                        from.sin_addr.s_addr = pnt->ip_address;
                        from.sin_port = pnt->port;
                        if (sendto(pnt->sd, (char *)&packet, 29, 0, (struct sockaddr *)&from, sizeof(from)) < 0)
                        {
                        }
                }
                pnt = pnt->f_chain;
        }
	if (id->ref_sd) sendto (id->ref_sd, &packet, 29, 0, (struct sockaddr *)&id->ref_addr, sizeof(id->ref_addr));

}

void    jarl2dplus_voice_last_send (struct dstar_packet pkt, struct ModuleTable *id)
{
        struct  connected_table *pnt;
	extern	unsigned char Dplus_ptt_off[];


        packet.dplus.length = 0x20;        // packet length
        packet.dplus.reserve = 0x80;
        memcpy (packet.dplus.id, "DSVT", 4);
        packet.dplus.resv[0] = 0x20;
        packet.dplus.resv[1] = 0x00;
        packet.dplus.resv[2] = 0x00;
        packet.dplus.resv[3] = 0x00;
        memcpy (&packet.dplus.trunk, &pkt.trunk, 22);

        pnt = first_pnt->f_chain;
        while (pnt)
        {
                if (pnt->protocol == DPLUS)
                {
                        from.sin_addr.s_addr = pnt->ip_address;
                        from.sin_port = pnt->port;
                        sendto(pnt->sd, (char *)&packet, 32, 0, (struct sockaddr *)&from, sizeof(from));
                        sendto(pnt->sd, (char *)&Dplus_ptt_off, 10, 0, (struct sockaddr *)&from, sizeof(from));
                }
                pnt = pnt->f_chain;
        }
	if (id->ref_sd) sendto (id->ref_sd, &packet, 32, 0, (struct sockaddr *)&id->ref_addr, sizeof(id->ref_addr));
}

int    dplus2dplus(int length)
{
        struct  connected_table *pnt;
        u_long  ip_addr;
        int     port;
	time_t	atime;
	unsigned char	temp[10];
	int	i;
	int	ret;

	if (xmit_pass_code[0] == 0x00) return FALSE;
	if (!memcmp (packet.dplus.body.header.mycall, "        ", 8)) return FALSE;
        ip_addr = from.sin_addr.s_addr;
        port = from.sin_port;

        pnt = first_pnt->f_chain;
        while (pnt)
        {
		if (pnt->protocol == DPLUS)
		{
                	if ((pnt->ip_address == ip_addr) && (pnt->port == port))
                	{
                        	if (length == 58)
                       		{
					if (memcmp (&pnt->dp_FrameID, &packet.dplus.trunk.FrameID, 2))
					{
						memcpy (&pnt->dp_FrameID, &packet.dplus.trunk.FrameID, 2);
                                		memcpy (pnt->module, packet.dplus.body.header.rpt2, 8);
                                		memcpy (pnt->mycall, packet.dplus.body.header.mycall, 8);
                                		memcpy (pnt->mycall_ex, packet.dplus.body.header.mycall_ex, 4);
                                		time(&pnt->access_time);
                                		if (pnt->re_xmit) pnt->ptt = TRUE;
						dtmf_c_save = 0x20;
						dtmf_c_save1 = 0x00;
						dtmf_c_save2 = 0x00;
						dtmf_pos = 0;
						memset (dtmf, 0x00, 10);
					}
		                        memset (temp, 0x00, 10);
                		        for (i = 0 ; i < 8 ; i++)
                                	{	
                                     	   	if (packet.dplus.body.header.urcall[i] == 0x20) break;
                                        	temp[i] = packet.dplus.body.header.urcall[i];
                                	}
                                	if (!strcmp (temp, xmit_pass_code)) 
					{
						pnt->re_xmit = TRUE;
						memcpy (packet.dplus.body.header.urcall, "CQCQCQ  ", 8);
					}
                        	}
                        	else if (length == 32)
				{
					pnt->ptt = FALSE;
					if (dtmf_pos)
					{
                                                time(&atime);
                                                fprintf (log_file,"%24.24s DTMF CODE %s from %8.8s\n", ctime(&atime), dtmf, pnt->callsign);
                                                fflush (log_file);
                                        	if (!strcmp (dtmf, xmit_pass_code)) pnt->re_xmit = TRUE;
                                        	else pnt->re_xmit = FALSE;
					}
                                }
                        	else if (length == 29)
                        	{
                                	if (packet.dplus.trunk.FrameSeq & 0x40)
					{
						pnt->ptt = FALSE;
						if (dtmf_pos)
						{
							if (!strcmp (dtmf, xmit_pass_code)) pnt->re_xmit = TRUE;
							else pnt->re_xmit = FALSE;
						}
					}
                                	dtmf_c = dtmf_decode (&packet.dplus.body.voice);
                                	if ((dtmf_c == dtmf_c_save1) && (dtmf_c == dtmf_c_save2))
                                	{
						if (dtmf_c != dtmf_c_save)
						{
                                        		if (dtmf_c != 0x20) dtmf[dtmf_pos++] = dtmf_c;
							dtmf_c_save = dtmf_c;
                                        		if (dtmf_pos > 7) dtmf_pos = 7;
						}
                                	}
					dtmf_c_save2 = dtmf_c_save1;
                                	dtmf_c_save1 = dtmf_c;
                        	}
				if (!pnt->re_xmit) return FALSE;
				break;
                	}
		}
                pnt = pnt->f_chain;
        }

        pnt = first_pnt->f_chain;
        while (pnt)
        {
		if (pnt->protocol == DPLUS)
		{
                	if ((ip_addr != pnt->ip_address) || (port != pnt->port))
                	{
                               	from.sin_addr.s_addr = pnt->ip_address;
                               	from.sin_port = pnt->port;
                               	ret = sendto (pnt->sd, (char *)&packet, length, 0,
                        		(struct sockaddr *)&from, sizeof(from));
                	}
		}
                pnt = pnt->f_chain;
        }
	return TRUE;
}

void	dplus2dcs(int length)
{
	struct	connected_table	*pnt;
	struct	ModuleTable	*m_pnt;

	if (length == 58)
	{
		m_pnt = module_pnt;
		while (m_pnt)
		{
			if (!memcmp (packet.dplus.body.header.rpt2, m_pnt->ModuleName, 8))
			{
				if (memcmp (packet.dplus.trunk.FrameID, m_pnt->DCS_C.FrameID, 2))
				{
					memcpy (m_pnt->DCS_C.FrameType , "0001", 4);
					memcpy (m_pnt->DCS_C.flags, &packet.dplus.body.header, 39);
					memcpy (m_pnt->DCS_C.FrameID, packet.dplus.trunk.FrameID, 3);
					memset (m_pnt->DCS_C.Message, 0x20, 20);
					m_pnt->DCS_C.FrameVer[0] = 0x01;
					m_pnt->DCS_C.FrameVer[1] = 0x00;
					m_pnt->DCS_C.Language = 0x21;
					m_pnt->DCS_C_FrameCounter = 0;
				}
				return;
			}
			m_pnt = m_pnt->f_chain;
		}
		return;
	}
	else if ((length == 29) || (length == 32))
	{
		m_pnt = module_pnt;
		while (m_pnt)
		{
			if (!memcmp (packet.dplus.trunk.FrameID, m_pnt->DCS_C.FrameID, 2)) break;
			m_pnt = m_pnt->f_chain;
			if (m_pnt == NULL) return;
		}

		if (packet.dplus.trunk.FrameSeq)
		{
			if ((packet.dplus.trunk.FrameSeq & 0x3f) % 2)
			{
				m_pnt->dplus_mini_header = packet.dplus.body.voice.slowdata[0] ^  0x70;
				m_pnt->dplus_data[0] = packet.dplus.body.voice.slowdata[1] ^  0x4f;
				m_pnt->dplus_data[1] = packet.dplus.body.voice.slowdata[2] ^  0x93;
			}
			else
			{
				m_pnt->dplus_data[2] = packet.dplus.body.voice.slowdata[0] ^  0x70;
				m_pnt->dplus_data[3] = packet.dplus.body.voice.slowdata[1] ^  0x4f;
				m_pnt->dplus_data[4] = packet.dplus.body.voice.slowdata[2] ^  0x93;
				switch (m_pnt->ref_mini_header)
				{
					case 0x40:
						memcpy (&m_pnt->DCS_C.Message[0], m_pnt->dplus_data, 5);
						break;
					case 0x41:
						memcpy (&m_pnt->DCS_C.Message[5], m_pnt->dplus_data, 5);
						break;
					case 0x42:
						memcpy (&m_pnt->DCS_C.Message[10], m_pnt->dplus_data, 5);
						break;
					case 0x43:
						memcpy (&m_pnt->DCS_C.Message[15], m_pnt->dplus_data, 5);
						break;
				}
			}
		}
		
		m_pnt->DCS_C.FrameCnt[0] = m_pnt->DCS_C_FrameCounter & 0xff;
		m_pnt->DCS_C.FrameCnt[1] = (m_pnt->DCS_C_FrameCounter >> 8) & 0xff;
		m_pnt->DCS_C.FrameCnt[2] = (m_pnt->DCS_C_FrameCounter >> 16) & 0xff;
		m_pnt->DCS_C_FrameCounter++;
		m_pnt->DCS_C.Source = 0x34;     // from REF
		m_pnt->DCS_C.FrameSeq = packet.dplus.trunk.FrameSeq;
		memcpy (&m_pnt->DCS_C.Voice[0], &packet.dplus.body.voice, 12);

		pnt = first_pnt->f_chain;
		while (pnt)
		{
			if (!memcmp (m_pnt->DCS_C.rpt2, pnt->module, 8))
			{
				if (pnt->protocol == DCS)
				{
        	               		from.sin_addr.s_addr = pnt->ip_address;
                	       		from.sin_port = pnt->port;
                       			sendto(pnt->sd, &m_pnt->DCS_C, 100,
                               		        0, (struct sockaddr *)&from, sizeof(from));
				}
			}
			else
			{
				if (pnt->protocol == DCS)
				{
                                	if (packet.dplus.trunk.FrameSeq == 20)
                                	{
                                        	memset (&DCS_Msg, 0x00, 35);
                                        	memcpy (&DCS_Msg.call, pnt->mycall, 8);
                                        	memcpy (&DCS_Msg.msg, "Talk on ", 8);
                                        	memcpy (&DCS_Msg.module, pnt->module, 8);
                                        	from.sin_addr.s_addr = pnt->ip_address;
                                        	from.sin_port = pnt->port;
                                        	sendto (pnt->sd, &DCS_Msg, 35, 0, (struct sockaddr *)&from, sizeof(from));
                                	}
				}
			}
			
			pnt = pnt->f_chain;
		}
		if ((m_pnt->dcs_module[0] != 0x20) && m_pnt->dcs_sd)
		{
			memcpy(m_pnt->DCS_C.rpt2, m_pnt->dcs_module, 8);
			sendto (m_pnt->dcs_sd, &m_pnt->DCS_C, 100, 0, (struct sockaddr *)&m_pnt->dcs_addr, sizeof(m_pnt->dcs_addr));
			memcmp (m_pnt->DCS_C.rpt2, m_pnt->ModuleName, 8);
		}
	}
}

