/*
	Interface for ID-RP2C

*/


#define	Max_Send_Check	200
#define	DPRS_PORT	14580
#define	RECV_PORT	21000
#define	SEND_INTERVAL	59
#define	Beacon_Interval	0
#define	Latitude_Default	356735;		// TOKYO
#define	Longitude_Default	1397455;	// TOKYO
#define	RETRY_COUNT	60
#define	DPRS_SERVER	"d-prs.d-star.info"
#define	CONFIG_FILE	"/opt/dxchange/etc/dxchange.conf"
#define	CSS_FILE	"/opt/dxchange/web/dxchange.css"
#define LOGO_FILE	"/opt/dxchange/web/logo.png"
#define	JS_FILE		"/opt/dxchange/web/dxchange.js"
#define LOG_FILE	"/var/log/dxchange.log"
#define	PID_FILE	"/var/run/dxchange.pid"
#define	DCS_PORT	30051
#define	REF_PORT	20001

/*
	0000 0000 0000 0000
	|- protocol -| ver.
*/
#define DPLUS   16
#define DCS     32

#define	TRUE		1
#define	FALSE		0
#define INVALID		2

#define	APRS_SEND	0x01
#define	APRS_SHORT	0x02
#define	APRS_SKIP	0x03
#define	ARPS_AUTO	0x04
#define	APRS_NG		0x05
#define	APRS_INVALID	0x06
#define	APRS_ERROR	0x07

#include	<stdint.h>
#include	<string.h>
#include	<time.h>
#include	<sys/time.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/socket.h>
#include 	<sys/types.h>
#include 	<netinet/in.h>
#include 	<netdb.h>
#include	<signal.h>
#include	<sys/ioctl.h>
#include	<sys/stat.h>
#include	<net/if.h>
#include	<errno.h>
#include	<sys/utsname.h>
#include	"dstar.h"
#include	"packet.h"


struct	ModuleTable
{
	struct	ModuleTable	*f_chain;
	struct	sockaddr_in	dcs_addr;
	struct	sockaddr_in	ref_addr;
	struct	timeval	recv_time;
	time_t	dcs_recv_time;
	time_t	ref_recv_time;
	unsigned char	ModuleName[8];
	u_long		ipaddress;
	time_t		AccessTime;
	int		port;
	int		voice_port;
	int		SendSeq;
	int		packet_cnt;
	int		aprs_msg_pnt;
	int		RadioVoicePacketCnt;
	int		HeaderCnt;
	int		DCS_FrameCounter;
	int		DCS_C_FrameCounter;
	int		dcs_sd;
	int		dcs_port;
	int		ref_sd;
	int		ref_port;
	int		rpt_save_length;
	int		lost_cnt;
	int		dcs_state;
	int		ref_state;
	unsigned char	RadioLat[8];
	unsigned char	RadioLong[9];
	unsigned char	RadioCall[8];
	unsigned char	RadioMsg[20];
	unsigned char	RadioAtitude[6];
	unsigned char	RadioSpeed[3];
	unsigned char	RadioDirection[3];
	unsigned char	RadioTime[7];
	unsigned char	RadioGpsStatus;
	unsigned char	RadioGpsSkip;
	unsigned char   FrameID[2];
	unsigned char   mini_header;
	unsigned char   data_temp[5];
	unsigned char   aprs_msg[256];
	unsigned char	aprs_msg_save[256];
	unsigned char	mycall[8];
	unsigned char	mycall_ex[4];
	unsigned char	urcall[8];
	unsigned char	rptcall[8];
	unsigned char	AprsSend;
	unsigned char	RX_on;
	unsigned char	lost_frame_sw;
	unsigned char	dcs_module[8];
	unsigned char	ref_module[8];
	unsigned char	ref_mini_header;
	unsigned char	ref_data[5];
	unsigned char	ref_FrameID[2];
	unsigned char	dplus_mini_header;
	unsigned char	dplus_data[5];
	struct	dstar_packet	rpt_save;
	struct	DCS_frame	DCS_Frm;
	struct	DCS_frame	DCS_C;
	struct	STATUS_frame	STATUS_Frm;
	struct	STATUS_frame	STATUS_Save;
};

unsigned char	GpsMsg[20];

struct	
{
	unsigned	char	CallSign[8];
	time_t			SendTime;
}	SendCheck[Max_Send_Check];

int		send_interval;
int		AutoReLink;
int		RetryCnt;
int		beacon;
unsigned char	server_name[128];
int		server_port;
unsigned char	trust_name[128];
int		trust_port;
int		recv_port;
int		send_port;
int		gw_port;
int		dcs_cnt;
int		ref_cnt;
unsigned char	client_callsign[7];
unsigned char	radio_id;
unsigned char	beacon_comment[64];
int		BeaconLat;
int		BeaconLong;
int		BeaconInterval;
int		aprs_sd;
long int	aprs_cnt;

struct  	sockaddr_in aprs_addr;
time_t		BeaconTime;
unsigned char		DprsTemp[256];

int	reload;
int	debug_sw;
int	gps_only_skip;
int	gps_skip_bits;
int	sig_term;

FILE	*log_file;
FILE	*pid_file;

/* Monitor & Forward definition */

struct	forward
{
	struct	forward	*f_chain;
	unsigned char	fqdn[128];
	int		port;
	int		fwd_sd;
	struct	sockaddr_in	fwd_addr;
	long int	packets;
	char		ip_replace;
};

struct	status
{
	struct	status	*f_chain;
	unsigned char	fqdn[128];
	unsigned char	userID[16];
	unsigned char	passwd[64];
	int		port;
	int		status_sd;
	struct	sockaddr_in	status_addr;
	long int	packets;
};

struct	forward		*forward_pnt, *forward_last;
struct	status		*status_pnt, *status_last;
unsigned char   	aprs_server[16];

struct  sockaddr_in     status_addr;

fd_set          read_set;
fd_set		fd_save;

struct	sockaddr_in	voice_addr;
int			voice_sd;

/* http port */
int	http_port;
int	http_sd;
struct	sockaddr_in	http_recv;
struct	sockaddr_in	http_serv;

int	trust_sd;
struct	sockaddr_in	trust_addr;

struct  ModuleTable     *module_pnt, *module_last;

unsigned char	xmit_pass_code[10];

unsigned char   dtmf_c, dtmf_c_save;
unsigned char	dtmf_c_save1, dtmf_c_save2;
int             dtmf_pos;
unsigned char   dtmf[10];

struct DCS_MSG	DCS_Msg;

unsigned char	RECV_NIC[8];
unsigned char	SEND_NIC[8];
unsigned char	GW_NIC[8];

int	verify_sw;

struct	tm	*gt;

struct utsname      uname_buf;
