#include	<openssl/md5.h>
#include	"dxchange.h"
#include	"monitor.h"
#include	"config.h"

void	DateSend(int sock);

extern	time_t	AprsConnectTime;

char    *wday[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
char    *month[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
char	http_temp[512];

void	http_srv_accept(void)
{
	int	len;
	int	sock;
	int	yes = 1;
	time_t	atime;

	len = sizeof(http_recv);
	sock = accept(http_sd, (struct sockaddr *)&http_recv, &len);
	if (sock < 0)
	{
		time(&atime);
		fprintf (log_file, "%24.24s %s\n", ctime(&atime), strerror(errno));
		fflush (log_file);
		close (http_sd);
		http_port= 0;
	}
	else
	{
		setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes));
		FD_SET (sock, &fd_save);
	}
}

void	NotFound (int sock)
{
	send (sock, "HTTP/1.1 404 Not Found\r\n", 24, 0);
	DateSend(sock);
	send (sock, "Content-Type: text/html\r\n", 25, 0);
	send (sock, "Content-length: 248\r\n\r\n", 23, 0);
	send (sock, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\r\n", 94, 0);
	send (sock, "<html><head><title>404 Not Found</title></head>",  47, 0); 
	send (sock, "<body><h1>Not Found</h1><p>The requested URL /favicon.ico was not found on this server.</p></body></html>", 107, 0);
}

void	NotModify (int sock)
{
	send (sock, "HTTP/1.1 304 Not Modified\r\nConnection: close\r\n\r\n", 50, 0);
	//DateSend (sock);
	//send (sock, "\r\n", 2, 0);
}

void	ETagSend (int sock, char tag[])
{
        send (sock, "ETag: \"", 7, 0);
        send (sock, tag, 32, 0);
        send (sock, "\"\r\n", 3, 0);
}

void	LastModSend (int sock, time_t mod_time)
{
        gt = gmtime(&mod_time);
        sprintf (http_temp, "Last-Modified: %3.3s, %2.2d %3.3s %4.4d %02d:%02d:%02d GMT\r\n",
                        wday[gt->tm_wday],
                        gt->tm_mday,
                        month[gt->tm_mon],
                        gt->tm_year+1900,
                        gt->tm_hour,
                        gt->tm_min,
                        gt->tm_sec);
        send (sock, http_temp, strlen(http_temp), 0);
}

time_t	ModifiedTime (char string[])
{
	time_t	req_time;
	char	*tok;
	int	mon;

	tok = string;
	tok = strtok (tok, " :\0");
	gt->tm_mday = atoi(tok);
	tok = strtok (NULL, " :\0");
	for (mon = 0 ; mon < 12 ; mon++)
	{
		if (!memcmp (tok, month[mon], 3)) break;
	}
	gt->tm_mon = mon;
	tok = strtok (NULL, " :\0");
	gt->tm_year = atoi (tok) - 1900;
	tok = strtok (NULL, " :\0");
	gt->tm_hour = atoi (tok);
	tok = strtok (NULL, " :\0");
	gt->tm_min = atoi (tok);
	tok = strtok (NULL, " :\0");
	gt->tm_sec = atoi (tok);
	gt->tm_isdst = daylight;
	req_time = mktime(gt);
	req_time -= timezone;
	return req_time;
}


void	ETagGen (char file_name[], unsigned char md_string[])
{
	MD5_CTX	ctx;
	unsigned char	md[MD5_LBLOCK];
	FILE	*fp;
	int	ret;

        fp = fopen (file_name, "rb");
        MD5_Init (&ctx);
        while (1)
        {
                ret = fread (http_temp, 1, sizeof(http_temp), fp);
                if (ret > 0) MD5_Update(&ctx, http_temp, ret);
                else break;
        }
        fclose (fp);
        MD5_Final (md, &ctx);
        sprintf (md_string, "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
                        md[0], md[1], md[2], md[3], md[4], md[5], md[6], md[7],
                        md[8], md[9], md[10], md[11], md[12], md[13], md[14], md[15]);
}

void	FileBodySend (char file_name[], int sock)
{
	FILE	*fp;
	int	ret;

        fp = fopen (file_name, "rb");
        while (1)
        {
                ret = fread (http_temp, 1, sizeof(http_temp), fp);
                if (ret > 0) send (sock, http_temp, ret, 0);
                else break;
        }

        fclose(fp);
}

/*
        Java Scrip File send
        file name : /opt/dxchange/web/dxchange.js
*/
void    js_send(int sock, char buf[] )
{
        unsigned char   md_string[33];
        FILE    *fp;
        int     ret;
        struct  stat    stat_buf;
        fpos_t  fsize;
        char    *tok;
        int     mon;
        int     k;
        time_t  req_time;
        char    NotMod;
        extern long int timezone;
        extern  int     daylight;

        ret = stat (JS_FILE, &stat_buf);

        if (ret != 0)
        {
                NotFound (sock);
                return;
        }

        ETagGen (JS_FILE, md_string);

        req_time = 0;
        tok = strtok (buf, "\r\n\0");
        NotMod = FALSE;
        while (tok)     /* Checnk last modified */
        {
                if (!memcmp (tok, "If-Modified-Since: ", 19))
                {
                        req_time = ModifiedTime (tok+24);
                        if (req_time >= stat_buf.st_mtime) NotMod = TRUE;
                }
                else if (!memcmp (tok, "If-None-Match: ", 15))
                {
                        if (!memcmp (tok+16, md_string, 32))
                        {
                                NotModify (sock);
                                return;
                        }

                }
                tok = strtok (NULL, "\r\n\0");
        }
        if (NotMod)
        {
                NotModify(sock);
                return;
        }

        send (sock, "HTTP/1.1 200 OK\r\n", 16, 0);
        DateSend (sock);
        LastModSend (sock, stat_buf.st_mtime);
        ETagSend (sock, md_string);
        send (sock, "Content-Type: text/javascript\r\n", 31, 0);
        send (sock, "Cache-Control: max-age=3600\r\n", 29, 0);
        send (sock, "Connection: close\r\n", 19, 0);
        sprintf (http_temp, "Content-length: %0d\r\n", stat_buf.st_size);
        send (sock, http_temp, strlen(http_temp), 0);
        send (sock, "\r\n", 2, 0);

        FileBodySend (JS_FILE, sock);
}

/*
        logo File send
        file name : /opt/xchange/web/logo.png
*/
void    rogo_send(int sock, char buf[] )
{
	unsigned char	md_string[33];
        FILE    *fp;
        int     ret;
        struct  stat    stat_buf;
        fpos_t  fsize;
        char    *tok;
        int     mon;
        int     k;
        time_t  req_time;
	char	NotMod;
        extern long int timezone;
        extern  int     daylight;

        ret = stat (LOGO_FILE, &stat_buf);

        if (ret != 0)
        {
                NotFound (sock);
                return;
        }

	ETagGen (LOGO_FILE, md_string);

        req_time = 0;
        tok = strtok (buf, "\r\n\0");
	NotMod = FALSE;
        while (tok)     /* Checnk last modified */
        {
                if (!memcmp (tok, "If-Modified-Since: ", 19))
                {
                        req_time = ModifiedTime (tok+24);
			if (req_time >= stat_buf.st_mtime) NotMod = TRUE;
                }
		else if (!memcmp (tok, "If-None-Match: ", 15))
		{
			if (!memcmp (tok+16, md_string, 32))
			{
				NotModify (sock);
				return;
			}
			
		}
                tok = strtok (NULL, "\r\n\0");
        }
        if (NotMod)
        {
                NotModify(sock);
                return;
        }

        send (sock, "HTTP/1.1 200 OK\r\n", 16, 0);
        DateSend (sock);
	LastModSend (sock, stat_buf.st_mtime);
	ETagSend (sock, md_string);
        send (sock, "Content-Type: image/png\r\n", 26, 0);
	send (sock, "Cache-Control: max-age=3600\r\n", 29, 0);
        send (sock, "Connection: close\r\n", 19, 0);
        sprintf (http_temp, "Content-length: %0d\r\n", stat_buf.st_size);
        send (sock, http_temp, strlen(http_temp), 0);
        send (sock, "\r\n", 2, 0);

	FileBodySend (LOGO_FILE, sock);
}


/*
	CSS File send
	file name : /opt/dxchange/web/dxchange.css
*/
void	css_send(int sock, char	buf[] )
{
	unsigned char	md_string[33];

	FILE	*fp;
	int	ret;
	struct	stat	stat_buf;
	fpos_t	fsize;
	char	*tok;
	int	mon;
	int	k;
	time_t	req_time;
	char	NotMod;
	extern long int	timezone;
	extern	int	daylight;

	ret = stat (CSS_FILE, &stat_buf);

	if (ret != 0)
	{
		NotFound (sock);
		return;
	}

	ETagGen (CSS_FILE, md_string);

	req_time = 0;
	tok = strtok (buf, "\r\n\0");
	NotMod = FALSE;
	while (tok)	/* Checnk last modified */
	{
                if (!memcmp (tok, "If-Modified-Since: ", 19))
                {
                        req_time = ModifiedTime (tok+24);
                        if (req_time >= stat_buf.st_mtime) NotMod = TRUE;
                }
                else if (!memcmp (tok, "If-None-Match: ", 15))
                {
                        if (!memcmp (tok+16, md_string, 32))
			{
				NotModify(sock);
                        	return;
			}
                }
		tok = strtok (NULL, "\r\n\0");
	}
	if (NotMod)
	{
		NotModify(sock);
		return;
	}
			
	send (sock, "HTTP/1.1 200 OK\r\n", 16, 0);
	DateSend (sock);
	LastModSend (sock, stat_buf.st_mtime);
	ETagSend (sock, md_string);
	send (sock, "Content-Type: text/css\r\n", 24, 0);
	send (sock, "Cache-Control: max-age=3600\r\n", 29, 0);
	send (sock, "Connection: close\r\n", 19, 0);
	sprintf (http_temp, "Content-length: %0d\r\n", stat_buf.st_size);
	send (sock, http_temp, strlen(http_temp), 0);
	send (sock, "\r\n", 2, 0);

	FileBodySend (CSS_FILE, sock);
}

void	DateSend(int sock)
{
	time_t	atime;

	time(&atime);
        gt = gmtime(&atime);
        sprintf (http_temp, "Date: %3.3s, %2.2d %3.3s %4.4d %02d:%02d:%02d GMT\r\n",
                        wday[gt->tm_wday],
                        gt->tm_mday,
                        month[gt->tm_mon],
                        gt->tm_year+1900,
                        gt->tm_hour,
                        gt->tm_min,
                        gt->tm_sec);
        send (sock, http_temp, strlen(http_temp), 0);
}

void	chunked_send(char string[], int sock)
{
	char	chunk[6];

	sprintf (chunk, "%02x\r\n", strlen(string));
	send (sock, chunk, 4, 0);
	send (sock, string, strlen(string), 0);
	send (sock, "\r\n", 2, 0);
}

void	http_srv_recv(int sock)
{
	struct	connected_table *pnt;
	struct	ModuleTable	*m_t;
	struct	forward		*fwd_pnt;
	struct	status		*sta_pnt;
	time_t	atime;
	extern	time_t	start_time;
	time_t	dtime;
	int	d, h, m, s;
	char	temp[512];
	int	i;
	int	len;
	char	mask;
	char	header;

	if ((len = recv (sock, temp, sizeof(temp), 0)) <= 0)
	{
		close (sock);
		FD_CLR (sock, &fd_save);
		return;
	}

	temp[len] = 0x00;
	if (!memcmp (temp, "GET /favicon.ico", 16))
	{
		NotFound(sock);
		return;
	}
	if (!memcmp (temp, "GET /xchange.css", 13))
	{
		css_send(sock, temp );
		return;
	}
        if (!memcmp (temp, "GET /logo.png", 13))
        {
                rogo_send(sock, temp );
                return;
        }
        if (!memcmp (temp, "GET /xchange.js", 13))
        {
                js_send(sock, temp );
                return;
        }
 
	send (sock,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n", 42, 0);
	DateSend (sock);
	sprintf (temp, "Server: dxchange %5.5s\r\n", PACKAGE_VERSION);
	send (sock, temp, strlen(temp), 0);
	send (sock, "Cache-Control: no-cache\r\n", 25, 0);
	send (sock, "Transfer-Encoding: chunked\r\n\r\n",  30, 0);

	time(&atime);
	chunked_send ("<!DOCTYPE HTML>\r\n\0",  sock);
	sprintf (temp, "<html><head><meta http-equiv=\"refresh\" content=\"5\"><title>D-STAR X-change Status %7.7s</title>\r\n", client_callsign);
	chunked_send(temp, sock);
	//sprintf (temp, "<script type=\"text/javascript\" src=\"dxchange.js\"></script>\r\n");
	//chunked_send(temp, sock);
	sprintf (temp, "<link rel=\"stylesheet\" type=\"text/css\" href=\"/xchange.css\" /></head>\r\n");
	chunked_send (temp, sock);

	sprintf (temp, "<body><h3>D-STAR X-change (dxchange) Status V%5.5s at %24.24s</h3>\r\n",PACKAGE_VERSION, ctime(&atime));
	chunked_send(temp, sock);
	chunked_send ("<img src=\"logo.png\" align=\"left\" border=\"0\"><br>\r\n\0", sock);

	dtime = atime - start_time;
	d = dtime / 86400;
	dtime %= 86400;
	h = dtime / 3600;
	dtime %= 3600;
	m = dtime / 60;
	s = dtime % 60;

	sprintf (temp, "<table><tr><td>Started</td><td>%24.24s</td></tr><tr><td>Up time</td><td>\r\n", ctime(&start_time));
	chunked_send(temp, sock);
	if (d)
	{
		sprintf (temp, "<div Align=right>%dd%2dh%2dm%2ds</div></td></tr>\r\n", d, h, m, s);
	}
	else if (h)
	{
		sprintf (temp, "<div Align=right>%2dh%2dm%2ds</div></td></tr>\r\n", h, m, s);
	}
	else if (m)
	{
	        sprintf (temp, "<div align=right>%dm%2ds</div></td><tr>\r\n", m, s);
	}
	else 
	{
        	sprintf (temp, "<div align=right>%2ds</div></td></tr>\r\n", s);
	}
	chunked_send(temp, sock);
	chunked_send ("</table>\r\n\0", sock);


/* Repeater Information */
        if (dcs_cnt || ref_cnt) sprintf (temp, "<h3>Repeater Status</h3><table><tr><th>Rpt. Call</th><th>DCS/REF</th><th>My Callsign</th><th>Ur Callsign</th>\r\n");
	else sprintf (temp, "<h3>Repeater Status</h3><table><tr><th>Rpt. Call</th><th>My Callsign</th><th>Ur Callsign</th>\r\n");
	chunked_send (temp, sock);
	if (trust_port) sprintf (temp, "<th>Dest. Rpt</th><th>Short Message</th><th>Last Access Time</th><th>Packets</th><th>D-PRS</th></tr>\r\n");
	else sprintf (temp, "<th>Short Message</th><th>Last Access Time</th><th>Packets</th><th>D-PRS</th></tr>\r\n");
	chunked_send (temp, sock);

        m_t = module_pnt;
        while (m_t)
        {
                if (m_t->ModuleName[0] > 0x20)
                {
			if (m_t->urcall[0] == '/')
			{
				memset (m_t->rptcall, 0x20, 8);
				m_t->rptcall[7] = m_t->urcall[7];
				memcpy (m_t->rptcall, &m_t->urcall[1], 6);
			}
			sprintf (temp, "<tr><td>%8.8s</td>\r\n", m_t->ModuleName);
			chunked_send(temp, sock);
			if (dcs_cnt || ref_cnt)
			{	
				if (m_t->dcs_module[0] != 0x20)
				{
					if (m_t->ref_module[0] != 0x20)
					{
						sprintf (temp, "<td>%8.8s / %8.8s</td>\r\n", m_t->dcs_module, m_t->ref_module);
					}
					else
					{
						sprintf (temp, "<td><center>%8.8s</center></td>\r\n", m_t->dcs_module);
					}
				}
				else
				{
					sprintf (temp, "<td><center>%8.8s</center></td>\r\n", m_t->ref_module);
				}
				chunked_send (temp, sock);
			}
                        if (m_t->RX_on) chunked_send("<td><font color=red><b>\r\n\0", sock);
                        else            chunked_send("<td>\r\n\0", sock);
                        sprintf (temp, "%8.8s\r\n", m_t->mycall);
			chunked_send(temp, sock);
                        if (memcmp (m_t->mycall_ex, "    ", 4))
                                {
                                        sprintf (temp, "/%4.4s\r\n", m_t->mycall_ex);
					chunked_send(temp, sock);
                                }
                        if (m_t->RX_on) chunked_send("</b></font>\r\n\0", sock);
                        if (trust_port ) sprintf (temp, "</td><td>%8.8s</td><td>%8.8s</td><td>%20.20s</td><td>\r\n", 
							m_t->urcall, m_t->rptcall, m_t->RadioMsg);
			else sprintf (temp, "</td><td>%8.8s</td><td>%20.20s</td><td>\r\n", m_t->urcall, m_t->RadioMsg);
			chunked_send(temp, sock);
                        if (m_t->AccessTime != 0)
			{
				sprintf (temp, "%24.24s\r\n", ctime(&m_t->AccessTime));
				chunked_send(temp, sock);
			}
                        sprintf (temp, "</td><td><center>%d/%d/%d</center></td>\r\n",
                        	m_t->HeaderCnt, m_t->RadioVoicePacketCnt, m_t->packet_cnt);
                        chunked_send(temp, sock);
                        if (m_t->AprsSend == APRS_SEND) sprintf (temp, "<td><a href=\"#\"><center><b>Send</b></center><span class=\"msg_body\">%s</span></a></td></tr>\r\n", m_t->aprs_msg_save);
                        else if (m_t->AprsSend == APRS_SHORT) sprintf (temp, "<td><a href=\"#\"><center><b>Short</b></center><span class=\"msg_body\">%s</span></a></td></tr>\r\n", m_t->aprs_msg_save);
                        else if (m_t->AprsSend == APRS_NG)    sprintf (temp, "<td><a href=\"#\"><cneter><b>No Data</b></center><span class=\"msg_body\">%s</span></a></td></tr>\r\n", m_t->aprs_msg_save);
                        else if (m_t->AprsSend == APRS_ERROR) sprintf (temp, "<td><a href=\"#\"><center><b>Error</b></center><span class=\"msg_body\">%s</span></a></td></tr>\r\n", m_t->aprs_msg_save);
                        else sprintf (temp, "<td> </td></tr>\r\n");
			chunked_send(temp, sock);
                }
                m_t = m_t->f_chain;
        }
        chunked_send ("</table><br>\r\n\0", sock);


/* APRS server information */
	time(&atime);
        dtime = atime - AprsConnectTime;
        d = dtime / 86400;
        dtime %= 86400;
        h = dtime / 3600;
        dtime %= 3600;
        m = dtime / 60;
        s = dtime % 60;
	chunked_send ("<h3>APRS Server</h3>\r\n\0", sock);
	sprintf (temp, "<table><tr><td><a href=http://%0d.%0d.%0d.%0d:14501>%s</a> \r\n",
                        aprs_addr.sin_addr.s_addr & 0xff,
                        (aprs_addr.sin_addr.s_addr >> 8) & 0xff,
                        (aprs_addr.sin_addr.s_addr >> 16) & 0xff,
                        (aprs_addr.sin_addr.s_addr >> 24) & 0xff,
			aprs_server);
	chunked_send (temp, sock);
	if (verify_sw) chunked_send ("Verified.   \r\n\0", sock);
	else chunked_send ("Unverified. \r\n\0", sock);
	sprintf (temp, "</td><td>(%s:%0d %0d.%0d.%0d.%0d:%0d)</td><td><b>Up</b> \r\n", 
			server_name, server_port,
			aprs_addr.sin_addr.s_addr & 0xff,
			(aprs_addr.sin_addr.s_addr >> 8) & 0xff,
			(aprs_addr.sin_addr.s_addr >> 16) & 0xff,
			(aprs_addr.sin_addr.s_addr >> 24) & 0xff,
			server_port);
	chunked_send (temp, sock);
        if (d)
        {
                sprintf (temp, "%dd%2dh%2dm%2ds\r\n", d, h, m, s);
        }
        else if (h)
        {
                sprintf (temp, "%2dh%2dm%2ds\r\n", h, m, s);
        }
        else if (m)
        {
                sprintf (temp, "%dm%2ds\r\n", m, s);
        }
        else
        {
                sprintf (temp, "%2ds\r\n", s);
        }
	chunked_send (temp, sock);
	sprintf (temp, "</td><td>(%d packets)\r\n", aprs_cnt);
	chunked_send (temp, sock);
	chunked_send ("</td></tr></table>\r\n\0", sock);


/* D-PRS Interval timer */
	sprintf (temp, "<h3>D-PRS Message Send Status</h3><table><tr><td><b>Interval Timer</b></td><td>%d Sec.</td></tr></table>\r\n", send_interval);
	chunked_send (temp, sock);
	header = FALSE;
	time (&atime);
        for (i = 0 ; i < Max_Send_Check ; i++)
        {
		
                if (SendCheck[i].SendTime <= atime) SendCheck[i].CallSign[0] = 0x00;
                if (SendCheck[i].CallSign[0] != 0x00)
                {
			if (!header)
			{
	        		sprintf (temp, "<table><tr><th>Call Sign</th><th>Send Time</th><th>Remaining time</th></tr>\r\n");
        			chunked_send (temp, sock);
				header = TRUE;
			}
			sprintf (temp, "<tr><td>%8.8s</td><td>%24.24s</td><td><center>%d</center></td></tr>\r\n",
                        	SendCheck[i].CallSign, ctime(&SendCheck[i].SendTime), (SendCheck[i].SendTime - atime));
			chunked_send (temp, sock); 
                }
        }
	if (header) chunked_send ("</table>\r\n\0", sock);


/* Forward Port Information */

	if (forward_pnt)
	{
		chunked_send ("<h3>Forward Port Information</h3>\r\n\0", sock);
		fwd_pnt = forward_pnt;
		chunked_send ("<table>\r\n\0", sock);
		chunked_send ("<tr><th><center>domain name : port</center></th><th><center>Packets</center></th><th>Status</th><tr>\r\n\0", sock);
		while (fwd_pnt)
		{
			if (fwd_pnt->ip_replace) mask = '*';
			else mask = ' ';
			sprintf (temp, "<tr><td><center>%c%s:%0d</center></td><td><center>%d</center></td>\r\n", mask, fwd_pnt->fqdn, fwd_pnt->port, fwd_pnt->packets);
			chunked_send (temp, sock);
			if (fwd_pnt->port) chunked_send ("<td><center>OK</center></td><tr>\r\n\0", sock);
			else chunked_send ("<td><center>NG</center></td><tr>\r\n\0", sock); 
			fwd_pnt = fwd_pnt->f_chain;
		}
		chunked_send ("</table>\r\n\0", sock);
	}


/* Status Port Information */

        if (status_pnt)
        {
                chunked_send ("<h3>Status Port Information</h3>\r\n\0", sock);
                sta_pnt = status_pnt;
                chunked_send ("<table>\r\n\0", sock);
                chunked_send ("<tr><th><center>domain name : port</center></th><th><center>Packets</center></th><th>Status</th><tr>\r\n\0", sock);
                while (sta_pnt)
                {
                        sprintf (temp, "<tr><td><center>%s:%0d</center></td><td><center>%d</center></td>\r\n", sta_pnt->fqdn, sta_pnt->port, sta_pnt->packets);
                        chunked_send (temp, sock);
                        if (sta_pnt->port) chunked_send ("<td><center>OK</center></td><tr>\r\n\0", sock);
                        else chunked_send ("<td><center>NG</center></td><tr>\r\n\0", sock);
                        sta_pnt = sta_pnt->f_chain;
                }
                chunked_send ("</table>\r\n\0", sock);
        }


/* Users on Monitor port */
	struct	MonPort	*mon_p;
	if (mon_pnt)
	{
		sprintf (temp, "<h3>Users on Monitor Port</h3>\r\n");
		chunked_send (temp, sock);
		i = 0;
		mon_p = mon_pnt;
		chunked_send ("<table>\r\n\0", sock);
		while (mon_p)
		{
			if (mon_p->mon_port)
			{
				sprintf (temp, "<tr><td><b>Listen port %0d</b></td><td><b>%d</b></td></tr>\r\n", i, mon_p->mon_port);
				chunked_send (temp, sock);
				i++;
			}
			mon_p = mon_p->f_chain;
		}
		chunked_send ("</table>\r\n\0", sock);
		pnt = first_pnt->f_chain;
		if (pnt)
		{
			sprintf (temp, "<br><table><tr><th>Call Sign</th><th>IP Address</th><th>Port</th><th>Connect Time</th><th>Module</th><th>User</th><th>Access Time</th><th>Protocol</th><tr>\r\n");
			chunked_send (temp, sock);

        		while (pnt)
        		{
				chunked_send ("<tr><td>\r\n\0", sock);
				if (pnt->ptt) chunked_send ("<font  color=red><b>\r\n\0", sock);
				else if (pnt->re_xmit) chunked_send ("<font color=blue><b>\r\n\0", sock); 
				sprintf (temp, "%8.8s\r\n", pnt->callsign);
				chunked_send (temp, sock);
				if (pnt->ptt)
				{
					chunked_send ("</b></font>\r\n\0", sock);
				}
				sprintf (temp, "</td><td><center>%0d.%0d.%0d.%0d</center></td><td>%d</td><td>%24.24s</td>\r\n",
        		                (pnt->ip_address & 0xff),
                		        ((pnt->ip_address >> 8) & 0xff),
                        		((pnt->ip_address >> 16) & 0xff),
                	        	((pnt->ip_address >> 24) & 0xff),
                 		       	htons(pnt->port), ctime(&pnt->connect_time));
				chunked_send (temp, sock);
				sprintf (temp, "<td>%8.8s</td><td>\r\n", pnt->module);
				chunked_send (temp, sock);
				if (pnt->ptt)
				{
					chunked_send ("<font color=red>\r\n\0", sock);
				}
				if (memcmp (pnt->mycall_ex, "    ", 4))
					sprintf (temp, "%8.8s/%4.4s\r\n", pnt->mycall, pnt->mycall_ex);
				else
					sprintf (temp, "%8.8s\r\n", pnt->mycall);
				chunked_send (temp, sock);
				if (pnt->ptt) chunked_send ("</font>\r\n\0", sock);
				chunked_send ("</td>\r\n\0", sock); 
				if (pnt->access_time) sprintf (temp, "<td>%24.24s</td>\r\n", ctime(&pnt->access_time));
				else			sprintf (temp, "<td> </td>\r\n");
				chunked_send (temp, sock);
				if (pnt->protocol == DPLUS) chunked_send("<td><center>DPLUS</center></td></tr>\r\n\0", sock);
				else if (pnt->protocol == DCS) chunked_send ("<td><center>DCS</center></td></tr>\r\n\0", sock);
				else chunked_send ("<td> </td></tr>\r\n\0", sock);
                		pnt = pnt->f_chain;
        		}
			chunked_send ("</table>\r\n\0", sock);
		}
	}

	chunked_send ("<br><b>(C) Copyright 2015 JARL D-STAR Committee</b>\r\n\0", sock);
	chunked_send ("</body></html>\r\n\0", sock);


/* Treminate (Last) for Chunked */
	send (sock, "0\r\n\r\n", 5, 0);
	
}
