#include	"dxchange.h"
#include	"monitor.h"

int	add_connected_table (unsigned char callsign[], unsigned char module[], int sick, int proto);
void	delete_from_table(u_long ip_add, int port);
void	alive_in_table(u_long ip_addr, int port);
void	ConnectTableCheck(void);
void	packet_resend (int length, int sock);

int	ssn_old;
int	from_len;
time_t	r_time;

struct	dstar_packet	exchange_header_packet;
struct	dstar_packet	exchange_voice_packet;

extern unsigned char	Dplus_keep_alive[];
extern unsigned char	Dplus_connect[];
extern unsigned char	Dplus_disconnect[];
extern unsigned char	Dplus_verifyReq[];
extern unsigned char	Dplus_verifyResp[];
extern unsigned char	Dplus_on_off[];
extern unsigned char	Dplus_ptt_off[];
extern unsigned char	DCS_connect_ack[];
extern unsigned char	DCS_disconnect_nak[];
	
void monitor_init(void)
{
	int	i;
	time_t	atime;
	struct	MonPort	*mon_p;

	mon_p = mon_pnt;
	while (mon_p)
	{
		if (mon_p->mon_port > 0)
		{
			mon_p->mon_sd = socket(AF_INET, SOCK_DGRAM, 0);
		        if (mon_p->mon_sd < 0)
		        {
				time (&atime);
				fprintf(log_file, "%24.24s did not create in Monitor sock\n", ctime(&atime));
				fflush (log_file);
				mon_p->mon_port = 0;
			}
			else
			{
				memset(&mon_p->mon_addr, 0, sizeof(mon_p->mon_addr));
				mon_p->mon_addr.sin_family = AF_INET;
				mon_p->mon_addr.sin_port = htons(mon_p->mon_port);
				mon_p->mon_addr.sin_addr.s_addr = htonl(INADDR_ANY);
				if (bind(mon_p->mon_sd, (struct sockaddr *)&mon_p->mon_addr, sizeof(mon_p->mon_addr)) < 0)
				{
					time(&atime);
					fprintf (log_file, "%24.24s Bind Error on Monitor Socket %s\n", ctime(&atime), strerror(errno));
					fflush (log_file);
					mon_p->mon_port = 0;
				}
				else
				{
					FD_SET (mon_p->mon_sd, &fd_save);
				}
			}
		}	
		mon_p = mon_p->f_chain;
	}

	from_len = sizeof (struct sockaddr);
	first_pnt = malloc (sizeof (struct connected_table));
	first_pnt->ip_address = 0;
	first_pnt->port = 0;
	first_pnt->f_chain = NULL;
	first_pnt->alive = 0;
	first_pnt->protocol = 0;
	gettimeofday(&first_pnt->send_time, NULL);
	last_pnt = first_pnt;
	time(&MonCheckTime);
	MonCheckTime += 5;
}


void	monitor_connect(struct	MonPort *mon_p)
{
	int	n;
	socklen_t	from_len;
	int	sock;

	sock = mon_p->mon_sd;
	from_len = sizeof(from);
        memset(&from, 0, sizeof(from));
        from.sin_family = AF_INET;
        from.sin_port = htons(mon_p->mon_port);
        from.sin_addr.s_addr = htonl(INADDR_ANY);	
	n = recvfrom (sock, (char *)&packet, sizeof(packet), 
				0, (struct sockaddr *)&from, &from_len);
	switch (n)
	{
		case 3:		// Dplus keep alive
			if (!memcmp (&packet, &Dplus_keep_alive, 3))
			{
				alive_in_table (from.sin_addr.s_addr, 
							from.sin_port);
			}
			break;

		case 5:
			if (!memcmp (&packet, Dplus_connect, 5))
                        {
                                sendto (sock, (char *)&Dplus_connect, 5, 0, (struct sockaddr *)&from, sizeof(from));
			}
			else if (!memcmp (&packet, Dplus_disconnect, 5))
			{
				sendto (sock, (char *)&Dplus_disconnect, 5, 0, (struct sockaddr *)&from, sizeof(from));
				delete_from_table (from.sin_addr.s_addr, from.sin_port);
			}
			break;

		case 28:
			if (!memcmp (&packet, Dplus_verifyReq, 4))
			{
				time(&r_time);
				if (add_connected_table (packet.verifyReq.callsign, packet.verifyReq.callsign, sock, DPLUS))
				{
                                	fprintf (log_file,"%24.24s %8.8s connected on Monitor port (Protocol Dplus)\n", 
							ctime(&r_time), &packet.verifyReq.callsign);
                                	fflush (log_file);
					memcpy (&packet.verifyResp.id, &Dplus_verifyResp, 4);
					memcpy (&packet.verifyResp.OK, "OK", 2);
					memcpy (&packet.verifyResp.RW, "RW", 2);
                                	sendto (sock, &packet.verifyResp, 8, 0, (struct sockaddr *)&from, sizeof(from));
					sendto (sock, &Dplus_keep_alive, 3, 0, (struct sockaddr *)&from, sizeof(from));
				}
			}
			break;
		case 519:	// DCS
			time (&r_time);
			packet.DCS_Connect.callsign[7] = packet.DCS_Connect.band;
			packet.DCS_Connect.XrefName[7] = packet.DCS_Connect.module;
			if (add_connected_table (packet.DCS_Connect.callsign, packet.DCS_Connect.XrefName, sock, DCS))
			{
                                fprintf (log_file,"%24.24s %8.8s connected on Monitor port (Protocol DCS)\n",
                                               ctime(&r_time), &packet.DCS_Connect.callsign);
                                fflush (log_file);
                                memcpy (&DCS_connect_ack, packet.DCS_Connect.callsign, 10);
                                sendto (sock, &DCS_connect_ack, 14, 0, (struct sockaddr *)&from, sizeof(from));
				memcpy (&DCS_connect_ack, packet.DCS_Connect.XrefName, 8);
				DCS_connect_ack[7] = 0x20;
				DCS_connect_ack[8] = 0x00;
				sendto (sock, &DCS_connect_ack , 9, 0, (struct sockaddr *)&from, sizeof(from));
				
			}
			else
			{
                        	memcpy (&DCS_disconnect_nak, &packet.DCS_NAK.callsign, 10);
                        	sendto (sock, &DCS_disconnect_nak, 14, 0, (struct sockaddr *)&from, sizeof(from));
			}
			break;
		case 19:
			memcpy (&DCS_disconnect_nak, &packet.DCS_NAK.callsign, 10);
			sendto (sock, &DCS_disconnect_nak, 14, 0, (struct sockaddr *)&from, sizeof(from));
                        delete_from_table (from.sin_addr.s_addr, from.sin_port);
                        break;
		case 11:		// dcs disconnect
			delete_from_table (from.sin_addr.s_addr, from.sin_port);
			break;
		case 15:		// dcs connection info.
			break;
		case 100:
			if (memcmp(packet.DCS_Frame.mycall, "        ", 8))
			{
				if (dcs2dcs ()) 
				{
					dcs2dplus();
					dcs2icom();
				}
				dcs2dcs_c();
			}
			break;
		case 25:
		case 12:
		case 38:
			break;
                case 17:        // DCS keep alive
                        alive_in_table (from.sin_addr.s_addr, from.sin_port);
                        break;
		case 58:
		case 29:
		case 32:
		case 10:
			if (dplus2dplus(n))
			{
				dplus2icom(n);
				dplus2dcs(n);
			}
			break;
		case 56:
		case 27:
			break;
	}
}

/* Connect table update */
void	ConnectTableCheck()
{
	struct	connected_table *pnt;

loop:
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->alive > 5)
		{
			delete_from_table (pnt->ip_address, pnt->port);
			goto loop;
		}
		pnt = pnt->f_chain;
	}
}

int	add_connected_table (unsigned char call[], unsigned char module[], int sock, int proto)
{
	struct	connected_table *pnt;
	time_t	atime;
	
	if (proto == DCS)
	{
		pnt = first_pnt->f_chain;
		while (pnt)
		{
			if (pnt->protocol == DCS)
			{
				if (!memcmp (module, &pnt->module, 8) && !memcmp(call, &pnt->callsign, 8)) return FALSE;
			}
			pnt = pnt->f_chain;
		}
	}

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if ((pnt->ip_address == from.sin_addr.s_addr) 
			&& (pnt->port == from.sin_port))
		{
			time (&atime);
			if (proto == DCS)
			{
				if (memcmp (&pnt->module, module, 8))
				{
					memcpy (&pnt->module, module, 8);
					fprintf (log_file, "%24.24s Module Name replacei %8.8s\n",
						ctime(&atime), module);
				}		
					
			}
			fprintf (log_file, "%24.24s %s ip:%0d.%0d.%0d.%0d port:%d Already exist\n", 
				ctime(&atime),
				call,
				(pnt->ip_address & 0xff),
				((pnt->ip_address >> 8) & 0xff),
				((pnt->ip_address >> 16) & 0xff),
				((pnt->ip_address >> 24) & 0xff),
				htons(pnt->port));
			fflush(log_file);
			return TRUE;
		}
		pnt = pnt->f_chain;
	}	
	pnt = malloc (sizeof (struct connected_table));
	pnt->f_chain = NULL;
	pnt->ip_address = from.sin_addr.s_addr;
	pnt->port = from.sin_port;
	pnt->protocol = proto;
	memcpy (&pnt->callsign[0], call, 8);
	memset (&pnt->module, 0x20, 8);
	if (proto == DCS) memcpy (&pnt->module, module, 8);
	pnt->alive = 0;
	gettimeofday (&pnt->send_time, NULL);
	time (&pnt->connect_time);
	pnt->send_time.tv_sec++;
	pnt->access_time = 0;
	memset (&pnt->mycall, 0x20, 8);
	memset (&pnt->mycall_ex, 0x20, 4);
	pnt->ptt = FALSE;
	pnt->sd = sock;
	pnt->FrameCounter = 0;
	pnt->re_xmit = FALSE;
	memset (&pnt->FrameID, 0x00, 2);
	memset (&pnt->ex_FrameID, 0x00, 2);
	memset (&pnt->dp_FrameID, 0x00, 2);
	last_pnt->f_chain = pnt;
	last_pnt = pnt;
	return TRUE;
}


void	delete_from_table (u_long ip_addr, int	port)
{
	struct	connected_table *pnt, *pnt_wrk;

	pnt_wrk = first_pnt;
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->ip_address == ip_addr)
		{
			if (pnt->port == port)
			{
				time(&r_time);
				if (pnt->protocol == DPLUS) fprintf (log_file, "%24.24s %8.8s disconnected from Monitor port (Protocol Dplus)\n", ctime(&r_time), pnt->callsign);
				else if (pnt->protocol == DCS) fprintf (log_file, "%24.24s %8.8s disconnected from Monitor port (Protocol DCS)\n", ctime(&r_time), pnt->callsign);
				fflush (log_file);
				pnt_wrk->f_chain = pnt->f_chain;
				free (pnt);
				last_pnt = first_pnt;
				pnt = first_pnt->f_chain;
				while (pnt)
				{
					last_pnt = pnt;
					pnt = pnt->f_chain;
				}
				return;
			}
		}
		pnt_wrk = pnt;
		pnt = pnt->f_chain;
	}
	return;
}

/* client status check */
void	alive_in_table (u_long ip_addr, int in_port)
{
	struct	connected_table *pnt;

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if ((pnt->ip_address == ip_addr) && (pnt->port == in_port))
		{
			pnt->alive = 0;
			break;
		}
		pnt = pnt->f_chain;
	}
}

void    alive_reset (void)
{
        struct  connected_table *pnt;
	struct	timeval	r_time;

	gettimeofday (&r_time, NULL);

        pnt = first_pnt->f_chain;
        while (pnt)
        {
		if (timercmp(&pnt->send_time, &r_time, <))
		{
       	 		pnt->alive++;
			from.sin_addr.s_addr = pnt->ip_address;
			from.sin_port = pnt->port;
                	if (pnt->protocol == DPLUS) 
			{
				sendto (pnt->sd, (char *)&Dplus_keep_alive, 3, 0,
                        		(struct sockaddr *)&from, sizeof(from));
				pnt->send_time.tv_sec = r_time.tv_sec + 1;
			}
			else if (pnt->protocol == DCS)
			{
				// old version 
				memcpy (DCS_Poll_Reply.XrefName, pnt->module, 7);
				DCS_Poll_Reply.XrefName[7] = 0x20;
				DCS_Poll_Reply.XrefModule = 0x00;
				sendto (pnt->sd, &DCS_Poll_Reply, 9, 0, (struct sockaddr *)&from, sizeof(from));
				
				// new version
                        	DCS_Poll_Reply.id = 0x0a;
                        	memcpy (DCS_Poll_Reply.XrefName, pnt->module, 8);
				DCS_Poll_Reply.XrefModule = 0x20;
                        	memcpy (DCS_Poll_Reply.callsign, pnt->callsign, 8);
				DCS_Poll_Reply.module = pnt->callsign[7];
                        	DCS_Poll_Reply.filler[0] = 0x00;
                        	DCS_Poll_Reply.filler[1] = 0x20;
                        	DCS_Poll_Reply.filler[2] = 0x20;
                        	sendto (pnt->sd, &DCS_Poll_Reply, 22, 0, (struct sockaddr *)&from, sizeof(from));
				pnt->send_time.tv_sec = r_time.tv_sec + 5;
			}
			pnt->send_time.tv_usec = r_time.tv_usec; 
		}
               	pnt = pnt->f_chain;
        }
}

void	connected_table_print(void)
{
	struct	connected_table *pnt;
	time_t	atime;

	pnt = first_pnt->f_chain;
	if (!pnt) return;

	time(&atime);
	fprintf (log_file, "Monitor Connected Table %24.24s\n", ctime(&atime));
	while (pnt)
	{
		fprintf (log_file, "%8.8s ip:%0d.%0d.%0d.%0d  port:%d re_xmit:%0d\n", 
			pnt->callsign, 
			(pnt->ip_address & 0xff),
			((pnt->ip_address >> 8) & 0xff),
			((pnt->ip_address >> 16) & 0xff),
			((pnt->ip_address >> 24) & 0xff), 
			htons(pnt->port), pnt->re_xmit);
		pnt = pnt->f_chain;
	}
	fprintf (log_file, "Monitor Table End\n");
	fflush (log_file);
}	
