struct STATUS_frame
{
        unsigned char   StatusID[6];    /* "DSTRST" */
        unsigned char   Type[2];
#if __WORDSIZE == 64
	time_t		EntryUpdateTime;
#else
	time_t		EntryUpdateTime;
	time_t		dummy_t;
#endif
        unsigned char   ip_address[16];
	unsigned short int	port;
	unsigned char	reserve[2];
	unsigned char	RPT2Call[8];
	unsigned char	RPT1Call[8];
	unsigned char	UrCall[8];
	unsigned char	MyCall[8];
	unsigned char	MyCall2[4];
	unsigned char	ShortMessage[20];
	int		Latitude;
	int		Longitude;
};

struct DCS_frame
{
        unsigned char   FrameType[4];    /* "0001" */
	unsigned char   flags[3];               /* 0x00,0x00,0x00 */
        unsigned char   rpt2[8];		// ref_name1[8];	// rpt2
        unsigned char   rpt1[8];		// ref_name2[8];// rpt1
        unsigned char   urcall[8];
        unsigned char   mycall[8];
        unsigned char   mycall2[4];
        unsigned char   FrameID[2];
        unsigned char   FrameSeq;
        unsigned char   Voice[9];
        unsigned char   SlowData[3];
        unsigned char   FrameCnt[3];
        unsigned char   FrameVer[2];
        unsigned char   Language;
        unsigned char   Message[20];
	unsigned char	Source;
        unsigned char   reserve[11];
	unsigned char	src_ip_addr[4];
};

struct
{
	unsigned char   XrefName[8];
        unsigned char   XrefModule;
        unsigned char   callsign[8];
        unsigned char   module;
        unsigned char   id;             // 0x0a
        unsigned char   filler[3];
} DCS_Poll_Reply;

struct	DCS_MSG
{
	unsigned char	call[8];
	unsigned char	msg[8];
	unsigned char	module[8];
	unsigned char 	filler[11];
};

struct
{
        unsigned char   call[8];
        unsigned char   comment[17];
} CCS_Heartbeat;

struct
{	unsigned char	moduleName[8];
	unsigned char	filler;
} DCS_Keep_Alive;

struct
{
	unsigned char	call[8];
	unsigned char	module;
	unsigned char	filler[10];
} CCS_Cancel;

struct Dplus
{
	unsigned char   length;         // packet length include this byte
        unsigned char   reserve;        // 0x80
        unsigned char   id[4];          // DVST
        unsigned char   resv[4];        // header 0x10, 0x00, 0x00, 0x00
					// voice  0x20, 0x00, 0x00, 0x00
        struct
        {
               unsigned char   id;     // data 0x40  voice 0x20
               unsigned char   dst_rpt_id;
               unsigned char   src_rpt_id;
               unsigned char   src_term_id;
               unsigned char   FrameID[2];
               unsigned char   FrameSeq;  // header 0x80  last frame | 0x40
        } trunk;
        union
        {
        	struct
                {
                	char    flag[3];
                        char    rpt2[8];
                        char    rpt1[8];
                        char    urcall[8];
                        char    mycall[8];
                        char    mycall_ex[4];
                        unsigned char   crc[2];
               } header;
               struct
               {
                        char    voice[9];
                        char    slowdata[3];
               } voice;
               struct
               {
               	        char    voice[9];
                        char    slowdata[3];
                        char    dummy[3];
               } last;
        } body;
};

union
{
	unsigned char	Connect[5];
	unsigned char	KeepAlive[3];
	struct
	{
		unsigned char	id[4];
		unsigned char	callsign[8];
		unsigned char	pin[8];
		unsigned char	version[8];
	} verifyReq;
	struct	
	{
		unsigned char	id[4];
		unsigned char	OK[2];
		unsigned char	RW[2];
	} verifyResp;

	struct	Dplus	dplus;

	struct
	{
        	unsigned char   frame_id[4];    /* "0001" */
        	unsigned char   flags[3];               /* 0x00,0x00,0x00 */
        	unsigned char   ref_name[8];
        	unsigned char   client[8];
        	unsigned char   cqcqcq[8];              /* CQCQCQ  */
        	unsigned char   mycall[8];
        	unsigned char   mycall_ex[4];
        	unsigned char   StreamID[2];
        	unsigned char   reserve[16];    /* all 0x00 */
        	unsigned char   reserve61[3];   /* 0x01 0x00 0x21 */
        	unsigned char   reserve64[20];  /* all 0x20 */
        	unsigned char   reserve84[9];   /* all 0x00 */
        	unsigned char   DataSource;             /* 0x30:from RF  0x034:DPlus 0x035:DCS */
        	unsigned char   reserve94[6];   /* all 0x00 */
	} CCS_Status_Frame;

	struct
	{
		unsigned char	callsign[8];
		unsigned char	band;
		unsigned char	module;
		unsigned char	filler;
		unsigned char	XrefName[8];
		unsigned char	html[500];
	} DCS_Connect;

        struct
        {
                unsigned char   callsign[8];
                unsigned char   band;
                unsigned char   module;
                unsigned char   nak[4];
        } DCS_NAK;

	struct
	{
		unsigned char	callsign[8];
		unsigned char	filler;
		unsigned char	XrefName[8];
	} DCS_Poll_Req;
	
	struct	DCS_frame	DCS_Frame;

} packet;

