#include	"dxchange.h"
#include	"monitor.h"

void    module_init(struct ModuleTable *module, unsigned char Module[], 
		int port, char dcs_m[], int dcs_p, char ref_m[], int ref_p);
void	forward_init (struct forward *fwd, unsigned char Fullname[], 
		int port, char ip_rep);
void    status_init (struct status *sta, unsigned char Fullname[], int port);


enum
{
        DCS_OPEN = 0,
        DCS_LOOP,
        DCS_NG
};

enum
{
        REF_OPEN = 0,
        REF_LOOP,
        REF_NG
};

int	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	len;
	int	k;
	int	n;
	int	m;
	int	j;
	unsigned char	Module[8];
	unsigned char	dcs_m[8];
	unsigned char	ref_m[8];
	struct	ModuleTable	*module_next;
	struct	MonPort	*mon_p;
	int	field_sw;
	int	port;
	int	dcs_p;
	int	ref_p;
	time_t	atime;
	int	false_ret;
	unsigned char	fqdn[128];
	struct	forward		*forward_next;
	struct	status		*status_next;
	char	ip_rep;

	FILE	*config_file;
	
	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&atime), argv[1]);
			fflush (log_file);
			return FALSE;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&atime), CONFIG_FILE);
			fflush (log_file);
			return FALSE;
		}
	}

	false_ret = FALSE;

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "APRS_SERVER", 11))
				{
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (server_name, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (field_sw)
                                                {
							if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                }
                                                else
                                                {
                                                	if (*pnt == ':') field_sw = 1;
                                                        else
                                                        {
                                                                if (*pnt != 0x20) server_name[n++] = *pnt;
                                                                if (n > 127) n = 127;
                                                        }
                                                }
                                                pnt++;
                                        }
					if (n && (port > 0))
					{
                                                server_name[n] = 0x00;
                                                server_port = port;
					}
					else
					{
						time (&atime);
						fprintf (log_file, "%24.24s Invalid Format of APRS_SERVER\n", 
										ctime(&atime));
						fflush (log_file);
						false_ret = TRUE;
					}
				}
                                else if (!memcmp (p, "TRUST_SERVER", 12))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (trust_name, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (field_sw)
                                                {
                                                        if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                }
                                                else
                                                {
                                                        if (*pnt == ':') field_sw = 1;
                                                        else
                                                        {
                                                                if (*pnt != 0x20) trust_name[n++] = *pnt;
                                                                if (n > 127) n = 127;
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n && (port > 0))
                                        {
                                                trust_name[n] = 0x00;
                                                trust_port = port;
                                        }
                                        else
                                        {
                                                time (&atime);
                                                fprintf (log_file, "%24.24s Invalid Format of TRUST_SERVER\n",
                                                                                ctime(&atime));
                                                fflush (log_file);
                                                false_ret = TRUE;
                                        }
                                }
				else if (!memcmp (p, "RECV_PORT", 9))
				{
					recv_port = atoi(pnt);
				}
                                else if (!memcmp (p, "SEND_PORT", 9))
                                {
                                        send_port = atoi(pnt);
                                }
                                else if (!memcmp (p, "GW_PORT", 9))
                                {
                                        gw_port = atoi(pnt);
                                }
				else if (!memcmp (p, "CALLSIGN", 8))
				{
					memset (client_callsign, 0x20, 7);
					len = strlen(pnt);
					if (len > 7) len = 7;
					memcpy (client_callsign, pnt, len);
				}
				else if (!memcmp (p, "RADIO_ID", 8))
				{
					radio_id = *pnt;
				}
				else if (!memcmp (p, "AUTO_RELINK", 11))
				{
					AutoReLink = atoi (pnt);				
				}
				else if (!memcmp (p, "RETRY_COUNT", 11))
				{
					RetryCnt = atoi (pnt);
				} 
				else if (!memcmp (p, "SEND_INTERVAL", 13))
				{
					send_interval =  atoi (pnt);
				}
				else if (!memcmp (p, "GPS_MESSAGE_SKIP", 16))
				{
					gps_only_skip = atoi(pnt);
				}
				else if (!memcmp (p, "GPS_SKIP_BITS", 13))
				{
					gps_skip_bits = atoi(pnt);
				}
                	        else if (!memcmp (p, "BEACON_LAT", 10))
                        	{
                        	        BeaconLat = atof (pnt) * 10000.;
				}	
				else if (!memcmp (p, "BEACON_LONG", 11))
                        	{
                	                BeaconLong = atof (pnt) * 10000.;
                        	}
                	        else if (!memcmp (p, "BEACON_INTERVAL", 11))
                        	{
                                	BeaconInterval = atoi (pnt);
                       	 	}
                        	else if (!memcmp (p, "BEACON_COMMENT", 14))
                        	{
                               		 memset (beacon_comment, 0x00, 64);
                                	len = strlen(pnt);
                                	if (len > 63) len = 63;
                                	memcpy (beacon_comment, pnt, len);
                        	}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug_sw = atoi(pnt);
				}
                                else if (!memcmp (p, "STATUS", 7))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt != ',')
                                                {
                                                        if (field_sw)
                                                        {
                                                                if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                        }
                                                        else
                                                        {
                                                                if (*pnt == ':') field_sw = 1;
                                                                else
                                                                {
                                                                        if (*pnt != 0x20) fqdn[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                }
                                                        }
                                                }
                                                else
                                                {
                                                        status_next = malloc (sizeof (struct status));
                                                        if (status_next != NULL)
                                                        {
                                                                fqdn[n] = 0x00;
                                                                status_init(status_next, fqdn, port);
                                                                if (status_pnt) status_last->f_chain = status_next;
                                                                else status_pnt = status_next;
                                                                status_last = status_next;
                                                                port = 0;
                                                                n = 0;
                                                                field_sw = 0;
                                                        }
                                                        else
                                                        {
                                                                time(&atime);
                                                                fprintf (log_file, "%24.24s Memoty not allocate (STATUS)\n", ctime(&atime));
                                                                fflush (log_file);
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n)
                                        {
                                                fqdn[n] = 0x00;
                                                status_next = malloc (sizeof (struct status));
                                                status_init(status_next, fqdn, port);
                                                if (status_pnt) status_last->f_chain = status_next;
                                                else status_pnt = status_next;
                                                status_last = status_next;
                                        }
                                }
				else if (!memcmp (p, "MONITOR_PORT", 12))
				{
					n = 0;
					while (*pnt)
					{
						if (*pnt == ',')
						{
							if (n > 0)
							{
								mon_p = malloc (sizeof (struct MonPort));
								if (mon_p != NULL)
								{
									mon_p->mon_port = n;
									mon_p->mon_sd = 0;
									mon_p->f_chain = NULL;
									if (mon_pnt) mon_last->f_chain = mon_p;
									else mon_pnt = mon_p;
									mon_last = mon_p;
									n = 0;
								}
								else
								{
									time(&atime);
									fprintf (log_file, "%24.24s  Memory not allocate for Monitor Port Table\n", ctime(&atime));
									fflush (log_file);
								}
							}
						}
						else
						{
							n *= 10;
							n += (*pnt - '0');
						}
						pnt++;
					}
					if (n)
					{
						mon_p = malloc (sizeof (struct MonPort));
						if (mon_p != NULL)
						{
							mon_p->mon_port = n;
							mon_p->mon_sd = 0;
							mon_p->f_chain = NULL;
							if (mon_pnt) mon_last->f_chain = mon_p;
							else mon_pnt = mon_p;
							mon_last = mon_p;
						}
						else
						{
							time(&atime);
							fprintf (log_file, "%24.24s  Memory not allocate for Monitor Port Table\n", ctime(&atime));
							fflush (log_file);
						}
					}
	
				}
				else if (!memcmp (p, "FORWARD", 7))
				{
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
					ip_rep = FALSE;
                                        memset (fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt != ',')
                                                {
                                                        if (field_sw)
                                                        {
                                                                if (isdigit(*pnt)) port = port * 10 + *pnt - '0';
                                                        }
                                                        else
                                                        {
                                                                if (*pnt == ':') field_sw = 1;
                                                                else
								{
									if ((*pnt == '*') && (n == 0)) ip_rep = '*';
									else if ((*pnt == '#') && (n == 0)) ip_rep = '#';
									else
									{ 
										if (*pnt != 0x20) fqdn[n++] = *pnt;
										if (n > 127) n = 127;
									}
								}
                                                        }
                                                }
                                                else
                                                {
                                                        forward_next = malloc (sizeof (struct forward));
                                                        if (forward_next != NULL)
                                                        {
								fqdn[n] = 0x00;
                                                                forward_init(forward_next, fqdn, port, ip_rep);
                                                                if (forward_pnt) forward_last->f_chain = forward_next;
                                                                else forward_pnt = forward_next;
                                                                forward_last = forward_next;
                                                                port = 0;
                                                                n = 0;
                                                                field_sw = 0;
								ip_rep = FALSE;
                                                        }
                                                        else
                                                        {
                                                                time(&atime);
                                                                fprintf (log_file, "%24.24s Memoty not allocate (FORWARD)\n", ctime(&atime));
                                                                fflush (log_file);
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n)
                                        {
						fqdn[n] = 0x00;
                                                forward_next = malloc (sizeof (struct forward));
                                                forward_init(forward_next, fqdn, port, ip_rep);
                                                if (forward_pnt) forward_last->f_chain = forward_next;
                                                else forward_pnt = forward_next;
                                                forward_last = forward_next;
                                        }
				}
				else if (!memcmp (p, "MODULE_NAME", 11))
				{
					n = 0;
					m = 0;
					k = 0;
					j = 0;
					field_sw = 0;
					port = 0;
					dcs_p = 0;
					ref_p = 0;
					memset (Module, 0x20, 8);
					memset (dcs_m, 0x20, 8);
					memset (ref_m, 0x20, 8);
					while (*pnt)
					{
						if (*pnt != ',')
						{
							if (field_sw == 1)
							{
								if (*pnt == ':') field_sw++;
								else if (isdigit(*pnt)) port = port * 10 + *pnt - '0';
								 
							}
							else if (field_sw == 2)
							{
								if (*pnt == ':') field_sw++;
								else if (m < 8)
								{
									if (m == 0)
									{
										if (*pnt != 0x20) dcs_m[m++] = *pnt;
									}
									else
									{
										dcs_m[m++] = *pnt;
									}
								}
							}	
							else if (field_sw == 3)
							{
								if (*pnt == ':') field_sw++;
								else if (isdigit(*pnt)) dcs_p = dcs_p * 10 + *pnt - '0';
							}
							else if (field_sw == 4)
							{
								if (*pnt == ':') field_sw++;
								else if (j < 8)
								{
									if (j == 0)
									{
										if (*pnt != 0x20) ref_m[j++] = *pnt;
									}
									else
									{
										ref_m[j++] = *pnt;
									}
								}
							}
							else if (field_sw == 5)
							{
								if (isdigit(*pnt)) ref_p = ref_p * 10 + *pnt - '0';
							}
							else
							{
								if (*pnt == ':') field_sw++;
								else if (n < 8) 
								{
									if (n == 0)
									{
										if (*pnt != 0x20) Module[n++] = *pnt;
									}
									else
									{
										Module[n++] = *pnt;
									}
								}
							}
						}
						else
						{
							module_next = malloc (sizeof (struct ModuleTable));
							if (module_next != NULL)
							{
								module_init(module_next, Module, port, dcs_m, dcs_p, ref_m, ref_p);
								if (module_pnt) module_last->f_chain = module_next;
								else module_pnt = module_next;
								module_last = module_next;
								port = 0;
								dcs_p = 0;
								ref_p = 0;
								n = 0;
								m = 0;
								j = 0;
								field_sw = 0;
								memset (Module, 0x20, 8);
								memset (dcs_m, 0x20, 8);
								memset (ref_m, 0x20, 9);
							}
							else
							{
								time(&atime);
								fprintf (log_file, "%24.24s Memoty not allocate\n", ctime(&atime));
								fflush (log_file); 
							}
						}
						pnt++;	
					}
					if (n)
					{
                                                module_next = malloc (sizeof (struct ModuleTable));
						module_init(module_next, Module, port, dcs_m, dcs_p, ref_m, ref_p);
                                                if (module_pnt) module_last->f_chain = module_next;
                                                else module_pnt = module_next;
                                                module_last = module_next;
					}
				}
				else if (!memcmp (p, "REXMIT_PASS_CODE", 16))
				{
					memset (xmit_pass_code, 0x00, 10);
					n = strlen(pnt);
					if (n > 8) n = 8;
					memcpy (xmit_pass_code, pnt, n);
 				}
				else if (!memcmp (p, "HTTP_PORT", 9))
				{
					http_port = atoi(pnt);
				}
				else if (!memcmp (p, "SEND_NIC", 8))
				{
					memset (SEND_NIC, 0x00, 8);
					memcpy (SEND_NIC, pnt, strlen(pnt));
				}
                                else if (!memcmp (p, "RECV_NIC", 8))
                                {
                                        memset (RECV_NIC, 0x00, 8);
                                        memcpy (RECV_NIC, pnt, strlen(pnt));
                                }
                                else if (!memcmp (p, "GW_NIC", 8))
                                {
                                        memset (GW_NIC, 0x00, 8);
                                        memcpy (GW_NIC, pnt, strlen(pnt));
                                }
				else
				{
					time (&atime);
					fprintf (log_file, "%24.24s Error on config file : %s\n",ctime(&atime), buff);
					fflush (log_file);
				}
			}
		}
	}

	fclose (config_file);

	time (&atime);
	if (module_pnt == NULL)
	{
		fprintf (log_file, "%24.24s Repeater Module name not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (recv_port <= 0)
	{
		fprintf (log_file, "%24.24s Repeater receive port not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (server_name[0] == 0x20)
	{
		fprintf (log_file, "%24.24s APRS server name not assign.\n", ctime(&atime));
		false_ret - TRUE;
		fflush (log_file);
	}

        if (server_port <= 0)
        {
                fprintf (log_file, "%24.24s APRS server port not assign.\n", ctime(&atime));
                false_ret - TRUE;
                fflush (log_file);
        }
	
	if (!memcmp (client_callsign, "XX0XXX", 6))
	{
		fprintf (log_file, "%24.24s CALLSIGN not define.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	} 
	if (false_ret) return FALSE;
	return TRUE;
	
}

void	module_init(struct ModuleTable *module, unsigned char Module[], int port, char dcs_m[], int dcs_p, char ref_m[], int ref_p)
{
	module->AccessTime = 0;
	memcpy (module->ModuleName, Module, 8);
	memcpy (module->dcs_module, dcs_m, 8);
	memcpy (module->ref_module, ref_m, 8);
	memset (module->mycall, 0x20, 8);
	memset (module->mycall_ex, 0x20, 4);
	memset (module->rptcall, 0x20, 8);
	module->AprsSend = 0x00;
	module->RX_on = FALSE;
	module->DCS_FrameCounter = 0;
	module->aprs_msg_pnt = 0;
	module->packet_cnt = 0;
	module->HeaderCnt = 0;
	module->RadioVoicePacketCnt;
	module->f_chain = NULL;
	module->voice_port = 0;
	module->port = 0;
	module->voice_port = port;
	module->SendSeq = 0;
	module->dcs_sd = 0;
	module->ref_sd = 0;
	if (dcs_p) module->dcs_port = dcs_p;
	else if (dcs_m[0] != 0x20) module->dcs_port = DCS_PORT;
	else  module->dcs_port = 0;
	if (ref_p) module->ref_port = ref_p;
	else if (ref_m[0] != 0x20) module->ref_port = REF_PORT;
	else module->ref_port = 0;
	module->rpt_save_length = 0;
	module->recv_time.tv_sec = 0;
	module->recv_time.tv_usec = 0;
	module->lost_cnt = 0;
	if (module->dcs_port)
	{
		dcs_cnt++;
		module->dcs_state = DCS_OPEN;
	}
	else
		module->dcs_state = DCS_NG;
	if (module->ref_port)
	{
		ref_cnt++;
		module->ref_state = REF_OPEN;
	}
	else
		module->ref_state = REF_NG; 
}

void	forward_init (struct forward *fwd, unsigned char FullName[], int port, char ip_rep)
{
	fwd->f_chain = NULL;
	fwd->port = port;
	memcpy (fwd->fqdn, FullName, 128);
	fwd->packets = 0;
	fwd->ip_replace = ip_rep;
}

void    status_init (struct status *sta, unsigned char FullName[], int port)
{
        sta->f_chain = NULL;
        sta->port = port;
        memcpy (sta->fqdn, FullName, 128);
        sta->packets = 0;
	memset (sta->userID, 0x00, 16);
	memset (sta->passwd, 0x00, 64);
}

