#include	"dxchange.h"
#include	"monitor.h"

void    ref_connect(struct ModuleTable *pnt);
void    ref_verify_send(struct ModuleTable *pnt);


extern	char	Dplus_connect[];
extern	char	Dplus_verifyReq[];
extern	char	Dplus_verifyResp[];
extern	char	Dplus_keep_alive[];

enum
{
	REF_OPEN = 0,
	REF_LOOP,
	REF_NG
} ref_state = REF_OPEN;

void	ref2dplus(int n, struct ModuleTable *m_pnt)
{
        struct  connected_table *pnt;
        time_t  atime;

        pnt = first_pnt->f_chain;
        while (pnt)
        {
                if (pnt->protocol == DPLUS)
                {
			if (n == 58) memcpy (packet.dplus.body.header.rpt2, m_pnt->ModuleName, 8);
                        from.sin_addr.s_addr = pnt->ip_address;
                        from.sin_port = pnt->port;
                        if (sendto(pnt->sd, (char *)&packet, n,
                                0, (struct sockaddr *)&from, sizeof(from)) < 0)
                        {
                                time (&atime);
                                fprintf (log_file, "%24.24s sendto error\n", ctime(&atime));
                                fflush (log_file);
                        }
                }
                pnt = pnt->f_chain;
        }
}

void	ref2dcs(int length, struct ModuleTable *m_pnt)
{
        struct  connected_table *pnt;

        if (length == 58)
        {
		if (memcmp (packet.dplus.trunk.FrameID, m_pnt->DCS_C.FrameID, 2))
		{
        		memcpy (packet.dplus.body.header.rpt2, m_pnt->ModuleName, 8);
                	memcpy (m_pnt->DCS_C.FrameType , "0001", 4);
                	memcpy (m_pnt->DCS_C.flags, &packet.dplus.body.header, 39);
                	memcpy (m_pnt->DCS_C.FrameID, packet.dplus.trunk.FrameID, 3);	// FrameID + FrameSeq
                	memset (m_pnt->DCS_C.Message, 0x20, 20);
                	m_pnt->DCS_C.FrameVer[0] = 0x01;
                	m_pnt->DCS_C.FrameVer[1] = 0x00;
                	m_pnt->DCS_C.Language = 0x21;
                	m_pnt->DCS_C_FrameCounter = 0;
		}
                return;
        }
        else if ((length == 29) || (length == 32))
        {
		if (!memcmp (packet.dplus.trunk.FrameID, m_pnt->DCS_C.FrameID, 2))
		{
                	if (packet.dplus.trunk.FrameSeq)
                	{
                        	if ((packet.dplus.trunk.FrameSeq & 0x3f) % 2)
                        	{
                                	m_pnt->ref_mini_header = packet.dplus.body.voice.slowdata[0] ^  0x70;
                                	m_pnt->ref_data[0] = packet.dplus.body.voice.slowdata[1] ^  0x4f;
                                	m_pnt->ref_data[1] = packet.dplus.body.voice.slowdata[2] ^  0x93;
                        	}
                        	else
                        	{
                                	m_pnt->ref_data[2] = packet.dplus.body.voice.slowdata[0] ^  0x70;
                                	m_pnt->ref_data[3] = packet.dplus.body.voice.slowdata[1] ^  0x4f;
                                	m_pnt->ref_data[4] = packet.dplus.body.voice.slowdata[2] ^  0x93;
                                	switch (m_pnt->ref_mini_header)
                                	{
                                        	case 0x40:
                                                	memcpy (&m_pnt->DCS_C.Message[0], m_pnt->ref_data, 5);
             						break;
                                        	case 0x41:
							memcpy (&m_pnt->DCS_C.Message[5], m_pnt->ref_data, 5);
                                                	break;
                                        	case 0x42:
                                                	memcpy (&m_pnt->DCS_C.Message[10], m_pnt->ref_data, 5);
                                                	break;
                                        	case 0x43:
                                                	memcpy (&m_pnt->DCS_C.Message[15], m_pnt->ref_data, 5);
                                                	break;
                                	}
                        	}
                	}
                	m_pnt->DCS_C.FrameCnt[0] = m_pnt->DCS_C_FrameCounter & 0xff;
                	m_pnt->DCS_C.FrameCnt[1] = (m_pnt->DCS_C_FrameCounter >> 8) & 0xff;
                	m_pnt->DCS_C.FrameCnt[2] = (m_pnt->DCS_C_FrameCounter >> 16) & 0xff;
                	m_pnt->DCS_C_FrameCounter++;
                	m_pnt->DCS_C.Source = 0x34;     // from REF
                	m_pnt->DCS_C.FrameSeq = packet.dplus.trunk.FrameSeq;
                	memcpy (&m_pnt->DCS_C.Voice[0], &packet.dplus.body.voice, 12);

                	pnt = first_pnt->f_chain;
                	while (pnt)
                	{
                        	if (!memcmp (m_pnt->DCS_C.rpt2, pnt->module, 8))
                        	{
                                	if (pnt->protocol == DCS)
                                	{
                                        	from.sin_addr.s_addr = pnt->ip_address;
                                        	from.sin_port = pnt->port;
                                        	sendto(pnt->sd, &m_pnt->DCS_C, 100,
                                                	0, (struct sockaddr *)&from, sizeof(from));
                                	}
                        	}
                        	else
                        	{
                                	if (pnt->protocol == DCS)
                                	{
                                        	if (packet.dplus.trunk.FrameSeq == 20)
                                        	{
                                                	memset (&DCS_Msg, 0x00, 35);
                                                	memcpy (&DCS_Msg.call, pnt->mycall, 8);
                                                	memcpy (&DCS_Msg.msg, "Talk on ", 8);
                                                	memcpy (&DCS_Msg.module, pnt->module, 8);
                                                	from.sin_addr.s_addr = pnt->ip_address;
                                                	from.sin_port = pnt->port;
                                                	sendto (pnt->sd, &DCS_Msg, 35, 0, (struct sockaddr *)&from, sizeof(from));
                                        	}
                                	}
                        	}
                        	pnt = pnt->f_chain;
                	}
                	if (m_pnt->dcs_port)
                	{
                        	memcpy(m_pnt->DCS_C.rpt2, m_pnt->dcs_module, 8);
                        	sendto (m_pnt->dcs_sd, &m_pnt->DCS_C, 100, 0, (struct sockaddr *)&m_pnt->dcs_addr, sizeof(m_pnt->dcs_addr));
                        	memcpy (m_pnt->DCS_C.rpt2, m_pnt->ModuleName, 8);
                	}
		}
        }
}

void	ref2icom (int n)
{

}

void	reflector (struct ModuleTable *pnt)
{
        int     n;
	int	err;
        socklen_t       from_len;
	char		temp[64];
	struct  addrinfo        hints, *res;
	time_t	atime;

	time (&atime);
	switch (pnt->ref_state)
	{
		case REF_OPEN:
			pnt->ref_state = REF_NG;
			if (pnt->ref_port == 0) break;
                       	sprintf (temp, "%6.6s.dstargateway.org", pnt->ref_module);
                        memset (&hints, 0x00, sizeof(hints));
                        hints.ai_socktype = SOCK_DGRAM;
                        hints.ai_family = AF_INET;
                       	if ((err = getaddrinfo (temp, NULL, &hints, &res)) != 0)
                        {
                             	fprintf (log_file, "%24.24s getaddrinfo error \"%8.8s\" (RFE:%s:%0d) %s\n",
                                               ctime(&atime), pnt->ref_module, temp, pnt->ref_port, gai_strerror(err));
                                pnt->ref_port = 0;
                                ref_cnt--;
                        }
                        else
			{
                          	if ((pnt->ref_sd = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
                               	{
                                        fprintf (log_file, "%24.24s REF UDP Socket not open. Already used this port:%d\n", ctime(&atime), trust_port);
                                        fflush (log_file);
                                        pnt->ref_port = 0;
                                        ref_cnt--;
                                 }
                                 else
                                 {
                                      	pnt->ref_addr.sin_addr.s_addr = ((struct sockaddr_in *)(res->ai_addr))->sin_addr.s_addr;
                                        pnt->ref_addr.sin_family = AF_INET;
                                        pnt->ref_addr.sin_port = htons(pnt->ref_port);
                                        fprintf (log_file, "%24.24s REF Port \"%8.8s\" (%s:%0d) open.\n", ctime(&atime), pnt->ref_module, temp, pnt->ref_port);
                                        FD_SET (pnt->ref_sd, &fd_save);
                                        if (pnt->ref_module[7] != 0x20) ref_connect (pnt);
					time (&pnt->ref_recv_time);
					pnt->ref_state = REF_LOOP;
                              	}
                               	freeaddrinfo (res);
                       	}
			break;

		case REF_LOOP:
			if (FD_ISSET (pnt->ref_sd, &read_set))
			{
        			from_len = sizeof(from);
        			memset(&from, 0, sizeof(from));
        			from.sin_family = AF_INET;
        			from.sin_port = htons(pnt->ref_port);
        			from.sin_addr.s_addr = htonl(INADDR_ANY);
        			n = recvfrom (pnt->ref_sd, &packet, 58,
                        	        0, (struct sockaddr *)&from, &from_len);
				if (n > 0) time (&pnt->ref_recv_time);
				if (n == 3)	// keep alive (heart beat)
				{
					if (!memcmp (&packet, Dplus_keep_alive, 3))
						sendto (pnt->ref_sd, &Dplus_keep_alive, 3, 0, (struct sockaddr *)&pnt->ref_addr, sizeof(pnt->ref_addr));
					break;
				}
				else if (n == 5)
				{
					if (!memcmp (&packet, &Dplus_connect, 5)) ref_verify_send(pnt);
					break;
				}
				else if ((n == 58)	// header
					|| (n == 29)	// voice
					|| (n == 32)	// last voice
					|| (n == 10))	// ptt_off
				{
					ref2dplus(n, pnt);
					ref2dcs(n, pnt);
					ref2icom(n);
				}
				else if (n == 8)	// verify resp
				{
					if (!memcmp (&packet, Dplus_verifyResp, 4))
					{
						fprintf (log_file, "%24.24s REF verified %8.8s %2.2s %2.2s\n", 
							ctime(&atime), pnt->ModuleName, packet.verifyResp.OK, packet.verifyResp.RW);
						fflush (log_file);
					}
					break;
				}
				else if (n == 10)	// ptt off
				{
				}
			}
                        if ((atime - pnt->ref_recv_time) > 10)
                        {
                                pnt->ref_state = REF_OPEN;
                                FD_CLR (pnt->ref_sd, &fd_save);
                                close (pnt->ref_sd);
				fprintf (log_file, "%24.24s %8.8s Disconnected\n", ctime(&atime), pnt->ref_module);
				fflush (log_file);
                        }
			break;

		case REF_NG:
			break;
	}
	
}

void	ref_verify_send(struct ModuleTable *pnt)
{
	unsigned char	verify_pkt[28];

	memcpy (verify_pkt, Dplus_verifyReq, 4);
	memcpy (&verify_pkt[4], pnt->ModuleName, 8);
	memset (&verify_pkt[12], 0x00, 8);
	memcpy (&verify_pkt[20], "DV019999", 8);
	sendto (pnt->ref_sd, verify_pkt, 28, 0, (struct sockaddr *)&pnt->ref_addr, sizeof(pnt->ref_addr));

}

void	ref_connect(struct ModuleTable *pnt)
{
	int	ret;

	ret = sendto (pnt->ref_sd, &Dplus_connect, 5, 0, (struct sockaddr *)&pnt->ref_addr, sizeof(pnt->ref_addr));
}

