#include	"dxchange.h"
#include	"monitor.h"

struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[], u_long ipaddr, u_short port);

extern	struct	sockaddr_in	in_sock;
extern	int	len_in_sock;
struct	sockaddr_in	rpt_addr;

int	rpt_sd;

struct	dstar_packet	d_packet;

void	dummy_repeater_read(void)
{
	int	length;

	len_in_sock= sizeof(in_sock);
	length = recvfrom(rpt_sd, &d_packet, sizeof(d_packet), 0, 
				(struct sockaddr *)&in_sock, &len_in_sock);
}

int	repeater(void)
{
	struct	ModuleTable	*m_pnt;
	int	length;
	int	send_length;
	int	data_length;
	time_t	atime;
	int	ret;
	struct	status		*sta_pnt;
	u_long	ip_temp;
	u_short	port_temp;
	int	frame_seq;
	struct	timeval		time_21ms;
	struct	timeval		cur_time;
	struct	timeval		time_temp;

	len_in_sock = sizeof (in_sock);
    	length = recvfrom(rpt_sd, &d_packet, sizeof(d_packet), 0, (struct sockaddr *)&in_sock, &len_in_sock);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s Repeater data Reciv. error\n", ctime(&atime));
        	return FALSE;			// end
    	}
	if (!memcmp(d_packet.id, "DSTR", 4) && (d_packet.sr == 0x73) 
		&& (d_packet.c == 0x12) && (d_packet.trunk.FrameType == 0x20) && ((d_packet.trunk.FrameSeq & 0x3f) < 21))		// check D-STAR packet (DSTR)
	{
		if (forward_pnt) forward (d_packet, length);

		if ((length == 58) || (length == 64))
		{
                        if (length == 58)
                        {
                                memcpy (&d_packet.body.header.ip, &in_sock.sin_addr.s_addr, 4);
                                memcpy (&d_packet.body.header.port, &in_sock.sin_port, 2);
                        }
			m_pnt = module_check(d_packet.body.header.rpt1);
			if (m_pnt->rpt_save_length) rep_send (m_pnt);
			memcpy (&m_pnt->rpt_save, &d_packet, 64);
			m_pnt->rpt_save_length = 64;
			m_pnt->FrameID[0] = d_packet.trunk.FrameID[0];
			m_pnt->FrameID[1] = d_packet.trunk.FrameID[1];
                        memcpy (&m_pnt->ipaddress, &d_packet.body.header.ip, 4);
                        memcpy (&m_pnt->port, &d_packet.body.header.port, 2);
			gettimeofday (&cur_time, NULL);
			time_21ms.tv_sec = 0;
			time_21ms.tv_usec = 21000;
			timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
			m_pnt->lost_cnt = 0;
		}

		else if ((length == 29)	|| (length == 35)) // voice packet ICOM
		{
			if (length == 29)
			{
				memcpy (&d_packet.body.voice.ip, &in_sock.sin_addr.s_addr, 4);
				memcpy (&d_packet.body.voice.port, &in_sock.sin_port, 2);
			}
			memcpy (&ip_temp, &d_packet.body.voice.ip, 4);
			memcpy (&port_temp, &d_packet.body.voice.port, 2);
			m_pnt = module_check_ex (d_packet.trunk.FrameID, ip_temp, port_temp);
			if (m_pnt)
			{
				if (m_pnt->rpt_save_length == 35)
				{
					if ((m_pnt->rpt_save.trunk.FrameSeq & 0x3f) == (d_packet.trunk.FrameSeq & 0x3f))
						memcpy (&m_pnt->rpt_save, &d_packet, 35);
					else
					{
					frame_seq = (m_pnt->rpt_save.trunk.FrameSeq & 0x3f) + 1;
					frame_seq %= 21;
					while (frame_seq != (d_packet.trunk.FrameSeq & 0x3f))
					{
						lost_packet_send (frame_seq, m_pnt, d_packet);
						frame_seq = (m_pnt->rpt_save.trunk.FrameSeq  & 0x3f) + 1;
						frame_seq %= 21;
					}
					}
					m_pnt->lost_frame_sw = 0;
				}
				rep_send (m_pnt);
				memcpy (&m_pnt->rpt_save, &d_packet, 35);
				m_pnt->rpt_save_length = 35;
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if ((length == 32)	|| (length == 38)) // Last Frame ICOM
		{
                        if (length == 32)
                        {
                                memcpy (&d_packet.body.last_voice.ip, &in_sock.sin_addr.s_addr, 4);
                                memcpy (&d_packet.body.last_voice.port, &in_sock.sin_port, 2);
                        }
			memcpy (&ip_temp, &d_packet.body.last_voice.ip, 4);
			memcpy (&port_temp, &d_packet.body.last_voice.port, 2);
			m_pnt = module_check_ex (d_packet.trunk.FrameID, ip_temp, port_temp); 
			if (m_pnt)
			{
				if (m_pnt->rpt_save_length == 35)
				{
					frame_seq = (m_pnt->rpt_save.trunk.FrameSeq & 0x3f) + 1;
					frame_seq %= 21;
					while (frame_seq != (d_packet.trunk.FrameSeq & 0x3f))
					{
						lost_packet_send (frame_seq, m_pnt, d_packet);
						frame_seq = (m_pnt->rpt_save.trunk.FrameSeq & 0x3f) + 1;
						frame_seq %= 21;
					}
					m_pnt->lost_frame_sw = 0;
				}
				rep_send (m_pnt);
                        	memcpy (&m_pnt->rpt_save, &d_packet, 38);
                        	m_pnt->rpt_save_length = 38;
				rep_send (m_pnt);
				m_pnt->rpt_save_length = 0;
				m_pnt->recv_time.tv_sec = 0;
				m_pnt->recv_time.tv_usec = 0;
			
			}
		}
	}
	return TRUE;
}

int	repeater_init(void)
{
	struct	ifreq	ifr;
	time_t	atime;

    	// IPv4 UDP socket
    	if((rpt_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
                time(&atime);
                fprintf (log_file, "%24.24s Repeater socket not open\n", ctime(&atime));
        	return FALSE;	
    	}

        // 待ち受けるIPとポート番号を設定
        rpt_addr.sin_family = AF_INET;
        rpt_addr.sin_port = htons(recv_port);
        rpt_addr.sin_addr.s_addr = INADDR_ANY;

	if (RECV_NIC[0] != 0x00)
	{
		ifr.ifr_addr.sa_family = AF_INET;
		strncpy (ifr.ifr_name, RECV_NIC, IFNAMSIZ-1);
		time (&atime);
		if (ioctl (rpt_sd, SIOCGIFADDR, &ifr) >= 0)
		{
			rpt_addr.sin_addr.s_addr = 
				((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
			fprintf (log_file, "%24.24s NIC (%s) Repeater Receive Port %d open.\n", 
					ctime(&atime), RECV_NIC, recv_port);
			
		}
		else
		{
			fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), RECV_NIC);
		}
		fflush (log_file);
	}	
	
	FD_SET (rpt_sd, &fd_save);

    	// Bind
    	if(bind(rpt_sd, (struct sockaddr *)&rpt_addr, sizeof(rpt_addr)) < 0) {
		time(&atime);
		fprintf (log_file, "%24.24s Repeater socket not bind %s\n", ctime(&atime), strerror(errno));
        	return FALSE;
    	}
	return TRUE;
}
