#include	"dxchange.h"


void	portSet(void)
{
	struct	addrinfo	hints;
	struct	forward		*fwd_pnt;
	struct	status		*sta_pnt;
	int	err;
	struct	STATUS_Login_frame	Login_Frm;
	char	PORT[10];
	struct	termios	termio;
	tcflag_t	baudrate = B9600;
	

	time_t	atime;

	int	yes = 1;


        // status
        if (status_pnt)
        {
		sta_pnt = status_pnt;
		time (&atime);
		while (sta_pnt)
		{
                       	memset (&hints, 0x00, sizeof(hints));
                       	hints.ai_socktype = SOCK_DGRAM;
			hints.ai_family = PF_UNSPEC;
			sprintf (PORT, "%d", sta_pnt->port);
                       	if ((err = getaddrinfo (sta_pnt->fqdn, PORT, &hints, &sta_pnt->status_info)) != 0)
                       	{
                               	fprintf (log_file, "%24.24s getaddrinfo error (Status:%s:%0d) %s\n", 
						ctime(&atime), sta_pnt->fqdn, sta_pnt->port, gai_strerror(err));
                               	sta_pnt->port = 0;
				if (sta_pnt->status_info != NULL) freeaddrinfo (sta_pnt->status_info); 
                       	}
			else
			{
				if ((sta_pnt->status_sd = socket (sta_pnt->status_info->ai_family, 
					sta_pnt->status_info->ai_socktype, sta_pnt->status_info->ai_protocol)) < 0 )
				{
					fprintf (log_file, "%24.24s STATUS UDP socket not open\n",ctime(&atime));
					sta_pnt->port = 0;
					if (sta_pnt->status_info != NULL) freeaddrinfo (sta_pnt->status_info);
				}
				else
				{
					fprintf (log_file, "%24.24s Status Port %s:%0d open.\n", 
						ctime(&atime), sta_pnt->fqdn, sta_pnt->port);
	                               	memcpy (Login_Frm.StatusID, "DSTRST", 6);
        	                       	memcpy (Login_Frm.Type, "00", 2);
                	               	#if __WORDSIZE == 64
                        	       	time (&Login_Frm.EntryUpdateTime);
                               		#else
   	                            	time (&Login_Frm.EntryUpdateTime);
        	                       	memset (&Login_Frm.dummy_t, 0x00, 4);
                	               	#endif
                        	       	// Convert local time to UTC
                               		Login_Frm.EntryUpdateTime += timezone;
					//memcpy (Login_Frm.UserID, sta_pnt->userID, 16);
					memset (Login_Frm.UserID, 0x20, 16);
					memcpy (Login_Frm.UserID, client_callsign, 8);
					memcpy (Login_Frm.Passwd, sta_pnt->passwd, 64);
					memset (Login_Frm.reserve, 0x00, 4);
                                      	err = sendto (sta_pnt->status_sd, &Login_Frm, 100, 0,
                                           	sta_pnt->status_info->ai_addr,
                                              	sta_pnt->status_info->ai_addrlen);
                                      	sta_pnt->packets++;
				}
                	}
			sta_pnt = sta_pnt->f_chain;
			fflush (log_file);
		}
        }

        // forward
        if (forward_pnt)
        {
		fwd_pnt = forward_pnt;
		time (&atime);
		while (fwd_pnt)
		{
			memset (&hints, 0x00, sizeof(hints));
			hints.ai_socktype = SOCK_DGRAM;
			hints.ai_family = PF_UNSPEC;
			sprintf (PORT, "%d", fwd_pnt->port);
			if ((err = getaddrinfo (fwd_pnt->fqdn, PORT, &hints, &fwd_pnt->fwd_info)) != 0)
			{
				fprintf (log_file, "%24.24s getaddrinfo error (Forward:%s:%0d) %s\n", 
					ctime(&atime), fwd_pnt->fqdn, fwd_pnt->port, gai_strerror(err));
				fwd_pnt->port = 0;
				if (fwd_pnt->fwd_info != NULL)  freeaddrinfo (fwd_pnt->fwd_info);
			}
			else
			{
                        	if((fwd_pnt->fwd_sd = socket(fwd_pnt->fwd_info->ai_family, 
					fwd_pnt->fwd_info->ai_socktype, fwd_pnt->fwd_info->ai_protocol)) < 0)
				{
                                	fprintf (log_file, "%24.24s Forward UDP socket not open (%s)\n",
                                                                ctime(&atime), fwd_pnt->fqdn);
                               		fwd_pnt->port = 0;
					if (fwd_pnt->fwd_info != NULL)  freeaddrinfo (fwd_pnt->fwd_info);
                        	}
				else
				{
					fprintf (log_file, "%24.24s Forward Port %s:%0d open.\n", 
						ctime(&atime), fwd_pnt->fqdn, fwd_pnt->port);
					FD_SET (fwd_pnt->fwd_sd, &fd_save);
				}
                	}
			fwd_pnt = fwd_pnt->f_chain;
			fflush (log_file);
		}
        }

	// httpd
        if (http_port > 0)
        {
		memset (&hints, 0x00, sizeof(hints));
		hints.ai_socktype = SOCK_STREAM;
		hints.ai_family = PF_UNSPEC;
		hints.ai_flags = AI_PASSIVE;
		sprintf (PORT, "%d", http_port);
		if ((err = getaddrinfo (NULL, PORT, &hints, &http_serv)) != 0)
		{
			fprintf (log_file, "%24.24s getaddrinfo error (http port:%d) %s\n",
				ctime(&atime), http_port, gai_strerror(err));
			http_port = 0;
			if (http_serv != NULL)  freeaddrinfo (http_serv);
			fflush (log_file);
		}
		else
		{
                	if ((http_sd = socket (http_serv->ai_family, http_serv->ai_socktype, http_serv->ai_protocol)) < 0)
			{
				time(&atime);
				fprintf (log_file, "%24.24s HTTP TCP Socket not open. Already used this port:%d\n", ctime(&atime), http_port);
				fflush (log_file);
				http_port = 0;
				if (http_serv != NULL)  freeaddrinfo (http_serv);
			}
			else
			{
                		if (setsockopt (http_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes)))
				{
					time(&atime);
					fprintf (log_file, "%24.24s error setsock opt on HTTP_PORT\n", ctime(&atime));
					fflush (log_file);
					http_port = 0;
					if (http_serv != NULL)  freeaddrinfo (http_serv);
					close (http_sd);
					http_sd = 0;
				}
				else
				{
                			if (bind (http_sd, http_serv->ai_addr, http_serv->ai_addrlen) != 0)
					{
						time (&atime);
						fprintf (log_file, "%24.24s error bind on HTTP_PORT %s\n", ctime(&atime), strerror(errno));
						fflush (log_file);
						http_port = 0;
					}
					else
					{
                				if (listen (http_sd, 5))
						{
							time (&atime);
							fprintf (log_file, "%24.24s error listen on HTTP_PORT %s\n", 
										ctime(&atime), strerror(errno));
							http_port = 0;
							if (http_serv != NULL)  freeaddrinfo (http_serv);
							fflush (log_file);
						}
						else
						{
							FD_SET (http_sd, &fd_save);
                                        		fprintf (log_file, "%24.24s HTTP Port %d open.\n", 
									ctime(&atime), http_port);
                                        		fflush (log_file);
						}
					}
				}

			}
		}
		if (http_port) gt = malloc (sizeof (struct tm));
        }
	
	// serial port
	if (SERIAL_PORT[0] != 0x00)
	{
		if ((serial_fd = open (SERIAL_PORT, O_RDWR | O_NOCTTY)) < 0)
		{
			fprintf (log_file, "%24.24s error on Serial port (%s) open. %s\n", ctime(&atime), SERIAL_PORT, strerror(errno));
			serial_fd = 0;
		}
		else
		{
			tcgetattr(serial_fd, &termio_save);
			/* Clear the struct for new port settings */ 
			/* 制御文字の初期化を行う */
			termio.c_iflag = 0;
			termio.c_oflag = 0;
			termio.c_cflag = 0;
			termio.c_lflag = 0;
			termio.c_line = 0;
			bzero(termio.c_cc,sizeof(termio.c_cc));

    			/* Settings for port
			if (baud == 1200) baudrate = B1200;
			else if (baud == 2400) baudrate = B2400;
			else if (baud == 4800) baudrate = B4800;
			else if (baud == 9600) baudrate = B9600;
			else if (baud == 19200) baudrate = B19200;
			else baudrate = B9600;
      			BAUDRATE : Set bps rate. You could also use cfsetispeed and cfsetospeed.
      			ボーレートの設定。cfsetispeed,cfsetospeedも使用できる
      			CRTSCTS  : Output hardware flow control ( only used if the cable has all
                  		necessary lines. See sect. 7 of Serial-HOWTO )
             			出力のハードウェアフロー制御(必要な結線が全てされているケースのみ)
      			CS8      : 8n1 ( 8bit,no parity,1 stopbit)
      			CLOCAL   : local connection,no modem control
      			CREAD    : enable receiving characters
                    	受信文字を有効にする
    			*/
    			termio.c_cflag = baudrate | CS8 | CLOCAL | CREAD ;

    			/* IGNPAR  : ignore bytes with parity errors */
    			/* (パリティエラーのデータは無視する )*/
    			/* ICRNL  : */
    			/* (CRをNLに対応させる。これを行わないと他のコンピュータでCRを入力しても
                 		入力が終わりにならない)*/

    			termio.c_oflag = 0;     /* Raw output (Rawモードでの出力)*/
    			termio.c_lflag = 0;     /* Set input mode (non-canonical,no echo,....) */
                        			/* ICANN :カノニカル入力を有効にする
                                 		全てのエコーを無効にし、プログラムに対し
                                 		シグナルは送らせない */
    			termio.c_cc[VTIME] = 0; /* inter-character timer 2 sec
                        		         (キャラクタタイマは使わない) */
    			termio.c_cc[VMIN] = 1;  /* read single char received
                        		         (1文字来るまで読み込みをブロックする */ 

    			/* Now clean the modem line and activate the settings for the port */
    			/* モデムラインをクリアする */
    			tcflush(serial_fd,TCIFLUSH);
    			/* 新しい設定を適用する */
    			tcsetattr(serial_fd,TCSANOW,&termio);

			fprintf (log_file, "%24.24s Serial port (device : %s  baud rate : %d) open.\n", ctime(&atime), SERIAL_PORT, baud);
			FD_SET (serial_fd , &fd_save);
		}
		fflush (log_file);

	}
	
}

