#include	"dxchange.h"

void    lock_send (struct dstar_packet *pkt);
struct  ModuleTable     *module_check (char call[]);


void	capture_init (void)
{
	time_t	atime;
	char	filter_exp[16];
	struct  ModuleTable     *module_next;

	if (cap_port == 0) return;


	strncpy (GW_CALLSIGN, client_callsign, 7);
	GW_CALLSIGN[7] = 'G';

	time(&atime);
	fprintf (log_file, "%24.24s GW_callsgin %8.8s\n", 
				ctime(&atime), GW_CALLSIGN);
	fflush (log_file);
 
	module_next = malloc (sizeof (struct ModuleTable));
	if (module_next != NULL)
	{
		module_init(module_next, GW_CALLSIGN, cap_port);
		if (module_pnt) module_last->f_chain = module_next;
		else module_pnt = module_next;
		module_last = module_next;
	}
	else
	{
		time(&atime);
		fprintf (log_file, "%24.24s Memoty not allocate Module table (%s)\n",
			ctime(&atime), GW_CALLSIGN);
		fflush (log_file);
	}

	cap_handler = pcap_open_live (ZR_NIC, 128, FALSE, 5, errbuff);
	if (cap_handler == NULL)
	{
		fprintf (log_file, "%24.24s %s pcap_open_live error %s\n", 
				ctime(&atime), ZR_NIC, errbuff);
	}
	else
	{
		fprintf (log_file, "%24.24s %s pcap_open_live open\n",
                                ctime(&atime), ZR_NIC);
	}
	fflush (log_file);

	sprintf (filter_exp, "udp port %d", cap_port);
	if (pcap_compile (cap_handler, &cap_fp, filter_exp, 0, 0) == -1)
	{
		fprintf (log_file, "%24.24s cap filter not compiled %s\n", 
				ctime(&atime), filter_exp);
	}
	else
	{
		fprintf (log_file, "%24.24s cap filter compiled %s\n",
                                ctime(&atime), filter_exp);
	}
	fflush (log_file);


	if (pcap_setfilter (cap_handler, &cap_fp) == -1)
	{
		fprintf (log_file, "%24.24s cap filer not setting %s\n", 
				ctime(&atime), filter_exp);
		fflush (log_file);
	}
	if (pcap_setnonblock (cap_handler, TRUE, errbuff))
	{
		fprintf (log_file, "%24.24s pcap_setnonblock error %s\n", ctime(&atime), errbuff);
		fflush (log_file);
	}
	else
	{
		time(&atime);
		fprintf (log_file, "%24.24s Capture port (%s) open.\n", ctime(&atime), filter_exp);
		fflush (log_file);
	}
	if ((pcap_fd = pcap_get_selectable_fd(cap_handler)) != -1)
	{
		FD_SET (pcap_fd, &fd_save);
	}
	else
	{
		fprintf (log_file, "%24.24s pcap_get_selectable_fd error", ctime(&atime));
		fflush (log_file);
		pcap_fd = 0;
	}
}

void	capture_read (void)
{
	int	res;
	time_t	atime;
	int	length;
	int	data_length;
	struct	dstar_packet	*pkt;
	struct	ModuleTable	*pnt;
	extern  unsigned char   lost_voice[];

	res = pcap_next_ex (cap_handler, &header,  &pkt_data);
	if (res == -1)
	{
		time(&atime);
		fprintf (log_file, "%24.24s pcap_next_ex error %s\n", 
				ctime(&atime), pcap_geterr(cap_handler));
		fflush (log_file);
		return;
	}
	/*	check from/to */
	//if (memcmp(&pkt_data[26], &rpt_mon_addr.sin_addr.s_addr, 4)) return;
	
	length = header->caplen - 42;
	pkt = (struct dstar_packet *)(pkt_data + 42);		// ip v4
	if (memcmp(pkt->id, "DSTR", 4)) return;

	pnt = module_check (GW_CALLSIGN);
	if (length == 58)
	{
		memcpy (&pnt->rpt_save, pkt, 58);
		pnt->aprs_msg_pnt = 0;
		pnt->FrameID[0] = pnt->rpt_save.trunk.FrameID[0];
		pnt->FrameID[1] = pnt->rpt_save.trunk.FrameID[1];
		pnt->RadioGpsStatus = FALSE;
		pnt->RadioGpsSkip = FALSE;
		pnt->packet_cnt++;
		pnt->RadioVoicePacketCnt = 1;
		pnt->HeaderCnt++;
		memcpy (&pnt->ipaddress, &pnt->rpt_save.body.header.ip, 4);
		memcpy (&pnt->port, &pnt->rpt_save.body.header.port, 2);
		memset (pnt->RadioMsg, 0x20, 20);
		memset (pnt->rptcall, 0x20, 8);
		memcpy (pnt->mycall, pnt->rpt_save.body.header.mycall, 8);
		memcpy (pnt->mycall_ex, pnt->rpt_save.body.header.mycall_ex, 4);
		memcpy (pnt->urcall, pnt->rpt_save.body.header.urcall, 8);
		time (&pnt->AccessTime);
		pnt->AprsSend = 0x00;
		pnt->RX_on = TRUE;
		memset (pnt->aprs_msg, 0x00, 256);
	}
	else if (length == 29) // voice packet ICOM
	{
		memcpy (&pnt->rpt_save, pkt, 29);
		pnt->RadioVoicePacketCnt++;
		pnt->packet_cnt++;
		if (pnt->rpt_save.trunk.FrameSeq != 0)		// exclude RF header
		{
			if (pnt->rpt_save.trunk.FrameSeq & 0x40)		// Last Frame
			{
        			pnt->aprs_msg_pnt = 0;
        			pnt->FrameID[0] = 0x00;
        			pnt->FrameID[1] = 0x00;
        			pnt->RadioGpsStatus = FALSE;
        			pnt->rpt_save_length = 0;
        			pnt->RX_on = FALSE;
				return;
			}
				 
			if ((pnt->rpt_save.trunk.FrameSeq & 0x3f) % 2)
			{
				pnt->mini_header 
					= pnt->rpt_save.body.voice.slowdata[0] ^ 0x70;
				pnt->data_temp[0] 
					= pnt->rpt_save.body.voice.slowdata[1] ^ 0x4f;
				pnt->data_temp[1] 
					= pnt->rpt_save.body.voice.slowdata[2] ^ 0x93;
			}
			else
			{
				pnt->data_temp[2] 
					= pnt->rpt_save.body.voice.slowdata[0] ^ 0x70;
				pnt->data_temp[3] 
					= pnt->rpt_save.body.voice.slowdata[1] ^ 0x4f;
				pnt->data_temp[4] 
					= pnt->rpt_save.body.voice.slowdata[2] ^ 0x93;
				switch (pnt->mini_header)
				{
					case 0x40:	// short message
						memcpy (&pnt->RadioMsg[0], &pnt->data_temp[0], 5);
						break;
					case 0x41:
						memcpy (&pnt->RadioMsg[5], &pnt->data_temp[0], 5);
						break;
					case 0x42:
						memcpy (&pnt->RadioMsg[10], &pnt->data_temp[0], 5);
						break;
					case 0x43:
						memcpy (&pnt->RadioMsg[15], &pnt->data_temp[0], 5);
						memcpy (&pnt->STATUS_Frm.body.status.ShortMessage,
									 &pnt->RadioMsg, 20);
						break;
					case 0x35:
						if (pnt->data_temp[0] == '$')
						{
							pnt->aprs_msg_pnt = 0;
							memset (pnt->aprs_msg, 0x00, 256);
						}
					case 0x31:	// slow data for GPS
					case 0x32:
					case 0x33:
					case 0x34:
						data_length = pnt->mini_header & 0x0f;
						memcpy (&pnt->aprs_msg[pnt->aprs_msg_pnt], 
								&pnt->data_temp[0], data_length);
						
						pnt->aprs_msg_pnt += data_length;
						if (pnt->aprs_msg[pnt->aprs_msg_pnt - 1] == 0x0d)
							pnt->aprs_msg[pnt->aprs_msg_pnt++] = 0x0a;
						if (pnt->aprs_msg[pnt->aprs_msg_pnt - 1] == 0x0a)
						{
							pnt->aprs_msg[pnt->aprs_msg_pnt] = 0x00;
							if (pnt->aprs_msg_pnt > 6)
							{
								if (!strncmp(pnt->aprs_msg, "$$CRC", 5))
								{
									gps_a (pnt->aprs_msg, pnt);
								}
								else if (!strncmp(pnt->aprs_msg, "$GP", 3))
								{
									gps (pnt->aprs_msg, pnt);
								}
								else if ((pnt->aprs_msg_pnt <= 31) 
									&& gps_call_check(pnt->aprs_msg)) 
								{
									gps (pnt->aprs_msg, pnt);
								}
							}
							pnt->aprs_msg_pnt = 0;
							memset (pnt->aprs_msg, 0x00, 256);
						}
						if (pnt->aprs_msg_pnt > 250)
							pnt->aprs_msg_pnt = 250;
						break;
				}
			}
			if (!memcmp (&pnt->rpt_save.body.voice.voice, lost_voice, 9))
			{
				pnt->aprs_msg_pnt = 0;
				memset (pnt->aprs_msg, 0x00, 256);
			}
		}
	}
	else if (length == 32) // Last Frame ICOM
	{
        	pnt->aprs_msg_pnt = 0;
        	pnt->FrameID[0] = 0x00;
        	pnt->FrameID[1] = 0x00;
        	pnt->RadioGpsStatus = FALSE;
        	pnt->rpt_save_length = 0;
        	pnt->RX_on = FALSE;
	}
}
