#include	"dxchange.h"

void		ReConnectSet(void);
void		BeaconSend(void);
void        	AprsUserPassSend (void);

enum
{
	DPRS_OPEN_AUTOLINK_START = 0,
	DPRS_OPEN_AUTOLINK_RESTART,
	DPRS_OPEN_AUTOLINK,
	DPRS_OPEN_DONE_AUTOLINK,
	DPRS_OPEN_AUTOLINK_WAIT,
	DPRS_ACCEPT,
	DPRS_LOOP,
	DPRS_NG
} DprsState = DPRS_OPEN_AUTOLINK_START;

time_t	AprsKeepAlive;
time_t	Timer;
time_t	AprsConnectTime;
time_t	AprsVerifyTime;

int     ReDprsConnectCnt = 0;
int     ReDprsConnectCount = 0;
int	aprs_status;

int	aprs (void)
{
	struct	addrinfo	hints;
	int			err;
	char	PORT[8];

	time_t	atime;
	int	len;
	char	*tp;

	switch (DprsState)
	{
		case DPRS_LOOP:
               		time(&atime);
               		if (atime >= AprsKeepAlive) ReConnectSet();
               		if (BeaconInterval && verify_sw)
               		{
                       		if (atime >= BeaconTime) BeaconSend();
               		}
               		if (FD_ISSET (aprs_sd, &read_set))      // from aprs server
               		{
                       		len = recvfrom (aprs_sd, DprsTemp, sizeof(DprsTemp),
                              			 0, NULL, NULL);
                       		if (len <= 0) 
				{
					ReConnectSet();
				}
                       		else
                       		{
                               		DprsTemp[len] = 0x00;
                                        if (debug_sw)
                                        {
                                                fprintf (log_file, "%24.24s %s", ctime(&atime), DprsTemp);
                                                fflush (log_file);
                                        }
                               		if (!memcmp (DprsTemp, "# logresp", 9))
                               		{
                                       		tp = strtok (DprsTemp, " \r\n\0");
						tp = strtok (NULL, " \r\n\0");
						tp = strtok (NULL, " \r\n\0");
						tp = strtok (NULL, " \r\n\0");		// "verified." or "unverified"
						verify_sw = FALSE;
						if (!memcmp(tp, "verified", 8)) verify_sw = TRUE;
						tp = strtok (NULL, " \r\n\0");		// "server"
						tp = strtok (NULL, " \r\n\0");		// server name
                                       		memcpy (aprs_server , tp, strlen(tp));
						time (&atime);
						if (verify_sw)
							fprintf (log_file, "%24.24s APRS Server (%s) Verified.\n", 
								ctime(&atime), aprs_server);
						else
							fprintf (log_file, "%24.24s APRS Server (%s) Unverified.\n", 
								ctime(&atime), aprs_server);
						fflush (log_file);
                               		}
                               		time(&AprsKeepAlive);
                               		AprsKeepAlive += 70;
                       		}
               		}
			break;

		case DPRS_NG:
			break;

		case DPRS_OPEN_AUTOLINK_WAIT:
			time (&atime);
			if ((atime - Timer) >= 5) 
			{
				if (RetryCnt > 0)
				{
                                	if (ReDprsConnectCnt++ > RetryCnt)
                                        {
                                                fprintf (log_file, "%24.24s APRS Server Down\n", ctime(&atime));
                                                fflush (log_file);
                                                return FALSE;
                                        }
					time (&Timer);
					break;
				}
				DprsState = DPRS_OPEN_AUTOLINK_RESTART;
			}
			break;

		case DPRS_OPEN_AUTOLINK_START:
			ReDprsConnectCnt = 0;

		case DPRS_OPEN_AUTOLINK_RESTART:
			DprsState = DPRS_OPEN_AUTOLINK;
			aprs_status = -1;
			memcpy (aprs_server, "NONE\0", 5);
			verify_sw = FALSE;
			break;

   		case DPRS_OPEN_AUTOLINK:
			if(aprs_status < 0)
			{
                        	memset (&hints, 0x00, sizeof(hints));
				hints.ai_socktype = SOCK_STREAM;
                        	hints.ai_family = AF_INET;
				sprintf (PORT, "%d", aprs_port);
                        	if ((err = getaddrinfo (aprs_name, PORT, &hints, &aprs_addr)) != 0)
                        	{
					time(&atime);
                                	fprintf (log_file, "%24.24s getaddrinfo error(APRS Server) %s\n", 
						ctime(&atime), gai_strerror(err));
					fprintf (log_file, "%24.24s APRS Server Name : %s\n", ctime(&atime), aprs_name);
                                	fflush (log_file);
					if ((err == EAI_AGAIN) || (err == EAI_NONAME))
					{
						if (RetryCnt > 0)
						{
							aprs_port = 0;
							return FALSE;
						}
						else
						{
							DprsState = DPRS_OPEN_AUTOLINK_WAIT;
							time(&Timer);
							break;
						}
					}
					else
					{
						aprs_port = 0;
						return FALSE;
					}
                        	}
				if((aprs_sd = socket(aprs_addr->ai_family, aprs_addr->ai_socktype, 0)) < 0)
				{
                                        time (&atime);
                                        fprintf (log_file, "%24.24s D-PRS TCP socket not open\n", ctime(&atime));
                                        fflush (log_file);
					if (aprs_addr != NULL) freeaddrinfo (aprs_addr);
                                        return FALSE;
                                }

				aprs_status = connect (aprs_sd, aprs_addr->ai_addr, aprs_addr->ai_addrlen);
				if (errno == ECONNREFUSED)
				{
                                        time (&atime);
                                        fprintf (log_file, "%24.24s connect error (APRS Server) %s\n",
                                                        ctime(&atime), strerror(errno));
                                        fflush (log_file);
					DprsState = DPRS_OPEN_AUTOLINK_WAIT;
					time (&Timer);
					close (aprs_sd);
					aprs_sd = 0;
					break;
				}
				if (aprs_status < 0)
				{
					time (&atime);
					fprintf (log_file, "%24.24s connect error (APRS Server) %s\n", 
							ctime(&atime), strerror(errno));
					fflush (log_file);
					time(&atime);
					if((atime - Timer) >= 3)	/* wait 3 seconds */
					{
						if (ReDprsConnectCnt++ > 5)
						{
							DprsState = DPRS_OPEN_AUTOLINK_START;
							aprs_status = -1;
							ReDprsConnectCnt = 0;
							close (aprs_sd);
							aprs_sd = 0;
							break;
						}
						time(&Timer);;
						break;
					}
					break;
				}
			}
			FD_SET (aprs_sd, &fd_save);
			DprsState = DPRS_OPEN_DONE_AUTOLINK;
			ReDprsConnectCnt = 0;
			time(&Timer);
			break;

   		case DPRS_OPEN_DONE_AUTOLINK:
               		if (FD_ISSET (aprs_sd, &read_set))
			{
				len = recvfrom (aprs_sd, DprsTemp, sizeof(DprsTemp), 0, NULL, NULL);
				if (len > 2)
				{
					if (!memcmp(DprsTemp, "# ", 2))
					{	
						DprsState = DPRS_ACCEPT;
						time(&AprsConnectTime);
					}
					break;
				}
			}
			time(&atime);
			if (RetryCnt > 0)
			{
				if ((atime - Timer) >= 5)	/* wait 5 seconds */
				{
					ReDprsConnectCnt++;
					if (ReDprsConnectCnt > RetryCnt)	// default 60   5 * 60 = 300 Sec.
					{
						fprintf (log_file, "%24.24s APRS Server Down\n", ctime(&atime));
						fflush (log_file);
						return FALSE;
					}
					time (&Timer);
				}
			}
			else
			{
				if ((atime - Timer) >= 70)
				{
					DprsState = DPRS_OPEN_AUTOLINK_START;
					FD_CLR (aprs_sd, &fd_save);
					close (aprs_sd);
					aprs_sd = 0;
					if (aprs_addr != NULL) freeaddrinfo (aprs_addr);
				}
			}
			break;

		case DPRS_ACCEPT:
			time (&atime);
			fprintf (log_file, "%24.24s APRS Server Connected\n", ctime(&atime));
			fflush (log_file);
			AprsUserPassSend();
			DprsState = DPRS_LOOP;
			ReDprsConnectCnt = 0;
			time(&AprsKeepAlive);
			AprsKeepAlive += 70;
			time(&AprsVerifyTime);
			AprsVerifyTime += 10;
			break;
      	}
	return TRUE;
}

void	ReConnectSet (void)
{
        time_t  atime;

	if (AutoReLink)
	{
        	DprsState = DPRS_OPEN_AUTOLINK_START;
	}
	else
	{
		DprsState = DPRS_NG;
	}
	FD_CLR (aprs_sd, &fd_save);
       	close (aprs_sd);
	aprs_sd = 0;
	freeaddrinfo (aprs_addr);
       	time(&atime);
       	fprintf (log_file, "%24.24s APRS Server (%s) Disconnected\n", ctime(&atime), aprs_server);
        fflush (log_file);
	memcpy (aprs_server, "NONE\0", 5);
	verify_sw = FALSE;
        aprs_status = -1;
}

void	aprs_link_start(void)
{
	time_t	atime;

	DprsState = DPRS_OPEN_AUTOLINK_START;
	if (aprs_sd)
	{
		FD_CLR (aprs_sd, &fd_save);
        	close (aprs_sd);
		aprs_sd = 0;
	}
        time(&atime);
	fprintf (log_file, "%24.24s APRS Server (%s) Disconnected\n", ctime(&atime), aprs_server);
        fprintf (log_file, "%24.24s APRS Server ReConnect Start\n", ctime(&atime));
        fflush (log_file);
        aprs_status = -1;
}
