/*
	Interface for ID-RP2C

*/


#define	Max_Send_Check	200
//#define	DPRS_PORT	14580
//#define       DPRS_SERVER     "d-prs.d-star.info"
#define	RECV_PORT	21000
#define	CAP_PORT	20000
#define	SEND_INTERVAL	59
#define	Beacon_Interval	0
#define	Latitude_Default	356735;		// TOKYO
#define	Longitude_Default	1397455;	// TOKYO
#define	RETRY_COUNT	60
#define	CONFIG_FILE	"/opt/dxchange/etc/dxchange.conf"
#define	CSS_FILE	"/opt/dxchange/web/dxchange.css"
#define LOGO_FILE	"/opt/dxchange/web/logo.png"
#define	JS_FILE		"/opt/dxchange/web/dxchange.js"
#define LOG_FILE	"/var/log/dxchange.log"
#define	PID_FILE	"/var/run/dxchange.pid"

#define	TRUE		1
#define	FALSE		0
#define INVALID		2

#define	APRS_SEND	0x01
#define	APRS_SHORT	0x02
#define	APRS_SKIP	0x03
#define	ARPS_AUTO	0x04
#define	APRS_NG		0x05
#define	APRS_INVALID	0x06
#define	APRS_ERROR	0x07

#include	<stdint.h>
#include	<string.h>
#include	<ctype.h>
#include	<time.h>
#include	<sys/time.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/socket.h>
#include 	<sys/types.h>
#include 	<netinet/in.h>
#include 	<netdb.h>
#include	<signal.h>
#include	<sys/ioctl.h>
#include	<sys/stat.h>
#include	<net/if.h>
#include	<errno.h>
#include	<sys/utsname.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<termios.h>
#include	<pcap.h>
#include	"dstar.h"
#include	"packet.h"


struct	ModuleTable
{
	struct	ModuleTable	*f_chain;
	struct	timeval	recv_time;
	unsigned char	ModuleName[8];
	in_addr_t	ipaddress;
	time_t		AccessTime;
	in_port_t	port;
	int		SendSeq;
	int		packet_cnt;
	int		aprs_msg_pnt;
	int		RadioVoicePacketCnt;
	int		HeaderCnt;
	int		rpt_save_length;
	int		lost_cnt;
	unsigned char	RadioLat[8];
	unsigned char	RadioLong[9];
	unsigned char	RadioCall[8];
	unsigned char	RadioMsg[20];
	unsigned char	RadioAtitude[6];
	unsigned char	RadioSpeed[3];
	unsigned char	RadioDirection[3];
	unsigned char	RadioTime[7];
	unsigned char	RadioGpsStatus;
	unsigned char	RadioGpsSkip;
	unsigned char   FrameID[2];
	unsigned char   mini_header;
	unsigned char   data_temp[5];
	char   		aprs_msg[256];
	char		aprs_msg_save[256];
	unsigned char	mycall[8];
	unsigned char	mycall_ex[4];
	unsigned char	urcall[8];
	unsigned char	rptcall[8];
	unsigned char	AprsSend;
	unsigned char	RX_on;
	unsigned char	lost_frame_sw;
	struct	dstar_packet	rpt_save;
	struct	STATUS_frame	STATUS_Frm;
	struct	STATUS_frame	STATUS_Save;
};


struct	connected_table {
	struct connected_table *f_chain;
	in_addr_t		ip_address;
	int		port;
	int		protocol;
	struct		timeval	send_time;
	time_t		connect_time;
	time_t		access_time;
	unsigned char	callsign[8];
	unsigned char	mycall[8];
	unsigned char	mycall_ex[4];
	unsigned char	module[8];
	unsigned char	FrameID[2];
	unsigned char	ex_FrameID[2];
	unsigned char	dp_FrameID[2];
	int		alive;
	int		sd;
	int		FrameCounter;
	unsigned char	ptt;
};

struct STATUS_Login_frame
{
        unsigned char   StatusID[6];    /* "DSTRST" */
        unsigned char   Type[2];	/* 00 */
#if __WORDSIZE == 64
        time_t          EntryUpdateTime;
#else
        time_t          EntryUpdateTime;
        time_t          dummy_t;
#endif
	unsigned char	UserID[16];
	unsigned char	Passwd[64];
        unsigned char   reserve[4];
};

unsigned char	GpsMsg[20];

struct	
{
	unsigned	char	CallSign[10];
	time_t			SendTime;
}	SendCheck[Max_Send_Check];

int		send_interval;
int		AutoReLink;
int		RetryCnt;
int		beacon;
char		aprs_name[128];
char		aprs_ip[NI_MAXHOST];
int		aprs_port;
int		aprs_submit;
int		mon_port;
int		zr_port;
int		gw_port;
int		cap_port;
int		serial_fd;
int		pcap_fd;
int		baud;
unsigned char	client_callsign[7];
unsigned char	radio_id;
char	beacon_comment[64];
int		BeaconLat;
int		BeaconLong;
int		BeaconInterval;
int		aprs_sd;
long int	aprs_cnt;
time_t		status_keep_alive;

struct	addrinfo	*aprs_addr;
time_t		BeaconTime;
char		DprsTemp[256];

int	reload;
int	debug_sw;
int	gps_only_skip;
int	gps_skip_bits;
int	sig_term;

FILE	*log_file;
FILE	*pid_file;

/* Monitor & Forward definition */

struct	forward
{
	struct		forward	*f_chain;
	char		fqdn[128];
	int		port;
	int		fwd_sd;
	struct	addrinfo	*fwd_info;
	long int	packets;
};

struct	status
{
	struct	status		*f_chain;
	char			fqdn[128];
	unsigned char		userID[16];
	unsigned char		passwd[64];
	in_port_t		port;
	int			status_sd;
	struct	addrinfo	*status_info;
	long int		packets;
};

struct	forward		*forward_pnt, *forward_last;
struct	status		*status_pnt, *status_last;
char   	aprs_server[16];


fd_set          read_set;
fd_set		fd_save;


/* http port */
int	http_port;
int	http_sd;
struct	sockaddr_storage	http_recv;
struct	addrinfo	*http_serv;

struct  ModuleTable     *module_pnt, *module_last;

unsigned char   dtmf_c, dtmf_c_save;
unsigned char	dtmf_c_save1, dtmf_c_save2;
int             dtmf_pos;
unsigned char   dtmf[10];

char	ZR_NIC[8];
char	GW_NIC[8];
char	SERIAL_PORT[16];
char	GW_CALLSIGN[8];

struct  sockaddr_in     rpt_mon_addr;

int	verify_sw;

struct	tm	*gt;

struct utsname      uname_buf;

struct	termios	termio_save;

/* pcap */
pcap_t  *cap_handler;
char    pcap_buff[128];
char    errbuff[PCAP_ERRBUF_SIZE];
struct  bpf_program     cap_fp;
struct  pcap_pkthdr     *header;
const   u_char          *pkt_data;

