#include	"dxchange.h"

struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[], in_addr_t ipaddr, in_addr_t port);

extern	struct	addrinfo	*rpt_gw_addr;
extern	int	rpt_gw_sd;

void	forward_recv (struct forward	*fwd_pnt)
{
	socklen_t	from_len;
	int		sock;
	int		n;
	struct	forward	*pnt;
	struct sockaddr_storage from;

	sock = fwd_pnt->fwd_sd;
	from_len = sizeof (struct sockaddr_storage);

	n = recvfrom (sock, (char *)&packet, sizeof(packet),
			0, (struct sockaddr *)&from, &from_len);

	if (zr_port)
	{
		sendto (rpt_gw_sd, &packet, from_len, 0,
			(struct sockaddr *)&rpt_gw_addr, sizeof(rpt_gw_addr));
	}
 
	pnt = forward_pnt;
	while (pnt)
	{
		if (pnt != fwd_pnt)
		{
			sendto (pnt->fwd_sd, &packet, from_len, 0, 
				pnt->fwd_info->ai_addr, pnt->fwd_info->ai_addrlen);
		}
		pnt = pnt->f_chain;
	}
	
}

void	forward (struct dstar_packet ds_pkt, int length)
{
	time_t	atime;
	int	ret;
	struct	forward		*fwd_pnt;

	fwd_pnt = forward_pnt;
	while (fwd_pnt)
	{
		if (fwd_pnt->port)
		{
			ret = sendto (fwd_pnt->fwd_sd, &ds_pkt, length, 0,
					fwd_pnt->fwd_info->ai_addr, fwd_pnt->fwd_info->ai_addrlen);
			if (ret < 0)
			{
				time (&atime);
				fprintf (log_file, "%24.24s forward send error %s\n", ctime(&atime), strerror(errno));
				fflush (log_file);
				FD_CLR (fwd_pnt->fwd_sd, &fd_save);
				close (fwd_pnt->fwd_sd);
				fwd_pnt->fwd_sd = 0;
				fwd_pnt->port = 0;
			}
			else
				fwd_pnt->packets++;
		}
		fwd_pnt = fwd_pnt->f_chain;
	}
}
