#include "dxchange.h"

void	send_check_reset (char call_sign[])
{
	int	i;
	time_t	atime;

	for (i = 0 ; i < Max_Send_Check ; i ++)
	{
		if (!memcmp (call_sign, SendCheck[i].CallSign, 10))
		{
			SendCheck[i].SendTime -= send_interval;
			break;
		}
	}

	time (&atime);
        for (i = 0 ; i < Max_Send_Check ; i++)
        {
                if (atime >= SendCheck[i].SendTime)
                                SendCheck[i].CallSign[0] = 0x00;
        }
}
			
int	send_check(char	call_sign[])
{
	time_t	atime;
	int	i;

	time(&atime);

	for (i = 0 ; i < Max_Send_Check ; i++)
	{
		if (!memcmp (call_sign, SendCheck[i].CallSign, 10))
		{
			if (atime >= SendCheck[i].SendTime)
			{
				time(&SendCheck[i].SendTime);
				SendCheck[i].SendTime += send_interval;
				return TRUE;
			}
			else
			{
				fprintf (log_file, "%24.24s Short interval %10.10s (Remaining %ld Sec.)\n", 
						ctime(&atime), call_sign, SendCheck[i].SendTime - atime);
				fflush (log_file);
				return FALSE;
			}
		}
	}
	

	for (i = 0 ; i < Max_Send_Check ; i++)
	{
		if (atime >= SendCheck[i].SendTime)
				SendCheck[i].CallSign[0] = 0x00;
	}
	
	for (i = 0 ; i < Max_Send_Check ; i++)
	{
		if (SendCheck[i].CallSign[0] == 0x00)
		{
			memcpy (SendCheck[i].CallSign, call_sign, 10);
			time (&SendCheck[i].SendTime);
			SendCheck[i].SendTime += send_interval;
			return TRUE;
		}
	}
	fprintf (log_file, "ERROR: Table over flow\n");
	fflush (log_file);
	return FALSE;
}


void	send_check_init(void)
{
	int	i;
	for (i = 0 ; i < Max_Send_Check ; i++)
	{
		SendCheck[i].CallSign[0] = 0x00;
	}
}	
