#include	"init.h"
#include	"dxchange.h"
#include	"config.h"

void	pselectSet(void);
void	portSet(void);
int     aprs (void);
void    send_check_init(void);
void    lost_frame(void);
void    httpd_srv_recv(int sock);
void	httpd_srv_accept(void);
void    forward_recv (struct forward *fwd_pnt);
void    repeater_gw(void);
int     repeater_zr(void);
int	repeater_mon(void);
int     repeater_init(void);
int     read_config(int argc, char **argv);
int     handler_init(void);
void	serial_read(void);

struct	ModuleTable	*module_check (char call[]);
struct	ModuleTable	*module_check_ex (char FrameID[], in_addr_t ipaddr, in_port_t port);

extern	void	handler(int sig);

extern	int		rpt_zr_sd;
extern	int		rpt_gw_sd;
extern	int		rpt_mon_sd;
sigset_t        	sigset;
sigset_t		save_sig;
struct  timespec        timeout;
time_t			start_time;


struct	sockaddr_in	in_sock;
socklen_t		len_in_sock;

#define CRCPOLY2 0xEDB88320

unsigned int crc32(int n, unsigned char c[])
{
	int i, j;
	unsigned int r;

	r = 0xFFFFFFFFUL;
	for (i = 0; i < n; i++) {
		r ^= c[i];
		for (j = 0; j < 8 ; j++)
			if (r & 1) r = (r >> 1) ^ CRCPOLY2;
			else       r >>= 1;
	}
	return r ^ 0xFFFFFFFF;
}


int main(int argc, char** argv)
{

	int	i;
	int	ret;
	int	status_start;
	unsigned int	hash;

	struct	forward	*fwd_pnt;
	struct	status	*sta_pnt;

	time_t	atime;
	time_t	uptime;

	tzset();
	daemon (0, 0);

        uname(&uname_buf);

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}
	time (&start_time);

	fprintf (log_file, "%24.24s D-STAR X-change (dxchange) RP2C with D-PRS V%5.5s (%s  %s) Start\n", 
						ctime(&start_time), PACKAGE_VERSION, __DATE__, __TIME__);
	if (debug_sw)	fprintf (log_file, "                         %s %s %s\n",
						uname_buf.sysname, uname_buf.release, uname_buf.version);
	fflush (log_file);

	pid_file = fopen(PID_FILE, "w");
	if (pid_file == NULL)
	{
		fprintf (log_file, "%24.24s Already running dxchange.\n", ctime(&atime));
		fclose (log_file);
		return -1;
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file); 

	/* default value */
	send_interval = SEND_INTERVAL;
	aprs_port = 0;
	aprs_udp = 0;
	memset (aprs_name, 0x20, 128);
	mon_port = RECV_PORT;
	AutoReLink = 1;
	RetryCnt = RETRY_COUNT;
	BeaconLat = Latitude_Default; 
	BeaconLong = Longitude_Default;
	BeaconInterval = Beacon_Interval;
	time(&BeaconTime);
	reload = FALSE;
	sig_term = FALSE;
	gps_only_skip = FALSE;
	gps_skip_bits = 2;
	debug_sw = FALSE;
	aprs_cnt = 0;

	module_pnt = NULL;

	forward_pnt = NULL;
	status_pnt = NULL;
	verify_sw = FALSE;

	http_port = 0;
	zr_port = 0;
	mon_port = 0;
	gw_port = 0;
	serial_fd = 0;
	baud	= 0;
	time (&status_keep_alive);

	memset (aprs_server, 0x00, 16);
	memset (ZR_NIC, 0x00, 8);
	memset (GW_NIC, 0x00, 8);
	memset (SERIAL_PORT, 0x00, 16);
	send_check_init();

	http_sd = 0;

	if (!handler_init()) goto end;

	if (!read_config (argc, (char **)argv)) goto end;

	srand (crc32(8, client_callsign));
	status_start = rand() % 300;
	
	time (&atime);
	if (debug_sw)
	{
		fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
		fflush (log_file);
	}

	pselectSet();	// FD & sig init

	if (!repeater_init()) goto end;

	portSet();

	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL, 
				(fd_set *)NULL, &timeout, &sigset);
		time (&atime);
		if (ret < 0) 
		{
                	fprintf (log_file, "%24.24s pselect error %s\n", ctime(&atime), strerror(errno));
                	fflush (log_file);
			break;
		}
		else if (ret > 0)
		{
                	if (FD_ISSET (rpt_mon_sd, &read_set))
                	{
                        	if (!repeater_mon()) break;
                	}
			
			if (FD_ISSET (rpt_gw_sd, &read_set))
			{
				repeater_gw();
			}

			if (FD_ISSET (rpt_zr_sd, &read_set))
			{
				repeater_zr();
			}

			fwd_pnt = forward_pnt;
			while (fwd_pnt)
			{
				if ((fwd_pnt->fwd_sd > 0) && FD_ISSET(fwd_pnt->fwd_sd, &read_set))
								forward_recv (fwd_pnt);
				fwd_pnt = fwd_pnt->f_chain;
			}

			if (FD_ISSET (serial_fd, &read_set)) serial_read();

			if (FD_ISSET (http_sd, &read_set)) httpd_srv_accept();

			if (http_port)
			{
				for (i = 0 ; i < FD_SETSIZE ; i++)
				{
					if (FD_ISSET (i, &read_set))
					{
						if ((i == aprs_sd) 
							|| (i == rpt_mon_sd)
							|| (i == rpt_gw_sd)
							|| (i == rpt_zr_sd)
							|| (i == serial_fd)
							|| (i == http_sd)) goto skip; 
						fwd_pnt = forward_pnt;
						while (fwd_pnt)
						{
							if (i == fwd_pnt->fwd_sd) goto skip;
							fwd_pnt = fwd_pnt->f_chain;
						}
						httpd_srv_recv(i);
					}
					skip:	continue;					
				}
			}
		}
		else
		{
			lost_frame();
		}

		if ((status_pnt != NULL) && ((atime - status_keep_alive) >= status_start))
		{
							status_keep_alive_send();
							status_start = 300;
		}
		if (!aprs()) break;
		if (sig_term) break;
	
	}

	// socket close
	if (rpt_mon_sd) close (rpt_mon_sd);
	if (rpt_gw_sd) close (rpt_gw_sd);
	if (rpt_zr_sd) close (rpt_zr_sd);
	if (aprs_sd) close (aprs_sd);
	if (serial_fd)
	{
		tcsetattr(serial_fd, TCSANOW, &termio_save);
		tcflush (serial_fd, TCIOFLUSH);
		close (serial_fd);
	}
end:
	if (status_pnt) status_logoff_send();
	time(&atime);
	uptime = atime - start_time;
	fprintf (log_file, "%24.24s D-STAR X-change (dxchange) ID-RP2C Interface terminated (Up : %ldd%2ldh%2ldm%2lds)\n\n",
			ctime(&atime), 
			(uptime / 86400),
			((uptime % 86400) / 3600),
			(((uptime % 86400) % 3600) / 60),
			(((uptime % 86400) % 3600) % 60));
	fclose (log_file);
	if (forward_pnt)
	{
		fwd_pnt = forward_pnt;
		while (fwd_pnt)
		{
		 	close (fwd_pnt->fwd_sd);
			fwd_pnt = fwd_pnt->f_chain;
		}
	}
	if (http_port > 0) close (http_sd);
	remove (PID_FILE);
    	return 0;
}

void	pselectSet(void)
{
	FD_ZERO (&fd_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}

struct ModuleTable *module_check (char call[])
{

	struct ModuleTable *pnt;

	pnt = module_pnt;

	while (pnt)
	{
		if (!memcmp (call, pnt->ModuleName, 8)) return pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}


struct 	ModuleTable *module_check_ex (char FrameID[], in_addr_t ip_addr, in_port_t port)
{
	struct ModuleTable *pnt;

	pnt = module_pnt;
	while (pnt)
	{
		if ((ip_addr == pnt->ipaddress) && (port == pnt->port))
		{
			if (!memcmp (FrameID, pnt->FrameID, 2)) return  pnt;
		}
		pnt = pnt->f_chain;
	}
	return NULL;
}

