#include	"dxchange.h"

struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[], in_addr_t ipaddr, in_addr_t port);

extern	struct	sockaddr_in	rpt_gw_addr;
extern	int	rpt_gw_sd;

void	forward_recv (struct forward	*fwd_pnt)
{
	struct	sockaddr_in from;
	socklen_t	from_len;
	int		sock;
	int		n;
	struct	forward	*pnt;

	sock = fwd_pnt->fwd_sd;
	from_len = sizeof (from);
	memset (&from, 0x00, sizeof(from));
	from.sin_family = AF_INET;
	from.sin_port = htons (fwd_pnt->port);
	from.sin_addr.s_addr = htonl (INADDR_ANY);
	
	n = recvfrom (sock, (char *)&packet, sizeof(packet),
			0, (struct sockaddr *)&from, &from_len);

	if (send_port)
	{
		sendto (rpt_gw_sd, &packet, from_len, 0,
			(struct sockaddr *)&rpt_gw_addr, sizeof(rpt_gw_addr));
	}
 
	pnt = forward_pnt;
	while (pnt)
	{
		if (pnt != fwd_pnt)
		{
			sendto (pnt->fwd_sd, &packet, from_len, 0, 
				(struct sockaddr *)&pnt->fwd_addr, sizeof(pnt->fwd_addr));
		}
		pnt = pnt->f_chain;
	}
	
}

void	forward (struct dstar_packet ds_pkt, int length)
{
	time_t	atime;
	int	ret;
	struct	forward		*fwd_pnt;

	fwd_pnt = forward_pnt;
	while (fwd_pnt)
	{
		if (fwd_pnt->port)
		{
			ret = sendto (fwd_pnt->fwd_sd, &ds_pkt, length, 0,
					(struct sockaddr *)&fwd_pnt->fwd_addr, sizeof(fwd_pnt->fwd_addr));
			if (ret < 0)
			{
				time (&atime);
				fprintf (log_file, "%24.24s forward send error %s\n", ctime(&atime), strerror(errno));
				fflush (log_file);
				close (fwd_pnt->fwd_sd);
				fwd_pnt->port = 0;
			}
			else
				fwd_pnt->packets++;
		}
		fwd_pnt = fwd_pnt->f_chain;
	}
}
