#include	"dxchange.h"

void    gps (char msg[], struct ModuleTable *id);
void	gps_a (char msg[], struct ModuleTable *id);

struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[], in_addr_t ipaddr, in_port_t port);

extern	struct	sockaddr_in	in_sock;
extern	int	len_in_sock;
struct	sockaddr_in	rpt_addr;
extern	unsigned char	lost_voice[];

int	rpt_sd;

void	last_frame_send (struct ModuleTable *pnt)
{
	struct	status	*sta_pnt;

	pnt->aprs_msg_pnt = 0;
        pnt->FrameID[0] = 0x00;
        pnt->FrameID[1] = 0x00;
        pnt->RadioGpsStatus = FALSE;
        pnt->rpt_save_length = 0;
        pnt->RX_on = FALSE;

	if (status_pnt)
        {
        	memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
                memcpy (&pnt->STATUS_Frm.Type, "06", 2);
                memset (&pnt->STATUS_Frm.ip_address, 0x00, 16);
		#if __WORDSIZE == 64
                time (&pnt->STATUS_Frm.EntryUpdateTime);
                #else
		time (&pnt->STATUS_Frm.EntryUpdateTime);
                memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
                #endif
		// Convert local time to UTC
		pnt->STATUS_Frm.EntryUpdateTime += timezone;
                sta_pnt = status_pnt;
                while (sta_pnt)
                {
                	 sendto (sta_pnt->status_sd, &pnt->STATUS_Frm, 100, 0,
                       		(struct sockaddr *)&sta_pnt->status_addr,
                                           sizeof(sta_pnt->status_addr));
                         sta_pnt->packets++;
                        sta_pnt = sta_pnt->f_chain;
                }
                memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
	}
}

int	gps_call_check (char call[])
{
	int	n;

	for (n = 0 ; n < 8 ; n++)
	{
		if (((call[n]  >= 'A') && (call[n] <= 'Z')) || ((call[n] >= '0') && (call[n] <= '9')) || (call[n] == ' ')) continue;
		else return 0;
	}
	return 1;
}
 

void	rep_send (struct ModuleTable *pnt)
{
	struct  status          *sta_pnt;
	int			data_length;
	extern	long int	timezone;

	if (pnt->rpt_save_length == 58)	// header packet ICOM
	{
		pnt->aprs_msg_pnt = 0;
		pnt->FrameID[0] = pnt->rpt_save.trunk.FrameID[0];
		pnt->FrameID[1] = pnt->rpt_save.trunk.FrameID[1];
		pnt->RadioGpsStatus = FALSE;
		pnt->RadioGpsSkip = FALSE;
		pnt->packet_cnt++;
		pnt->RadioVoicePacketCnt = 1;
		pnt->HeaderCnt++;
		memcpy (&pnt->ipaddress, &pnt->rpt_save.body.header.ip, 4);
		memcpy (&pnt->port, &pnt->rpt_save.body.header.port, 2);
		memset (pnt->RadioMsg, 0x20, 20);
		memset (pnt->rptcall, 0x20, 8);
		memcpy (pnt->mycall, pnt->rpt_save.body.header.mycall, 8);
		memcpy (pnt->mycall_ex, pnt->rpt_save.body.header.mycall_ex, 4);
		memcpy (pnt->urcall, pnt->rpt_save.body.header.urcall, 8);
		time (&pnt->AccessTime);
		pnt->AprsSend = 0x00;
		pnt->RX_on = TRUE;
		memset (pnt->aprs_msg, 0x00, 256);
		if (status_pnt)
		{
			sta_pnt = status_pnt;
			memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
			memcpy (&pnt->STATUS_Frm.Type, "05", 2);
			memcpy (&pnt->STATUS_Frm.RPT2Call,  &pnt->rpt_save.body.header.rpt2, 36);
			memset (&pnt->STATUS_Frm.ip_address, 0x00, 16);
                        #if __WORDSIZE == 64
                        time (&pnt->STATUS_Frm.EntryUpdateTime);
                        #else
                        time (&pnt->STATUS_Frm.EntryUpdateTime);
                        memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
                        #endif
			pnt->STATUS_Frm.EntryUpdateTime += timezone;
			memset (&pnt->STATUS_Frm.ShortMessage, 0x20, 20);
			//memset (&pnt->STATUS_Frm.Latitude, 0x00, 16);
			pnt->STATUS_Frm.Latitude = 3600000;
			pnt->STATUS_Frm.Longitude = 3600000;
			memset (&pnt->STATUS_Save, 0x00, 100);
			pnt->STATUS_Frm.port = 0;
			while (sta_pnt)
			{
				sendto (sta_pnt->status_sd, &pnt->STATUS_Frm, 100, 0, 
					(struct sockaddr *)&sta_pnt->status_addr, sizeof(sta_pnt->status_addr));
				sta_pnt->packets++;
				sta_pnt = sta_pnt->f_chain;
			}
			memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
		}
	}
	else if (pnt->rpt_save_length == 29) // voice packet ICOM
	{
		pnt->RadioVoicePacketCnt++;
		pnt->packet_cnt++;
		if (pnt->rpt_save.trunk.FrameSeq != 0)		// exclude RF header
		{
			if (pnt->rpt_save.trunk.FrameSeq & 0x40)		// Last Frame
			{
				last_frame_send (pnt);
				return;
			}
				 
			if ((pnt->rpt_save.trunk.FrameSeq & 0x3f) % 2)
			{
				pnt->mini_header 
					= pnt->rpt_save.body.voice.slowdata[0] ^ 0x70;
				pnt->data_temp[0] 
					= pnt->rpt_save.body.voice.slowdata[1] ^ 0x4f;
				pnt->data_temp[1] 
					= pnt->rpt_save.body.voice.slowdata[2] ^ 0x93;
			}
			else
			{
				pnt->data_temp[2] 
					= pnt->rpt_save.body.voice.slowdata[0] ^ 0x70;
				pnt->data_temp[3] 
					= pnt->rpt_save.body.voice.slowdata[1] ^ 0x4f;
				pnt->data_temp[4] 
					= pnt->rpt_save.body.voice.slowdata[2] ^ 0x93;
				switch (pnt->mini_header)
				{
					case 0x40:	// short message
						memcpy (&pnt->RadioMsg[0], &pnt->data_temp[0], 5);
						break;
					case 0x41:
						memcpy (&pnt->RadioMsg[5], &pnt->data_temp[0], 5);
						break;
					case 0x42:
						memcpy (&pnt->RadioMsg[10], &pnt->data_temp[0], 5);
						break;
					case 0x43:
						memcpy (&pnt->RadioMsg[15], &pnt->data_temp[0], 5);
						memcpy (&pnt->STATUS_Frm.ShortMessage[0], &pnt->RadioMsg[0], 20);
						break;
					case 0x35:
						if (pnt->data_temp[0] == '$')
						{
							pnt->aprs_msg_pnt = 0;
							memset (pnt->aprs_msg, 0x00, 256);
						}
					case 0x31:	// slow data for GPS
					case 0x32:
					case 0x33:
					case 0x34:
						data_length = pnt->mini_header & 0x0f;
						memcpy (&pnt->aprs_msg[pnt->aprs_msg_pnt], 
								&pnt->data_temp[0], data_length);
						
						pnt->aprs_msg_pnt += data_length;
						if (pnt->aprs_msg[pnt->aprs_msg_pnt - 1] == 0x0d)
							pnt->aprs_msg[pnt->aprs_msg_pnt++] = 0x0a;
						if (pnt->aprs_msg[pnt->aprs_msg_pnt - 1] == 0x0a)
						{
							pnt->aprs_msg[pnt->aprs_msg_pnt] = 0x00;
							if (pnt->aprs_msg_pnt > 6)
							{
								if (!strncmp(pnt->aprs_msg, "$$CRC", 5))
								{
									gps_a (pnt->aprs_msg, pnt);
								}
								else if (!strncmp(pnt->aprs_msg, "$GP", 3))
								{
									gps (pnt->aprs_msg, pnt);
								}
								else if ((pnt->aprs_msg_pnt <= 31) 
									&& gps_call_check(pnt->aprs_msg)) 
								{
									gps (pnt->aprs_msg, pnt);
								}
							}
							pnt->aprs_msg_pnt = 0;
							memset (pnt->aprs_msg, 0x00, 256);
						}
						if (pnt->aprs_msg_pnt > 250)
							pnt->aprs_msg_pnt = 250;
						break;
				}
			}
			if (!memcmp (&pnt->rpt_save.body.voice.voice, lost_voice, 9))
			{
				pnt->aprs_msg_pnt = 0;
				memset (pnt->aprs_msg, 0x00, 256);
			}
		}
		if (status_pnt)
		{
			if (pnt->rpt_save.trunk.FrameSeq == 0)
			{
                               	memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
                               	memcpy (&pnt->STATUS_Frm.Type, "07", 2);
				memset (&pnt->STATUS_Frm.ip_address, 0x00, 16);
                               	#if __WORDSIZE == 64
                               	time (&pnt->STATUS_Frm.EntryUpdateTime);
                               	#else
                               	time (&pnt->STATUS_Frm.EntryUpdateTime);
                               	memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
                               	#endif
				pnt->STATUS_Frm.EntryUpdateTime += timezone;
				if (memcmp (&pnt->STATUS_Frm.ip_address, &pnt->STATUS_Save.ip_address, 84))
				{
					sta_pnt = status_pnt;
					while (sta_pnt)
					{
						sendto (sta_pnt->status_sd, &pnt->STATUS_Frm, 100, 0, 
							(struct sockaddr *)&sta_pnt->status_addr, 
							sizeof(sta_pnt->status_addr));
						sta_pnt->packets++;
						sta_pnt = sta_pnt->f_chain;
					}
					memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
				}
			}
		}		
	}
	else if (pnt->rpt_save_length == 32) // Last Frame ICOM
	{
		last_frame_send(pnt);
	}
}
