#include	"dxchange.h"
#include	"config.h"


void	status_logoff_send(void)
{
	struct	status	*sta_pnt;
	struct	STATUS_frame	StatusFrm;

	memcpy (StatusFrm.StatusID, "DSTRST", 6);
	memcpy (StatusFrm.Type, "01", 2);
	memset (&StatusFrm.ip_addr, 0x00, 16);
	#if __WORDSIZE == 64
	time (&StatusFrm.EntryUpdateTime);
	#else
	time (&StatusFrm.EntryUpdateTime);
	memset (&StatusFrm.dummy_t, 0x00, 4);
	#endif
	sta_pnt = status_pnt;
	while (sta_pnt)
	{
		memcpy (StatusFrm.body.logoff.dxchange_callsign, client_callsign, 8);
		sendto (sta_pnt->status_sd, &StatusFrm, 100, 0,
				sta_pnt->status_info->ai_addr,
				sta_pnt->status_info->ai_addrlen);
		close (sta_pnt->status_sd);
		sta_pnt = sta_pnt->f_chain;
	}
}


void	status_keep_alive_send(void)
{
        struct  status  *sta_pnt;
	struct	STATUS_frame	StatusFrm;
	struct	ModuleTable	*module;

        if (status_pnt)
        {
                memcpy (StatusFrm.StatusID, "DSTRST", 6);
                memcpy (StatusFrm.Type, "99", 2);
                memset (&StatusFrm.ip_addr, 0x00, 16);
                #if __WORDSIZE == 64
                time (&StatusFrm.EntryUpdateTime);
                #else
                time (&StatusFrm.EntryUpdateTime);
                memset (&StatusFrm.dummy_t, 0x00, 4);
                #endif
                // Convert local time to UTC
                StatusFrm.EntryUpdateTime += timezone;
                sta_pnt = status_pnt;
                while (sta_pnt)
                {
			module = module_pnt;
			while (module)
			{
				memcpy (StatusFrm.body.keep_alive.ModuleName, module->ModuleName, 8);
				memcpy (StatusFrm.body.keep_alive.dxchange_callsign, client_callsign, 8);
				memcpy (StatusFrm.body.keep_alive.Version, PACKAGE_VERSION, 5);
                        	sendto (sta_pnt->status_sd, &StatusFrm, 100, 0,
                                	sta_pnt->status_info->ai_addr,
                                	sta_pnt->status_info->ai_addrlen);
				module = module->f_chain;
			}
                       	sta_pnt->packets++;
                       	sta_pnt = sta_pnt->f_chain;
                }
		time (&status_keep_alive);
        }
}

void	status_send_ptton(struct ModuleTable *pnt)
{
	struct  status  *sta_pnt;

	sta_pnt = status_pnt;
	memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
        memcpy (&pnt->STATUS_Frm.Type, "05", 2);
        memcpy (&pnt->STATUS_Frm.body.status.RPT2Call,  &pnt->rpt_save.body.header.rpt2, 36);
        memset (&pnt->STATUS_Frm.ip_addr, 0x00, 16);
        #if __WORDSIZE == 64
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        #else
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
        #endif
        pnt->STATUS_Frm.EntryUpdateTime += timezone;
        memset (&pnt->STATUS_Frm.body.status.ShortMessage, 0x20, 20);
        //memset (&pnt->STATUS_Frm.body.status.Latitude, 0x00, 16);
        pnt->STATUS_Frm.body.status.Latitude = 3600000;
        pnt->STATUS_Frm.body.status.Longitude = 3600000;
        memset (&pnt->STATUS_Save, 0x00, 100);
        pnt->STATUS_Frm.port = 0;
        while (sta_pnt)
        {
        	sendto (sta_pnt->status_sd, &pnt->STATUS_Frm, 100, 0,
                	sta_pnt->status_info->ai_addr, sta_pnt->status_info->ai_addrlen);
                sta_pnt->packets++;
                sta_pnt = sta_pnt->f_chain;
        }
        memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
}

void	status_send_pttoff (struct ModuleTable *pnt)
{
	struct	status	*sta_pnt;

        memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
        memcpy (&pnt->STATUS_Frm.Type, "06", 2);
        memset (&pnt->STATUS_Frm.ip_addr, 0x00, 16);
        #if __WORDSIZE == 64
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        #else
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
        #endif
        // Convert local time to UTC
        pnt->STATUS_Frm.EntryUpdateTime += timezone;
        sta_pnt = status_pnt;
        while (sta_pnt)
        {
        	sendto (sta_pnt->status_sd, &pnt->STATUS_Frm, 100, 0,
                	sta_pnt->status_info->ai_addr,
                sta_pnt->status_info->ai_addrlen);
                sta_pnt->packets++;
                sta_pnt = sta_pnt->f_chain;
        }
        memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
}

void	status_send_update (struct ModuleTable *pnt)
{
	struct	status	*sta_pnt;

	if (pnt->rpt_save.trunk.FrameSeq == 0)
        {
        	memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
                memcpy (&pnt->STATUS_Frm.Type, "07", 2);
                memset (&pnt->STATUS_Frm.ip_addr, 0x00, 16);
                #if __WORDSIZE == 64
                time (&pnt->STATUS_Frm.EntryUpdateTime);
                #else
                time (&pnt->STATUS_Frm.EntryUpdateTime);
                memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
                #endif
                pnt->STATUS_Frm.EntryUpdateTime += timezone;
                if (memcmp (&pnt->STATUS_Frm.ip_addr, &pnt->STATUS_Save.ip_addr, 84))
                {
                	sta_pnt = status_pnt;
                        while (sta_pnt)
                        {
                        	sendto (sta_pnt->status_sd, &pnt->STATUS_Frm, 100, 0,
                                	sta_pnt->status_info->ai_addr,
                                sta_pnt->status_info->ai_addrlen);
                                sta_pnt->packets++;
                                sta_pnt = sta_pnt->f_chain;
                        }
                        memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
                }
	}
}
