#include "dxchange.h"

void	last_check_reset (char call_sign[], char rpt_call_sign[])
{
	int	i;
	time_t	atime;

	time (&atime);
	for (i = 0 ; i < Max_Last_Check ; i ++)
	{
		if (!memcmp (call_sign, LastCheck[i].CallSign, 8)) 
		{
			LastCheck[i].LastTime = atime + gps_msg_send;
			memcpy (LastCheck[i].RptCallSign, rpt_call_sign, 8);
			if (debug_sw)
			{
				fprintf (log_file, "%24.24s re-store in GPS MSG Table Rpt:%8.8s Call:%8.8s\n", 
						ctime(&atime), rpt_call_sign, call_sign);
				fflush (log_file);
			}
			return;
		}
	}

        for (i = 0 ; i < Max_Last_Check ; i++)
        {
		if (call_sign[0] == 0x00)
		{
                	memcpy (LastCheck[i].CallSign, call_sign, 8);
			memcpy (LastCheck[i].RptCallSign, rpt_call_sign, 8);
			LastCheck[i].LastTime = atime + gps_msg_send;
			if (debug_sw)
			{
				fprintf (log_file, "%24.24s store in GPS MSG Table Rpt:%8.8s Call:%8.8s\n",
						ctime(&atime), rpt_call_sign, call_sign);
				fflush (log_file);
			}
			return;
		}
        }
}
			
char	*Last_check(char call_sign[])
{
	time_t	atime;
	int	i;

	time(&atime);

	for (i = 0 ; i < Max_Last_Check ; i++)
	{
		if (!memcmp (call_sign, LastCheck[i].CallSign, 8))
		{
			if (atime <= LastCheck[i].LastTime) return LastCheck[i].RptCallSign;
			else
			{
				LastCheck[i].CallSign[0] = 0x00;
				fprintf (log_file, "%24.24s  Expire %10.10s\n", 
						ctime(&atime), call_sign);
				fflush (log_file);
				return NULL;
			}
		}
	}

	for (i = 0 ; i < Max_Last_Check ; i++)
	{
		if (atime <= LastCheck[i].LastTime)
				LastCheck[i].CallSign[0] = 0x00;
	}
	return FALSE;
}


void	last_check_init(void)
{
	int	i;
	for (i = 0 ; i < Max_Last_Check ; i++)
	{
		LastCheck[i].CallSign[0] = 0x00;
	}
}	
