#include	"dxchange.h"

void    rep_send (struct ModuleTable *pnt);
void    forward (struct dstar_packet ds_pkt, int length);

struct	ModuleTable	*module_check (char call[], char gw_call[]);
struct	ModuleTable	*module_check_ex (char FrameID[], in_addr_t ipaddr, in_port_t port);

extern	struct	sockaddr_in	in_sock;
extern	socklen_t	len_in_sock;
//struct	sockaddr_in	rpt_mon_addr;
struct	sockaddr_in	rpt_zr_addr;
struct	sockaddr_in	rpt_gw_addr;

int	rpt_mon_sd;
int	rpt_zr_sd;
int	rpt_gw_sd;

union
{
	struct	dstar_packet	d_packet;
	char	zr_buffer[4096];
}	zr_buff;

void	repeater_zr(void)
{
        int     length;
        socklen_t       sock_len;
        struct  sockaddr_in     rpt_sock;
        struct  forward         *pnt;

        sock_len= sizeof(rpt_sock);
        length = recvfrom(rpt_zr_sd, &zr_buff, sizeof(zr_buff), 0,
				(struct sockaddr *)&rpt_sock, &sock_len);
        pnt = forward_pnt;
        while (pnt)
        {
                sendto (pnt->fwd_sd, &zr_buff, length, 0,
                        pnt->fwd_info->ai_addr, pnt->fwd_info->ai_addrlen);
                pnt = pnt->f_chain;
        }
}

void	repeater_gw(void)
{
	int	length;
	socklen_t	sock_len;
	struct	sockaddr_in	gw_sock;
	struct	forward		*pnt;

	sock_len= sizeof(gw_sock);
	length = recvfrom(rpt_gw_sd, &zr_buff, sizeof(zr_buff), 0, 
				(struct sockaddr *)&gw_sock, &sock_len);

        pnt = forward_pnt;
        while (pnt)
        {
                sendto (pnt->fwd_sd, &zr_buff, length, 0,
                        pnt->fwd_info->ai_addr, pnt->fwd_info->ai_addrlen);
                pnt = pnt->f_chain;
        }
}


int	repeater_mon(void)
{
	struct	ModuleTable	*m_pnt;
	int	length;
	time_t	atime;
	in_addr_t	ip_temp;
	in_port_t	port_temp;
	struct	timeval		time_21ms;
	struct	timeval		cur_time;

	len_in_sock = sizeof (in_sock);
    	length = recvfrom(rpt_mon_sd, &zr_buff, sizeof(zr_buff), 0, (struct sockaddr *)&in_sock, &len_in_sock);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s Repeater data Reciv. error\n", ctime(&atime));
        	return FALSE;			// end
    	}

	if (!memcmp(zr_buff.d_packet.id, "DSTR", 4) && (zr_buff.d_packet.sr == 0x73) 
		&& (zr_buff.d_packet.c == 0x12) && (zr_buff.d_packet.trunk.FrameType == 0x20) 
		&& ((zr_buff.d_packet.trunk.FrameSeq & 0x3f) < 21))		// check D-STAR packet (DSTR)
	{
		if (length == 58)
		{
			m_pnt = module_check(zr_buff.d_packet.body.header.rpt1, zr_buff.d_packet.body.header.rpt1);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &zr_buff, 58);
				m_pnt->rpt_save_length = 58;
				rep_send (m_pnt);
				m_pnt->FrameID[0] = zr_buff.d_packet.trunk.FrameID[0];
				m_pnt->FrameID[1] = zr_buff.d_packet.trunk.FrameID[1];
                        	memcpy (&m_pnt->ipaddress, &in_sock.sin_addr.s_addr, 4);
                        	memcpy (&m_pnt->port, &in_sock.sin_port, 2);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if (length == 29) // voice packet ICOM
		{
			memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
			memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (zr_buff.d_packet.trunk.FrameID, ip_temp, port_temp);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &zr_buff, 29);
				m_pnt->rpt_save_length = 29;
				rep_send (m_pnt);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if (length == 32) // Last Frame ICOM
		{
                        memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
                        memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (zr_buff.d_packet.trunk.FrameID, ip_temp, port_temp); 
			if (m_pnt)
			{
                        	memcpy (&m_pnt->rpt_save, &zr_buff, 32);
                        	m_pnt->rpt_save_length = 32;
				rep_send (m_pnt);
				m_pnt->rpt_save_length = 0;
				m_pnt->recv_time.tv_sec = 0;
				m_pnt->recv_time.tv_usec = 0;
			
			}
		}
		if (forward_pnt) forward (zr_buff.d_packet, length);
	}
	return TRUE;
}

int	repeater_init(void)
{
	struct	ifreq	ifr;
	time_t	atime;

    	// IPv4 UDP socket
	// monitor port
    	if((rpt_mon_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
                time(&atime);
                fprintf (log_file, "%24.24s Zone Repeater socket(Monitor) not open\n", ctime(&atime));
        	return FALSE;	
    	}

        // 待ち受けるIPとポート番号を設定
        rpt_mon_addr.sin_family = AF_INET;
        rpt_mon_addr.sin_port = htons(mon_port);
        rpt_mon_addr.sin_addr.s_addr = INADDR_ANY;

	if (ZR_NIC[0] != 0x00)
	{
		ifr.ifr_addr.sa_family = AF_INET;
		strncpy (ifr.ifr_name, ZR_NIC, IFNAMSIZ-1);
		time (&atime);
		if (ioctl (rpt_mon_sd, SIOCGIFADDR, &ifr) >= 0)
		{
			rpt_mon_addr.sin_addr.s_addr = 
				((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
			fprintf (log_file, "%24.24s NIC (%s) Zone Repeater Monitor Port %d open.\n", 
					ctime(&atime), ZR_NIC, mon_port);
			
		}
		else
		{
			fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), ZR_NIC);
		}
		fflush (log_file);
	}	
	
	FD_SET (rpt_mon_sd, &fd_save);

    	// Bind
    	if(bind(rpt_mon_sd, (struct sockaddr *)&rpt_mon_addr, sizeof(rpt_mon_addr)) < 0) {
		time(&atime);
		fprintf (log_file, "%24.24s Zone Repeater Monitor socket not bind %s\n", ctime(&atime), strerror(errno));
        	return FALSE;
    	}

/* ========================================================== */
	
        if((rpt_zr_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        {
                time(&atime);
                fprintf (log_file, "%24.24s Zone Repeater socket not open\n", ctime(&atime));
		zr_port = 0;
                return TRUE;
        }

	fprintf (log_file, "%24.24s NIC (%s) Zone Repeater Port %d open.\n",
		ctime(&atime), ZR_NIC, mon_port);
	fflush (log_file);

        // 待ち受けるIPとポート番号を設定
        rpt_zr_addr.sin_family = AF_INET;
        rpt_zr_addr.sin_port = htons(zr_port);
        rpt_zr_addr.sin_addr.s_addr = rpt_mon_addr.sin_addr.s_addr;


        FD_SET (rpt_zr_sd, &fd_save);

        // Bind
        if(bind(rpt_zr_sd, (struct sockaddr *)&rpt_zr_addr, sizeof(rpt_zr_addr)) < 0) {
                time(&atime);
                fprintf (log_file, "%24.24s Zone Repeater socket not bind %s\n", ctime(&atime), strerror(errno));
                zr_port = 0;
        }

/* ============================================================ */
	return TRUE;
}
