#include	"dxchange.h"

void    dprs_msg_set (char src_call[], char dst_call[], char msg[], char ack[]);
int     dprs_call_check (char call[]);

void	dprs_message (char string[])
{
	int	i, k;
	int	len;
	char	sender_callsign[9];
	char	dst_callsign[9];
	char	*tp;
	char	*sp, *lp, *cp, *llp;
	char	*msg_p;
	char	*ack_p;

	sp = string;
	lp = string + strlen(string) - 1;
	strtok (string, "\r\n\0");
	while (lp > sp)
	{
		cp = strtok (sp, "\r\n\0");
		llp = cp + strlen(cp);
		tp = strstr (cp, "::");
		if (tp)
		{
			if ((llp - tp) > 13)
			{
				memset (sender_callsign, 0x00, 9);
				k = 0;
				len = strlen (cp);
				for (i = 0 ; i < len ; i++)
				{
					if (*cp != '>')
					{
						sender_callsign[k] = *cp;
						k++;
						cp++;
						if (k > 8) break;
						
					}
					else
						break;
				}
				if (memcmp (tp + 12, "ack", 3))
				{
					memcpy (dst_callsign, tp+2, 9);
					tp += 12;
					msg_p = tp;
					ack_p = NULL;
					while (tp < llp)
					{	
						if (*tp == '{')
						{	
							//fprintf (log_file, "debug %s\n", &string[k+1]);
							//fflush (log_file);
							*tp = 0x00;
							ack_p = tp+1;
							break;
						}
						tp++;
					}
					dprs_msg_set (sender_callsign, dst_callsign, msg_p, ack_p);
				}
		
				fflush (log_file);
			}
		}
		sp = llp + 2;
	}
}

void	dprs_msg_set (char src_call[], char dst_call[], char msg[], char ack[])
{
	time_t	atime;
	int	length;

	struct	DprsMsg *pnt;

	time (&atime);
	if (!dprs_call_check(dst_call))
	{
		fprintf (log_file, "%24.24s %8.8s not in Last Check Table\n", 
			ctime(&atime), dst_call);
		fflush (log_file);
		return;
	}
	pnt = malloc (sizeof (struct DprsMsg));

	pnt->next = NULL;
	memcpy (pnt->src_call, src_call, 8);
	memcpy (pnt->dst_call, dst_call, 8);
	memset (pnt->msg, 0x20, 20);
	length = strlen(msg);
	if (length > 20) length = 20;
	if (length) memcpy (pnt->msg, msg, length);
	memset (pnt->ack, 0x00, 8);
	if (ack) memcpy (pnt->ack, ack, strlen(ack));
	fprintf (log_file, "%24.24s src:%8.8s dst:%8.8s msg:%20.20s Ack:%s\n",
				ctime(&atime), pnt->src_call, pnt->dst_call, pnt->msg, pnt->ack);
	fflush (log_file); 
	if (DprsMsg_pnt)
	{
		pnt->next = DprsMsg_pnt;
		DprsMsg_pnt = pnt;
	}
	else
	{
		DprsMsg_pnt = pnt;
	}
}

int	dprs_call_check (char call[])
{
	int	i;
	time_t	atime;

	time (&atime);
	for (i = 0 ; i < Max_Last_Check ; i++)
	{
		if ((atime - LastCheck[i].LastTime) > expire_time)
			LastCheck[i].CallSign[0] =  0x00;
	}

	for (i = 0 ; i < Max_Last_Check ; i++)
	{
		if (!memcmp(LastCheck[i].CallSign, call, 8)) return TRUE;
	}
	return FALSE;
}
