#include	"dxchange.h"

void    rep_send (struct ModuleTable *pnt);
void    forward (struct dstar_packet ds_pkt, int length);
void	send_zr_reply (char buff[]);
void	send_gw_reply (char buff[]);
void	send_zr (char buff[]);
void	send_gw (char buff[]);

struct	ModuleTable	*module_check (char call[], char gw_call[]);
struct	ModuleTable	*module_check_ex (char FrameID[], in_addr_t ipaddr, in_port_t port);

extern	struct	sockaddr_in	in_sock;
extern	socklen_t	len_in_sock;
struct	sockaddr_in	rpt_zr_addr;
struct	sockaddr_in	rpt_gw_addr;

int	rpt_mon_sd;
int	rpt_zr_sd;
int	rpt_gw_sd;
int	recv_zr_seq = 0;
int	send_zr_seq = 0;
int	send_zr_seq_save = 0;
int	recv_gw_seq = 0;
int	send_gw_seq = 0;
int	send_gw_seq_save = 0;
struct	sockaddr_in	zr_in_addr;
struct	sockaddr_in	zr_out_addr;
struct	sockaddr_in	gw_in_addr;
struct	sockaddr_in	gw_out_addr;

char	zr_frame_id[2] = {0x00, 0x00};
char	mon_frame_id[2] = {0x00, 0x00};

union
{
	struct	dstar_packet	d_packet;
	char	zr_buffer[1024];
}	zr_buff;

union
{
	struct  dstar_packet    d_packet;
	char    gw_buffer[1024];
}	gw_buff;

union
{
	struct  dstar_packet    d_packet;
	char    mon_buffer[128];
}       mon_buff;

void	repeater_zr(void)
{
        int     zr_length;
        socklen_t       zr_in_addr_len;
        struct  forward         *pnt;
	unsigned int	seq_tmp;
	time_t	atime;

        zr_in_addr_len= sizeof(zr_in_addr);
        zr_length = recvfrom(rpt_zr_sd, &zr_buff, sizeof(zr_buff), 0,
				(struct sockaddr *)&zr_in_addr, &zr_in_addr_len);

	if (zr_length < 10) return;
	if (memcmp (zr_buff.zr_buffer, "DSTR", 4)) return;

	if (zr_buff.zr_buffer[6] == 's')
	{
		send_zr_reply (zr_buff.zr_buffer);
		send_gw (zr_buff.zr_buffer);

		if (zr_length == 58)
		{
			memcpy (zr_frame_id, &zr_buff.zr_buffer[14], 2);
		}

		if (!memcmp (zr_frame_id, &zr_buff.zr_buffer[14], 2))
		{
        		pnt = forward_pnt;
        		while (pnt)
        		{
               			sendto (pnt->fwd_sd, &zr_buff, zr_length, 0,
                       			pnt->fwd_info->ai_addr, pnt->fwd_info->ai_addrlen);
               			pnt = pnt->f_chain;
        		}
		}
	}
	else if (zr_buff.zr_buffer[6] == 'r')
	{
		seq_tmp = (zr_buff.zr_buffer[4] << 8) | (zr_buff.zr_buffer[5] & 0xff);
                seq_tmp &= 0xffff;
                if (seq_tmp != send_zr_seq_save)
                {
			time(&atime);
                        fprintf (log_file, "%24.24s zr seq. send:%d  recv:%d\n", 
				ctime(&atime), send_zr_seq_save, seq_tmp);
                        fflush (log_file);
                        //send_zr_seq = seq_tmp;
                }
                send_gw_seq &= 0xffff;
	}
}

void	send_zr_reply (char pkt[])
{
	char	zr_reply[10];

	memcpy (zr_reply, "DSTR", 4);
	zr_reply[4] = recv_zr_seq >> 8;
	zr_reply[5] = recv_zr_seq & 0xff;
	zr_reply[6] = 'r';
	zr_reply[7] = 0x00;
	zr_reply[8] = 0x00;
	zr_reply[9] = 0x00;
	if ((pkt[4] == zr_reply[4]) && (pkt[5] == zr_reply[5]))
	{
		recv_zr_seq++;
		recv_zr_seq &= 0xffff;
	}
	sendto (rpt_zr_sd, zr_reply, 10, 0, zr_out_info->ai_addr, zr_out_info->ai_addrlen);
}

void	send_zr (char pkt[])
{
	int	length;

	length = (pkt[8] << 8) | pkt[9];
	length += 10;
	pkt[4] = send_zr_seq >> 8;
	pkt[5] = send_zr_seq & 0xff;
	send_zr_seq_save = send_zr_seq;
	send_zr_seq++;
	send_zr_seq &= 0xffff;

	sendto (rpt_zr_sd, pkt, length, 0, zr_out_info->ai_addr, zr_out_info->ai_addrlen);
}


void	repeater_gw(void)
{
	int	gw_length;
	socklen_t	gw_in_addr_len;
	struct	forward		*pnt;
	unsigned int	seq_tmp;
	time_t	atime;

	gw_in_addr_len = sizeof(gw_in_addr);
	gw_length = recvfrom(rpt_gw_sd, &gw_buff, sizeof(gw_buff), 0, 
				(struct sockaddr *)&gw_in_addr, &gw_in_addr_len);

	if (gw_length < 10) return;
	if (memcmp (gw_buff.gw_buffer, "DSTR", 4)) return;

	if (gw_buff.gw_buffer[6] == 's')
	{
		send_gw_reply (gw_buff.gw_buffer);
		send_zr (gw_buff.gw_buffer);

        	pnt = forward_pnt;
        	while (pnt)
        	{
                	sendto (pnt->fwd_sd, &gw_buff, gw_length, 0,
                        	pnt->fwd_info->ai_addr, pnt->fwd_info->ai_addrlen);
                	pnt = pnt->f_chain;
        	}
	}
	else if (gw_buff.gw_buffer[6] == 'r')
	{
		seq_tmp = (gw_buff.gw_buffer[4] << 8) | (gw_buff.gw_buffer[5] & 0xff);
		seq_tmp &= 0xffff;
		if (seq_tmp != send_gw_seq_save)
		{
			time(&atime);
			fprintf (log_file, "%24.24s gw seq. send:%d  recv:%d\n", ctime(&atime), send_gw_seq_save, seq_tmp);
			fflush (log_file);
			send_gw_seq = seq_tmp;
		}
		send_gw_seq &= 0xffff;
	}
}

void    send_gw_reply (char pkt[])
{
        char    gw_reply[10];

        memcpy (gw_reply, "DSTR", 4);
        gw_reply[4] = recv_gw_seq >> 8;
        gw_reply[5] = recv_gw_seq & 0xff;
        gw_reply[6] = 'r';
        gw_reply[7] = 0x00;
        gw_reply[8] = 0x00;
        gw_reply[9] = 0x00;
        if ((pkt[4] == gw_reply[4]) && (pkt[5] == gw_reply[5]))
        {
                recv_gw_seq++;
                recv_gw_seq &= 0xffff;
        }
        sendto (rpt_gw_sd, gw_reply, 10, 0, gw_out_info->ai_addr, gw_out_info->ai_addrlen);
}

void	send_gw (char pkt[])
{
	int	length;

	length = (pkt[8] << 8) | pkt[9];
	length += 10;

	pkt[4] = send_gw_seq >> 8;
	pkt[5] = send_gw_seq & 0xff;
	send_gw_seq_save = send_gw_seq;
	send_gw_seq++;
	send_gw_seq &= 0xffff;

	sendto (rpt_gw_sd, pkt, length, 0, gw_out_info->ai_addr, gw_out_info->ai_addrlen);
}


int	repeater_mon(void)
{
	struct	ModuleTable	*m_pnt;
	int	length;
	time_t	atime;
	in_addr_t	ip_temp;
	in_port_t	port_temp;
	struct	timeval		time_21ms;
	struct	timeval		cur_time;

	len_in_sock = sizeof (in_sock);
    	length = recvfrom(rpt_mon_sd, &mon_buff, sizeof(mon_buff), 0, (struct sockaddr *)&in_sock, &len_in_sock);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s Repeater data Reciv. error\n", ctime(&atime));
        	return FALSE;			// end
    	}

	if (!memcmp(mon_buff.d_packet.id, "DSTR", 4) && (mon_buff.d_packet.sr == 0x73) 
		&& (mon_buff.d_packet.c == 0x12) && (mon_buff.d_packet.trunk.FrameType == 0x20) 
		&& ((mon_buff.d_packet.trunk.FrameSeq & 0x3f) < 21))		// check D-STAR packet (DSTR)
	{
		if (length == 58)
		{
			m_pnt = module_check(mon_buff.d_packet.body.header.rpt1, mon_buff.d_packet.body.header.rpt1);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &mon_buff, 58);
				m_pnt->rpt_save_length = 58;
				rep_send (m_pnt);
				m_pnt->FrameID[0] = mon_buff.d_packet.trunk.FrameID[0];
				m_pnt->FrameID[1] = mon_buff.d_packet.trunk.FrameID[1];
                        	memcpy (&m_pnt->ipaddress, &in_sock.sin_addr.s_addr, 4);
                        	memcpy (&m_pnt->port, &in_sock.sin_port, 2);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
			if ((zr_port == 0) || (mon_buff.d_packet.body.header.rpt2[7] != 'G')) 
					memcpy (mon_frame_id, mon_buff.d_packet.trunk.FrameID, 2);
		}
		else if (length == 29) // voice packet ICOM
		{
			memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
			memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (mon_buff.d_packet.trunk.FrameID, ip_temp, port_temp);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &mon_buff, 29);
				m_pnt->rpt_save_length = 29;
				rep_send (m_pnt);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if (length == 32) // Last Frame ICOM
		{
                        memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
                        memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (mon_buff.d_packet.trunk.FrameID, ip_temp, port_temp); 
			if (m_pnt)
			{
                        	memcpy (&m_pnt->rpt_save, &mon_buff, 32);
                        	m_pnt->rpt_save_length = 32;
				rep_send (m_pnt);
				m_pnt->rpt_save_length = 0;
				m_pnt->recv_time.tv_sec = 0;
				m_pnt->recv_time.tv_usec = 0;
			
			}
		}
		if (forward_pnt)
		{
			if (!memcmp (mon_frame_id, mon_buff.d_packet.trunk.FrameID, 2))
				forward (mon_buff.d_packet, length);
		}
	}
	return TRUE;
}

int	repeater_init(void)
{
	struct	ifreq	ifr;
	time_t	atime;
	struct  addrinfo        hints;
	char	PORT[8];
	int	err;

	if ((ZR_NIC[0] != 0x00) && (mon_port > 0))
	{
    		// IPv4 UDP socket
		// monitor port
    		if((rpt_mon_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		{
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket(Monitor) not open\n", ctime(&atime));
        		return FALSE;	
    		}

        	// 待ち受けるIPとポート番号を設定
        	rpt_mon_addr.sin_family = PF_UNSPEC;
        	rpt_mon_addr.sin_port = htons(mon_port);
        	rpt_mon_addr.sin_addr.s_addr = INADDR_ANY;

		memset (&ifr, 0x00, sizeof (struct ifreq)); 
		ifr.ifr_addr.sa_family = PF_UNSPEC;
		strncpy (ifr.ifr_name, ZR_NIC, IFNAMSIZ-1);
		time (&atime);
		if (ioctl (rpt_mon_sd, SIOCGIFADDR, &ifr) >= 0)
		{
			rpt_mon_addr.sin_addr.s_addr = 
				((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
			fprintf (log_file, "%24.24s NIC (%s) Zone Repeater Monitor Port %d open.\n", 
					ctime(&atime), ZR_NIC, mon_port);
			
		}
		else
		{
			fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), ZR_NIC);
		}
		fflush (log_file);
	
		FD_SET (rpt_mon_sd, &fd_save);

    		// Bind
    		if(bind(rpt_mon_sd, (struct sockaddr *)&rpt_mon_addr, sizeof(rpt_mon_addr)) < 0) {
			time(&atime);
			fprintf (log_file, "%24.24s Zone Repeater Monitor socket not bind %s\n", 
				ctime(&atime), strerror(errno));
        		return FALSE;
    		}
	}

/* ========================================================= */

	if ((GW_NIC[0] != 0x00) && (gw_port > 0))
	{
        	if((rpt_gw_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        	{
                	time(&atime);
                	fprintf (log_file, "%24.24s Gateway socket not open\n", ctime(&atime));
                	gw_port = 0;
                	return TRUE;
        	}

        	// 待ち受けるIPとポート番号を設定
        	rpt_gw_addr.sin_family = PF_UNSPEC;
        	rpt_gw_addr.sin_port = htons(gw_port);
        	rpt_gw_addr.sin_addr.s_addr = INADDR_ANY;

		memset (&ifr, 0x00, sizeof (struct ifreq));
                ifr.ifr_addr.sa_family = PF_UNSPEC;
                strncpy (ifr.ifr_name, GW_NIC, IFNAMSIZ-1);
                time (&atime);
                if (ioctl (rpt_gw_sd, SIOCGIFADDR, &ifr) >= 0)
                {
                        rpt_gw_addr.sin_addr.s_addr =
                                ((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
                        fprintf (log_file, "%24.24s NIC (%s) Gateway Port %d open.\n",
                                        ctime(&atime), GW_NIC, gw_port);

                }
                else
                {
                        fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), GW_NIC);
                }
                fflush (log_file);

	        FD_SET (rpt_gw_sd, &fd_save);

        	// Bind
        	if(bind(rpt_gw_sd, (struct sockaddr *)&rpt_gw_addr, sizeof(rpt_gw_addr)) < 0) {
                	time(&atime);
                	fprintf (log_file, "%24.24s Gateway socket not bind %s\n", ctime(&atime), strerror(errno));
                	gw_port = 0;
        	}
		memset (&hints, 0x00, sizeof(hints));
		hints.ai_socktype = SOCK_DGRAM;
		hints.ai_family = PF_UNSPEC;
		sprintf (PORT, "%d", gw_port);
		if ((err= getaddrinfo (GW_ADDR, PORT, &hints, &gw_out_info)) != 0)
		{
			fprintf (log_file, "%24.24s getaddrinfo error (GW OUT:%s:%0d) %s\n",
				ctime(&atime), GW_ADDR, gw_port, gai_strerror(err));
			if (gw_out_info != NULL)  freeaddrinfo (gw_out_info);
		}
	}

/* ========================================================== */

	if ((ZR_NIC[0] != 0x00) && (zr_port > 0))
	{	
        	if((rpt_zr_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        	{
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket not open\n", ctime(&atime));
			zr_port = 0;
                	return TRUE;
        	}

		fprintf (log_file, "%24.24s NIC (%s) Zone Repeater Port %d open.\n",
			ctime(&atime), ZR_NIC, zr_port);
		fflush (log_file);

        	// 待ち受けるIPとポート番号を設定
        	rpt_zr_addr.sin_family = PF_UNSPEC;
        	rpt_zr_addr.sin_port = htons(zr_port);
        	rpt_zr_addr.sin_addr.s_addr = rpt_mon_addr.sin_addr.s_addr;


        	FD_SET (rpt_zr_sd, &fd_save);

        	// Bind
        	if(bind(rpt_zr_sd, (struct sockaddr *)&rpt_zr_addr, sizeof(rpt_zr_addr)) < 0) {
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket not bind %s\n", ctime(&atime), strerror(errno));
                	zr_port = 0;
        	}

		memset (&hints, 0x00, sizeof(hints));
        	hints.ai_socktype = SOCK_DGRAM;
        	hints.ai_family = PF_UNSPEC;
        	sprintf (PORT, "%d", zr_port);
        	if ((err= getaddrinfo (ZR_ADDR, PORT, &hints, &zr_out_info)) != 0)
        	{
        		fprintf (log_file, "%24.24s getaddrinfo error (ZR OUT:%s:%0d) %s\n",
                		ctime(&atime), ZR_ADDR, zr_port, gai_strerror(err));
                	if (zr_out_info != NULL)  freeaddrinfo (zr_out_info);
        	}
	}

/* ============================================================ */
	return TRUE;
}
