#!ruby -Ks
# т܃TvQ[
require 'dxruby'

# wi`
class Map
  @@map = [[0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 11, 30, 34, 66, 67, 67],
           [0, 0, 0, 24, 25, 26, 0, 0, 29, 11, 11, 39, 40, 6, 34, 34],
           [0, 0, 24, 17, 31, 35, 0, 0, 12, 20, 11, 11, 11, 39, 40, 40],
           [0, 24, 17, 34, 7, 44, 0, 28, 28, 29, 11, 11, 11, 11, 11, 11],
           [0, 33, 31, 34, 35, 0, 28, 3, 37, 38, 11, 11, 11, 18, 19, 19],
           [0, 42, 43, 43, 44, 28, 3, 38, 11, 11, 11, 18, 19, 13, 28, 28],
           [0, 0, 0, 0, 3, 37, 38, 11, 11, 18, 19, 13, 28, 28, 28, 0],
           [0, 0, 0, 3, 38, 11, 11, 11, 18, 13, 28, 28, 51, 52, 52, 52],
           [0, 0, 3, 38, 11, 11, 18, 19, 13, 51, 52, 52, 86, 58, 61, 76],
           [28, 0, 29, 11, 11, 18, 13, 28, 51, 86, 58, 58, 61, 61, 58, 62],
           [0, 28, 29, 11, 18, 13, 28, 0, 60, 58, 61, 61, 61, 61, 76, 71],
           [0, 28, 29, 11, 27, 28, 28, 51, 86, 61, 61, 58, 76, 70, 71, 0],
           [0, 0, 29, 11, 36, 4, 28, 60, 58, 61, 58, 76, 71, 0, 1, 2],
           [0, 28, 29, 11, 11, 36, 4, 69, 70, 70, 70, 71, 0, 1, 2, 0],
           [0, 0, 12, 20, 11, 11, 27, 0, 1, 0, 1, 1, 1, 2, 2, 0],
           [0, 0, 28, 12, 20, 11, 27, 0, 0, 0, 2, 2, 0, 2, 2, 0],
           [0, 0, 0, 2, 29, 11, 27, 1, 2, 2, 2, 0, 0, 2, 2, 2],
           [0, 0, 0, 2, 29, 11, 27, 1, 0, 1, 1, 2, 2, 0, 0, 2],
           [0, 0, 0, 0, 29, 11, 27, 1, 0, 2, 2, 2, 1, 1, 2, 2],
           [0, 45, 47, 2, 29, 11, 36, 4, 1, 2, 2, 0, 0, 2, 2, 0],
           [45, 82, 56, 0, 29, 11, 11, 36, 4, 1, 2, 2, 2, 2, 0, 0],
           [54, 0, 56, 0, 12, 20, 11, 11, 36, 37, 4, 0, 2, 2, 2, 2],
           [54, 55, 81, 46, 47, 12, 20, 11, 11, 11, 36, 4, 1, 1, 1, 2],
           [54, 55, 0, 0, 56, 0, 12, 19, 20, 11, 11, 36, 37, 4, 1, 1],
           [54, 0, 55, 55, 56, 0, 0, 0, 12, 20, 11, 11, 11, 36, 37, 37],
           [63, 73, 55, 55, 56, 0, 0, 2, 2, 29, 11, 11, 11, 11, 11, 11],
           [0, 54, 0, 55, 81, 47, 0, 2, 3, 38, 11, 11, 11, 11, 11, 11],
           [0, 54, 0, 0, 55, 56, 2, 0, 29, 11, 11, 11, 21, 22, 22, 22],
           [0, 63, 64, 64, 64, 65, 0, 0, 29, 11, 11, 21, 15, 48, 49, 49],
           [0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 11, 30, 34, 57, 34, 34],
          ]
  temp = Image.load("image/maptile.png")
  x = temp.width / 32
  y = temp.height / 32
  @@images = temp.slice_tiles(x, y, true)

  # 
  def initialize
    @y = 14 * 32    # }bv̏ʒu
    @count = 0      # 1`bvԂړt[
  end

  # }bvXV
  def update
    @count -= 1
  end

  # }bv`
  def draw
    $rt.draw_tile(0, 0, @@map, @@images, 0, @y + @count, 16, 16, 0)
  end
end

# GP̂ꏈ
class Enemy1bomb < Sprite
  @@image0 = Image.load_tiles("image/enemy1bomb.png", 4, 2, true)
  @@image1 = Array.new(8) {Image.new(48, 48)}      # TCY̓摜
  black = [128, 0, 0, 0]
  for i in 0..7
    for y in 0..47
      for x in 0..47
        @@image1[i][x, y] = black if @@image0[i][x, y][0] == 255 # 摜œȂɂ
      end
    end
  end

  # CX^X
  def initialize(x, y)
    super(x, y)
    self.z = 10
    self.target = $rt
    @count = 0
  end

  # XV
  def update
    self.y += 1.5
    @count += 1
    if @count >= 40
      self.vanish
    end
  end

  # `
  def draw
    self.image = @@image0[@count / 5]
    super
    $rt.draw(self.x-16, self.y-16, @@image1[@count / 5], 1)
  end
end

# GQ̂ꏈ
class Enemy2bomb < Sprite
  @@image0 = Image.load_tiles("image/enemy2bomb.png", 4, 2, true)
  @@image1 = Array.new(8) {Image.new(128, 64)}      # TCY̓摜
  black = [128, 0, 0, 0]
  for y in 0..63
    for x in 0..127
      if @@image0[0][x, y][0] == 255 # 摜œȂɂ
        @@image1[0][x, y] = black
        @@image1[1][x, y] = black
      end
      if @@image0[2][x, y][0] == 255 # 摜œȂɂ
        @@image1[2][x, y] = black
        @@image1[3][x, y] = black
      end
    end
  end

  # CX^X
  def initialize(x, y)
    super(x, y)
    self.z = 10
    self.target = $rt
    @count = 0
  end

  # XV
  def update
    self.y += 0.5
    @count += 1
    if @count >= 40
      self.vanish
    end
  end

  # `
  def draw
    self.image = @@image0[@count / 5]
    super
    $rt.draw(self.x-16, self.y-16, @@image1[@count / 5], 1)
  end
end

# GPpVbgqbg
class EnemyShot1Hit < Sprite
  @@image = Image.load("image/enemyshot1.png")

  # CX^X
  def initialize(x, y, angle)
    super(x, y, @@image)
    self.z = 20
    self.alpha = 255
    self.target = $rt
    temp2 = angle + 180
    @dx = Math.cos((temp2) / 180.0 * Math::PI)
    @dy = Math.sin((temp2) / 180.0 * Math::PI)
  end

  # XV
  def update
    self.x += @dx
    self.y += @dy
    self.alpha -= 10

    if self.alpha < 0
      self.vanish
    end
  end
end

# GPpVbg
class EnemyShot1 < Sprite
  @@image = Image.load("image/enemyshot1.png")
  @@sound = Array.new(3) do
    v = 60
    SoundEffect.new(60,WAVE_TRI) do
      v = v - 1
      [800, v]
    end
  end
  @@soundnumber = 0
  @@soundflag = false

  # CX^X
  def initialize(x, y, angle)
    super(x, y, @@image)
    self.z = 20
    self.collision = [4, 4, 11, 11]
    self.target = $rt
    @dx = Math.cos(angle / 180.0 * Math::PI) * 1.5
    @dy = Math.sin(angle / 180.0 * Math::PI) * 1.5
    @shot_angle = angle
  end

  # XV
  def update
    self.x += @dx
    self.y += @dy
    @@soundflag = false
  end

  def shot(obj)
    self.vanish
    $etc_objects << EnemyShot1Hit.new(self.x, self.y, @shot_angle)
    if @@soundflag == false
      @@sound[@@soundnumber].play
      @@soundnumber += 1
      @@soundnumber = 0 if @@soundnumber > 2
      @@soundflag = true
    end
  end
end

# GQpVbgqbg
class EnemyShot2Hit < Sprite
  @@image = Image.load("image/enemyshot2.png")

  # CX^X
  def initialize(x, y, angle)
    super(x, y, @@image)
    self.z = 20
    self.alpha = 255    # At@l
    self.target = $rt
    temp2 = angle + 180
    @dx = Math.cos((temp2) / 180.0 * Math::PI) * 3.5
    @dy = Math.sin((temp2) / 180.0 * Math::PI) * 3.5
  end

  # XV
  def update
    # ړ
    self.x += @dx
    self.y += @dy
    self.alpha -= 10
    if self.alpha < 0
      self.vanish
    end
  end
end

# GQpVbg
class EnemyShot2 < Sprite
  @@image = Image.load("image/enemyshot2.png")
  v = 60
  @@sound = Array.new(3) do
    v = 60
    SoundEffect.new(60,WAVE_TRI) do
      v = v - 1
      [600, v]
    end
  end
  @@soundnumber = 0
  @@soundflag = false

  # CX^X
  def initialize(x, y, angle)
    super(x, y, @@image)
    self.z = 20
    self.collision = [6, 6, 17, 17]
    self.target = $rt
    @dx = Math.cos(angle / 180.0 * Math::PI) * 3.5
    @dy = Math.sin(angle / 180.0 * Math::PI) * 3.5
    @shot_angle = angle
  end

  # XV
  def update
    # ړ
    self.x += @dx
    self.y += @dy
    @@soundflag = false
  end

  # @ɓƂɌĂ΂郁\bh
  def shot(obj)
    self.vanish
    $etc_objects << EnemyShot2Hit.new(self.x, self.y, @shot_angle)
    if @@soundflag == false
      @@sound[@@soundnumber].play
      @@soundnumber += 1
      @@soundnumber = 0 if @@soundnumber > 2
      @@soundflag = true
    end
  end
end

# GP
class Enemy1 < Sprite
  # 摜ǂݍ݁tbV/e摜
  image0 = Image.load_tiles("image/enemy1.png", 4, 1, true)  # ǂݍ
  image1 = Array.new(4) {Image.new(48, 48)}      # TCY̓摜
  image2 = Array.new(4) {Image.new(48, 48)}
  white = [255, 200, 200, 200]
  black = [128, 0, 0, 0]
  for i in 0..3
    for y in 0..47
      for x in 0..47
        image1[i][x, y] = white if image0[i][x, y][0] != 0 # 摜œȂ𔒂ɂ
        image2[i][x, y] = black if image0[i][x, y][0] != 0 # 摜œȂɂ
      end
    end
  end
  @@image = [image0, image1, image2]

  # SoundEffectłʉBR܂ł̑dĐł悤z񉻁B
  @@sound = Array.new(3) do
    v = 60
    f = 500
    SoundEffect.new(120,WAVE_SAW) do
      v = v - 0.5
      f = f - 1
      [f, v]
    end
  end
  @@soundnumber = 0
  @@soundflag = false

  # CX^X
  def initialize(x, y)
    super(x, y)
    self.z = 10
    self.collision = [0, 0, 47, 47] # Փ˔
    self.target = $rt
    @hp = 15         # qbg|Cg
    @shotcount = 0   # eԊu𑪂JE^
    @imagenumber = 0 # e1(tbV\)
    @animecount = 0  # Aj[VpJE^
  end

  # XV
  def update
    # ړ
    self.y += 2

    # e
    @shotcount += 1
    if @shotcount > 40
      # pxvZ
      angle = (Math.atan2($myship.y + 16 - (self.y + 24 + 8), $myship.x + 16 - (self.x + 16 + 8)) / Math::PI * 180)

      # e
      $enemy_shots << EnemyShot1.new(self.x + 16, self.y + 24, angle)

      # JEg
      @shotcount = 0
    end

    # Ƃ肠t[AtbVĂȂԂɂ
    @imagenumber = 0

    # Aj[VpJEg
    @animecount += 1
    @animecount -= 80 if @animecount >= 80

    @@soundflag = false
  end

  # @VbgɓƂɌĂ΂郁\bh
  def hit(obj)
    # HP炷
    @hp = @hp - obj.damage

    # ꏈ
    if @hp <= 0
      self.vanish
      $etc_objects << Enemy1bomb.new(self.x, self.y)

      # ʉ̑dĐ
      if @@soundflag == false
        @@sound[@@soundnumber].play
        @@soundnumber += 1
        @@soundnumber = 0 if @@soundnumber > 2
        @@soundflag = true
      end
    end

    # tbVɂ
    @imagenumber = 1
  end

  def draw
    self.image = @@image[@imagenumber][@animecount / 20]
    super
    $rt.draw(self.x-16, self.y-16, @@image[2][@animecount / 20], 1)
  end
end

# GQ
class Enemy2 < Sprite
  # 摜ǂݍ݁tbV/e摜
  image0 = Image.load_tiles("image/enemy2.png", 4, 1, true)  # ǂݍ
  image1 = Array.new(4) {Image.new(128, 64)} # TCY̓摜
  image2 = Array.new(4) {Image.new(128, 64)}
  white = [255, 200, 200, 200]
  black = [128, 0, 0, 0]
  for i in 0..3
    for y in 0..63
      for x in 0...127
        image1[i][x, y] = white if image0[i][x, y][0] != 0 # 摜œȂ𔒂ɂ
        image2[i][x, y] = black if image0[i][x, y][0] != 0 # 摜œȂɂ
      end
    end
  end
  @@image = [image0, image1, image2]
  v = 80
  @@sound = SoundEffect.new(4000,WAVE_RECT, 5000) do
    v = v - 0.03
    [rand(300), v]
  end

  # CX^X
  def initialize(x, y)
    super(x, y)
    self.z = 10
    self.collision = [0, 0, 127, 63] # Փ˔
    self.target = $rt
    @dy = 10 # cړ
    @hp = 400 # qbg|Cg
    @shotcount = 0   # eԊu𑪂JE^
    @imagenumber = 0 # e1(tbV\)
    @animecount = 0  # Aj[VpJE^
  end

  # XV
  def update
    # ړ
    self.y += @dy

    if @dy > 0         # Ɉړ
      @dy -= 0.3         # 
    else               # ړĂ
      @shotcount += 1    # VbgJEg𑫂
      if @shotcount > 60 # JEg60𒴂e
        # pxvZ
        angle = (Math.atan2($myship.y + 16 - (self.y + 40 + 12), $myship.x + 16 - (self.x + 56 + 12)) / Math::PI * 180)
        # 5
        $enemy_shots << EnemyShot2.new(self.x + 56, self.y + 40, angle - 45)
        $enemy_shots << EnemyShot2.new(self.x + 56, self.y + 40, angle - 22.5)
        $enemy_shots << EnemyShot2.new(self.x + 56, self.y + 40, angle)
        $enemy_shots << EnemyShot2.new(self.x + 56, self.y + 40, angle + 22.5)
        $enemy_shots << EnemyShot2.new(self.x + 56, self.y + 40, angle + 45)
        # JEg
        @shotcount = 0
      end
    end

    # Ƃ肠t[AtbVĂȂԂɂ
    @imagenumber = 0

    # Aj[VpJEg
    @animecount += 1
    @animecount -= 40 if @animecount >= 40
  end

  # @VbgƂɌĂ΂郁\bh
  def hit(obj)
    # HP炷
    @hp = @hp - obj.damage

    # ꏈ
    if @hp <= 0
      self.vanish
      $etc_objects << Enemy2bomb.new(self.x, self.y)
      @@sound.play
    end

    # tbVɂ
    @imagenumber = 1
  end

  # `
  def draw
    self.image = @@image[@imagenumber][@animecount / 10]
    super
    $rt.draw(self.x-16, self.y-16, @@image[2][@animecount / 10], 1)       # e
  end
end

# @pVbg
class MyShot < Sprite
  @@image = Image.load("image/myshot.png")
  attr_accessor :damage

  # CX^X
  def initialize(x, y, angle)
    super(x, y, @@image)
    self.z = 15
    self.collision = [0, 0, 31, 31] # Փ˔
    self.angle = angle + 90 # px
    self.target = $rt
    @dx = Math.cos(angle / 180.0 * Math::PI) * 16 # ړ
    @dy = Math.sin(angle / 180.0 * Math::PI) * 16 # cړ
    @damage = 5     # GɓƂɗ^_[W
  end

  # XV
  def update
    # Vbgړ
    self.x += @dx
    self.y += @dy
  end

  # GɓƂɌĂ΂郁\bh
  def shot(obj)
    self.vanish
  end
end

# @
class MyShip < Sprite

  # 摜ǂݍ݂Ɖe摜
  @@image0 = Image.load_tiles("image/myship.png", 4, 1, true)
  @@image1 = Array.new(4) {Image.new(32, 32)}
  black = [128, 0, 0, 0]
  for i in 0..3
    for y in 0..31
      for x in 0..31
        # 摜œȂɂ
        @@image1[i][x, y] = black if @@image0[i][x, y][0] != 0
      end
    end
  end

  # Vbg
  f = 4000
  @@sound = SoundEffect.new(20, WAVE_TRI) do   # 20ms ̎Opg𐶐
    f = f - 120      # g 4000Hz  1ms Ƃ 120Hz 
    [f, 15]          # [ g,  ] ̔zԂ
  end

  # 
  def initialize
    super(200, 400)
    self.z = 15
    self.collision = [4, 4, 27, 27]  # Փ˔
    self.target = $rt
    @animecount = 0   # Aj[VpJEg

  end

  def update
    # ړ
    dx = Input.x * 3
    dy = Input.y * 3
    if Input.x != 0 and Input.y != 0   # ii̎ 0.7 {
      dx *= 0.7
      dy *= 0.7
    end
    self.x += dx
    self.y += dy

    # ʒ[̔
    self.x = 0 if self.x < 0
    self.x = 448 - 32 if self.x > 448 - 32
    self.y = 0 if self.y < 0
    self.y = 480 - 32 if self.y > 480 - 32

    # Vbg
    if Input.pad_push?(P_BUTTON0)
      $my_shots << MyShot.new(self.x - 18, self.y - 32, 270)
      $my_shots << MyShot.new(self.x + 18, self.y - 32, 270)
      $my_shots << MyShot.new(self.x + 32, self.y - 16, 300)
      $my_shots << MyShot.new(self.x - 32, self.y - 16, 240)
      @@sound.play
    end

    # Aj[VpJEg
    @animecount += 1
    @animecount -= 80 if @animecount >= 80
  end

  # `
  def draw
    self.image = @@image0[@animecount / 20]
    super
    $rt.draw(self.x - 16, self.y - 16, @@image1[@animecount / 20], 1)  # e
  end
end

# ܂łNX`

# 炪Q[̃C

Window.caption = "тܗpTvQ[DXRuby1.4" # EBhẼLvVݒ
Window.width = 360        # EBhẺTCYݒ
Window.height = 480       # EBhȄcTCYݒ
Input.set_repeat(0, 5)     # L[̃I[gs[gݒB5 t[ 1  on

$etc_objects = []          # IuWFNgz
$my_shots = []              # e
$enemies = []              # G
$enemy_shots = []          # G̒e

$rt = RenderTarget.new(448,480)
screen_sprite = Sprite.new(0, 0)
screen_sprite.collision = [0, 0, 448, 480]

count = 0                 # GopJEg
font = Font.new(32)       # tHg

$myship = MyShip.new      # @
$etc_objects << $myship  # @IuWFNgzɒǉ
$etc_objects << Map.new  # wiIuWFNgIuWFNgzɒǉ

# C[v
Window.loop do

  # Go
  count += 1
  if count % 20 == 0      #  20 JEg 1 
    if count % 400 == 0   # 400 JEg 1 
      # G 2 ̃IuWFNgIuWFNgzɒǉ
      $enemies << Enemy2.new(rand(240), -64)
      count = 0
    else
      # G 1 ̃IuWFNgIuWFNgzɒǉ
      $enemies << Enemy1.new(rand(320), -48)
    end
  end

  # IuWFNgXV
  Sprite.update([$etc_objects, $my_shots, $enemies, $enemy_shots])

  # ʂo
  $my_shots = screen_sprite.check($my_shots)
  $enemies = screen_sprite.check($enemies)
  $enemy_shots = screen_sprite.check($enemy_shots)

  # Փ˔
  Sprite.check($my_shots, $enemies)     # @VbgƓG
  Sprite.check($enemy_shots, $myship)   # GVbgƎ@

  # Փ˔ŏLz񂩂폜
  Sprite.clean([$etc_objects, $my_shots, $enemies, $enemy_shots])

  # IuWFNg`
  Sprite.draw([$etc_objects, $my_shots, $enemies, $enemy_shots])

  $rt.update
  Window.draw(-$myship.x/5,0,$rt)

  # Esc L[ŏI
  break if Input.key_push?(K_ESCAPE)

  # eo
  Window.draw_font(0, 0, Window.get_load.to_i.to_s + " %", font, :z => 100)
  Window.draw_font(0, 32, [$etc_objects, $my_shots, $enemies, $enemy_shots].flatten.size.to_s + " objects", font, :z => 100)
end

