#define WINVER 0x0500                                  /* o[W` Windows2000ȏ */
#define _WIN32_WINNT WINVER

#include "ruby.h"
#ifndef RUBY_ST_H
#include "st.h"
#endif

#define DXRUBY_EXTERN 1

#include "dxruby.h"
#include "messagethread.h"

static HANDLE hMessageThread;
static DWORD MessageThreadID;
static HANDLE hEventMainThreadStart;
int MainThreadError = 0;

static int InitWindow( void );
static int InitDXGraphics( void );
static void DXRelease();

char *ERR_MESSAGE[ERR_MAX] = 
{
    "",
    "mۂł܂ł",
    "G[",
    "XN[[hύXł܂ł",
    "EBhE̐Ɏs܂",
    "DirectX Graphics̏ŃG[܂",
    "DirectInput̏ŃG[܂"
};

void DXRuby_raise( int errorcode, char *msg )
{
    char buf[1024];
    buf[0] = '\0';

    strcat( buf, ERR_MESSAGE[errorcode] );
    strcat( buf, " - " );
    strcat( buf, msg );

    /* buf̒gbZ[WƂeDXRubyErrorO𓊂 */
#ifdef HAVE_RB_ENC_STR_NEW
    rb_funcall( rb_cObject, rb_intern( "raise" ), 2, eDXRubyError, rb_funcall( rb_str_new2( buf ), rb_intern( "force_encoding" ), 1, rb_str_new2( sys_encode ) ) );
#else
    rb_raise( eDXRubyError, buf );
#endif
}

/*--------------------------------------------------------------------
  i֐jXN[TCYύX
 ---------------------------------------------------------------------*/
static int DDChangeSize( void )
{
    D3DVIEWPORT9 vp;
    HRESULT hr;
    int i;
    D3DDISPLAYMODE d3ddm;

    g_D3DPP.BackBufferWidth    = g_WindowInfo.width;
    g_D3DPP.BackBufferHeight   = g_WindowInfo.height;

    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {
        /* tXN[i32bitColorŒ/tbV[g͂΂AΈԍ) */
        int count , max, set_refreshrate;

        max = g_pD3D->lpVtbl->GetAdapterModeCount( g_pD3D, D3DADAPTER_DEFAULT, D3DFMT_X8R8G8B8 );
        set_refreshrate = 0;
        g_sync = 0;
        g_D3DPP.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

        for( count = 0 ; count < max ; count++ )
        {
            g_pD3D->lpVtbl->EnumAdapterModes( g_pD3D, D3DADAPTER_DEFAULT, D3DFMT_X8R8G8B8 , count , &d3ddm);
            /* 𑜓x疳 */
            if( g_WindowInfo.width != d3ddm.Width || g_WindowInfo.height != d3ddm.Height )
            {
                continue;
            }

            /* fpsw肪Â炻Ɍ */
            if( g_WindowInfo.fps != 0 && d3ddm.RefreshRate == g_WindowInfo.fps )
            {
                set_refreshrate = d3ddm.RefreshRate;
                g_sync = 1; // [h
                g_D3DPP.PresentationInterval = D3DPRESENT_INTERVAL_ONE;
                break;
            }

            /* ꍇɂ͈ԑ傫zɂ */
            if( d3ddm.RefreshRate > set_refreshrate )
            {
                set_refreshrate = d3ddm.RefreshRate;
            }
        }

        g_D3DPP.BackBufferFormat           = D3DFMT_X8R8G8B8;
        g_D3DPP.Windowed                   = FALSE;
        g_D3DPP.FullScreen_RefreshRateInHz = set_refreshrate;
    }
    else
    {
        /* EBhE[h */

        /* ݂̃[h擾 */
        g_pD3D->lpVtbl->GetAdapterDisplayMode( g_pD3D, D3DADAPTER_DEFAULT , &d3ddm );

        g_sync = 0; // 񓯊[h
        g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE;
        g_D3DPP.BackBufferFormat           = D3DFMT_UNKNOWN;
        g_D3DPP.Windowed                   = TRUE;
        g_D3DPP.FullScreen_RefreshRateInHz = 0;
    }

    /* D3DXSpriteXg */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
    }

    /* C_[^[Qbg̉ */
    {
        struct DXRubyRenderTarget *rt = DXRUBY_GET_STRUCT( RenderTarget, g_WindowInfo.render_target );
        RELEASE( rt->surface );
    }

    /* [U[_[^[Qbg̉ */
//    ppD3DTexture = (LPDIRECT3DTEXTURE9 *)alloca( g_RenderTargetList.count * sizeof(LPDIRECT3DTEXTURE9 *) );
    for( i = 0; i < g_RenderTargetList.count; i++ )
    {
        struct DXRubyRenderTarget *rt = (struct DXRubyRenderTarget *)g_RenderTargetList.pointer[i];

//        ppD3DTexture[i] = to_image( rt );
        RELEASE( rt->surface );
        RELEASE( rt->texture->pD3DTexture );
    }

    /* VF[_̃Xg */
    for( i = 0; i < g_ShaderCoreList.count; i++ )
    {
        struct DXRubyShaderCore *core = (struct DXRubyShaderCore *)g_ShaderCoreList.pointer[i];
        core->pD3DXEffect->lpVtbl->OnLostDevice( core->pD3DXEffect );
    }

    /* ݒύX */
    hr = g_pD3DDevice->lpVtbl->Reset( g_pD3DDevice, &g_D3DPP );
    if( FAILED( hr ) ) return 1;

    /* C_[^[Qbg̕ */
    {
        struct DXRubyRenderTarget *rt = DXRUBY_GET_STRUCT( RenderTarget, g_WindowInfo.render_target );
        g_pD3DDevice->lpVtbl->GetRenderTarget( g_pD3DDevice, 0, &rt->surface );
    }

    /* [U[_[^[Qbg̕ */
    for( i = 0; i < g_RenderTargetList.count; i++ )
    {
        struct DXRubyRenderTarget *rt = (struct DXRubyRenderTarget *)g_RenderTargetList.pointer[i];

        /* eNX`IuWFNg쐬 */
        hr = D3DXCreateTexture( g_pD3DDevice, rt->texture->width, rt->texture->height,
                                1, D3DUSAGE_RENDERTARGET, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT,
                                &rt->texture->pD3DTexture);
        if( FAILED( hr ) ) return 2;

        hr = rt->texture->pD3DTexture->lpVtbl->GetSurfaceLevel( rt->texture->pD3DTexture, 0, &rt->surface );
        if( FAILED( hr ) ) return 3;
    }

    /* VF[_̕A */
    for( i = 0; i < g_ShaderCoreList.count; i++ )
    {
        struct DXRubyShaderCore *core = (struct DXRubyShaderCore *)g_ShaderCoreList.pointer[i];
        core->pD3DXEffect->lpVtbl->OnResetDevice( core->pD3DXEffect );
    }

    /* D3DXSpriteA */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnResetDevice( g_pD3DXSprite );
    }

    return 0;
}

/*--------------------------------------------------------------------
   EBhE̐Ə
 ---------------------------------------------------------------------*/
static int ChangeSize()
{
    HRESULT hr;
    RECT rect;
    VALUE vrender_target;
    struct DXRubyRenderTarget *rt;
    int ret;

    /* EBhẼTCYݒ */
    rect.top     = 0;
    rect.left    = 0;
    rect.right   = g_WindowInfo.width * g_WindowInfo.scale;
    rect.bottom  = g_WindowInfo.height * g_WindowInfo.scale;

    /* EBhẼTCYC */
    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {   /* tXN[ */
        SetWindowLong( g_hWnd, GWL_STYLE, WS_POPUP );
        SetWindowPos( g_hWnd, HWND_TOP, 0, 0, g_WindowInfo.width, g_WindowInfo.height, SWP_NOZORDER);
    }
    else
    {   /* EBhE[h */
        SetWindowLong( g_hWnd, GWL_STYLE, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX);
        AdjustWindowRect( &rect, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX, FALSE );

        /* ƍvZ */
        rect.right   = rect.right - rect.left;
        rect.bottom  = rect.bottom - rect.top;

        /* EBhEړ/TCYݒ */
        if( g_WindowInfo.x == CW_USEDEFAULT )
        {   /* ʒuftHg̏ꍇ */
            SetWindowPos( g_hWnd, HWND_TOP, 0, 0, rect.right, rect.bottom, SWP_NOZORDER | SWP_NOMOVE);
        }
        else
        {   /* ʒuw̏ꍇ */
            SetWindowPos( g_hWnd, HWND_TOP, g_WindowInfo.x, g_WindowInfo.y, rect.right, rect.bottom, SWP_NOZORDER );
        }
    }

    /* DirectX̃XN[TCYύX */
    ret = DDChangeSize();
    if( ret != 0 )
    {
        return ret;
    }

    /* EBhE\ */
    ShowWindow( g_hWnd, SW_SHOWNORMAL );
    InvalidateRect( NULL, NULL, TRUE );
    UpdateWindow( g_hWnd );

    {
        struct DXRubyRenderTarget *rt = DXRUBY_GET_STRUCT( RenderTarget, g_WindowInfo.render_target );

        /* V[̃NA */
        g_pD3DDevice->lpVtbl->SetRenderTarget( g_pD3DDevice, 0, rt->surface );
        g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                     D3DCOLOR_XRGB( rt->r, rt->g, rt->b ), 0, 0 );
        g_pD3DDevice->lpVtbl->Present( g_pD3DDevice, NULL, NULL, NULL, NULL );
    }

    g_WindowInfo.created = Qtrue;

    return 0;
}


static int reset( void )
{
    HRESULT hr;
    hr = g_pD3DDevice->lpVtbl->TestCooperativeLevel( g_pD3DDevice );
    if( hr == D3DERR_DEVICENOTRESET ) /* foCX̓XgԂł邪Zbg\ł */
    {
        int i;
        /* ֗̓foCXZbg\Ԃł */
        /* D3DXSpriteXg */
        if( g_pD3DXSprite )
        {
            g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
        }

        /* _[^[Qbg̉ */
        {
            struct DXRubyRenderTarget *rt = (struct DXRubyRenderTarget *)g_WindowInfo.render_target;
            RELEASE( rt->surface );
        }
        for( i = 0; i < g_RenderTargetList.count; i++ )
        {
            struct DXRubyRenderTarget *rt = (struct DXRubyRenderTarget *)g_RenderTargetList.pointer[i];
            RELEASE( rt->surface );
            RELEASE( rt->texture->pD3DTexture );
        }

        /* VF[_̃Xg */
        for( i = 0; i < g_ShaderCoreList.count; i++ )
        {
            struct DXRubyShaderCore *core = (struct DXRubyShaderCore *)g_ShaderCoreList.pointer[i];
            core->pD3DXEffect->lpVtbl->OnLostDevice( core->pD3DXEffect );
        }

        hr = g_pD3DDevice->lpVtbl->Reset( g_pD3DDevice, &g_D3DPP ); /* ݂ */
        if( FAILED( hr ) )
        {
            if( hr == D3DERR_DEVICELOST )
            {
                return 0; /* ܂Xg */
            }
            return 1;
        }

        /* _[^[Qbg̕ */
        {
            struct DXRubyRenderTarget *rt = (struct DXRubyRenderTarget *)g_WindowInfo.render_target;
            g_pD3DDevice->lpVtbl->GetRenderTarget( g_pD3DDevice, 0, &rt->surface );
        }
        for( i = 0; i < g_RenderTargetList.count; i++ )
        {
            struct DXRubyRenderTarget *rt = (struct DXRubyRenderTarget *)g_RenderTargetList.pointer[i];

            /* eNX`IuWFNg쐬 */
            hr = D3DXCreateTexture( g_pD3DDevice, rt->texture->width, rt->texture->height,
                                    1, D3DUSAGE_RENDERTARGET, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT,
                                    &rt->texture->pD3DTexture);
            if( FAILED( hr ) ) return 2;

            hr = rt->texture->pD3DTexture->lpVtbl->GetSurfaceLevel( rt->texture->pD3DTexture, 0, &rt->surface );
            if( FAILED( hr ) ) return 3;
        }

        /* VF[_̕A */
        for( i = 0; i < g_ShaderCoreList.count; i++ )
        {
            struct DXRubyShaderCore *core = (struct DXRubyShaderCore *)g_ShaderCoreList.pointer[i];
            core->pD3DXEffect->lpVtbl->OnResetDevice( core->pD3DXEffect );
        }

        if( g_pD3DXSprite ) /* D3DXSpriteA */
        {
            g_pD3DXSprite->lpVtbl->OnResetDevice( g_pD3DXSprite );
        }
    }
    else /* DirectX̓G[ */
    {
        return 4;
    }

    return 0;
}


/*--------------------------------------------------------------------
   XbhC
 ---------------------------------------------------------------------*/
static DWORD WINAPI MessageThreadProc( LPVOID lpParameter )
{
    MSG msg;
    msg.message = WM_NULL;
    /* EBhE쐬(̎_ł͔\) */
    InitWindow();
    if( MainThreadError != 0 )
    {
        SetEvent( hEventMainThreadStart );
        ExitThread( 0 );
    }

    /* DirectX Graphics̏ */
    InitDXGraphics();
    if( MainThreadError != 0 )
    {
        SetEvent( hEventMainThreadStart );
        ExitThread( 0 );
    }

    /* DirectInput */
    InitDirectInput();
    if( MainThreadError != 0 )
    {
        SetEvent( hEventMainThreadStart );
        ExitThread( 0 );
    }

    /* IƂ̒ʒm */
    SetEvent( hEventMainThreadStart );

    /* bZ[W[v */
    /* WM_QUIT͂܂ŃbZ[W */
    while( msg.message != WM_QUIT )
    {
        if( GetMessage( &msg, g_hWnd, 0, 0 ) != 0)
        {
            /* bZ[W鎞 */
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
    }

    DXRelease();

    // XbhI
    ExitThread( 0 );
}

/*--------------------------------------------------------------------
   i֐jEBhEvV[W
 ---------------------------------------------------------------------*/
LRESULT CALLBACK MessageThreadWndProc( HWND hWnd, UINT msg, UINT wParam, LONG lParam )
{
    RECT rect;
    VALUE temp;

    switch( msg )
    {
    case WM_CREATE:
        break;

    case WM_ACTIVATE:
        /* EBhEANeBu^ANeBu */
        g_WindowInfo.active = (LOWORD(wParam) != 0);
        break;

    case WM_CLOSE:
        g_WindowInfo.requestclose = 1;
        return 0;

    case WM_DESTROY:
        /* EBhEj */
        PostQuitMessage( 0 );
        g_hWnd = NULL;
        return 0;

    case WM_MOUSEWHEEL:
        g_WindowInfo.mousewheelpos += (short)HIWORD(wParam);
        break;

    case WM_APP + 0:
        /* foCX̃Zbg */
        return reset();
        break;

    case WM_APP + 1:
        /* EBhE̐ݒύX */
        return ChangeSize();
        break;
    }

    /* ftHg */
    return DefWindowProc( hWnd, msg, wParam, lParam );
}

/*--------------------------------------------------------------------
  i֐jEBhE̐
 ---------------------------------------------------------------------*/
static int InitWindow( void )
{
    WNDCLASSEX wcex;
    RECT rect;

    /* EChEENX̓o^ */
    wcex.cbSize        = sizeof( WNDCLASSEX );
    wcex.style         = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc   = (WNDPROC)MessageThreadWndProc;
    wcex.cbClsExtra    = 0;
    wcex.cbWndExtra    = 0;
    wcex.hInstance     = g_hInstance;
    wcex.hIcon         = NULL;
    wcex.hIconSm       = NULL;
    wcex.hCursor       = LoadCursor( NULL, IDC_ARROW );
    wcex.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
    wcex.lpszMenuName  = NULL;
    wcex.lpszClassName = "DXRuby";

    if( !RegisterClassEx( &wcex ) )
    {
        MainThreadError = 1;
        return MainThreadError;
    }

    /* CEEChE쐬(EChEE[hp) */
    rect.top     = 0;
    rect.left    = 0;
    rect.right   = g_WindowInfo.width;
    rect.bottom  = g_WindowInfo.height;

    AdjustWindowRect( &rect, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX, FALSE );

    rect.right   = rect.right - rect.left;
    rect.bottom  = rect.bottom - rect.top;
    rect.left    = 0;
    rect.top     = 0;

    g_hWnd = CreateWindow( TEXT("DXRuby"), TEXT("DXRuby Application"),
                           WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           rect.right - rect.left, rect.bottom - rect.top,
                           NULL, NULL, g_hInstance, NULL );
    if( g_hWnd == NULL )
    {
        MainThreadError = 2;
        return MainThreadError;
    }

    GetWindowRect( g_hWnd, &rect );
    g_WindowInfo.x        = rect.left;
    g_WindowInfo.y        = rect.top;

    WINNLSEnableIME( g_hWnd, FALSE );

    return 0;
}


/*--------------------------------------------------------------------
  i֐jDirectX Graphics
 ---------------------------------------------------------------------*/
static int InitDXGraphics( void )
{
    D3DVIEWPORT9 vp;
    HRESULT hr;

    /* Direct3DIuWFNg̍쐬 */
    g_pD3D = Direct3DCreate9( D3D_SDK_VERSION );

    if( g_pD3D == NULL )
    {
        MainThreadError = 3;
        return MainThreadError;
    }

    /* D3DDeviceIuWFNg̍쐬(EChEE[h) */
    ZeroMemory( &g_D3DPP, sizeof( g_D3DPP ) );

    g_D3DPP.BackBufferWidth            = 0;
    g_D3DPP.BackBufferHeight           = 0;
    g_D3DPP.BackBufferFormat           = D3DFMT_UNKNOWN;
    g_D3DPP.BackBufferCount            = 2;
    g_D3DPP.MultiSampleType            = D3DMULTISAMPLE_NONE;
    g_D3DPP.MultiSampleQuality         = 0;
    g_D3DPP.SwapEffect                 = D3DSWAPEFFECT_DISCARD;
    g_D3DPP.hDeviceWindow              = g_hWnd;
    g_D3DPP.Windowed                   = TRUE;
    g_D3DPP.EnableAutoDepthStencil     = TRUE;
    g_D3DPP.AutoDepthStencilFormat     = D3DFMT_D24S8;
    g_D3DPP.Flags                      = 0;
    g_D3DPP.FullScreen_RefreshRateInHz = 0;
    g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE;

    hr = g_pD3D->lpVtbl->CreateDevice( g_pD3D, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,
                                       D3DCREATE_MIXED_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice );

    if( FAILED( hr ) )
    {
        hr = g_pD3D->lpVtbl->CreateDevice( g_pD3D, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,
                                           D3DCREATE_SOFTWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice );

        if( FAILED( hr ) )
        {
            MainThreadError = 4;
            return MainThreadError;
        }
    }

    /* r[|[g̐ݒ */
    vp.X       = 0;
    vp.Y       = 0;
    vp.Width   = g_D3DPP.BackBufferWidth;
    vp.Height  = g_D3DPP.BackBufferHeight;
    vp.MinZ    = 0.0f;
    vp.MaxZ    = 1.0f;

    hr = g_pD3DDevice->lpVtbl->SetViewport( g_pD3DDevice, &vp );

    if( FAILED( hr ) )
    {
        MainThreadError = 5;
        return MainThreadError;
    }

    g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                 D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );

    /* D3DXSpriteIuWFNg쐬 */
    hr = D3DXCreateSprite( g_pD3DDevice, &g_pD3DXSprite );

    if( FAILED( hr ) )
    {
        MainThreadError = 6;
        return MainThreadError;
    }

    return 0;
}

/*--------------------------------------------------------------------
   DirectXIuWFNg
 ---------------------------------------------------------------------*/
static void DXRelease()
{
    int i;
    HRESULT hr;

    /* D3DXSpriteIuWFNg̎gpI */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
    }

    /* DirectInput */
    Input_release();

    /* D3DXSpriteIuWFNgj */
    RELEASE( g_pD3DXSprite );

    /* Direct3D DeviceIuWFNg̔j */
    RELEASE( g_pD3DDevice );

	/* Direct3DIuWFNg̔j */
    RELEASE( g_pD3D );

    g_iRefAll--;
    if( g_iRefAll == 0 )
    {
        CoUninitialize();
    }

}


void InitMessageThread( void )
{
    hEventMainThreadStart = CreateEvent( NULL, FALSE, FALSE, NULL );
    hMessageThread = CreateThread( NULL, 0, &MessageThreadProc, 0, 0, &MessageThreadID );
    {
        unsigned long result = WaitForSingleObject( hEventMainThreadStart, INFINITE );
        switch( MainThreadError )
        {
        case 0:
            break;
        case 1:
            DXRuby_raise( ERR_WINDOWCREATE, "RegisterClassEx" );
            break;
        case 2:
            DXRuby_raise( ERR_WINDOWCREATE, "CreateWindow" );
            break;
        case 3:
            DXRuby_raise( ERR_D3DERROR, "Direct3DCreate9" );
            break;
        case 4:
            DXRuby_raise( ERR_D3DERROR, "CreateDevice" );
            break;
        case 5:
            DXRuby_raise( ERR_D3DERROR, "SetViewport" );
            break;
        case 6:
            DXRuby_raise( ERR_D3DERROR, "D3DXCreateSprite" );
            break;
        case 7:
            DXRuby_raise( ERR_D3DERROR, "GetSwapChain" );
            break;
        case 10:
            DXRuby_raise( ERR_DINPUTERROR, "DirectInput8Create" );
            break;
        case 11:
            DXRuby_raise( ERR_DINPUTERROR, "CreateDevice" );
            break;
        case 12:
            DXRuby_raise( ERR_DINPUTERROR, "SetDataFormat" );
            break;
        case 13:
            DXRuby_raise( ERR_DINPUTERROR, "SetCooperativeLevel" );
            break;
        case 14:
            DXRuby_raise( ERR_DINPUTERROR, "EnumDevices" );
            break;
        case 15:
            DXRuby_raise( ERR_DINPUTERROR, "SetDataFormat" );
            break;
        case 16:
            DXRuby_raise( ERR_DINPUTERROR, "SetCooperativeLevel" );
            break;
        case 17:
            DXRuby_raise( ERR_DINPUTERROR, "GetProperty" );
            break;
        case 18:
            DXRuby_raise( ERR_DINPUTERROR, "EnumObjects" );
            break;
        }
    }
}

void ExitMessageThread( void )
{
    DWORD exitcode;

    if( g_hWnd != NULL )
    {
        PostMessage( g_hWnd, WM_DESTROY, 0, 0 );
    }

    do
    {
        if( !GetExitCodeThread( hMessageThread, &exitcode ) )
        {
            rb_raise( eDXRubyError, "Therad exit error - ExitMessageThread" );
        }
        Sleep(1);
    }
    while( exitcode == STILL_ACTIVE );

    /* EChEENX̓o^ */
    UnregisterClass( "DXRuby", g_hInstance );

    CloseHandle( hMessageThread );
}


void WindowCreateMessage( void )
{
    int ret;

    ret = SendMessage( g_hWnd, WM_APP + 1, 0, 0 );
    switch( ret )
    {
    case 0:
        break;
    case 1:
        DXRuby_raise( ERR_NOEXISTSCREENMODE, "Reset" );
        break;
    case 2:
        DXRuby_raise( ERR_INTERNAL, "D3DXCreateTexture" );
        break;
    case 3:
        DXRuby_raise( ERR_INTERNAL, "GetSurfaceLevel" );
        break;
    case 4:
        DXRuby_raise( ERR_INTERNAL, "TestCooperativeLevel" );
        break;
    }
}

void ResetMessage( void )
{
    int ret;
    /* foCXXg̏ꍇ̏ */
    ret = SendMessage( g_hWnd, WM_APP + 0, 0, 0 );
    switch( ret )
    {
    case 0:
        break;
    case 1:
        DXRuby_raise( ERR_INTERNAL, "Reset" );
        break;
    case 2:
        DXRuby_raise( ERR_INTERNAL, "D3DXCreateTexture" );
        break;
    case 3:
        DXRuby_raise( ERR_INTERNAL, "GetSurfaceLevel" );
        break;
    case 4:
        DXRuby_raise( ERR_INTERNAL, "TestCooperativeLevel" );
        break;
    }
}

