/*
###################################
#
# dxruby.c Ver. 0.0.9
#
###################################
*/
#undef DIRECTINPUT_VERSION
#define DIRECTINPUT_VERSION        (0x0800)            /* DirectInputo[W` */
#define WINVER 0x0500            //    o[W` Windows2000ȏ
#define _WIN32_WINNT WINVER

#include "ruby.h"
#include <stdlib.h>
#include <mmsystem.h>
#include <tchar.h>
#include <d3dx9.h>
#include <dmusici.h>
#include <dinput.h>
#include <memory.h>
#include <math.h>

#ifndef RSTRING_PTR
#  define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif
#ifndef RSTRING_LEN
#  define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define RELEASE( x )  if( x ) { x->lpVtbl->Release( x ); x = NULL; }

#define PADMAX 2

#define P_LEFT     0
#define P_RIGHT    1
#define P_UP       2
#define P_DOWN     3
#define P_BUTTON0  4
#define P_BUTTON1  5
#define P_BUTTON2  6
#define P_BUTTON3  7
#define P_BUTTON4  8
#define P_BUTTON5  9
#define P_BUTTON6  10
#define P_BUTTON7  11
#define P_BUTTON8  12
#define P_BUTTON9  13
#define P_BUTTON10 14
#define P_BUTTON11 15
#define P_BUTTON12 16
#define P_BUTTON13 17
#define P_BUTTON14 18
#define P_BUTTON15 19
#define M_LBUTTON   0
#define M_RBUTTON   1
#define M_MBUTTON   2
#define FORMAT_JPEG D3DXIFF_JPG
#define FORMAT_PNG  D3DXIFF_PNG
#define FORMAT_BMP  D3DXIFF_BMP
#define WAVE_RECT 0
#define WAVE_SIN 1
#define WAVE_SAW 2
#define WAVE_TRI 3


static VALUE mWindow;       /* EBhEW[ */
static VALUE mInput;        /* CvbgW[ */
static VALUE cImage;        /* C[WNX       */
static VALUE cSound;        /* TEhNX       */
static VALUE cFont;         /* tHgNX       */
static VALUE cSoundEffect;  /* ʉNX     */
static VALUE eDXRubyError;  /* O                 */


/* O[oϐ */
static HINSTANCE             g_hInstance   = NULL; /* AvP[VCX^X   */
static HANDLE                g_hWind       = NULL; /* EBhEnh             */
static LPDIRECT3D9           g_pD3D        = NULL; /* Direct3DC^[tFCX       */
static LPDIRECT3DDEVICE9     g_pD3DDevice  = NULL; /* Direct3DDeviceC^[tFCX */
static D3DPRESENT_PARAMETERS g_D3DPP;              /* D3DDevice̐ݒ                */
static LPD3DXSPRITE          g_pD3DXSprite = NULL; /* XvCg                     */
static int g_bDeviceLost = FALSE;                  /* foCXXgTRUEɂȂ   */

static LPDIRECTINPUT8        g_pDInput            = NULL; /* DirectInput */
static LPDIRECTINPUTDEVICE8  g_pDIDKeyBoard       = NULL; /* DirectInput̃L[{[hfoCX */
static LPDIRECTINPUTDEVICE8  g_pDIDJoyPad[PADMAX];        /* DirectInput̃pbhfoCX     */
static BYTE g_diKeyState[256];                            /* DirectInputł̃L[{[h͗pobt@ */
static BYTE g_diKeyStateOld[256];                         /* DirectInputł̃L[{[h͗pobt@Pt[O */
static BYTE g_diKeyCount[256];                            /* DirectInputł̃L[{[h͗pJE^ */
static int g_JoystickCount = 0;
static BYTE g_byMouseState_L, g_byMouseStateOld_L;
static BYTE g_byMouseState_M, g_byMouseStateOld_M;
static BYTE g_byMouseState_R, g_byMouseStateOld_R;


static IDirectMusicPerformance8 *g_pDMPerformance = NULL;       /* DirectMusicPerformance8C^[tFCX */
static IDirectMusicLoader8      *g_pDMLoader = NULL;            /* [_[ */
static LPDIRECTSOUND8           g_pDSound = NULL;               /* DirectSoundC^[tFCX */
static int g_iRefDM = 0; /* DirectMusicptH[}X̎QƃJEg */
static int g_iRefDS = 0; /* DirectSound̎QƃJEg */
static int g_iRefAll = 1; /* C^[tF[X̎QƃJEg */


/* Q[p */
static int g_bActive = 0;

/* t[p */
static __int64 g_OneSecondCount       = 0;         /* bԂɃJE^鐔         */
static int     g_isPerformanceCounter = 0;         /* ptH[}XJE^P */
static __int64 g_OldTime              = 0;         /* Õt[I       */
static __int64 g_OneFrameCount        = 0;         /* Pt[̏ɂ     */

/* EBhE\ */
static struct DXRubyWindowInfo {
    int x;              /* W */
    int y;              /* W */
    int width;          /*      */
    int height;         /*    */
    int windowed;       /* EBhE[hQtrue */
    int created;        /* EBhE쐬Qtrue */
    float scale;        /* EBhẼTCY{ */
    int RefreshRate;    /* tbV[g */
    int enablemouse;    /* }EX\邩ǂ */
    int mousewheelpos;  /* }EXzC[̈ʒu */
    int fps;            /* fps */
    int fpscheck;       /* ݂fps */
    int frameskip;      /* R}tO */
    int r;              /* wiNAF Ԑ */
    int g;              /* wiNAF ΐ */
    int b;              /* wiNAF  */
} g_WindowInfo;

/* eNX`f[^ */
struct DXRubyTexture {
    LPDIRECT3DTEXTURE9 pD3DTexture;     /* XvCgɎgeNX`   */
	int width;
	int height;
	int refcount;
};

/* tHgf[^ */
struct DXRubyFont {
    LPD3DXFONT pD3DXFont;       /* tHgIuWFNg   */
};

/* tHgf[^ */
struct DXRubyFontSprite {
    struct DXRubyFont *font;    /* XvCgɎgtHg   */
    VALUE str;                  /* IuWFNg */
    int color;                  /* tHg̐F */
};

/* XvCgf[^ */
struct DXRubySprite {
    void *image;                /* `悷C[WIuWFNg̓tHg */
    int x;                      /* `ʒu x */
    int y;                      /* `ʒu y */
    float angle;                /* ]px */
    float scalex;               /* g嗦 */
    float scaley;               /* cg嗦 */
    float centerx;              /* ]̒S x */
    float centery;              /* ]̒S y */
    unsigned char alpha;        /* At@ijl */
    char addflag :1;            /* AZ̃tO */
    char fontflag :1;           /* tHgȂP */
    char reserve1 :6;           /* \ */
    char reserve2;              /* \ */
};

/* ImageIuWFNg̒g */
struct DXRubyImage {
    struct DXRubyTexture *texture;
    float x;     /* xn_ʒu      */
    float y;     /* yn_ʒu      */
    float width; /* C[W̕   */
    float height;/* C[W̍ */
};

/* SoundIuWFNg */
struct DXRubySound {
    IDirectMusicAudioPath8   *pDMDefAudioPath; /* ftHgI[fBIpX */
    IDirectMusicSegment8     *pDMSegment;        /* ZOg       */
	int start;
	int loopstart;
	int loopend;
	int loopcount;
};

/* SoundEffectIuWFNg */
struct DXRubySoundEffect {
    LPDIRECTSOUNDBUFFER pDSBuffer;    /* obt@         */
};

/* Pad */
static struct DXRubyPadInfo {
    int right;
    int left;
    int up;
    int down;
    LPDIRECTINPUTDEVICE8  pDIDJoyPad; /* DirectInput̃pbhfoCX */
} g_PadInfo[PADMAX];

/* Pad */
static struct DXRubyPadState {
    char button[20];
    int PadConfig[20];
} g_PadState[PADMAX], g_PadStateOld[PADMAX];

/* XvCgz */
static struct DXRubySpriteList {
	float z;                        /* XvCgZW */
	struct DXRubySprite *sprite;    /* XvCg\̂ւ̃|C^ */
} *g_SpriteList;
static int g_SpriteCount;                  /* XvCg̓o^ */
static int g_SpriteAllocateCount;          /* XvCgz̃mې */
static struct DXRubySprite *g_SpriteStruct;

/* V{ */
static VALUE symbol_add     = Qundef;
static VALUE symbol_angle   = Qundef;
static VALUE symbol_alpha   = Qundef;
static VALUE symbol_scalex  = Qundef;
static VALUE symbol_scaley  = Qundef;
static VALUE symbol_centerx = Qundef;
static VALUE symbol_centery = Qundef;
static VALUE symbol_z       = Qundef;
static VALUE symbol_color   = Qundef;

/* L[̃I[gs[gp */
static int g_iInputWait;
static int g_iInterval;

/* vg^Cv錾 */
static void InitWindow( void );
static void InitDXGraphics( void );
static void InitDirectInput( void );
LRESULT CALLBACK MainWndProc( HWND hWnd,UINT msg,UINT wParam,LONG lParam );
static void InitSync( void );
static __int64 GetSystemCounter( void );
static void Window_DirectXRelease( void );
static struct DXRubyTexture *Image_textureload( char *filename, D3DXIMAGE_INFO *psrcinfo );
static void Input_SetConfig( int number, int pad, int key );
static void ChangeSize( void );
static void Input_update( void );
static void Window_update( void );
static void Window_sync( int );
static void Window_create( void );
static void AllocSpriteList( void );
static void SortSpriteList( void );

static void release_Image( struct DXRubyImage* image );
static void release_Font( struct DXRubyFont* font );

/*********************************************************************
 * WindowW[
 * EBhE̊ǗE`sB
 *********************************************************************/

/*--------------------------------------------------------------------
  i֐jEBhE̐Ə
 ---------------------------------------------------------------------*/
static void Window_create( void )
{
    HRESULT hr;
    RECT rect;

    /* EBhẼTCYݒ */
    rect.top     = 0;
    rect.left    = 0;
    rect.right   = g_WindowInfo.width * g_WindowInfo.scale;
    rect.bottom  = g_WindowInfo.height * g_WindowInfo.scale;

    /* EBhẼTCYC */
    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {   /* tXN[ */
        SetWindowLong( g_hWind, GWL_STYLE, WS_POPUP );
        SetWindowPos( g_hWind, HWND_TOP, 0, 0, g_WindowInfo.width, g_WindowInfo.height, SWP_NOZORDER);
    }
    else
    {   /* EBhE[h */
        SetWindowLong( g_hWind, GWL_STYLE, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU );
        AdjustWindowRect( &rect, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU, FALSE );

        /* ƍvZ */
        rect.right   = rect.right - rect.left;
        rect.bottom  = rect.bottom - rect.top;

        /* EBhEړ/TCYݒ */
        if( g_WindowInfo.x == CW_USEDEFAULT )
        {   /* ʒuftHg̏ꍇ */
            SetWindowPos( g_hWind, HWND_TOP, 0, 0, rect.right, rect.bottom, SWP_NOZORDER | SWP_NOMOVE);
        }
        else
        {   /* ʒuw̏ꍇ */
            SetWindowPos( g_hWind, HWND_TOP, g_WindowInfo.x, g_WindowInfo.y, rect.right, rect.bottom, SWP_NOZORDER );
        }
    }

    /* DirectX̃XN[TCYύX */
    ChangeSize();

    /* EBhE\ */
    ShowWindow( g_hWind, SW_SHOWNORMAL );
    UpdateWindow( g_hWind );

    g_WindowInfo.created = Qtrue;

    return;
}


/*--------------------------------------------------------------------
  i֐jXN[TCYύX
 ---------------------------------------------------------------------*/
static void ChangeSize( void )
{
    D3DVIEWPORT9 vp;
    HRESULT hr;


    g_D3DPP.BackBufferWidth    = g_WindowInfo.width;
    g_D3DPP.BackBufferHeight   = g_WindowInfo.height;

    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {
        /* tXN[i32bitColor/60HzŒ) */
        g_D3DPP.BackBufferFormat           = D3DFMT_X8R8G8B8;
        g_D3DPP.Windowed                   = FALSE;
        g_D3DPP.FullScreen_RefreshRateInHz = 60;
        g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_ONE;
        g_WindowInfo.RefreshRate = 60;
    }
    else
    {
        /* EBhE[h */
        g_D3DPP.BackBufferFormat           = D3DFMT_UNKNOWN;
        g_D3DPP.Windowed                   = TRUE;
        g_D3DPP.FullScreen_RefreshRateInHz = 0;
        g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE;
        g_WindowInfo.RefreshRate = 0;
    }

    /* XvCgXg */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
    }

    /* ݒύX */
    hr = g_pD3DDevice->lpVtbl->Reset( g_pD3DDevice, &g_D3DPP );

    if( FAILED( hr ) )
    {
        if( hr == D3DERR_DEVICELOST )
        {
            g_bDeviceLost = TRUE;
        }
        else
        {
            rb_raise( eDXRubyError, "DirectX APǏĂяoɎs܂ - Reset" );
        }
    }

    /* XvCgA */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnResetDevice( g_pD3DXSprite );
    }

    /* r[|[g̐ݒ */
    vp.X       = 0;
    vp.Y       = 0;
    vp.Width   = g_D3DPP.BackBufferWidth;
    vp.Height  = g_D3DPP.BackBufferHeight;
    vp.MinZ    = 0.0f;
    vp.MaxZ    = 1.0f;

    hr = g_pD3DDevice->lpVtbl->SetViewport( g_pD3DDevice, &vp );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ݒɎs܂ - SetViewport" );
    }
}


/*--------------------------------------------------------------------
   Windows̃bZ[W[v
 ---------------------------------------------------------------------*/
static VALUE Window_loop( VALUE obj )
{
    MSG msg;
    VALUE ary[2];
    msg.message = WM_NULL;

    Window_create();

    /* V[̃NA */
    g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                 D3DCOLOR_XRGB( g_WindowInfo.r, g_WindowInfo.g, g_WindowInfo.b ), 0, 0 );
    /* Ƃ肠ʂɏ */
    g_pD3DDevice->lpVtbl->Present( g_pD3DDevice, NULL, NULL, NULL, NULL );

    /* t[ */
    InitSync();

    /* bZ[W[v */
    /* WM_QUIT͂܂ŃbZ[W */
    /* bZ[W̓ubNyield */
    while( msg.message != WM_QUIT )
    {
        if( PeekMessage( &msg, 0, 0, 0, PM_REMOVE ) != 0)
        {
            /* bZ[W鎞 */
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
        else
        {
//__int64 t;
            /* bZ[W */
            /* ͏ԍXV */
            Input_update();
            /* ubNs */
//t = GetSystemCounter();
            rb_yield( obj );
//printf("ruby = %d\n", GetSystemCounter() - t);
            /* fps */
            Window_sync( g_WindowInfo.fps );
            /* ` */
//t = GetSystemCounter();
            Window_update();
//printf("draw = %d\n", GetSystemCounter() - t);
        }
    }

    return Qtrue;
}


/*--------------------------------------------------------------------
   i֐jEBhEvV[W
 ---------------------------------------------------------------------*/
LRESULT CALLBACK MainWndProc( HWND hWnd, UINT msg, UINT wParam, LONG lParam )
{
    RECT rect;
    
    switch( msg )
    {
    /* EBhEANeBu^ANeBu */
    case WM_ACTIVATE:
        g_bActive = (LOWORD(wParam) != 0);
        break;
    /* EBhEj */
    case WM_DESTROY:

        Window_DirectXRelease();

        /* EChE */
        PostQuitMessage( 0 );
        g_hWind = NULL;
        return 0;

    case WM_MOUSEWHEEL:
        g_WindowInfo.mousewheelpos += (short)HIWORD(wParam);
        break;
/*
    case WM_SETCURSOR:
        if( g_pD3DDevice )
        {
            if( LOWORD( lParam ) == HTCLIENT )  // NCAg̈̂
            {
                if( g_WindowInfo.enablemouse == Qfalse )
                {
                    SetCursor( NULL );              // EChE̕WJ[\
                    return TRUE;                    // ݒIƂʒm
                }
            }
        }
        break;
*/
    }

    /* ftHg */
    return DefWindowProc( hWnd, msg, wParam, lParam );
}


/*--------------------------------------------------------------------
   ʃNAFw
 ---------------------------------------------------------------------*/
static VALUE Window_setbgcolor( VALUE obj, VALUE array )
{
    Check_Type(array, T_ARRAY);

    g_WindowInfo.r = NUM2INT( rb_ary_entry(array, 0) );
    g_WindowInfo.g = NUM2INT( rb_ary_entry(array, 1) );
    g_WindowInfo.b = NUM2INT( rb_ary_entry(array, 2) );

    return obj;
}


/*--------------------------------------------------------------------
   `ݒiʏ`j
 ---------------------------------------------------------------------*/
static VALUE Window_draw( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;

    if( argc < 3 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 3);

    AllocSpriteList();

    /* ̃C[WIuWFNg璆go */
    Data_Get_Struct( argv[2], struct DXRubyImage, image );
    if (RDATA(argv[2])->dfree != (RUBY_DATA_FUNC)release_Image)
    {
      rb_raise(rb_eTypeError, "wrong argument type %s (expected Image)", rb_obj_classname( argv[2] ));
    }

    /* DXRubySpriteIuWFNgݒ */
    g_SpriteStruct[g_SpriteCount].image = image;
    g_SpriteStruct[g_SpriteCount].x = NUM2INT( argv[0] );
    g_SpriteStruct[g_SpriteCount].y = NUM2INT( argv[1] );
    g_SpriteStruct[g_SpriteCount].angle  = 0.0f;
    g_SpriteStruct[g_SpriteCount].scalex = 1.0f;
    g_SpriteStruct[g_SpriteCount].scaley = 1.0f;
    g_SpriteStruct[g_SpriteCount].alpha  = 0xff;
    g_SpriteStruct[g_SpriteCount].centerx = image->width / 2;
    g_SpriteStruct[g_SpriteCount].centery = image->height / 2;
    g_SpriteStruct[g_SpriteCount].addflag = 0;
    g_SpriteStruct[g_SpriteCount].fontflag = 0;

    /* Xgf[^ɒǉ */
    g_SpriteList[g_SpriteCount].sprite = &g_SpriteStruct[g_SpriteCount];
    g_SpriteList[g_SpriteCount].z = argc < 4 || argv[3] == Qnil ? 0.0f : NUM2DBL( argv[3] );
    g_SpriteCount++;

    return obj;
}


/*--------------------------------------------------------------------
   `ݒigk`j
 ---------------------------------------------------------------------*/
static VALUE Window_drawScale( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;

    if( argc < 5 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 3);

    AllocSpriteList();

    /* ̃C[WIuWFNg璆go */
    Data_Get_Struct( argv[2], struct DXRubyImage, image );
    if (RDATA(argv[2])->dfree != (RUBY_DATA_FUNC)release_Image)
    {
      rb_raise(rb_eTypeError, "wrong argument type %s (expected Image)", rb_obj_classname( argv[2] ));
    }

    /* DXRubySpriteIuWFNgݒ */
    g_SpriteStruct[g_SpriteCount].image = image;
    g_SpriteStruct[g_SpriteCount].x = NUM2INT( argv[0] );
    g_SpriteStruct[g_SpriteCount].y = NUM2INT( argv[1] );
    g_SpriteStruct[g_SpriteCount].angle  = 0.0f;
    g_SpriteStruct[g_SpriteCount].scalex = NUM2DBL( argv[3] );
    g_SpriteStruct[g_SpriteCount].scaley = NUM2DBL( argv[4] );
    g_SpriteStruct[g_SpriteCount].centerx = argc < 6 || argv[5] == Qnil  ? image->width / 2 : NUM2DBL( argv[5] );
    g_SpriteStruct[g_SpriteCount].centery = argc < 7 || argv[6] == Qnil  ? image->height / 2 : NUM2DBL( argv[6] );
    g_SpriteStruct[g_SpriteCount].alpha  = 0xff;
    g_SpriteStruct[g_SpriteCount].addflag = 0;
    g_SpriteStruct[g_SpriteCount].fontflag = 0;

    /* Xgf[^ɒǉ */
    g_SpriteList[g_SpriteCount].sprite = &g_SpriteStruct[g_SpriteCount];
    g_SpriteList[g_SpriteCount].z = argc < 8 || argv[7] == Qnil ? 0.0f : NUM2DBL( argv[7] );
    g_SpriteCount++;

    return obj;
}


/*--------------------------------------------------------------------
   `ݒi]`j
 ---------------------------------------------------------------------*/
static VALUE Window_drawRot( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;

    if( argc < 4 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 3);

    AllocSpriteList();

    /* ̃C[WIuWFNg璆go */
    Data_Get_Struct( argv[2], struct DXRubyImage, image );
    if (RDATA(argv[2])->dfree != (RUBY_DATA_FUNC)release_Image)
    {
      rb_raise(rb_eTypeError, "wrong argument type %s (expected Image)", rb_obj_classname( argv[2] ));
    }

    /* DXRubySpriteIuWFNgݒ */
    g_SpriteStruct[g_SpriteCount].image = image;
    g_SpriteStruct[g_SpriteCount].x = NUM2INT( argv[0] );
    g_SpriteStruct[g_SpriteCount].y = NUM2INT( argv[1] );
    g_SpriteStruct[g_SpriteCount].angle  = NUM2DBL( argv[3] );
    g_SpriteStruct[g_SpriteCount].scalex = 1.0f;
    g_SpriteStruct[g_SpriteCount].scaley = 1.0f;
    g_SpriteStruct[g_SpriteCount].alpha  = 0xff;
    g_SpriteStruct[g_SpriteCount].addflag = 0;
    g_SpriteStruct[g_SpriteCount].centerx = argc < 5 || argv[4] == Qnil  ? image->width / 2 : NUM2DBL( argv[4] );
    g_SpriteStruct[g_SpriteCount].centery = argc < 6 || argv[5] == Qnil  ? image->height / 2 : NUM2DBL( argv[5] );
    g_SpriteStruct[g_SpriteCount].fontflag = 0;

    /* Xgf[^ɒǉ */
    g_SpriteList[g_SpriteCount].sprite = &g_SpriteStruct[g_SpriteCount];
    g_SpriteList[g_SpriteCount].z = argc < 7 || argv[6] == Qnil ? 0.0f : NUM2DBL( argv[6] );
    g_SpriteCount++;

    return obj;
}


/*--------------------------------------------------------------------
   `ݒi`j
 ---------------------------------------------------------------------*/
static VALUE Window_drawAlpha( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;

    if( argc < 4 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 3);

    AllocSpriteList();

    /* ̃C[WIuWFNg璆go */
    Data_Get_Struct( argv[2], struct DXRubyImage, image );
    if (RDATA(argv[2])->dfree != (RUBY_DATA_FUNC)release_Image)
    {
      rb_raise(rb_eTypeError, "wrong argument type %s (expected Image)", rb_obj_classname( argv[2] ));
    }

    /* DXRubySpriteIuWFNgݒ */
    g_SpriteStruct[g_SpriteCount].image = image;
    g_SpriteStruct[g_SpriteCount].x = NUM2INT( argv[0] );
    g_SpriteStruct[g_SpriteCount].y = NUM2INT( argv[1] );
    g_SpriteStruct[g_SpriteCount].angle  = 0.0f;
    g_SpriteStruct[g_SpriteCount].scalex = 1.0f;
    g_SpriteStruct[g_SpriteCount].scaley = 1.0f;
    g_SpriteStruct[g_SpriteCount].alpha  = NUM2INT( argv[3] );
    g_SpriteStruct[g_SpriteCount].addflag = 0;
    g_SpriteStruct[g_SpriteCount].centerx = image->width / 2;
    g_SpriteStruct[g_SpriteCount].centery = image->height / 2;
    g_SpriteStruct[g_SpriteCount].fontflag = 0;

    /* Xgf[^ɒǉ */
    g_SpriteList[g_SpriteCount].sprite = &g_SpriteStruct[g_SpriteCount];
    g_SpriteList[g_SpriteCount].z = argc < 5 || argv[4] == Qnil ? 0.0f : NUM2DBL( argv[4] );
    g_SpriteCount++;

    return obj;
}


/*--------------------------------------------------------------------
   `ݒiZ`j
 ---------------------------------------------------------------------*/
static VALUE Window_drawAdd( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;

    if( argc < 3 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 3);

    AllocSpriteList();

    /* ̃C[WIuWFNg璆go */
    Data_Get_Struct( argv[2], struct DXRubyImage, image );
    if (RDATA(argv[2])->dfree != (RUBY_DATA_FUNC)release_Image)
    {
      rb_raise(rb_eTypeError, "wrong argument type %s (expected Image)", rb_obj_classname( argv[2] ));
    }

    /* DXRubySpriteIuWFNgݒ */
    g_SpriteStruct[g_SpriteCount].image = image;
    g_SpriteStruct[g_SpriteCount].x = NUM2INT( argv[0] );
    g_SpriteStruct[g_SpriteCount].y = NUM2INT( argv[1] );
    g_SpriteStruct[g_SpriteCount].angle  = 0.0f;
    g_SpriteStruct[g_SpriteCount].scalex = 1.0f;
    g_SpriteStruct[g_SpriteCount].scaley = 1.0f;
    g_SpriteStruct[g_SpriteCount].alpha  = 0xff;
    g_SpriteStruct[g_SpriteCount].addflag = 1;
    g_SpriteStruct[g_SpriteCount].centerx = image->width / 2;
    g_SpriteStruct[g_SpriteCount].centery = image->height / 2;
    g_SpriteStruct[g_SpriteCount].fontflag = 0;

    /* Xgf[^ɒǉ */
    g_SpriteList[g_SpriteCount].sprite = &g_SpriteStruct[g_SpriteCount];
    g_SpriteList[g_SpriteCount].z = argc < 4 || argv[3] == Qnil ? 0.0f : NUM2DBL( argv[3] );
    g_SpriteCount++;

    return obj;
}


/*--------------------------------------------------------------------
   `ݒitIvVj
 ---------------------------------------------------------------------*/
static VALUE Window_drawEx( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;
    VALUE x, y, z, data, angle, scalex, scaley, alpha, centerx, centery, add;
    VALUE option;

    if( argc < 3 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 3);


    if( argc < 4 || argv[3] == Qnil )
    {
        option = rb_hash_new();
    }
    else
    {
        option = argv[3];
    }

    AllocSpriteList();

    add = rb_hash_aref( option, symbol_add );
    angle = rb_hash_aref( option, symbol_angle );
    alpha = rb_hash_aref( option, symbol_alpha );
    scalex = rb_hash_aref( option, symbol_scalex );
    scaley = rb_hash_aref( option, symbol_scaley );
    centerx = rb_hash_aref( option, symbol_centerx );
    centery = rb_hash_aref( option, symbol_centery );
    z = rb_hash_aref( option, symbol_z );

     /* ̃C[WIuWFNg璆go */
    Data_Get_Struct( argv[2], struct DXRubyImage, image );
    if (RDATA(argv[2])->dfree != (RUBY_DATA_FUNC)release_Image)
    {
      rb_raise(rb_eTypeError, "wrong argument type %s (expected Image)", rb_obj_classname( argv[2] ));
    }

    /* DXRubySpriteIuWFNgݒ */
    g_SpriteStruct[g_SpriteCount].image = image;
    g_SpriteStruct[g_SpriteCount].x = NUM2INT( argv[0] );
    g_SpriteStruct[g_SpriteCount].y = NUM2INT( argv[1] );
    g_SpriteStruct[g_SpriteCount].angle   = (angle   == Qnil ? 0.0f             : NUM2DBL( angle   ));
    g_SpriteStruct[g_SpriteCount].scalex  = (scalex  == Qnil ? 1.0f             : NUM2DBL( scalex  ));
    g_SpriteStruct[g_SpriteCount].scaley  = (scaley  == Qnil ? 1.0f             : NUM2DBL( scaley  ));
    g_SpriteStruct[g_SpriteCount].centerx = (centerx == Qnil ? image->width / 2 : NUM2DBL( centerx ));
    g_SpriteStruct[g_SpriteCount].centery = (centery == Qnil ? image->height / 2 : NUM2DBL( centery ));
    g_SpriteStruct[g_SpriteCount].alpha   = (alpha   == Qnil ? 0xff             : NUM2INT( alpha   ));
    g_SpriteStruct[g_SpriteCount].addflag = (add == Qnil || add == Qfalse ) ? 0 : 1;
    g_SpriteStruct[g_SpriteCount].fontflag = 0;

    /* Xgf[^ɒǉ */
    g_SpriteList[g_SpriteCount].sprite = &g_SpriteStruct[g_SpriteCount];
    g_SpriteList[g_SpriteCount].z = z == Qnil ? 0.0f : NUM2DBL( z );
    g_SpriteCount++;

    return obj;
}


/*--------------------------------------------------------------------
   tHg`
 ---------------------------------------------------------------------*/
static VALUE Window_drawFont( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubySprite *spr;
    struct DXRubyFont *font;
    VALUE color;
    int cr, cg, cb;
    VALUE z, angle, scalex, scaley, alpha, centerx, centery, add;
    VALUE option;
    struct DXRubyFontSprite *fontsprite;

    if( argc < 4 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 4);


    Check_Type(argv[2], T_STRING);

    if( argc < 5 || argv[4] == Qnil )
    {
        option = rb_hash_new();
    }
    else
    {
        option = argv[4];
    }

    add = rb_hash_aref( option, symbol_add );
    angle = rb_hash_aref( option, symbol_angle );
    alpha = rb_hash_aref( option, symbol_alpha );
    scalex = rb_hash_aref( option, symbol_scalex );
    scaley = rb_hash_aref( option, symbol_scaley );
    centerx = rb_hash_aref( option, symbol_centerx );
    centery = rb_hash_aref( option, symbol_centery );
    z = rb_hash_aref( option, symbol_z );
    color = rb_hash_aref( option, symbol_color );

    AllocSpriteList();

    /* ̃tHgIuWFNg璆go */
    Data_Get_Struct( argv[3], struct DXRubyFont, font );
    if (RDATA(argv[3])->dfree != (RUBY_DATA_FUNC)release_Font)
    {
      rb_raise(rb_eTypeError, "wrong argument type %s (expected Font)", rb_obj_classname( argv[3] ));
    }

    fontsprite = ALLOC( struct DXRubyFontSprite );
    if( fontsprite == NULL )
    {
        rb_raise( eDXRubyError, "tHgp̊mۂɎs܂" );
    }
    /* DXRubySpriteIuWFNgݒ */
    g_SpriteStruct[g_SpriteCount].image = fontsprite;
    g_SpriteStruct[g_SpriteCount].x = NUM2INT( argv[0] );
    g_SpriteStruct[g_SpriteCount].y = NUM2INT( argv[1] );
    g_SpriteStruct[g_SpriteCount].angle   = (angle   == Qnil ? 0.0f             : NUM2DBL( angle ));
    g_SpriteStruct[g_SpriteCount].scalex  = (scalex  == Qnil ? 1.0f             : NUM2DBL( scalex ));
    g_SpriteStruct[g_SpriteCount].scaley  = (scaley  == Qnil ? 1.0f             : NUM2DBL( scaley ));
    g_SpriteStruct[g_SpriteCount].centerx = (centerx == Qnil ? 0.0f             : NUM2DBL( centerx ));;
    g_SpriteStruct[g_SpriteCount].centery = (centery == Qnil ? 0.0f             : NUM2DBL( centery ));;
    g_SpriteStruct[g_SpriteCount].alpha   = (alpha   == Qnil ? 0xff             : NUM2INT( alpha ));
    g_SpriteStruct[g_SpriteCount].addflag = (add == Qnil || add == Qfalse ) ? 0 : 1;
    g_SpriteStruct[g_SpriteCount].fontflag = 1;
    fontsprite->str = argv[2];
    if( color != Qnil )
    {
        Check_Type(color, T_ARRAY);
        cr = NUM2INT(rb_ary_entry(color, 0));
        cg = NUM2INT(rb_ary_entry(color, 1));
        cb = NUM2INT(rb_ary_entry(color, 2));
    }
    else
    {
        cr = 255;
        cg = 255;
        cb = 255;
    }
    fontsprite->color = D3DCOLOR_XRGB(cr, cg, cb);
    fontsprite->font = font;

    /* Xgf[^ɒǉ */
    g_SpriteList[g_SpriteCount].sprite = &g_SpriteStruct[g_SpriteCount];
    g_SpriteList[g_SpriteCount].z = z == Qnil ? 0.0f : NUM2DBL( z );
    g_SpriteCount++;

    return obj;
}


typedef struct tag_dx_TLVERTEX {
    float           x, y, z;
    D3DCOLOR        color;
    float           tu, tv;
}TLVERTX, *LPTLVERTEX;

/*--------------------------------------------------------------------
   i֐jʍXV
 ---------------------------------------------------------------------*/
static void Window_update( void )
{
    HRESULT hr;
    static int max;

    /* foCXXg̕ */
    if( g_bDeviceLost )
    {
        Sleep( 100 );    /* 0.1b҂ */

        /* foCXԂ̃`FbN */
        hr  = g_pD3DDevice->lpVtbl->TestCooperativeLevel( g_pD3DDevice );
        if( FAILED( hr ) )
        {
            if( hr == D3DERR_DEVICELOST )
                return;  /* foCX̓XgԂł */

            if( hr != D3DERR_DEVICENOTRESET ) /* 悭킩G[ */
            {
                   rb_raise( eDXRubyError, "DirectX APǏĂяoɎs܂ - TestCooperativeLevel" );
            }

            /* ֗̓foCXZbg\Ԃł */
            /* XvCgXg */
            if( g_pD3DXSprite )
            {
                g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
            }

            hr = g_pD3DDevice->lpVtbl->Reset( g_pD3DDevice, &g_D3DPP ); /* ݂ */

            if( FAILED( hr ) )
            {
                if( hr == D3DERR_DEVICELOST )
                {
                    return; /* ܂Xg */
                }
                rb_raise( eDXRubyError, "DirectX APǏĂяoɎs܂ - Reset" );
            }

            if( g_pD3DXSprite ) /* XvCgA */
            {
                g_pD3DXSprite->lpVtbl->OnResetDevice( g_pD3DXSprite );
            }

        }
        /* foCX */
        g_bDeviceLost = FALSE;
    }

    /* `Ώۂ1Ε`揈̂̂sȂ */
    if( g_SpriteCount == 0 )
    {
	    /* V[̕\ */
	    hr = g_pD3DDevice->lpVtbl->Present( g_pD3DDevice, NULL, NULL, NULL, NULL );
	    /* foCXXg */
	    if( hr == D3DERR_DEVICELOST )
	    {
	        g_bDeviceLost = TRUE;
	    }
        return;
    }

    /* V[̃NA */
    g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                 D3DCOLOR_XRGB( g_WindowInfo.r, g_WindowInfo.g, g_WindowInfo.b ), 0, 0 );

	/* V[̕`Jn */
    if( SUCCEEDED( g_pD3DDevice->lpVtbl->BeginScene( g_pD3DDevice ) ) )
    {
		int i;
    	int oldflag = 0;

        /* XvCg̕`Jn */
        g_pD3DXSprite->lpVtbl->Begin( g_pD3DXSprite, D3DXSPRITE_ALPHABLEND );

        /* XvCgz\[g */
        SortSpriteList();

        /* XvCgXgɓo^ꂽ̂̂XvCgɕ` */
    	for( i = 0; i < g_SpriteCount; i++ )
    	{
        	float angle;
    		struct DXRubySprite *temp;

    		temp = g_SpriteList[i].sprite;

    		if( temp->addflag != oldflag ) 
        	{
	    		if( temp->addflag == 1) 
        		{
					g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_ONE);	/* Z̐ݒ */
	        	}
				else
    			{
					g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);	/*  */
	        	}
	    	}

        	oldflag = temp->addflag;

            angle = 3.141592653589793115997963468544185161590576171875f / 180.0f * temp->angle;

            if( temp->fontflag == 0)
            {
                TLVERTX VertexDataTbl[4];
                struct DXRubyImage *image = temp->image;
                float sina = sin(angle);
                float cosa = cos(angle);
                float data1x = temp->scalex * cosa;
                float data2x = temp->scalex * sina;
                float data1y = temp->scaley * sina;
                float data2y = temp->scaley * cosa;
                float tu1 = image->x / image->texture->width;
                float tu2 = (image->x + image->width) / image->texture->width;
                float tv1 = image->y / image->texture->height;
                float tv2 = (image->y + image->height) / image->texture->height;
                float centerx = temp->centerx;
                float centery = temp->centery;
                float x = temp->x;
                float y = temp->y;
                float width = image->width;
                float height = image->height;

                /* _P̃f[^ */
                VertexDataTbl[0].x      =  -centerx * data1x - (-centery) * data1y + x + centerx;
                VertexDataTbl[0].y      =  -centerx * data2x + (-centery) * data2y + y + centery;
                VertexDataTbl[0].z      =  0.0f;                                    /* yW */
                VertexDataTbl[0].tu     =  tu1;                                     /* eNX`̂wW */
                VertexDataTbl[0].tv     =  tv1;                                     /* eNX`̂xW */
                VertexDataTbl[0].color  =  D3DCOLOR_ARGB(temp->alpha,255,255,255);  /* _F */
                /* _Q̃f[^ */
                VertexDataTbl[1].x      =  (-centerx+width) * data1x - (-centery) * data1y + x + centerx;
                VertexDataTbl[1].y      =  (-centerx+width) * data2x + (-centery) * data2y + y + centery;
                VertexDataTbl[1].z      =  0.0f;
                VertexDataTbl[1].tu     =  tu2;
                VertexDataTbl[1].tv     =  tv1;
                VertexDataTbl[1].color  =  D3DCOLOR_ARGB(temp->alpha,255,255,255);
                /* _R̃f[^ */
                VertexDataTbl[2].x      =  (-centerx+width) * data1x - (-centery+height) * data1y + x + centerx;
                VertexDataTbl[2].y      =  (-centerx+width) * data2x + (-centery+height) * data2y + y + centery;
                VertexDataTbl[2].z      =  0.0f;
                VertexDataTbl[2].tu     =  tu2;
                VertexDataTbl[2].tv     =  tv2;
                VertexDataTbl[2].color  =  D3DCOLOR_ARGB(temp->alpha,255,255,255);
                /* _S̃f[^ */
                VertexDataTbl[3].x      =  (-centerx) * data1x - (-centery+height) * data1y + x + centerx;
                VertexDataTbl[3].y      =  (-centerx) * data2x + (-centery+height) * data2y + y + centery;
                VertexDataTbl[3].z      =  0.0f;
                VertexDataTbl[3].tu     =  tu1;
                VertexDataTbl[3].tv     =  tv2;
                VertexDataTbl[3].color  =  D3DCOLOR_ARGB(temp->alpha,255,255,255);

                /* eNX`Zbg */
                g_pD3DDevice->lpVtbl->SetTexture(g_pD3DDevice, 0, (IDirect3DBaseTexture9*)image->texture->pD3DTexture);

                /* foCXɎgp钸_tH[}bgZbg */
                g_pD3DDevice->lpVtbl->SetFVF(g_pD3DDevice, D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1);

                /* ` */
                g_pD3DDevice->lpVtbl->DrawPrimitiveUP(g_pD3DDevice, D3DPT_TRIANGLEFAN, 2, VertexDataTbl, sizeof(TLVERTX));
            }
            else
            {
                D3DVECTOR vector;
                D3DXMATRIX matrix;
                D3DXMATRIX matrix_t;
                RECT rect;

                /* ]yъgk */
                D3DXMatrixScaling    ( &matrix_t, temp->scalex, temp->scaley, 1 );
                D3DXMatrixRotationZ  ( &matrix  , angle );
                D3DXMatrixMultiply   ( &matrix  , &matrix_t, &matrix );

                /* sړ */
                D3DXMatrixTranslation( &matrix_t, (float)temp->x + temp->centerx, (float)temp->y + temp->centery, 0 );
                D3DXMatrixMultiply   ( &matrix  , &matrix, &matrix_t );

                g_pD3DXSprite->lpVtbl->SetTransform( g_pD3DXSprite, &matrix );

                rect.left   = -temp->centerx;
                rect.top    = -temp->centery;
                rect.right  = temp->centerx;
                rect.bottom = temp->centery;
                ((struct DXRubyFontSprite *)temp->image)->font->pD3DXFont->lpVtbl->DrawText(((struct DXRubyFontSprite *)temp->image)->font->pD3DXFont, g_pD3DXSprite,
                                                        RSTRING_PTR(((struct DXRubyFontSprite *)temp->image)->str),
                                                        -1,
                                                        &rect,
                                                        DT_LEFT | DT_NOCLIP,
                                                        ((int)temp->alpha << 24) | ((struct DXRubyFontSprite *)temp->image)->color & 0x00ffffff);
                g_pD3DXSprite->lpVtbl->Flush( g_pD3DXSprite );
                xfree( temp->image );
            }
        }

        /* XvCg̕`I */
        g_pD3DXSprite->lpVtbl->End( g_pD3DXSprite );

        /* V[̕`I */
        g_pD3DDevice->lpVtbl->EndScene( g_pD3DDevice );
    }

    /* V[̕\ */
    hr = g_pD3DDevice->lpVtbl->Present( g_pD3DDevice, NULL, NULL, NULL, NULL );

    /* foCXXg */
    if( hr == D3DERR_DEVICELOST )
    {
        g_bDeviceLost = TRUE;
    }

    g_SpriteCount = 0;
    return;
}


/*--------------------------------------------------------------------
  i֐jt[
 ---------------------------------------------------------------------*/
static void Window_sync( int frame )
{
    __int64 NowTime;
    __int64 WaitTime;
    static __int64 BeforeSecond = 0;
    static int fps = 0;
    static int skip = 0;

    NowTime = GetSystemCounter();
    g_OneFrameCount = NowTime - g_OldTime;

    /* EBhE[h */
    if( g_WindowInfo.windowed != Qnil && g_WindowInfo.windowed != Qfalse )
    {
        if ( frame > 0 ) /* fpsw肪nil or 0̎WaitȂ */
        {
            __int64 SleepTime;

            WaitTime = g_OneSecondCount / frame;

            /* ɑO񂩂Pt[̎ԂoĂ */
            if( g_OldTime + WaitTime < NowTime && skip == 0 )
            {
                /* R}䂵Ȃꍇ */
                if( g_WindowInfo.frameskip == Qfalse )
                {
                    fps++;
                    g_OldTime = NowTime;
                }
                else /* ꍇ */
                {
                    /* ̓EFCg`Ȃ */
                    skip++;
                    g_SpriteCount = 0;
                    g_OldTime = g_OldTime + WaitTime;
                }
            }
            else
            {
                /* O`΂̂ɍԂɍĂȂꍇ */
                if( g_OldTime + WaitTime < NowTime && skip == 1 )
                {
                    /* ߂ď */
                    g_OldTime = NowTime;
                }
                else
                {
                    __int64 TempTime;
                    /* ܂ȎԂSleepő҂ */
                    TempTime = GetSystemCounter();
                    SleepTime = (WaitTime - (TempTime - g_OldTime)) * 1000 / g_OneSecondCount;
                    if( SleepTime > 2 )
                    {
                        Sleep( (unsigned long)(SleepTime - 2) );
                    }

                    TempTime = GetSystemCounter();

                    /* [vŌɏ */
                    for ( ; ; )
                    {
                        TempTime = GetSystemCounter();
                        if( g_OldTime +  WaitTime < TempTime )
                        {
                            break;
                        }
                    }
                    g_OldTime = g_OldTime +  WaitTime;
                }
                skip = 0;
                fps++;
            }
        }
        else
        {
            g_OldTime = NowTime;
            fps++;
        }

        /* FPSlݒ */
        if( (NowTime - BeforeSecond) >= g_OneSecondCount )
        {
            BeforeSecond = NowTime;
            g_WindowInfo.fpscheck = fps;
            fps = 0;
        }
    }
    else
    {
        WaitTime = g_OneSecondCount / g_WindowInfo.RefreshRate;

        /* ɑO񂩂Pt[̎ԂoĂ */
        if( g_OldTime +  WaitTime < NowTime && skip == 0 )
        {
            /* ̓EFCg`Ȃ */
            skip++;
            g_SpriteCount = 0;
            g_OldTime = NowTime;
            return;
        }

        skip = 0;

        g_OldTime = g_OldTime +  WaitTime;
    }

    return;
}
/*--------------------------------------------------------------------
  i֐jt[pJE^l擾
 ---------------------------------------------------------------------*/
static __int64 GetSystemCounter( void )
{
    __int64 time;

    if( g_isPerformanceCounter == 1 )
    {
        QueryPerformanceCounter( (LARGE_INTEGER *)&time );
        return time;
    }
    else
    {
        return timeGetTime();
    }
}


/*--------------------------------------------------------------------
   EBhẼ[hiEBhE/Sʁjݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setwindowed( VALUE obj, VALUE windowed )
{
    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eDXRubyError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_setwindowed" );
    }

    g_WindowInfo.windowed = windowed;
    return g_WindowInfo.windowed;
}


/*--------------------------------------------------------------------
   EBhËʒuixWjݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setx( VALUE obj, VALUE x )
{
    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eDXRubyError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_setx" );
    }

    g_WindowInfo.x = NUM2INT( x );
    return x;
}


/*--------------------------------------------------------------------
   EBhËʒuiyWjݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_sety( VALUE obj , VALUE y )
{
    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eDXRubyError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_sety" );
    }

    g_WindowInfo.y = NUM2INT( y );
    return y;
}


/*--------------------------------------------------------------------
   EBhẼTCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setwidth( VALUE obj, VALUE width )
{
    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eDXRubyError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_setwidth" );
    }

    g_WindowInfo.width = NUM2INT( width );
    return width;
}


/*--------------------------------------------------------------------
   EBhẼTCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setheight( VALUE obj , VALUE height)
{
    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eDXRubyError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_setheight" );
    }

    g_WindowInfo.height = NUM2INT( height );
    return height;
}


/*--------------------------------------------------------------------
  EBhE^Cgݒ
 ---------------------------------------------------------------------*/
static VALUE Window_setCaption( VALUE obj, VALUE caption )
{
    Check_Type(caption, T_STRING);

    SetWindowText( g_hWind, RSTRING_PTR( caption ) );

    return caption;
}


/*--------------------------------------------------------------------
  EBhẼTCY{ݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_setScale( VALUE obj, VALUE scale )
{
    g_WindowInfo.scale = NUM2DBL(scale);

    return scale;
}


/*--------------------------------------------------------------------
  fpslݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_setfps( VALUE obj, VALUE fps )
{
    g_WindowInfo.fps = fps == Qnil ? 0 : NUM2INT(fps);

    return fps;
}


/*--------------------------------------------------------------------
  fpsl擾
 ---------------------------------------------------------------------*/
static VALUE Window_getfps( VALUE obj )
{
    return INT2FIX( g_WindowInfo.fpscheck );
}


/*--------------------------------------------------------------------
  1t[ׂ̏Ŏ擾
 ---------------------------------------------------------------------*/
static VALUE Window_getload( VALUE obj )
{
    if( g_WindowInfo.fps == 0 )
    {
        return INT2FIX( 0 );
    }
    return rb_float_new( (double) ( (double)g_OneFrameCount * 100.0 / ((double)g_OneSecondCount / (double)g_WindowInfo.fps )) );
}


/*--------------------------------------------------------------------
  t[XLbvon/offݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_setframeskip( VALUE obj, VALUE skip )
{
    g_WindowInfo.frameskip = (skip == Qnil || skip == Qfalse) ? Qfalse : Qtrue;

    return skip;
}


/*--------------------------------------------------------------------
  t@CI[v_CAO\
 ---------------------------------------------------------------------*/
static VALUE Window_openDialog(VALUE obj, VALUE vfilter, VALUE vtitle)
{
    OPENFILENAME OFN; 
    char buf[MAX_PATH*2];
	VALUE filter;
	buf[0] = 0;

	Check_Type(vfilter, T_ARRAY);
	Check_Type(vtitle, T_STRING);

	ZeroMemory(&OFN,sizeof(OPENFILENAME));
    OFN.lStructSize = sizeof(OPENFILENAME); 
    OFN.hwndOwner = g_hWind;

	OFN.lpstrFilter = "ׂẴt@C (*.*)\0*.*\0\0";
	filter = rb_ary_join( vfilter, rb_str_new( "\0", 1 ) );
	filter = rb_str_cat( filter, "\0", 1 );
	OFN.lpstrFilter = RSTRING_PTR(filter);
    OFN.lpstrFile = buf;
    OFN.nMaxFile = MAX_PATH*2;
    OFN.Flags = OFN_FILEMUSTEXIST;
	OFN.lpstrTitle = RSTRING_PTR(vtitle);
	OFN.lpstrDefExt = 0;
	if( !GetOpenFileName(&OFN) )
	{
        rb_raise( eDXRubyError, "t@C̑IɎs܂" );
	}

	return rb_str_new2( buf );
}


/*--------------------------------------------------------------------
  t@CZ[u_CAO\
 ---------------------------------------------------------------------*/
static VALUE Window_saveDialog(VALUE obj, VALUE vfilter, VALUE vtitle)
{
    OPENFILENAME OFN; 
    char buf[MAX_PATH*2];
	VALUE filter;
	buf[0] = 0;

	Check_Type(vfilter, T_ARRAY);
	Check_Type(vtitle, T_STRING);

	ZeroMemory(&OFN,sizeof(OPENFILENAME));
    OFN.lStructSize = sizeof(OPENFILENAME); 
    OFN.hwndOwner = g_hWind;

	OFN.lpstrFilter = "ׂẴt@C (*.*)\0*.*\0\0";
	filter = rb_ary_join( vfilter, rb_str_new( "\0", 1 ) );
	filter = rb_str_cat( filter, "\0", 1 );
	OFN.lpstrFilter = RSTRING_PTR(filter);
    OFN.lpstrFile = buf;
    OFN.nMaxFile = MAX_PATH*2;
    OFN.Flags = OFN_CREATEPROMPT | OFN_OVERWRITEPROMPT;
	OFN.lpstrTitle = RSTRING_PTR(vtitle);
	OFN.lpstrDefExt = 0;
	if( !GetSaveFileName(&OFN) )
	{
        rb_raise( eDXRubyError, "t@C̑IɎs܂" );
	}

	return rb_str_new2( buf );
}


/*--------------------------------------------------------------------
   IɎs
 ---------------------------------------------------------------------*/
static VALUE Window_shutdown( VALUE obj )
{
	/* }EXԕ */
    if( g_WindowInfo.enablemouse == Qfalse )
    {
        ShowCursor( TRUE );
    }

    /* Xg */
	g_SpriteCount = 0;

    /* DirectX */
    Window_DirectXRelease();

    /* EChEENX̓o^ */
    UnregisterClass( "DXRuby", g_hInstance );

    /* t[̌n */
    timeEndPeriod( 1 );

	g_iRefAll--;
	if( g_iRefAll == 0 )
	{
		CoUninitialize();
	}

    return obj;
}


/*--------------------------------------------------------------------
   DirectXIuWFNg
 ---------------------------------------------------------------------*/
void Window_DirectXRelease()
{
    int i;
    HRESULT hr;

    /* XvCgIuWFNg̎gpI */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
    }

    /* XvCgIuWFNgj */
    RELEASE( g_pD3DXSprite );

    for( i = 0 ; i < g_JoystickCount; i++ )
    {
        /* DirectInputDevice(JoyPad)IuWFNg̎gpI */
        if( g_pDIDJoyPad[i] )
        {
            g_pDIDJoyPad[i]->lpVtbl->Unacquire( g_pDIDJoyPad[i] ); 
        }

        /* DirectInputDevide(JoyPad)IuWFNg̔j */
        RELEASE( g_pDIDJoyPad[i] );
    }

    /* DirectInputDevice(Keyboard)IuWFNg̎gpI */
    if( g_pDIDKeyBoard )
    {
           g_pDIDKeyBoard->lpVtbl->Unacquire( g_pDIDKeyBoard ); 
    }

    /* DirectInputDevide(Keyboard)IuWFNg̔j */
    RELEASE( g_pDIDKeyBoard );

    /* DirectInputIuWFNg̔j */
    RELEASE( g_pDInput );

    /* Direct3D DeviceIuWFNg̔j */
    RELEASE( g_pD3DDevice );

	/* Direct3DIuWFNg̔j */
    RELEASE( g_pD3D );
}


/*--------------------------------------------------------------------
   XN[VbgB
 ---------------------------------------------------------------------*/
static VALUE Window_getScreenShot( int argc, VALUE *argv, VALUE obj )
{
	HRESULT hr;
	D3DDISPLAYMODE dmode;
	LPDIRECT3DSURFACE9 pSurface;
	RECT rect;
    VALUE filename, format;

    rb_scan_args( argc, argv, "11", &filename, &format );

	/* ݂̃fBXvC̃tH[}bgȂǂ擾 */
	hr = g_pD3D->lpVtbl->GetAdapterDisplayMode(g_pD3D, D3DADAPTER_DEFAULT, &dmode);
	if( FAILED( hr ) )
	{
        rb_raise( eDXRubyError, "Lv`Ɏs܂ - GetAdapterDisplayMode" );
    }

	/* Lv`pT[tFX쐬 */
	hr = g_pD3DDevice->lpVtbl->CreateOffscreenPlainSurface(g_pD3DDevice,
			dmode.Width,
			dmode.Height,
			D3DFMT_A8R8G8B8,
			D3DPOOL_SCRATCH, &pSurface, NULL);
	if( FAILED( hr ) )
	{
        rb_raise( eDXRubyError, "Lv`Ɏs܂ - CreateOffscreenPlainSurface" );
    }
	/* Lv` */
	hr = g_pD3DDevice->lpVtbl->GetFrontBufferData(g_pD3DDevice, 0, pSurface);
	if( FAILED( hr ) )
	{
		RELEASE(pSurface);
        rb_raise( eDXRubyError, "Lv`Ɏs܂ - GetFrontBufferData" );
	}

	/* T[tFX̕ۑ */
	if( g_D3DPP.Windowed )
	{
		POINT p = { 0, 0 };
		ClientToScreen(g_hWind  , &p);
		rect.left = p.x; rect.top = p.y;
		p.x = g_D3DPP.BackBufferWidth * g_WindowInfo.scale;
		p.y = g_D3DPP.BackBufferHeight * g_WindowInfo.scale;
		ClientToScreen(g_hWind, &p);
		rect.right = p.x; rect.bottom = p.y;
	}
	hr = D3DXSaveSurfaceToFile(
			RSTRING_PTR( filename ),							/* ۑt@C */
			format == Qnil ? D3DXIFF_JPG : FIX2INT( format ),	/* t@CtH[}bg */
			pSurface,											/* ۑT[tFX */
			NULL,												/* pbg */
			g_D3DPP.Windowed ? &rect : NULL);					/* ۑ̈ */
	RELEASE(pSurface);
	if( FAILED( hr ) )
	{
        rb_raise( eDXRubyError, "Lv`Ɏs܂ - D3DXSaveSurfaceToFile" );
    }

	return obj;
}



/*********************************************************************
 * ImageNX
 *
 * `p̉摜ێNXB
 * t@CnloadƓǂݍ܂AWindow::drawɓnĕ`悷B
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Image( struct DXRubyImage* image )
{
    /* eNX`IuWFNg̊J */
    if( image )
    {
    	if( image->texture )
    	{
	    	image->texture->refcount--;
	    	if( image->texture->refcount == 0 )
	    	{
				RELEASE( image->texture->pD3DTexture );
				free( image->texture );
	    	}
    	}
        free( image );
        image = NULL;

    	g_iRefAll--;
    	if( g_iRefAll == 0 )
    	{
    		CoUninitialize();
    	}
    }
}


/*--------------------------------------------------------------------
   ImgaeNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Image_allocate( VALUE klass )
{
    VALUE obj;
    struct DXRubyImage *image;

    /* DXRubyImagẽ擾ImageIuWFNg */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_allocate" );
    obj = Data_Wrap_Struct(klass, 0, release_Image, image);

    /* Ƃ肠eNX`IuWFNgNULLɂĂ */
    image->texture = NULL;

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(pbox`)
 ---------------------------------------------------------------------*/
static void fill( int x1, int y1, int x2, int y2, int col, struct DXRubyImage *image )
{
    D3DLOCKED_RECT texrect;
    int x, y;

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, NULL, 0 );
    for( y = y1; y <= y2; y++ )
    {
        for( x = x1; x <= x2; x++ )
        {
            *((int*)((char *)texrect.pBits + 
                ( x + (int)image->x ) * 4 +
                ( y + (int)image->y ) * texrect.Pitch)) = col;
        }
    }
    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );
    return;
}
/*--------------------------------------------------------------------
   ImgaeNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Image_initialize( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    HRESULT hr;
    D3DSURFACE_DESC desc;

    if( argc < 2 ) rb_raise(rb_eArgError, "wrong number of arguments (%d for %d)", argc, 2);

	/* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );

    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_initialize" );
    }

    /* t@CǂݍŃeNX`IuWFNg쐬 */
    hr = D3DXCreateTexture( g_pD3DDevice, NUM2INT( argv[0] ), NUM2INT( argv[1] ),
                                      1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                      &texture->pD3DTexture);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "eNX`̍쐬Ɏs܂ - Image_initialize" );
    }

	texture->refcount = 1;

	texture->pD3DTexture->lpVtbl->GetLevelDesc(texture->pD3DTexture, 0, &desc );
	texture->width = desc.Width;
    texture->height = desc.Height;

	/* ImageIuWFNgݒ */
    Data_Get_Struct( obj, struct DXRubyImage, image );

    image->texture = texture;
    image->x = 0;
    image->y = 0;
    image->width = NUM2INT( argv[0] );
    image->height = NUM2INT( argv[1] );

    g_iRefAll++;

    if( argc > 2 )
    {
        int col;
        col   = NUM2INT(RARRAY_PTR(argv[2])[0])<<24 | NUM2INT(RARRAY_PTR(argv[2])[1])<<16 |
                NUM2INT(RARRAY_PTR(argv[2])[2])<<8  | NUM2INT(RARRAY_PTR(argv[2])[3]);
        fill( 0, 0, image->width - 1, image->height - 1, col, image );
    }
    return obj;
}


/*--------------------------------------------------------------------
   ImgaeNXload
 ---------------------------------------------------------------------*/
static VALUE Image_load( int argc, VALUE *argv, VALUE klass )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    D3DXIMAGE_INFO srcinfo;
	D3DSURFACE_DESC desc;
    HRESULT hr;
    VALUE filename, width, height, obj;

    /* foCXIuWFNg̏`FbN */
    if( g_pD3DDevice == NULL )
    {
        rb_raise( eDXRubyError, "DirectX GraphicsĂ܂" );
    }

    rb_scan_args( argc, argv, "12", &filename, &width, &height );

	Check_Type(filename, T_STRING);

	/* t@C擾 */
    hr = D3DXGetImageInfoFromFile( RSTRING_PTR( filename ), &srcinfo );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̓ǂݍ݂Ɏs܂ - %s", RSTRING_PTR( filename ) );
    }

    /* eNX`[h */
    texture = Image_textureload( RSTRING_PTR( filename ), &srcinfo );
	texture->refcount = 1;

	texture->pD3DTexture->lpVtbl->GetLevelDesc(texture->pD3DTexture, 0, &desc );
	texture->width = desc.Width;
    texture->height = desc.Height;

    /* ImageIuWFNgݒ */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_load" );
    obj = Data_Wrap_Struct(cImage, 0, release_Image, image);

    image->texture = texture;
    image->x = 0;
    image->y = 0;
    image->width = (width  == Qnil ? srcinfo.Width  : NUM2INT( width ));
    image->height = (height == Qnil ? srcinfo.Height : NUM2INT( height ));

	g_iRefAll++;

	return obj;
}


/*--------------------------------------------------------------------
   ImgaeIuWFNg̕쐬
 ---------------------------------------------------------------------*/
static VALUE Image_loadToArray( VALUE klass, VALUE filename, VALUE vx, VALUE vy )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    int i, j, x, y;
    VALUE obj;
    VALUE array;
    D3DXIMAGE_INFO srcinfo;
	D3DSURFACE_DESC desc;
    HRESULT hr;


    /* foCXIuWFNg̏`FbN */
    if( g_pD3DDevice == NULL )
    {
        rb_raise( eDXRubyError, "DirectX GraphicsĂ܂" );
    }

	Check_Type(filename, T_STRING);
	x = NUM2INT( vx );
	y = NUM2INT( vy );

	/* t@C擾 */
    hr = D3DXGetImageInfoFromFile( RSTRING_PTR( filename ), &srcinfo );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̓ǂݍ݂Ɏs܂ - %s", RSTRING_PTR( filename ) );
    }

    /* eNX`[h */
    texture = Image_textureload( RSTRING_PTR( filename ), &srcinfo );
	texture->refcount = x * y;

	texture->pD3DTexture->lpVtbl->GetLevelDesc(texture->pD3DTexture, 0, &desc );
	texture->width = desc.Width;
    texture->height = desc.Height;

    /* Rubyz쐬 */
    array = rb_ary_new();

    for( i = 0; i < y; i++ )
    {
        for( j = 0; j < x; j++ )
        {
            /* DXRubyImagẽ擾ImageIuWFNg */
            image = malloc(sizeof(struct DXRubyImage));
            if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_loadToArray" );
            obj = Data_Wrap_Struct(cImage, 0, release_Image, image);

            image->texture = texture;
            image->x = j * srcinfo.Width / x;
            image->y = i * srcinfo.Height / y;
            image->width = srcinfo.Width / x;
            image->height = srcinfo.Height / y;

            rb_ary_push(array, obj);
			g_iRefAll++;
        }
    }

    return array;
}


/*--------------------------------------------------------------------
   Texture[h
 ---------------------------------------------------------------------*/
static struct DXRubyTexture *Image_textureload( char *filename, D3DXIMAGE_INFO *psrcinfo)
{
    HRESULT hr;
    struct DXRubyTexture *texture;
    int i, j;
    int y, x;
    LPDIRECT3DSURFACE9 pSurface;
    LPD3DXBUFFER pBuffer;
    RECT rect;
    D3DLOCKED_RECT LockedRect;

    /* eNX`TCYo */
    for( x = 1; x < psrcinfo->Width; x = x * 2 );
    for( y = 1; y < psrcinfo->Height; y = y * 2 );

    /* T[tFCX쐬 */
    g_pD3DDevice->lpVtbl->CreateOffscreenPlainSurface( g_pD3DDevice, x, y, D3DFMT_A8R8G8B8, D3DPOOL_SCRATCH, &pSurface, NULL );

    /* T[tFCXbN */
    hr = pSurface->lpVtbl->LockRect( pSurface, &LockedRect, NULL, 0 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "T[tFCX̃bNɎs܂ - LockRect" );
    }

    /* T[tFCX */
    /* G̃TCY傫TCYɎw肳ꂽ̋󔒂 */
    for( i = 0; i < y; i++ )
    {
        for( j = 0; j < x*4; j++ )
        {
            *((char *)LockedRect.pBits + j + i * LockedRect.Pitch) = 0;
        }
    }

    /* T[tFCXAbN */
    pSurface->lpVtbl->UnlockRect(pSurface);


    /* t@CT[tFCXɃ[h */
    rect.top = 0;
    rect.left = 0;
    rect.bottom = psrcinfo->Height;
    rect.right = psrcinfo->Width;

    hr = D3DXLoadSurfaceFromFile( pSurface, NULL, &rect, filename, 
                                  &rect, D3DX_DEFAULT, 0, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̓ǂݍ݂Ɏs܂ - %s", filename );
    }

    /* obt@m */
    hr = D3DXCreateBuffer( 0, &pBuffer);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "obt@̊mۂɎs܂ - D3DXCreateBuffer" );
    }

    /* t@Cɓfo */
    hr = D3DXSaveSurfaceToFileInMemory( &pBuffer, D3DXIFF_DDS, pSurface, NULL, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̍쐬Ɏs܂ - D3DXSaveSurfaceToFileInMemory" );
    }

    /* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );

    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_textureload" );
    }

    /* t@CǂݍŃeNX`IuWFNg쐬 */
    hr = D3DXCreateTextureFromFileInMemoryEx( g_pD3DDevice, pBuffer->lpVtbl->GetBufferPointer( pBuffer ), pBuffer->lpVtbl->GetBufferSize( pBuffer ), 
                                      D3DX_DEFAULT, D3DX_DEFAULT, 1,
                                      0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                      D3DX_DEFAULT,  D3DX_DEFAULT, 0,
                                      0, 0, &texture->pD3DTexture);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̓ǂݍ݂Ɏs܂ - %s", filename );
    }

    RELEASE( pBuffer );
    RELEASE( pSurface );

    return texture;
}


/*--------------------------------------------------------------------
   z񂩂C[W
 ---------------------------------------------------------------------*/
static VALUE Image_createFromArray( VALUE klass, VALUE width, VALUE height, VALUE array )
{
    struct DXRubyImage *image;
    struct DXRubyTexture *texture;
    D3DXIMAGE_INFO srcinfo;
    HRESULT hr;
    int i, j;
    int y, x;
    LPDIRECT3DSURFACE9 pSurface;
    LPD3DXBUFFER pBuffer;
    RECT rect;
    D3DLOCKED_RECT LockedRect;
    VALUE obj;
    int a1,a2,a3,a4;

    /* foCXIuWFNg̏`FbN */
    if( g_pD3DDevice == NULL )
    {
        rb_raise( eDXRubyError, "DirectX GraphicsĂ܂" );
    }

    /* eNX`TCYo */
    for( x = 1; x < NUM2INT(width);  x = x * 2 );
    for( y = 1; y < NUM2INT(height); y = y * 2 );

    /* T[tFCX쐬 */
    g_pD3DDevice->lpVtbl->CreateOffscreenPlainSurface( g_pD3DDevice, x, y, D3DFMT_A8R8G8B8, D3DPOOL_SCRATCH, &pSurface, NULL );

    /* T[tFCXbN */
    hr = pSurface->lpVtbl->LockRect( pSurface, &LockedRect, NULL, 0 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "T[tFCX̃bNɎs܂ - LockRect" );
    }

    /* T[tFCX */
    /* G̃TCY傫TCYɎw肳ꂽ̋󔒂 */
    for( i = 0; i < y; i++ )
    {
        for( j = 0; j < x*4; j += 4 )
        {
            a1 = NUM2INT(rb_ary_shift(array));
            a2 = NUM2INT(rb_ary_shift(array));
            a3 = NUM2INT(rb_ary_shift(array));
            a4 = NUM2INT(rb_ary_shift(array));
            *((int*)((char *)LockedRect.pBits + j + i * LockedRect.Pitch)) = a1 << 24 | a2 << 16 | a3 << 8 | a4;
        }
    }

    /* T[tFCXAbN */
    pSurface->lpVtbl->UnlockRect(pSurface);

    /* obt@m */
    hr = D3DXCreateBuffer( 0, &pBuffer);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "obt@̊mۂɎs܂ - D3DXCreateBuffer" );
    }

    /* t@Cɓfo */
    hr = D3DXSaveSurfaceToFileInMemory( &pBuffer, D3DXIFF_DDS, pSurface, NULL, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̍쐬Ɏs܂ - D3DXSaveSurfaceToFileInMemory" );
    }

    /* eNX`擾 */
    texture = (struct  DXRubyTexture *)malloc( sizeof( struct DXRubyTexture ) );
	texture->refcount = 1;

    if( texture == NULL )
    {
        rb_raise( eDXRubyError, "摜p̎擾Ɏs܂ - Image_textureload" );
    }

    /* t@CǂݍŃeNX`IuWFNg쐬 */
    hr = D3DXCreateTextureFromFileInMemoryEx( g_pD3DDevice, pBuffer->lpVtbl->GetBufferPointer( pBuffer ), pBuffer->lpVtbl->GetBufferSize( pBuffer ), 
                                      D3DX_DEFAULT, D3DX_DEFAULT, 1,
                                      0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                      D3DX_DEFAULT,  D3DX_DEFAULT, 0,
                                      0, 0, &texture->pD3DTexture);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̓ǂݍ݂Ɏs܂" );
    }

	texture->width = x;
    texture->height = y;

    RELEASE( pBuffer );
    RELEASE( pSurface );

    /* DXRubyImagẽ擾ImageIuWFNg */
    image = malloc(sizeof(struct DXRubyImage));
    if( image == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Image_createFromArray" );
    obj = Data_Wrap_Struct(cImage, 0, release_Image, image);

    image->texture = texture;
    image->x = 0;
    image->y = 0;
    image->width = NUM2INT( width );
    image->height = NUM2INT( height );

	g_iRefAll++;

	return obj;
}


/*--------------------------------------------------------------------
   C[W̃f[^擾
 ---------------------------------------------------------------------*/
static VALUE Image_getPixel( VALUE obj, VALUE vx, VALUE vy )
{
    struct DXRubyImage *image;
	LPDWORD p1;
	VALUE ary[4];
	DWORD a;
	D3DLOCKED_RECT texrect;
	int x, y;

	x = NUM2INT( vx );
	y = NUM2INT( vy );
	
    Data_Get_Struct( obj, struct DXRubyImage, image );

	if( x < 0 || x >= image->width || y < 0 || y >= image->height )
	{
		ary[0] = ary[1] = ary[2] = ary[3] = INT2FIX( 0 );
		return rb_ary_new4( 4, ary );
	}

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, NULL, 0 );

    p1 = (LPDWORD)texrect.pBits;
	a = p1[x + (int)image->x + ( y + (int)image->y ) * texrect.Pitch / sizeof(DWORD)];

	image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

	ary[0] = INT2FIX(  a >> 24 );
	ary[1] = INT2FIX( (a >> 16) & 0xff );
	ary[2] = INT2FIX( (a >> 8) & 0xff );
	ary[3] = INT2FIX(  a & 0xff );

	return rb_ary_new4( 4, ary );
}


/*--------------------------------------------------------------------
   C[W̃f[^ݒ
 ---------------------------------------------------------------------*/
static VALUE Image_setPixel( VALUE obj, VALUE vx, VALUE vy, VALUE color )
{
    struct DXRubyImage *image;
	int a1, a2, a3, a4;
	D3DLOCKED_RECT texrect;
	int x, y;

	x = NUM2INT( vx );
	y = NUM2INT( vy );

	Data_Get_Struct( obj, struct DXRubyImage, image );

	if( x < 0 || x >= image->width || y < 0 || y >= image->height )
	{
		return obj;
	}

	a1 = NUM2INT(rb_ary_entry(color, 0));
    a2 = NUM2INT(rb_ary_entry(color, 1));
    a3 = NUM2INT(rb_ary_entry(color, 2));
    a4 = NUM2INT(rb_ary_entry(color, 3));

	image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, NULL, 0 );

    *((int*)((char *)texrect.pBits + 
    	( x + (int)image->x ) * 4 +
    	( y + (int)image->y ) * texrect.Pitch))
			= a1 << 24 | a2 << 16 | a3 << 8 | a4;

	image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

	return obj;
}


/*--------------------------------------------------------------------
   C[W̐Fr
 ---------------------------------------------------------------------*/
static VALUE Image_compare( VALUE obj, VALUE vx, VALUE vy, VALUE color )
{
    struct DXRubyImage *image;
	LPDWORD p1;
	DWORD a;
	D3DLOCKED_RECT texrect;
	int x, y;
	int a1, a2, a3, a4;

	x = NUM2INT( vx );
	y = NUM2INT( vy );
	
    Data_Get_Struct( obj, struct DXRubyImage, image );

	if( x < 0 || x >= image->width || y < 0 || y >= image->height )
	{
		return INT2FIX( 0 );
	}

	a1 = NUM2INT(rb_ary_entry(color, 0));
    a2 = NUM2INT(rb_ary_entry(color, 1));
    a3 = NUM2INT(rb_ary_entry(color, 2));
    a4 = NUM2INT(rb_ary_entry(color, 3));

	image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, NULL, 0 );

    p1 = (LPDWORD)texrect.pBits;
	a = p1[x + (int)image->x + ( y + (int)image->y ) * texrect.Pitch / sizeof(DWORD)];

	image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

	if( a1 == (a >> 24) && a2 == ((a >> 16) & 0xff) && a3 == ((a >> 8) & 0xff) && a4 == (a & 0xff) )
	{
		return Qtrue;
	}
	else
	{
		return Qfalse;
	}
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(box`)
 ---------------------------------------------------------------------*/
static VALUE Image_box( VALUE obj, VALUE vx1, VALUE vy1, VALUE vx2, VALUE vy2, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x, y, x1, y1, x2, y2;
    int col;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    x1 = NUM2INT( vx1 );
    y1 = NUM2INT( vy1 );
    x2 = NUM2INT( vx2 );
    y2 = NUM2INT( vy2 );

    /* ォE̎wɏC */
    if( x1 > x2 )
    {
        x = x2;
        x2 = x1;
        x1 = x;
    }
    if( y1 > y2 )
    {
        y = y2;
        y2 = y1;
        y1 = y;
    }

    /* ͈͊O̎w͖ */
    if( x1 > image->width - 1 || x2 < 0 || y1 > image->height - 1 || y2 < 0)
    {
        return obj;
    }

    /* Nbv */
    if( x1 < 0 )
    {
        x1 = 0;
    }
    if( x2 > image->width - 1 )
    {
        x2 = image->width - 1;
    }
    if( y1 < 0 )
    {
        y1 = 0;
    }
    if( y2 > image->height - 1 )
    {
        y2 = image->height - 1;
    }

    col   = NUM2INT(rb_ary_entry(color, 0))<<24 | NUM2INT(rb_ary_entry(color, 1))<<16 |
            NUM2INT(rb_ary_entry(color, 2))<<8  | NUM2INT(rb_ary_entry(color, 3));

    fill( x1, y1, x2, y2, col, image );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(circlepline`)
 ---------------------------------------------------------------------*/
static void Image_circle_line( int x1, int x2, int y, int col, D3DLOCKED_RECT *texrect, struct DXRubyImage *image )
{
	int x;

	if( y < 0 || y > image->height - 1 )
	{
		return;
	}

	/* Nbv */
	if( x1 < 0 )
	{
		x1 = 0;
	}
	if( x2 > image->width - 1 )
	{
		x2 = image->width - 1;
	}

	for( x = x1; x <= x2; x++ )
	{
		*((int*)((char *)texrect->pBits + 
	    	( x + (int)image->x ) * 4 +
	    	( y + (int)image->y ) * texrect->Pitch)) = col;
	}
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(circle`hԂ)
 ---------------------------------------------------------------------*/
static VALUE Image_circleFill( VALUE obj, VALUE vx0, VALUE vy0, VALUE vr, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x0, y0, r, F, x, y;
    int col;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    x0 = NUM2INT( vx0 );
    y0 = NUM2INT( vy0 );
    r  = NUM2INT( vr );

    Check_Type(color, T_ARRAY);
    col   = NUM2INT(rb_ary_entry(color, 0))<<24 | NUM2INT(rb_ary_entry(color, 1))<<16 |
            NUM2INT(rb_ary_entry(color, 2))<<8  | NUM2INT(rb_ary_entry(color, 3));

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, NULL, 0 );

    x = r;
    y = 0;
    F = -2 * r + 3;

    while ( x >= y )
    {
        Image_circle_line( x0 - x, x0 + x, y0 + y, col, &texrect, image );
        Image_circle_line( x0 - x, x0 + x, y0 - y, col, &texrect, image );
        Image_circle_line( x0 - y, x0 + y, y0 + x, col, &texrect, image );
        Image_circle_line( x0 - y, x0 + y, y0 - x, col, &texrect, image );
        if ( F >= 0 )
        {
          x--;
          F -= 4 * x;
        }
        y++;
        F += 4 * y + 2;
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(ppixel`)
 ---------------------------------------------------------------------*/
static void Image_circle_pixel( int x, int y, int col, D3DLOCKED_RECT *texrect, struct DXRubyImage *image )
{
    if( x < 0 || x >= image->width || y < 0 || y >= image->height )
    {
        return;
    }

    *((int*)((char *)texrect->pBits + 
        ( x + (int)image->x ) * 4 +
        ( y + (int)image->y ) * texrect->Pitch)) = col;

    return;
}
/*--------------------------------------------------------------------
    C[W̃f[^ݒ(circle`hԂȂ)
 ---------------------------------------------------------------------*/
static VALUE Image_circle( VALUE obj, VALUE vx0, VALUE vy0, VALUE vr, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x0, y0, r, F, x, y;
    int col;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    x0 = NUM2INT( vx0 );
    y0 = NUM2INT( vy0 );
    r  = NUM2INT( vr );

    Check_Type(color, T_ARRAY);
    col   = NUM2INT(rb_ary_entry(color, 0))<<24 | NUM2INT(rb_ary_entry(color, 1))<<16 |
            NUM2INT(rb_ary_entry(color, 2))<<8  | NUM2INT(rb_ary_entry(color, 3));

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, NULL, 0 );

    x = r;
    y = 0;
    F = -2 * r + 3;

    while ( x >= y )
    {
        Image_circle_pixel( x0 + x + (int)image->x, y0 + y + (int)image->y, col, &texrect, image );
        Image_circle_pixel( x0 - x + (int)image->x, y0 + y + (int)image->y, col, &texrect, image );
        Image_circle_pixel( x0 + x + (int)image->x, y0 - y + (int)image->y, col, &texrect, image );
        Image_circle_pixel( x0 - x + (int)image->x, y0 - y + (int)image->y, col, &texrect, image );
        Image_circle_pixel( x0 + y + (int)image->x, y0 + x + (int)image->y, col, &texrect, image );
        Image_circle_pixel( x0 - y + (int)image->x, y0 + x + (int)image->y, col, &texrect, image );
        Image_circle_pixel( x0 + y + (int)image->x, y0 - x + (int)image->y, col, &texrect, image );
        Image_circle_pixel( x0 - y + (int)image->x, y0 - x + (int)image->y, col, &texrect, image );
        if ( F >= 0 )
        {
          x--;
          F -= 4 * x;
        }
        y++;
        F += 4 * y + 2;
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
    C[W̃f[^ݒ(line`)
 ---------------------------------------------------------------------*/
static VALUE Image_line( VALUE obj, VALUE vx1, VALUE vy1, VALUE vx2, VALUE vy2, VALUE color )
{
    struct DXRubyImage *image;
    D3DLOCKED_RECT texrect;
    int x, y, x1, y1, x2, y2, xp, yp;
    int col;
    int c, d, dx, dy, i;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    x1 = NUM2INT( vx1 );
    y1 = NUM2INT( vy1 );
    x2 = NUM2INT( vx2 );
    y2 = NUM2INT( vy2 );

    Check_Type(color, T_ARRAY);
    col   = NUM2INT(rb_ary_entry(color, 0))<<24 | NUM2INT(rb_ary_entry(color, 1))<<16 |
            NUM2INT(rb_ary_entry(color, 2))<<8  | NUM2INT(rb_ary_entry(color, 3));

    image->texture->pD3DTexture->lpVtbl->LockRect( image->texture->pD3DTexture, 0, &texrect, NULL, 0 );

    dx = x2 > x1 ? x2 - x1 : x1 - x2;
    dy = y2 > y1 ? y2 - y1 : y1 - y2;

    /* u[nASYɂ` */
    if( dx < dy )
    {
        xp = x1 < x2 ? 1 : -1;
        d = y1 < y2 ? 1 : -1;
        c = dy / 2;
        for( i = 0; i <= dy; i++ )
        {
            if( x1 >= 0 && x1 < (int)image->width && y1 >= 0 && y1 < (int)image->height )
            {
                *((int*)((char *)texrect.pBits + 
                            ( x1 + (int)image->x ) * 4 +
                            ( y1 + (int)image->y ) * texrect.Pitch)) = col;
            }
            y1 = y1 + d;
            c = c + dx;
            if( c > dy )
            {
                c = c - dy;
                x1 = x1 + xp;
            }
        }
    }
    else
    {
        yp = y1 < y2 ? 1 : -1;
        d = x1 < x2 ? 1 : -1;
        c = dx / 2;
        for( i = 0; i <= dx; i++ )
        {
            if( x1 >= 0 && x1 < (int)image->width && y1 >= 0 && y1 < (int)image->height )
            {
                *((int*)((char *)texrect.pBits + 
                            ( x1 + (int)image->x ) * 4 +
                            ( y1 + (int)image->y ) * texrect.Pitch)) = col;
            }
            x1 = x1 + d;
            c = c + dy;
            if( c > dx )
            {
                c = c - dx;
                y1 = y1 + yp;
            }
        }
    }

    image->texture->pD3DTexture->lpVtbl->UnlockRect( image->texture->pD3DTexture, 0 );

    return obj;
}


/*--------------------------------------------------------------------
   C[W̊JnʒuxԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getX( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    return INT2FIX( image->x );
}


/*--------------------------------------------------------------------
   C[W̊JnʒuyԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getY( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    return INT2FIX( image->y );
}


/*--------------------------------------------------------------------
   C[W̃TCYijԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getWidth( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    return INT2FIX( image->width );
}


/*--------------------------------------------------------------------
   C[W̃TCYijԂB
 ---------------------------------------------------------------------*/
static VALUE Image_getHeight( VALUE obj )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );

    return INT2FIX( image->height );
}


/*--------------------------------------------------------------------
   C[W̊Jnʒuxݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setX( VALUE obj, VALUE x )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    image->x = NUM2INT( x );

    return x;
}


/*--------------------------------------------------------------------
   C[W̊Jnʒuyݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setY( VALUE obj, VALUE y )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    image->y = NUM2INT( y );

    return y;
}


/*--------------------------------------------------------------------
   C[W̃TCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setWidth( VALUE obj, VALUE width )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    image->width = NUM2INT( width );

    return width;
}


/*--------------------------------------------------------------------
   C[W̃TCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Image_setHeight( VALUE obj, VALUE height )
{
    struct DXRubyImage *image;

    Data_Get_Struct( obj, struct DXRubyImage, image );
    image->height = NUM2INT( height );

    return height;
}



/*********************************************************************
 * SoundNX
 *
 * DirectMusicgpĉ炷B
 * Ƃ肠oƊ撣ĂB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Sound( struct DXRubySound* sound )
{
    HRESULT hr;

	/* TEhIuWFNg̊J */
    if( sound )
    {
	    /* oh */
    	if ( sound->pDMSegment != NULL )
    	{
	    	hr = sound->pDMSegment->lpVtbl->Unload( sound->pDMSegment, (IUnknown* )sound->pDMDefAudioPath );
		    if( FAILED( hr ) )
		    {
		        rb_raise( eDXRubyError, "oh̉Ɏs܂ - Unload" );
		    }
			/* ZOgJ */
	    	RELEASE( sound->pDMSegment );
    	}

    	/* ftHgI[fBIpXJ */
	    RELEASE( sound->pDMDefAudioPath );

    	g_iRefDM--;

    	if( g_iRefDM <= 0 )
    	{
	    	/* t~ */
		    if ( g_pDMPerformance )
		    {
		        hr = g_pDMPerformance->lpVtbl->Stop( g_pDMPerformance, NULL, NULL, 0, 0 );
		        if ( FAILED( hr ) )
		    	{
		            rb_raise( eDXRubyError, "ptH[}X̏IɎs܂ - Stop" );
		    	}
		    }
	        g_pDMPerformance->lpVtbl->CloseDown( g_pDMPerformance );
    		RELEASE(g_pDMPerformance);

		    /* [_J */
		    RELEASE(g_pDMLoader);
    	}

    	free( sound );
        sound = NULL;

    	g_iRefAll--;
    	if( g_iRefAll == 0 )
    	{
    		CoUninitialize();
    	}
    }
}


/*--------------------------------------------------------------------
   SoundNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Sound_allocate( VALUE klass )
{
    VALUE obj;
    struct DXRubySound *sound;

    /* DXRubyImagẽ擾ImageIuWFNg */
    sound = malloc(sizeof(struct DXRubySound));
    if( sound == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Sound_allocate" );
    obj = Data_Wrap_Struct(klass, 0, release_Sound, sound);

    /* Ƃ肠TEhIuWFNgNULLɂĂ */
    sound->pDMSegment = NULL;

    return obj;
}


/*--------------------------------------------------------------------
   SoundNXinitializeBt@C[hB
 ---------------------------------------------------------------------*/
static VALUE Sound_initialize( VALUE obj, VALUE filename )
{
    HRESULT hr;
    WCHAR wstrFileName[MAX_PATH];
    struct DXRubySound *sound;
    CHAR strPath[MAX_PATH];
    DWORD i;
    WCHAR wstrSearchPath[MAX_PATH];

	Check_Type(filename, T_STRING);

	if( g_iRefDM == 0 )
	{
	    /* ptH[}X̍쐬 */
	    hr = CoCreateInstance( &CLSID_DirectMusicPerformance, NULL,
	                           CLSCTX_INPROC_SERVER, &IID_IDirectMusicPerformance8,
	                           (void**)&g_pDMPerformance );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - CoCreateInstance" );
	    }

	    /* ptH[}X̏ */
	    hr = g_pDMPerformance->lpVtbl->InitAudio( g_pDMPerformance,
	                                              NULL,                  /* IDirectMusicC^[tFCX͕sv */
	                                              NULL,                  /* IDirectSoundC^[tFCX͕sv */
	                                              g_hWind,               /* EBhẼnh */
	                                              DMUS_APATH_SHARED_STEREOPLUSREVERB,  /* ftHg̃I[fBIpXE^Cv */
	                                              64,                    /* ptH[}XE`l̐ */
	                                              DMUS_AUDIOF_ALL,       /* VZTCŰ@\ */
	                                              NULL );                /* I[fBIEp[^ɂ̓ftHggp */
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - InitAudio" );
	    }

	    /* [_[̍쐬 */
	    hr = CoCreateInstance( &CLSID_DirectMusicLoader, NULL, 
	                           CLSCTX_INPROC_SERVER, &IID_IDirectMusicLoader8,
	                           (void**)&g_pDMLoader );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - CoCreateInstance" );
	    }

	    /* [_[̏ipXJgEfBNgɐݒj */
	    i = GetCurrentDirectory( MAX_PATH, strPath );
	    if ( i == 0 || MAX_PATH < i )
	    {
	        rb_raise( eDXRubyError, "JgEfBNg̎擾Ɏs - GetCurrentDirectory" );
	    }

	    /* }`EoCgUNICODEɕϊ */
	    MultiByteToWideChar( CP_ACP, 0, strPath, -1, wstrSearchPath, MAX_PATH );

	    /* [_[ɌpXݒ */
	    hr = g_pDMLoader->lpVtbl->SetSearchDirectory( g_pDMLoader, &GUID_DirectMusicAllTypes,
	                                                  wstrSearchPath, FALSE );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "pX̐ݒɎs - SetSearchDirectory" );
	    }
	}
    g_iRefDM++;

	/* TEhIuWFNg擾 */
    Data_Get_Struct( obj, struct DXRubySound, sound );

	/* I[fBIEpX쐬 */
	hr = g_pDMPerformance->lpVtbl->CreateStandardAudioPath( g_pDMPerformance,
		DMUS_APATH_DYNAMIC_STEREO,      /* pX̎ށB */
		64,                             /* ptH[}X `l̐B */
		TRUE,                           /* ŃANeBuɂȂB */
		&sound->pDMDefAudioPath );      /* I[fBIpX󂯎|C^B */

	if ( FAILED( hr ) )
	{
        rb_raise( eDXRubyError, "I[fBIpX̍쐬Ɏs܂ - CreateStandardAudioPath" );
	}

    /* t@C[h */
    MultiByteToWideChar( CP_ACP, 0, RSTRING_PTR( filename ), -1, wstrFileName, MAX_PATH );
	hr = g_pDMLoader->lpVtbl->LoadObjectFromFile( g_pDMLoader, &CLSID_DirectMusicSegment,
                                                  &IID_IDirectMusicSegment8,
                                                  wstrFileName,
                                                  (LPVOID*)&sound->pDMSegment );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "t@C̃[hɎs܂ - LoadObjectFromFile" );
    }

	sound->start = 0;
	sound->loopstart = 0;
	sound->loopend = 0;

	/* MIDȈꍇ */
    if( strstr( RSTRING_PTR( filename ), ".mid" ) != NULL )
    {
        hr = sound->pDMSegment->lpVtbl->SetParam( sound->pDMSegment, &GUID_StandardMIDIFile,
                                                  0xFFFFFFFF, 0, 0, NULL);
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "t@C̃[hɎs܂ - SetParam" );
        }
		sound->loopcount = DMUS_SEG_REPEAT_INFINITE;
    }
	else
	{
		sound->loopcount = 1;
	}

    /* oh_E[h */
    hr = sound->pDMSegment->lpVtbl->Download( sound->pDMSegment, (IUnknown* )sound->pDMDefAudioPath );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "oh̃[hɎs܂ - Download" );
    }

	g_iRefAll++;

    /* ʐݒ */
    hr = sound->pDMDefAudioPath->lpVtbl->SetVolume( sound->pDMDefAudioPath, 230 * 9600 / 255 - 9600 , 0 );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ʂ̐ݒɎs܂ - SetVolume" );
    }

	return obj;
}


/*--------------------------------------------------------------------
   Jnʒuݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setStart( VALUE obj, VALUE vstart )
{
    struct DXRubySound *sound;

    Data_Get_Struct( obj, struct DXRubySound, sound );
	sound->start = NUM2INT( vstart );

	return obj;
}


/*--------------------------------------------------------------------
   [vJnʒuݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setLoopStart( VALUE obj, VALUE vloopstart )
{
    struct DXRubySound *sound;

    Data_Get_Struct( obj, struct DXRubySound, sound );
	sound->loopstart = NUM2INT( vloopstart );

	return obj;
}


/*--------------------------------------------------------------------
   [vIʒuݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setLoopEnd( VALUE obj, VALUE vloopend )
{
    struct DXRubySound *sound;

    Data_Get_Struct( obj, struct DXRubySound, sound );
	sound->loopend = NUM2INT( vloopend );

	return obj;
}


/*--------------------------------------------------------------------
   [v񐔂ݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setLoopCount( VALUE obj, VALUE vloopcount )
{
    struct DXRubySound *sound;

    Data_Get_Struct( obj, struct DXRubySound, sound );
	sound->loopcount = NUM2INT( vloopcount );

	return obj;
}


/*--------------------------------------------------------------------
   ʂݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setVolume( int argc, VALUE *argv, VALUE obj )
{
    HRESULT hr;
    struct DXRubySound *sound;
	VALUE vvolume, vtime;
	int volume, time;

	rb_scan_args( argc, argv, "11", &vvolume, &vtime );

	time = vtime == Qnil ? 0 : NUM2INT( vtime );
    volume = vvolume > 255 ? 255 : NUM2INT( vvolume );
	Data_Get_Struct( obj, struct DXRubySound, sound );

	/* ʐݒ */
    hr = sound->pDMDefAudioPath->lpVtbl->SetVolume( sound->pDMDefAudioPath, volume * 9600 / 255 - 9600, time );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ʂ̐ݒɎs܂ - SetVolume" );
    }

	return obj;
}


/*--------------------------------------------------------------------
   炷iʉj
 ---------------------------------------------------------------------*/
static VALUE Sound_play( VALUE obj )
{
    HRESULT hr;
    struct DXRubySound *sound;

	Data_Get_Struct( obj, struct DXRubySound, sound );

    /* Đ */
    hr = g_pDMPerformance->lpVtbl->PlaySegmentEx( g_pDMPerformance, (IUnknown* )sound->pDMSegment, NULL, NULL,
                                                  DMUS_SEGF_SECONDARY, 0, NULL, NULL, (IUnknown* )sound->pDMDefAudioPath );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - PlaySegmentEx" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   炷iBGMj
 ---------------------------------------------------------------------*/
static VALUE Sound_bgmplay( VALUE obj )
{
    HRESULT hr;
    struct DXRubySound *sound;
    MUSIC_TIME temp;
	VALUE vstart, vloopstart, vloopend, vloopcount;
	int start, loopstart, loopend, loopcount;

	Data_Get_Struct( obj, struct DXRubySound, sound );

	/* ZOg擾 */
    hr = sound->pDMSegment->lpVtbl->GetLength( sound->pDMSegment, &temp );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ZOg̎擾Ɏs܂ - GetLength" );
    }

    /* ZOgĐX^[gʒuݒ */
    hr = sound->pDMSegment->lpVtbl->SetStartPoint( sound->pDMSegment, sound->start / 768 * DMUS_PPQ  );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ZOgJnʒu̐ݒɎs܂ - SetStartPoint" );
    }

    /* [v͈͐ݒ */
	hr = sound->pDMSegment->lpVtbl->SetLoopPoints( sound->pDMSegment, sound->loopstart / 768 * DMUS_PPQ
                                                                    , sound->loopend / 768 * DMUS_PPQ );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "[v͈͂̐ݒɎs܂ - SetLoopPoints" );
    }

    /* [v񐔐ݒ */
    hr = sound->pDMSegment->lpVtbl->SetRepeats( sound->pDMSegment, sound->loopcount );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "[v񐔂̐ݒɎs܂ - SetRepeats" );
    }

    /* Đ */
    hr = g_pDMPerformance->lpVtbl->PlaySegmentEx( g_pDMPerformance, (IUnknown* )sound->pDMSegment, NULL, NULL,
                                                  DMUS_SEGF_CONTROL, 0, NULL, NULL, (IUnknown* )sound->pDMDefAudioPath );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - PlaySegmentEx" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   ~߂
 ---------------------------------------------------------------------*/
static VALUE Sound_stop( VALUE obj )
{
    HRESULT hr;
    struct DXRubySound *sound;

    Data_Get_Struct( obj, struct DXRubySound, sound );

    /* Đ */
    hr = g_pDMPerformance->lpVtbl->StopEx( g_pDMPerformance, (IUnknown* )sound->pDMSegment, 0, 0 );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̒~Ɏs܂ - StopEx" );
    }

    return obj;

}


/*********************************************************************
 * SoundEffectNX
 *
 * DirectSoundgpĉ炷B
 * Ƃ肠oƊ撣ĂB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_SoundEffect( struct DXRubySoundEffect* soundeffect )
{
    /* TEhIuWFNg̊J */
    if( soundeffect )
    {
    	/* TEhobt@J */
	    RELEASE( soundeffect->pDSBuffer );

    	g_iRefDS--;

    	if( g_iRefDS == 0 )
    	{
    		RELEASE( g_pDSound );
    	}

    	free( soundeffect );
        soundeffect = NULL;

    	g_iRefAll--;
    	if( g_iRefAll == 0 )
    	{
    		CoUninitialize();
    	}
    }
}


/*--------------------------------------------------------------------
   SoundEffectNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_allocate( VALUE klass )
{
    VALUE obj;
    struct DXRubySoundEffect *soundeffect;

    /* DXRubySoundEffect̃擾SoundEffectIuWFNg */
    soundeffect = malloc(sizeof(struct DXRubySoundEffect));
    if( soundeffect == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - SoundEffect_allocate" );
    obj = Data_Wrap_Struct(klass, 0, release_SoundEffect, soundeffect);

    /* Ƃ肠TEhIuWFNgNULLɂĂ */
    soundeffect->pDSBuffer = NULL;

    return obj;
}


static short calcwave(int type, int f, int vol, int count, int p)
{
	switch( type )
	{
	case 1: /* TCg */
		return (sin( (3.141592653589793115997963468544185161590576171875f * 2) * (double)count / (double)p )) * (double)vol * 128;
		break;
	case 2: /* mRMg */
		return ((double)count / (double)p - 0.5) * (double)vol * 256;
		break;
	case 3: /* Opg */
		if( count < p / 4 )			/* 1/4 */
		{
			return (double)count / ((double)p / 4) * (double)vol * 128;
		}
		else if( count < p / 2 )		/* 2/4 */
		{
			return ((double)p / 2 - (double)count) / ((double)p / 4) * (double)vol * 128;
		}
		else if( count < p * 3 / 4 )	/* 3/4 */
		{
			return -((double)count - (double)p / 2)/ ((double)p / 4) * (double)vol * 128;
		}
		else											/* Ō */
		{
			return -((double)p - (double)count) / ((double)p / 4) * (double)vol * 128;
		}
		break;
	case 0: /* `g */
	default: /* ftHg */
		if( count < p / 2 )	/* O */
		{
			return vol * 128;
		}
		else									/* 㔼 */
		{
			return -vol * 128;
		}
		break;
	}
}
/*--------------------------------------------------------------------
   SoundEffectNXinitializeBg`𐶐B
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_initialize( int argc, VALUE *argv, VALUE obj )
{
    HRESULT hr;
    WCHAR wstrFileName[MAX_PATH];
    struct DXRubySoundEffect *soundeffect;
	DSBUFFERDESC desc;
	WAVEFORMATEX pcmwf;
	int i;
	short *pointer, *pointer2;
	DWORD size, size2;
	VALUE vf;
	int count;
	int vol, f;
	VALUE vsize, vtype, vresolution;
	int type, resolution;

    rb_scan_args( argc, argv, "12", &vsize, &vtype, &vresolution );

	type       = vtype       == Qnil ? 0    : NUM2INT( vtype );
	resolution = vresolution == Qnil ? 1000 : (NUM2INT( vresolution ) > 44100 ? 44100 : NUM2INT( vresolution ));

    /* DirectSoundIuWFNg̍쐬 */
	if( g_iRefDS == 0 )
	{
		hr = DirectSoundCreate8( &DSDEVID_DefaultPlayback, &g_pDSound, NULL );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectSound̏Ɏs܂ - DirectSoundCreate8" );
	    }

		hr = g_pDSound->lpVtbl->SetCooperativeLevel( g_pDSound, g_hWind, DSSCL_PRIORITY );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectSound̏Ɏs܂ - SetCooperativeLevel" );
	    }
	}
	g_iRefDS++;

	/* TEhIuWFNg쐬 */
    Data_Get_Struct( obj, struct DXRubySoundEffect, soundeffect );

	/* TEhobt@쐬 */
	pcmwf.wFormatTag = WAVE_FORMAT_PCM;
	pcmwf.nChannels = 1;
	pcmwf.nSamplesPerSec = 44100 * 2;
	pcmwf.wBitsPerSample = 16;
	pcmwf.nBlockAlign = pcmwf.nChannels * pcmwf.wBitsPerSample / 8;
	pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
	pcmwf.cbSize = 0;

	desc.dwSize = sizeof(desc);
	desc.dwFlags = 0;
	desc.dwBufferBytes = pcmwf.nAvgBytesPerSec / 100 * NUM2INT(vsize) / 10;
	desc.dwReserved = 0;
	desc.lpwfxFormat = &pcmwf;
	desc.guid3DAlgorithm = DS3DALG_DEFAULT;

	hr = g_pDSound->lpVtbl->CreateSoundBuffer( g_pDSound, &desc, &soundeffect->pDSBuffer, NULL );

	if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̍쐬Ɏs܂ - CreateSoundBuffer" );
    }

	/* bN */
	hr = soundeffect->pDSBuffer->lpVtbl->Lock( soundeffect->pDSBuffer, 0, 0, &pointer, &size, &pointer2, &size2, DSBLOCK_ENTIREBUFFER );
    if( FAILED( hr ) || size2 != 0 )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

	/* obt@ */
	for( i = 0; i < desc.dwBufferBytes / (pcmwf.wBitsPerSample / 8); i++ )
	{
		pointer[i] = 0;
	}

	count = 0;

	/* g` */
	for( i = 0; i < desc.dwBufferBytes / (pcmwf.wBitsPerSample / 8); i++ )
	{
		/* w莞ԒPʂŃubNĂяo */
		if ( i % (pcmwf.nSamplesPerSec / resolution) == 0 )
		{
			vf = rb_yield( obj );
			if( TYPE( vf ) != T_ARRAY )
			{
				soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
			    rb_raise(rb_eTypeError, "not valid value - SoundEffect_initialize");
				break;
			}
			switch (TYPE( rb_ary_entry(vf, 0) )) {
			  case T_FIXNUM:
			  case T_FLOAT:
				f = NUM2INT( rb_ary_entry(vf, 0) );
			    break;
			  default:
				soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
			    rb_raise(rb_eTypeError, "not valid value - SoundEffect_initialize");
			    break;
			}
			switch (TYPE( rb_ary_entry(vf, 1) )) {
			  case T_FIXNUM:
			  case T_FLOAT:
				vol = NUM2INT(rb_ary_entry(vf, 1));
			    break;
			  default:
				soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
			    rb_raise(rb_eTypeError, "not valid value - SoundEffect_initialize");
			    break;
			}
			/* ő/Œgƍő{[̐ */
			f = f > pcmwf.nSamplesPerSec / 2 ? pcmwf.nSamplesPerSec / 2 : f;
			f = f < 20 ? 20 : f;
			vol = vol > 255 ? 255 : vol;
			vol = vol < 0 ? 0 : vol;
		}
		count = count + f;
		if( count >= pcmwf.nSamplesPerSec )
		{
			count = count - pcmwf.nSamplesPerSec;
		}
		pointer[i] = calcwave(type, f, vol, count, pcmwf.nSamplesPerSec);
	}

	/* AbN */
	hr = soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

	g_iRefAll++;

	return obj;

}


/*--------------------------------------------------------------------
   g`B
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_add( int argc, VALUE *argv, VALUE obj )
{
    HRESULT hr;
    struct DXRubySoundEffect *soundeffect;
	DSBUFFERDESC desc;
	WAVEFORMATEX pcmwf;
	int i;
	short *pointer, *pointer2;
	DWORD size, size2;
	VALUE vf, vtype, vresolution;
	int count;
	int vol, f;
	int type, resolution;
	int data;

	rb_scan_args( argc, argv, "11", &vtype, &vresolution );

	type       = vtype       == Qnil ? 0    : NUM2INT( vtype );
	resolution = vresolution == Qnil ? 1000 : (NUM2INT( vresolution ) > 44100 ? 44100 : NUM2INT( vresolution ));

    /* TEhIuWFNg擾 */
    Data_Get_Struct( obj, struct DXRubySoundEffect, soundeffect );

	/* bN */
	hr = soundeffect->pDSBuffer->lpVtbl->Lock( soundeffect->pDSBuffer, 0, 0, &pointer, &size, &pointer2, &size2, DSBLOCK_ENTIREBUFFER );
    if( FAILED( hr ) || size2 != 0 )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

	pcmwf.nChannels = 1;
	pcmwf.nSamplesPerSec = 44100 * 2;
	pcmwf.wBitsPerSample = 16;
	pcmwf.nBlockAlign = pcmwf.nChannels * pcmwf.wBitsPerSample / 8;
	pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
	desc.dwBufferBytes = size;

	count = 0;

	/* g` */
	for( i = 0; i < desc.dwBufferBytes / (pcmwf.wBitsPerSample / 8); i++ )
	{
		/* w莞ԒPʂŃubNĂяo */
		if ( i % (pcmwf.nSamplesPerSec / resolution) == 0 )
		{
			vf = rb_yield( obj );
			if( TYPE( vf ) != T_ARRAY )
			{
				soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
			    rb_raise(rb_eTypeError, "not valid value - SoundEffect_initialize");
				break;
			}
			switch (TYPE( rb_ary_entry(vf, 0) )) {
			  case T_FIXNUM:
			  case T_FLOAT:
				f = NUM2INT( rb_ary_entry(vf, 0) );
			    break;
			  default:
				soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
			    rb_raise(rb_eTypeError, "not valid value - SoundEffect_initialize");
			    break;
			}
			switch (TYPE( rb_ary_entry(vf, 1) )) {
			  case T_FIXNUM:
			  case T_FLOAT:
				vol = NUM2INT(rb_ary_entry(vf, 1));
			    break;
			  default:
				soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
			    rb_raise(rb_eTypeError, "not valid value - SoundEffect_initialize");
			    break;
			}
			/* ő/Œgƍő{[̐ */
			f = f > pcmwf.nSamplesPerSec / 2 ? pcmwf.nSamplesPerSec / 2 : f;
			f = f < 20 ? 20 : f;
			vol = vol > 255 ? 255 : vol;
			vol = vol < 0 ? 0 : vol;
		}
		count = count + f;
		if( count >= pcmwf.nSamplesPerSec )
		{
			count = count - pcmwf.nSamplesPerSec;
		}

		data = calcwave(type, f, vol, count, pcmwf.nSamplesPerSec);

		if( data + (int)pointer[i] > 32767 )
		{
			pointer[i] = 32767;
		}
		else if( data + (int)pointer[i] < -32768 )
		{
			pointer[i] = -32768;
		}
		else
		{
			pointer[i] += data;
		}
	}

	/* AbN */
	hr = soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    return obj;

}


/*--------------------------------------------------------------------
   炷
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_play( VALUE obj )
{
    HRESULT hr;
    struct DXRubySoundEffect *soundeffect;
	DWORD flag;
	
	Data_Get_Struct( obj, struct DXRubySoundEffect, soundeffect );

	/* Ƃ߂ */
    hr = soundeffect->pDSBuffer->lpVtbl->Stop( soundeffect->pDSBuffer );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - SoundEffect_play" );
    }

	hr = soundeffect->pDSBuffer->lpVtbl->SetCurrentPosition( soundeffect->pDSBuffer, 0 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - SoundEffect_play" );
    }

	/* Đ */
    hr = soundeffect->pDSBuffer->lpVtbl->Play( soundeffect->pDSBuffer, 0, 0, 0 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - SoundEffect_play" );
	}
    return obj;
}


/*--------------------------------------------------------------------
   ~߂
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_stop( VALUE obj )
{
    HRESULT hr;
    struct DXRubySoundEffect *soundeffect;

    Data_Get_Struct( obj, struct DXRubySoundEffect, soundeffect );

    /* Ƃ߂ */
    hr = soundeffect->pDSBuffer->lpVtbl->Stop( soundeffect->pDSBuffer );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̒~Ɏs܂ - Stop" );
    }

    return obj;
}



/*********************************************************************
 * InputW[
 *
 * DirectInputgpăL[{[hEpbh̓͂sB
 *********************************************************************/

/*--------------------------------------------------------------------
   InputW[̓͏
 ---------------------------------------------------------------------*/
static void Input_update( void )
{
    HRESULT hr;
    int i, j;
    DIJOYSTATE paddata;

    /* tH[JX͂ꂽꍇAL[ƃpbhA}EX{^̓͂󂯕tȂ */
    if( g_bActive == 0 )
    {
        /* L[{[h̃f[^NA */
        memcpy( g_diKeyStateOld, g_diKeyState, sizeof(g_diKeyState) );

        /* pbhf[^NA */
        for( i = 0; i < g_JoystickCount; i++ )
        {
            for( j = 0; j < 20; j++ )
            {
                g_PadStateOld[i].button[j] = g_PadState[i].button[j];
                g_PadState[i].button[j] = 0;
            }
        }

        /* }EX{^̃f[^NA */
        g_byMouseStateOld_L = g_byMouseState_L;
        g_byMouseStateOld_M = g_byMouseState_M;
        g_byMouseStateOld_R = g_byMouseState_R;
        g_byMouseState_L = 0;
        g_byMouseState_M = 0;
        g_byMouseState_R = 0;

        return;
    }

    /* foCXANZXĎ擾 */
    g_pDIDKeyBoard->lpVtbl->Acquire( g_pDIDKeyBoard );

    for( i = 0; i < g_JoystickCount; i++ )
    {
        g_pDIDJoyPad[i]->lpVtbl->Poll( g_pDIDJoyPad[i] );
        g_pDIDJoyPad[i]->lpVtbl->Acquire( g_pDIDJoyPad[i] );
    }

    /* L[{[h̒ڃf[^擾 */
    memcpy( g_diKeyStateOld, g_diKeyState, sizeof(g_diKeyState) );
    g_pDIDKeyBoard->lpVtbl->GetDeviceState( g_pDIDKeyBoard, 256, g_diKeyState );

    /* Q[pbh̃f[^擾 */
    for( i = 0; i < g_JoystickCount; i++ )
    {
        int temp;
        int j;

        g_pDIDJoyPad[i]->lpVtbl->GetDeviceState( g_pDIDJoyPad[i], sizeof(DIJOYSTATE), &paddata );

        for( j = 0; j < 20; j++ )
        {
            g_PadStateOld[i].button[j] = g_PadState[i].button[j];
            g_PadState[i].button[j] = 0;
        }

        /*  */
        if( paddata.lX < g_PadInfo[i].left )
        {
            g_PadState[i].button[P_LEFT] = 1;
        }
        /* E */
        else if( paddata.lX > g_PadInfo[i].right )
        {
            g_PadState[i].button[P_RIGHT] = 1;
        }

        /*  */
        if( paddata.lY < g_PadInfo[i].up )
        {
            g_PadState[i].button[P_UP] = 1;
        }
        /*  */
        else if( paddata.lY > g_PadInfo[i].down )
        {
            g_PadState[i].button[P_DOWN] = 1;
        }

        /* {^ */
        for( j = 0; j < 16; j++)
        {
            g_PadState[i].button[j + 4] = paddata.rgbButtons[j] >> 7;
        }
    }

    /* }EX{^̏ */
    g_byMouseStateOld_L = g_byMouseState_L;
    g_byMouseStateOld_M = g_byMouseState_M;
    g_byMouseStateOld_R = g_byMouseState_R;
    g_byMouseState_L = GetKeyState( VK_LBUTTON );
    g_byMouseState_M = GetKeyState( VK_MBUTTON );
    g_byMouseState_R = GetKeyState( VK_RBUTTON );
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   ̓͂x̑ŕԂ
 ---------------------------------------------------------------------*/
static VALUE Input_x( int argc, VALUE *argv, VALUE obj )
{
    int x = 0;
	VALUE vnumber;
	int number;

    rb_scan_args( argc, argv, "01", &vnumber);

	number = (vnumber == Qnil ? 0 : NUM2INT( vnumber ));

	if( number < 0 || number >= PADMAX )
    {
        rb_raise( eDXRubyError, "l͈͊OłB - Input_x" );
    }

	/* Ђ */
    if( g_diKeyState[g_PadState[number].PadConfig[P_LEFT]] & 0x80  || g_PadState[number].button[P_LEFT] == 1 )
    {
        x = x - 1;
    }

    /* ݂ */
    if( g_diKeyState[g_PadState[number].PadConfig[P_RIGHT]] & 0x80  || g_PadState[number].button[P_RIGHT] == 1 )
    {
        x = x + 1;
    }

    return INT2FIX( x );
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   c̓͂y̑ŕԂ
 ---------------------------------------------------------------------*/
static VALUE Input_y( int argc, VALUE *argv, VALUE obj )
{
    int y = 0;
	VALUE vnumber;
	int number;

    rb_scan_args( argc, argv, "01", &vnumber);

	number = (vnumber == Qnil ? 0 : NUM2INT( vnumber ));

	if( number < 0 || number >= PADMAX )
    {
        rb_raise( eDXRubyError, "l͈͊OłB - Input_y" );
    }


    /*  */
    if( g_diKeyState[g_PadState[number].PadConfig[P_UP]] & 0x80  || g_PadState[number].button[P_UP] == 1 )
    {
        y = y - 1;
    }

    /*  */
    if( g_diKeyState[g_PadState[number].PadConfig[P_DOWN]] & 0x80  || g_PadState[number].button[P_DOWN] == 1 )
    {
        y = y + 1;
    }

    return INT2FIX( y );
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   ĂtrueɂȂB̓L[R[hB
 ---------------------------------------------------------------------*/
static VALUE Input_key( VALUE obj , VALUE vkey )
{
	int key;

	key = NUM2INT( vkey );
	if( key < 0 || key >= 256 )
    {
        rb_raise( eDXRubyError, "l͈͊OłB - Input_key" );
    }

    if( g_diKeyState[key] & 0x80 )
    {
        return Qtrue;
    }

    return Qfalse;
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   uԂtrueɂȂB̓{^ԍB
 ---------------------------------------------------------------------*/
static VALUE Input_buttonPush( int argc, VALUE *argv, VALUE obj )
{
	VALUE vnumber, vbutton;
	int number, button;

    rb_scan_args( argc, argv, "11", &vbutton, &vnumber);

	button = NUM2INT( vbutton );
	number = (vnumber == Qnil ? 0 : NUM2INT( vnumber ));

	if( number < 0 || button < 0 || number >= PADMAX || button >= 20 )
    {
        rb_raise( eDXRubyError, "l͈͊OłB - Input_button" );
    }

	if( g_diKeyState[g_PadState[number].PadConfig[button]] & 0x80 ||	/* ͂Ă */
         g_PadState[number].button[button] == 1 )
    {
    	if( !(g_diKeyStateOld[g_PadState[number].PadConfig[button]] & 0x80) &&	/* OOFFł */
         g_PadStateOld[number].button[button] != 1 )
	    {
	    	g_diKeyCount[g_PadState[number].PadConfig[button]] = 0;				/* JEg */
	    	return Qtrue;														/* Ȃɂ͂ƂTrue */
	    }
		else																	/* OON */
		{
			g_diKeyCount[g_PadState[number].PadConfig[button]]++;				/* JEg */
			if( g_iInputWait <= g_diKeyCount[g_PadState[number].PadConfig[button]] )	/* EFCg^C𒴂 */
			{
				if( g_iInterval != 0 &&
				   (g_diKeyCount[g_PadState[number].PadConfig[button]] - g_iInputWait) % g_iInterval == 0 ) /* C^[o^CƂ */
				{
			    	return Qtrue;														/* True */
				}
			}
			
		}
	}
    return Qfalse;
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   uԂtrueɂȂB̓L[R[hB
 ---------------------------------------------------------------------*/
static VALUE Input_keyPush( VALUE obj , VALUE vkey )
{
	int key;

	key = NUM2INT( vkey );
    if( key < 0 || key >= 256 )
    {
        rb_raise( eDXRubyError, "l͈͊OłB - Input_key" );
    }

    if( (g_diKeyState[key] & 0x80) )	/* ͂Ă */
	{
		if( !(g_diKeyStateOld[key] & 0x80) )	/* OOFFł */
	    {
	    	g_diKeyCount[key] = 0;				/* JEg */
    	    return Qtrue;						/* Ȃɂ͂ƂTrue */
	    }
		else																	/* OON */
		{
			g_diKeyCount[key]++;				/* JEg */
			if( g_iInputWait <= g_diKeyCount[key] )	/* EFCg^C𒴂 */
			{
				if( g_iInterval != 0 &&
				   (g_diKeyCount[key] - g_iInputWait) % g_iInterval == 0 ) /* C^[o^CƂ */
				{
			    	return Qtrue;														/* True */
				}
			}
			
		}
	}
    return Qfalse;
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   ĂtrueɂȂB̓{^ԍB
 ---------------------------------------------------------------------*/
static VALUE Input_button( int argc, VALUE *argv, VALUE obj )
{
	VALUE vnumber, vbutton;
	int number, button;

    rb_scan_args( argc, argv, "11", &vbutton, &vnumber);

	button = NUM2INT( vbutton );
	number = (vnumber == Qnil ? 0 : NUM2INT( vnumber ));

	if( number < 0 || button < 0 || number >= PADMAX || button >= 20 )
    {
        rb_raise( eDXRubyError, "l͈͊OłB - Input_button" );
    }

    if( g_diKeyState[g_PadState[number].PadConfig[button]] & 0x80 ||
        g_PadState[number].button[button] == 1 )
    {
        return Qtrue;
    }

    return Qfalse;
}


/*--------------------------------------------------------------------
   pbhƃL[̑Ήݒ肷
 ---------------------------------------------------------------------*/
static void Input_SetConfig( int number, int pad, int key )
{
    g_PadState[number].PadConfig[pad] = key;
}

static VALUE Input_setconfig( int argc, VALUE *argv, VALUE obj )
{
	VALUE vnumber, vpad, vkey;
	int number, pad, key;

	rb_scan_args( argc, argv, "21", &vpad, &vkey, &vnumber);

	number = (vnumber == Qnil ? 0 : NUM2INT( vnumber ));
	pad = NUM2INT( vpad );
	key = NUM2INT( vkey );

	if( number < 0 || pad < 0 || key < 0 || number >= PADMAX || pad >= 20 || key >= 256 )
    {
        rb_raise( eDXRubyError, "l͈͊OłB - Input_setconfig" );
    }

    Input_SetConfig( number, pad, key );

    return obj;
}


/*--------------------------------------------------------------------
   }EXzC[̏ԂԂ
 ---------------------------------------------------------------------*/
static VALUE Input_getmousewheelpos( VALUE obj )
{
    return INT2FIX(g_WindowInfo.mousewheelpos);
}


/*--------------------------------------------------------------------
   }EXzC[̏Ԃݒ肷
 ---------------------------------------------------------------------*/
static VALUE Input_setmousewheelpos( VALUE obj, VALUE wheelpos )
{
    g_WindowInfo.mousewheelpos = NUM2INT( wheelpos );

    return obj;
}


/*--------------------------------------------------------------------
   }EX̃{^ԂԂ
 ---------------------------------------------------------------------*/
static VALUE Input_getmousebutton( VALUE obj, VALUE button )
{

    switch( NUM2INT( button ) )
    {
    case M_LBUTTON:
        if( g_byMouseState_L & 0x80 )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }

    case M_RBUTTON:
        if( g_byMouseState_R & 0x80 )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }

    case M_MBUTTON:
        if( g_byMouseState_M & 0x80 )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }
    }

    return Qnil;
}


/*--------------------------------------------------------------------
   }EX̃{^ԂԂ
 ---------------------------------------------------------------------*/
static VALUE Input_mousePush( VALUE obj, VALUE button )
{

    switch( NUM2INT( button ) )
    {
    case M_LBUTTON:
        if( (g_byMouseState_L & 0x80) && !(g_byMouseStateOld_L & 0x80) )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }

    case M_RBUTTON:
        if( g_byMouseState_R & 0x80 && !(g_byMouseStateOld_R & 0x80) )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }

    case M_MBUTTON:
        if( g_byMouseState_M & 0x80 && !(g_byMouseStateOld_M & 0x80) )
        {
            return Qtrue;
        }
        else
        {
            return Qfalse;
        }
    }

    return Qnil;
}


/*--------------------------------------------------------------------
   }EXJ[\̈ʒuԂ
 ---------------------------------------------------------------------*/
static VALUE Input_getmouseposx( VALUE obj )
{
    POINT cursor;

    GetCursorPos( &cursor );
    ScreenToClient( g_hWind, &cursor );
    return INT2FIX( cursor.x );
}


/*--------------------------------------------------------------------
   }EXJ[\̈ʒuԂ
 ---------------------------------------------------------------------*/
static VALUE Input_getmouseposy( VALUE obj )
{
    POINT cursor;

    GetCursorPos( &cursor );
    ScreenToClient( g_hWind, &cursor );

    return INT2FIX( cursor.y );
}


/*--------------------------------------------------------------------
   }EX`悷邩ǂ̐ݒ
 ---------------------------------------------------------------------*/
static VALUE Input_enablemouse( VALUE obj, VALUE draw )
{
	VALUE flag = Qfalse;

	if( draw != Qnil && draw != Qfalse )
	{
		flag = Qtrue;
	}

	if( g_WindowInfo.enablemouse != flag )
    {
        if( flag == Qtrue )
        {
            ShowCursor( TRUE );
        }
        else
        {
            ShowCursor( FALSE );
        }

        g_WindowInfo.enablemouse = flag;
    }

    return draw;
}


/*--------------------------------------------------------------------
   InputW[̃I[gs[gԐݒ
 ---------------------------------------------------------------------*/
static VALUE Input_setrepeat( VALUE obj , VALUE vwait, VALUE vinterval )
{
	int wait, interval;

	g_iInputWait = NUM2INT( vwait );
	g_iInterval = NUM2INT( vinterval );

	return obj;
}



/*********************************************************************
 * FontW[
 *
 * D3DXFontC^[tF[XgpătHg`悷B
 * XvCg`ɍނƂłƂ肠B
 *********************************************************************/
/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Font( struct DXRubyFont* font )
{
    /* tHgIuWFNg̊J */
    if( font )
    {
		RELEASE( font->pD3DXFont );
        free( font );
        font = NULL;

    	g_iRefAll--;
    	if( g_iRefAll == 0 )
    	{
    		CoUninitialize();
    	}
    }
}


/*--------------------------------------------------------------------
   FontNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Font_allocate( VALUE klass )
{
    VALUE obj;
    struct DXRubyFont *font;

    /* DXRubyFont̃擾FontIuWFNg */
    font = malloc( sizeof(struct DXRubyFont) );
    if( font == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Font_allocate" );
    return Data_Wrap_Struct(klass, 0, release_Font, font);
}


/*--------------------------------------------------------------------
   FontNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Font_initialize( int argc, VALUE *argv, VALUE obj )
{
    struct DXRubyFont *font;
    HRESULT hr;
	D3DXFONT_DESC desc;
	VALUE size, fontname;

    /* foCXIuWFNg̏`FbN */
    if( g_pD3DDevice == NULL )
    {
        rb_raise( eDXRubyError, "DirectX GraphicsĂ܂" );
    }

	rb_scan_args( argc, argv, "11", &size, &fontname );

	desc.Height          = NUM2INT( size );
	desc.Width           = 0;
	desc.Weight          = FW_DONTCARE;
	desc.MipLevels       = 0;
	desc.Italic          = FALSE;
	desc.CharSet         = SHIFTJIS_CHARSET;
	desc.OutputPrecision = 0;
	desc.Quality         = DEFAULT_QUALITY;
	desc.PitchAndFamily  = DEFAULT_PITCH || FF_DONTCARE;
	if( fontname == Qnil )
	{
		lstrcpy(desc.FaceName, "lr SVbN");
	}
	else
	{
		Check_Type(fontname, T_STRING);
		lstrcpy(desc.FaceName, RSTRING_PTR( fontname ));
	}

	/* tHgIuWFNgo */
    Data_Get_Struct( obj, struct DXRubyFont, font );

	hr = D3DXCreateFontIndirect( g_pD3DDevice, &desc, &font->pD3DXFont );

	if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "tHg̍쐬Ɏs܂ - D3DXCreateFontIndirect" );
    }

	g_iRefAll++;

	return obj;
}


/*
***************************************************************
*
*         Global functions
*
***************************************************************/

void Init_dxruby()
{
    HRESULT hr;

    hr = CoInitialize(NULL);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "COM̏Ɏs܂ - CoInitialize" );
    }

    /* CX^Xnh擾 */
    g_hInstance = (HINSTANCE)GetModuleHandle( NULL );

    /* WindowW[o^ */
    mWindow = rb_define_module( "Window" );

    /* WindowW[Ƀ\bho^ */
    rb_define_singleton_method( mWindow, "loop"     , Window_loop       , 0  );
    rb_define_singleton_method( mWindow, "draw"     , Window_draw       , -1 );
    rb_define_singleton_method( mWindow, "drawScale", Window_drawScale  , -1 );
    rb_define_singleton_method( mWindow, "drawRot"  , Window_drawRot    , -1 );
    rb_define_singleton_method( mWindow, "drawAlpha", Window_drawAlpha  , -1 );
    rb_define_singleton_method( mWindow, "drawAdd"  , Window_drawAdd    , -1 );
    rb_define_singleton_method( mWindow, "drawEx"   , Window_drawEx     , -1 );
    rb_define_singleton_method( mWindow, "drawFont" , Window_drawFont   , -1 );
    rb_define_singleton_method( mWindow, "x="       , Window_setx       , 1  );
    rb_define_singleton_method( mWindow, "y="       , Window_sety       , 1  );
    rb_define_singleton_method( mWindow, "width="   , Window_setwidth   , 1  );
    rb_define_singleton_method( mWindow, "height="  , Window_setheight  , 1  );
    rb_define_singleton_method( mWindow, "caption=" , Window_setCaption , 1  );
    rb_define_singleton_method( mWindow, "scale="   , Window_setScale   , 1  );
    rb_define_singleton_method( mWindow, "windowed=", Window_setwindowed, 1  );
    rb_define_singleton_method( mWindow, "getScreenShot", Window_getScreenShot, -1 );
    rb_define_singleton_method( mWindow, "fps="     , Window_setfps     , 1  );
    rb_define_singleton_method( mWindow, "fps"      , Window_getfps     , 0  );
    rb_define_singleton_method( mWindow, "openFilename" , Window_openDialog, 2 );
    rb_define_singleton_method( mWindow, "saveFilename" , Window_saveDialog, 2 );
    rb_define_singleton_method( mWindow, "getLoad"      , Window_getload, 0  );
    rb_define_singleton_method( mWindow, "frameskip="   , Window_setframeskip, 1  );
    rb_define_singleton_method( mWindow, "bgcolor=" , Window_setbgcolor , 1  );



	/* ImageNX` */
    cImage = rb_define_class( "Image", rb_cObject );

    /* ImageNXɃNX\bho^*/
    rb_define_singleton_method(cImage, "load", Image_load, -1);
    rb_define_singleton_method(cImage, "loadToArray", Image_loadToArray, 3);
    rb_define_singleton_method(cImage, "createFromArray", Image_createFromArray, 3);

    /* ImageNXɃ\bho^*/
    rb_define_method( cImage, "initialize", Image_initialize, -1 );
    rb_define_method( cImage, "width"     , Image_getWidth  , 0 );
    rb_define_method( cImage, "height"    , Image_getHeight , 0 );
    rb_define_method( cImage, "[]="       , Image_setPixel  , 3 );
    rb_define_method( cImage, "[]"        , Image_getPixel  , 2 );
    rb_define_method( cImage, "box"       , Image_box       , 5 );
    rb_define_method( cImage, "line"      , Image_line      , 5 );
    rb_define_method( cImage, "circle"    , Image_circle    , 4 );
    rb_define_method( cImage, "circleFill", Image_circleFill, 4 );
    rb_define_method( cImage, "x"         , Image_getX      , 0 );
    rb_define_method( cImage, "y"         , Image_getY      , 0 );
    rb_define_method( cImage, "width="    , Image_setWidth  , 1 );
    rb_define_method( cImage, "height="   , Image_setHeight , 1 );
    rb_define_method( cImage, "x="        , Image_setX      , 1 );
    rb_define_method( cImage, "y="        , Image_setY      , 1 );
    rb_define_method( cImage, "compare"   , Image_compare   , 3 );

    /* ImageIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cImage, Image_allocate );


	/* InputW[o^ */
    mInput = rb_define_module( "Input" );

    /* InputW[Ƀ\bho^ */
    rb_define_singleton_method( mInput, "x"              , Input_x               , -1 );
    rb_define_singleton_method( mInput, "y"              , Input_y               , -1 );
    rb_define_singleton_method( mInput, "mousePosX"      , Input_getmouseposx    , 0  );
    rb_define_singleton_method( mInput, "mousePosY"      , Input_getmouseposy    , 0  );
    rb_define_singleton_method( mInput, "keyDown?"       , Input_key             , 1  );
    rb_define_singleton_method( mInput, "keyPush?"       , Input_keyPush         , 1  );
    rb_define_singleton_method( mInput, "padDown?"       , Input_button          , -1 );
    rb_define_singleton_method( mInput, "padPush?"       , Input_buttonPush      , -1 );
    rb_define_singleton_method( mInput, "mouseDown?"     , Input_getmousebutton  , 1  );
    rb_define_singleton_method( mInput, "mousePush?"     , Input_mousePush       , 1  );
    rb_define_singleton_method( mInput, "mouseEnable="   , Input_enablemouse     , 1  );
    rb_define_singleton_method( mInput, "mouseWheelPos"  , Input_getmousewheelpos, 0  );
    rb_define_singleton_method( mInput, "mouseWheelPos=" , Input_setmousewheelpos, 1  );
    rb_define_singleton_method( mInput, "setConfig"      , Input_setconfig       , -1 );
    rb_define_singleton_method( mInput, "setRepeat"      , Input_setrepeat       , 2  );


    /* FontNXo^ */
    cFont = rb_define_class( "Font", rb_cObject );

	/* ImageNXɃ\bho^*/
    rb_define_method( cFont, "initialize", Font_initialize, -1 );

    /* FontIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cFont, Font_allocate );


	/* SoundNX` */
    cSound = rb_define_class( "Sound", rb_cObject );

    /* SoundNXɃ\bho^*/
    rb_define_method( cSound, "initialize"   , Sound_initialize   , 1 );
    rb_define_method( cSound, "play"         , Sound_play         , 0 );
    rb_define_method( cSound, "bgmplay"      , Sound_bgmplay      , 0 );
    rb_define_method( cSound, "stop"         , Sound_stop         , 0 );
    rb_define_method( cSound, "setVolume"    , Sound_setVolume    , -1 );
    rb_define_method( cSound, "start="       , Sound_setStart     , 1 );
    rb_define_method( cSound, "loopStart="   , Sound_setLoopStart , 1 );
    rb_define_method( cSound, "loopEnd="     , Sound_setLoopEnd   , 1 );
    rb_define_method( cSound, "loopCount="   , Sound_setLoopCount , 1 );

    /* SoundIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cSound, Sound_allocate );


	/* SoundEffectNX` */
    cSoundEffect = rb_define_class( "SoundEffect", rb_cObject );

    /* SoundEffectNXɃ\bho^*/
    rb_define_method( cSoundEffect, "initialize", SoundEffect_initialize, -1 );
    rb_define_method( cSoundEffect, "play"      , SoundEffect_play      , 0 );
    rb_define_method( cSoundEffect, "stop"      , SoundEffect_stop      , 0 );
    rb_define_method( cSoundEffect, "add"       , SoundEffect_add       , -1 );

    /* SoundIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cSoundEffect, SoundEffect_allocate );


	/* L[{[h̃XLR[h萔ݒ */
    rb_define_const( rb_cObject, "K_ESCAPE"     , INT2FIX(DIK_ESCAPE) );
    rb_define_const( rb_cObject, "K_TAB"        , INT2FIX(DIK_TAB) );
    rb_define_const( rb_cObject, "K_RETURN"     , INT2FIX(DIK_RETURN) );
    rb_define_const( rb_cObject, "K_LCONTROL"   , INT2FIX(DIK_LCONTROL) );
    rb_define_const( rb_cObject, "K_LSHIFT"     , INT2FIX(DIK_LSHIFT) );
    rb_define_const( rb_cObject, "K_RCONTROL"   , INT2FIX(DIK_RCONTROL) );
    rb_define_const( rb_cObject, "K_RSHIFT"     , INT2FIX(DIK_RSHIFT) );
    rb_define_const( rb_cObject, "K_LMENU"      , INT2FIX(DIK_LMENU) );
    rb_define_const( rb_cObject, "K_RMENU"      , INT2FIX(DIK_RMENU) );
    rb_define_const( rb_cObject, "K_SPACE"      , INT2FIX(DIK_SPACE) );
    rb_define_const( rb_cObject, "K_1"          , INT2FIX(DIK_1) );
    rb_define_const( rb_cObject, "K_2"          , INT2FIX(DIK_2) );
    rb_define_const( rb_cObject, "K_3"          , INT2FIX(DIK_3) );
    rb_define_const( rb_cObject, "K_4"          , INT2FIX(DIK_4) );
    rb_define_const( rb_cObject, "K_5"          , INT2FIX(DIK_5) );
    rb_define_const( rb_cObject, "K_6"          , INT2FIX(DIK_6) );
    rb_define_const( rb_cObject, "K_7"          , INT2FIX(DIK_7) );
    rb_define_const( rb_cObject, "K_8"          , INT2FIX(DIK_8) );
    rb_define_const( rb_cObject, "K_9"          , INT2FIX(DIK_9) );
    rb_define_const( rb_cObject, "K_0"          , INT2FIX(DIK_0) );
    rb_define_const( rb_cObject, "K_Q"          , INT2FIX(DIK_Q) );
    rb_define_const( rb_cObject, "K_W"          , INT2FIX(DIK_W) );
    rb_define_const( rb_cObject, "K_E"          , INT2FIX(DIK_E) );
    rb_define_const( rb_cObject, "K_R"          , INT2FIX(DIK_R) );
    rb_define_const( rb_cObject, "K_T"          , INT2FIX(DIK_T) );
    rb_define_const( rb_cObject, "K_Y"          , INT2FIX(DIK_Y) );
    rb_define_const( rb_cObject, "K_U"          , INT2FIX(DIK_U) );
    rb_define_const( rb_cObject, "K_I"          , INT2FIX(DIK_I) );
    rb_define_const( rb_cObject, "K_O"          , INT2FIX(DIK_O) );
    rb_define_const( rb_cObject, "K_P"          , INT2FIX(DIK_P) );
    rb_define_const( rb_cObject, "K_A"          , INT2FIX(DIK_A) );
    rb_define_const( rb_cObject, "K_S"          , INT2FIX(DIK_S) );
    rb_define_const( rb_cObject, "K_D"          , INT2FIX(DIK_D) );
    rb_define_const( rb_cObject, "K_F"          , INT2FIX(DIK_F) );
    rb_define_const( rb_cObject, "K_G"          , INT2FIX(DIK_G) );
    rb_define_const( rb_cObject, "K_H"          , INT2FIX(DIK_H) );
    rb_define_const( rb_cObject, "K_J"          , INT2FIX(DIK_J) );
    rb_define_const( rb_cObject, "K_K"          , INT2FIX(DIK_K) );
    rb_define_const( rb_cObject, "K_L"          , INT2FIX(DIK_L) );
    rb_define_const( rb_cObject, "K_Z"          , INT2FIX(DIK_Z) );
    rb_define_const( rb_cObject, "K_X"          , INT2FIX(DIK_X) );
    rb_define_const( rb_cObject, "K_C"          , INT2FIX(DIK_C) );
    rb_define_const( rb_cObject, "K_V"          , INT2FIX(DIK_V) );
    rb_define_const( rb_cObject, "K_B"          , INT2FIX(DIK_B) );
    rb_define_const( rb_cObject, "K_N"          , INT2FIX(DIK_N) );
    rb_define_const( rb_cObject, "K_M"          , INT2FIX(DIK_M) );
    rb_define_const( rb_cObject, "K_F1"         , INT2FIX(DIK_F1) );
    rb_define_const( rb_cObject, "K_F2"         , INT2FIX(DIK_F2) );
    rb_define_const( rb_cObject, "K_F3"         , INT2FIX(DIK_F3) );
    rb_define_const( rb_cObject, "K_F4"         , INT2FIX(DIK_F4) );
    rb_define_const( rb_cObject, "K_F5"         , INT2FIX(DIK_F5) );
    rb_define_const( rb_cObject, "K_F6"         , INT2FIX(DIK_F6) );
    rb_define_const( rb_cObject, "K_F7"         , INT2FIX(DIK_F7) );
    rb_define_const( rb_cObject, "K_F8"         , INT2FIX(DIK_F8) );
    rb_define_const( rb_cObject, "K_F9"         , INT2FIX(DIK_F9) );
    rb_define_const( rb_cObject, "K_F10"        , INT2FIX(DIK_F10) );
    rb_define_const( rb_cObject, "K_F11"        , INT2FIX(DIK_F11) );
    rb_define_const( rb_cObject, "K_F12"        , INT2FIX(DIK_F12) );
    rb_define_const( rb_cObject, "K_NUMPAD7"    , INT2FIX(DIK_NUMPAD7) );
    rb_define_const( rb_cObject, "K_NUMPAD8"    , INT2FIX(DIK_NUMPAD8) );
    rb_define_const( rb_cObject, "K_NUMPAD9"    , INT2FIX(DIK_NUMPAD9) );
    rb_define_const( rb_cObject, "K_NUMPAD4"    , INT2FIX(DIK_NUMPAD4) );
    rb_define_const( rb_cObject, "K_NUMPAD5"    , INT2FIX(DIK_NUMPAD5) );
    rb_define_const( rb_cObject, "K_NUMPAD6"    , INT2FIX(DIK_NUMPAD6) );
    rb_define_const( rb_cObject, "K_NUMPAD1"    , INT2FIX(DIK_NUMPAD1) );
    rb_define_const( rb_cObject, "K_NUMPAD2"    , INT2FIX(DIK_NUMPAD2) );
    rb_define_const( rb_cObject, "K_NUMPAD3"    , INT2FIX(DIK_NUMPAD3) );
    rb_define_const( rb_cObject, "K_NUMPAD0"    , INT2FIX(DIK_NUMPAD0) );
    rb_define_const( rb_cObject, "K_NUMPADENTER", INT2FIX(DIK_NUMPADENTER) );
    rb_define_const( rb_cObject, "K_UP"         , INT2FIX(DIK_UP) );
    rb_define_const( rb_cObject, "K_LEFT"       , INT2FIX(DIK_LEFT) );
    rb_define_const( rb_cObject, "K_RIGHT"      , INT2FIX(DIK_RIGHT) );
    rb_define_const( rb_cObject, "K_DOWN"       , INT2FIX(DIK_DOWN) );

    rb_define_const( rb_cObject, "P_UP"         , INT2FIX(P_UP)       );
    rb_define_const( rb_cObject, "P_LEFT"       , INT2FIX(P_LEFT)     );
    rb_define_const( rb_cObject, "P_RIGHT"      , INT2FIX(P_RIGHT)    );
    rb_define_const( rb_cObject, "P_DOWN"       , INT2FIX(P_DOWN)     );
    rb_define_const( rb_cObject, "P_BUTTON0"    , INT2FIX(P_BUTTON0)  );
    rb_define_const( rb_cObject, "P_BUTTON1"    , INT2FIX(P_BUTTON1)  );
    rb_define_const( rb_cObject, "P_BUTTON2"    , INT2FIX(P_BUTTON2)  );
    rb_define_const( rb_cObject, "P_BUTTON3"    , INT2FIX(P_BUTTON3)  );
    rb_define_const( rb_cObject, "P_BUTTON4"    , INT2FIX(P_BUTTON4)  );
    rb_define_const( rb_cObject, "P_BUTTON5"    , INT2FIX(P_BUTTON5)  );
    rb_define_const( rb_cObject, "P_BUTTON6"    , INT2FIX(P_BUTTON6)  );
    rb_define_const( rb_cObject, "P_BUTTON7"    , INT2FIX(P_BUTTON7)  );
    rb_define_const( rb_cObject, "P_BUTTON8"    , INT2FIX(P_BUTTON8)  );
    rb_define_const( rb_cObject, "P_BUTTON9"    , INT2FIX(P_BUTTON9)  );
    rb_define_const( rb_cObject, "P_BUTTON10"   , INT2FIX(P_BUTTON10) );
    rb_define_const( rb_cObject, "P_BUTTON11"   , INT2FIX(P_BUTTON11) );
    rb_define_const( rb_cObject, "P_BUTTON12"   , INT2FIX(P_BUTTON12) );
    rb_define_const( rb_cObject, "P_BUTTON13"   , INT2FIX(P_BUTTON13) );
    rb_define_const( rb_cObject, "P_BUTTON14"   , INT2FIX(P_BUTTON14) );
    rb_define_const( rb_cObject, "P_BUTTON15"   , INT2FIX(P_BUTTON15) );

    rb_define_const( rb_cObject, "M_LBUTTON"    , INT2FIX(M_LBUTTON)  );
    rb_define_const( rb_cObject, "M_RBUTTON"    , INT2FIX(M_RBUTTON)  );
    rb_define_const( rb_cObject, "M_MBUTTON"    , INT2FIX(M_MBUTTON)  );

    rb_define_const( rb_cObject, "FORMAT_JPEG"  , INT2FIX(FORMAT_JPEG));
    rb_define_const( rb_cObject, "FORMAT_PNG"   , INT2FIX(FORMAT_PNG) );
    rb_define_const( rb_cObject, "FORMAT_BMP"   , INT2FIX(FORMAT_BMP) );

    rb_define_const( rb_cObject, "WAVE_SIN"     , INT2FIX(WAVE_SIN) );
    rb_define_const( rb_cObject, "WAVE_SAW"     , INT2FIX(WAVE_SAW) );
    rb_define_const( rb_cObject, "WAVE_TRI"     , INT2FIX(WAVE_TRI) );
    rb_define_const( rb_cObject, "WAVE_RECT"    , INT2FIX(WAVE_RECT) );

    /* O` */
    eDXRubyError = rb_define_class_under( mWindow, "DXRubyError", rb_eRuntimeError );

    /* 萔o^ */
/*    rb_define_const( cDXRuby, "VERSION", rb_str_new2( DXRUBY_VERSION ) );*/

    /* V{` */
    symbol_add            = ID2SYM(rb_intern("add"));
    symbol_angle          = ID2SYM(rb_intern("angle"));
    symbol_alpha          = ID2SYM(rb_intern("alpha"));
    symbol_scalex         = ID2SYM(rb_intern("scalex"));
    symbol_scaley         = ID2SYM(rb_intern("scaley"));
    symbol_centerx        = ID2SYM(rb_intern("centerx"));
    symbol_centery        = ID2SYM(rb_intern("centery"));
    symbol_z              = ID2SYM(rb_intern("z"));
    symbol_color          = ID2SYM(rb_intern("color"));

    /* IɎs֐ */
    rb_set_end_proc( Window_shutdown, Qnil );

    /* XvCg\̂̏lݒ */
	g_SpriteCount = 0;
	g_SpriteAllocateCount = 128;
	g_SpriteList = malloc( g_SpriteAllocateCount * sizeof(struct DXRubySpriteList) );
	g_SpriteStruct = malloc( g_SpriteAllocateCount * sizeof(struct DXRubySprite) );

    g_WindowInfo.x        = CW_USEDEFAULT;
    g_WindowInfo.y        = CW_USEDEFAULT;
    g_WindowInfo.width    = 640;
    g_WindowInfo.height   = 480;
    g_WindowInfo.windowed = Qtrue;
    g_WindowInfo.created  = Qfalse;
    g_WindowInfo.scale    = 1;
    g_WindowInfo.enablemouse = Qtrue;
    g_WindowInfo.mousewheelpos = 0;
    g_WindowInfo.fps = 60;
    g_WindowInfo.frameskip = Qfalse;
    g_WindowInfo.r = 0;
    g_WindowInfo.g = 0;
    g_WindowInfo.b = 0;

    ShowCursor( TRUE );

    Input_SetConfig( 0, P_LEFT   , DIK_LEFT  );
    Input_SetConfig( 0, P_RIGHT  , DIK_RIGHT );
    Input_SetConfig( 0, P_UP     , DIK_UP    );
    Input_SetConfig( 0, P_DOWN   , DIK_DOWN  );
    Input_SetConfig( 0, P_BUTTON0, DIK_Z     );
    Input_SetConfig( 0, P_BUTTON1, DIK_X     );
    Input_SetConfig( 0, P_BUTTON2, DIK_C     );

	g_iInputWait = 0;
	g_iInterval = 0;

	/* EBhE쐬(̎_ł͔\) */
    InitWindow();

    /* DirectX Graphics̏ */
    InitDXGraphics();

    /* DirectInput */
    InitDirectInput();
}


/*--------------------------------------------------------------------
  i֐jEBhE̐
 ---------------------------------------------------------------------*/
static void InitWindow( void )
{
    WNDCLASSEX wcex;
    RECT rect;

    /* EChEENX̓o^ */
    wcex.cbSize        = sizeof( WNDCLASSEX );
    wcex.style         = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc   = (WNDPROC)MainWndProc;
    wcex.cbClsExtra    = 0;
    wcex.cbWndExtra    = 0;
    wcex.hInstance     = g_hInstance;
    wcex.hIcon         = NULL;
    wcex.hIconSm       = NULL;
    wcex.hCursor       = LoadCursor( NULL, IDC_ARROW );
    wcex.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
    wcex.lpszMenuName  = NULL;
    wcex.lpszClassName = "DXRuby";

    if( !RegisterClassEx( &wcex ) )
    {
        rb_raise( eDXRubyError, "EBhȄɎs܂ - RegusterClassEx" );
    }

    /* CEEChE쐬(EChEE[hp) */
    rect.top     = 0;
    rect.left    = 0;
    rect.right   = g_WindowInfo.width;
    rect.bottom  = g_WindowInfo.height;

    AdjustWindowRect( &rect, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU, FALSE );

    rect.right   = rect.right - rect.left;
    rect.bottom  = rect.bottom - rect.top;
    rect.left    = 0;
    rect.top     = 0;

    g_hWind = CreateWindow( "DXRuby", "DXRuby Application",
                           WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU,
                           g_WindowInfo.x, g_WindowInfo.y,
                           rect.right - rect.left, rect.bottom - rect.top,
                           NULL, NULL, g_hInstance, NULL );
    if( g_hWind == NULL )
    {
        rb_raise( eDXRubyError, "EBhȄɎs܂ - CreateWindow" );
    }

    GetWindowRect( g_hWind, &rect );



}


/*--------------------------------------------------------------------
  i֐jDirectX Graphics
 ---------------------------------------------------------------------*/
static void InitDXGraphics( void )
{
    D3DVIEWPORT9 vp;
    HRESULT hr;

    /* Direct3DIuWFNg̍쐬 */
    g_pD3D = Direct3DCreate9( D3D_SDK_VERSION );

    if( g_pD3D == NULL )
    {
        rb_raise( eDXRubyError, "DirectX Graphics̏Ɏs܂ - Direct3DCreate9" );
    }

    /* D3DDeviceIuWFNg̍쐬(EChEE[h) */
    ZeroMemory( &g_D3DPP, sizeof( g_D3DPP ) );

    g_D3DPP.BackBufferWidth            = 0;
    g_D3DPP.BackBufferHeight           = 0;
    g_D3DPP.BackBufferFormat           = D3DFMT_A8R8G8B8;
    g_D3DPP.BackBufferCount            = 1;
    g_D3DPP.MultiSampleType            = D3DMULTISAMPLE_NONE;
    g_D3DPP.MultiSampleQuality         = 0;
    g_D3DPP.SwapEffect                 = D3DSWAPEFFECT_DISCARD;
    g_D3DPP.hDeviceWindow              = g_hWind;
    g_D3DPP.Windowed                   = TRUE;
    g_D3DPP.EnableAutoDepthStencil     = FALSE;
    g_D3DPP.AutoDepthStencilFormat     = D3DFMT_UNKNOWN;
    g_D3DPP.Flags                      = 0;
    g_D3DPP.FullScreen_RefreshRateInHz = 0;
    g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE;

    hr = g_pD3D->lpVtbl->CreateDevice( g_pD3D, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWind,
                                       D3DCREATE_HARDWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice );

    if( FAILED( hr ) )
    {
        /* foCX̐Ɏs烊t@XX^CUg悤ɂĂ݂ */
        /* ͓ǒxĘbɂȂȂ[hĩR[hj */
        hr = g_pD3D->lpVtbl->CreateDevice( g_pD3D, D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, g_hWind,
                                           D3DCREATE_SOFTWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectX Graphics̏Ɏs܂ - CreateDevice" );
        }
    }

    /* r[|[g̐ݒ */
    vp.X       = 0;
    vp.Y       = 0;
    vp.Width   = g_D3DPP.BackBufferWidth;
    vp.Height  = g_D3DPP.BackBufferHeight;
    vp.MinZ    = 0.0f;
    vp.MaxZ    = 1.0f;

    hr = g_pD3DDevice->lpVtbl->SetViewport( g_pD3DDevice, &vp );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectX Graphics̏Ɏs܂ - SetViewport" );
    }

    g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                 D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );

    /* XvCgIuWFNg쐬 */
    hr = D3DXCreateSprite( g_pD3DDevice, &g_pD3DXSprite );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectX Graphics̏Ɏs܂ - CreateSprite" );
    }
}


/*--------------------------------------------------------------------
  i֐jt[
 ---------------------------------------------------------------------*/
static void InitSync( void )
{
    timeBeginPeriod( 1 );

    /* ptH[}XJE^̕bԃJEgl擾 */
    if( QueryPerformanceFrequency( (LARGE_INTEGER *)&g_OneSecondCount ) )
    {
        /* ptH[}XJE^ꍇ */
        g_isPerformanceCounter = 1;
        QueryPerformanceCounter( (LARGE_INTEGER *)&g_OldTime );
    }
    else
    {
        /* ptH[}XJE^ꍇ */
        g_isPerformanceCounter = 0;
        g_OneSecondCount = 1000;
        g_OldTime = timeGetTime();
    }
}


/* foCX񋓊֐ */
BOOL CALLBACK EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance, void* pContext )
{
    HRESULT hr;

    /* 񋓂ꂽWCXeBbNւ̃C^[tFCX擾 */
    hr = g_pDInput->lpVtbl->CreateDevice( g_pDInput,
                            &pdidInstance->guidInstance,
                            &g_pDIDJoyPad[g_JoystickCount],
                            NULL );
    if( SUCCEEDED( hr ) )
    {
        return (++g_JoystickCount == PADMAX)?(DIENUM_STOP):(DIENUM_CONTINUE);
    }

    return DIENUM_STOP;
}

/* IuWFNgij񋓊֐ */
BOOL CALLBACK EnumAxisCallback( const DIDEVICEOBJECTINSTANCE* pdidoi, void *pContext )
{
    HRESULT hr;
    DIPROPRANGE diprg = { sizeof(DIPROPRANGE), sizeof(DIPROPHEADER) };
    struct DXRubyPadInfo *pad;

    pad = (struct DXRubyPadInfo *)pContext;

    diprg.diph.dwHow = DIPH_BYID; 
    diprg.diph.dwObj = pdidoi->dwType;

    /*========================================================*/
    /* 擾 */
    hr =  pad->pDIDJoyPad->lpVtbl->GetProperty( pad->pDIDJoyPad, DIPROP_RANGE, &diprg.diph );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - GetProperty" );
    }

    /* x */
    if( memcmp( &pdidoi->guidType, &GUID_XAxis ,sizeof(GUID)) == 0 )
    {
        int xcenter;
        xcenter = (diprg.lMin + diprg.lMax) / 2;
        pad->left  = (xcenter - diprg.lMin) / 2;
        pad->right = (diprg.lMax - xcenter) / 2 + xcenter;
    }

    /* y */
    if( memcmp( &pdidoi->guidType, &GUID_YAxis ,sizeof(GUID)) == 0 )
    {
        int ycenter;
        ycenter = (diprg.lMin + diprg.lMax) / 2;
        pad->up   = (ycenter - diprg.lMin) / 2;
        pad->down = (diprg.lMax - ycenter) / 2 + ycenter;
    }

    return DIENUM_CONTINUE;
}

/*--------------------------------------------------------------------
  i֐jDirectInput
 ---------------------------------------------------------------------*/
static void InitDirectInput( void )
{
    HRESULT hr;
    int i;

/* DirectInput */

    /* DirectInputIuWFNg̍쐬 */
    hr = DirectInput8Create( g_hInstance, DIRECTINPUT_VERSION,
                             &IID_IDirectInput8, (void **)&g_pDInput, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - DirectInput8Create" );
    }

/* L[{[h */

    /* foCXEIuWFNg쐬iL[{[hj */
    hr = g_pDInput->lpVtbl->CreateDevice( g_pDInput, &GUID_SysKeyboard, &g_pDIDKeyBoard, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - CreateDevice" );
    }

    /* f[^`ݒiL[{[hłj */
    hr = g_pDIDKeyBoard->lpVtbl->SetDataFormat( g_pDIDKeyBoard, &c_dfDIKeyboard );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - SetDataFormat" );
    }

    /* L[{[h̃[hݒitHAOEhr[hj */
    hr = g_pDIDKeyBoard->lpVtbl->SetCooperativeLevel( g_pDIDKeyBoard, g_hWind, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - SetCooperativeLevel" );
    }

    /* ͐Jn */
    g_pDIDKeyBoard->lpVtbl->Acquire( g_pDIDKeyBoard );


/* Q[pbh */

    for( i = 0; i < PADMAX; i++)
    {
        g_pDIDJoyPad[i] = NULL;
    }
    g_JoystickCount = 0;

    /* Q[foCX */
    hr = g_pDInput->lpVtbl->EnumDevices( g_pDInput, DI8DEVCLASS_GAMECTRL, EnumJoysticksCallback, NULL, DIEDFL_ATTACHEDONLY );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - EnumDevices" );
    }

    /* Q[foCX */
    for ( i = 0; i < g_JoystickCount; i++ )
    {
        /* f[^`ݒ */
        hr = g_pDIDJoyPad[i]->lpVtbl->SetDataFormat( g_pDIDJoyPad[i], &c_dfDIJoystick );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - SetDataFormat" );
        }

        /* L[{[h̃[hݒitHAOEhr[hj */
        hr = g_pDIDJoyPad[i]->lpVtbl->SetCooperativeLevel( g_pDIDJoyPad[i], g_hWind, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - SetCooperativeLevel" );
        }

        /* IuWFNg */
        g_PadInfo[i].pDIDJoyPad = g_pDIDJoyPad[i];
        hr = g_pDIDJoyPad[i]->lpVtbl->EnumObjects( g_pDIDJoyPad[i], EnumAxisCallback, &g_PadInfo[i], DIDFT_AXIS );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectInput̏Ɏs܂ - EnumObjects" );
        }

        /* ͐Jn */
        g_pDIDJoyPad[i]->lpVtbl->Acquire( g_pDIDJoyPad[i] );
    }

}




static void AllocSpriteList( void )
{
	int i;

	if( g_SpriteCount >= g_SpriteAllocateCount )
	{
		g_SpriteAllocateCount = g_SpriteAllocateCount * 3 / 2; /* 1.5{ɂ */
		g_SpriteList = realloc(g_SpriteList, g_SpriteAllocateCount * sizeof(struct DXRubySpriteList) );
		g_SpriteStruct = realloc(g_SpriteStruct, g_SpriteAllocateCount * sizeof(struct DXRubySprite) );
		for( i = 0; i < g_SpriteCount; i++)
		{
			g_SpriteList[i].sprite = &g_SpriteStruct[i];
		}
	}
}


/* }[W\[g */
void merge( struct DXRubySpriteList *list, struct DXRubySpriteList *temp, int left, int mid, int right )
{
    int i, left_end, num_elements, tmp_pos;

    left_end = mid - 1;
    tmp_pos = left;
    num_elements = right - left + 1;

    while ((left <= left_end) && (mid <= right))
    {
        if (list[left].z <= list[mid].z)
            temp[tmp_pos++] = list[left++];
        else
            temp[tmp_pos++] = list[mid++];
    }

    while (left <= left_end)
    {
        temp[tmp_pos++] = list[left++];
    }
    while (mid <= right)
    {
        temp[tmp_pos++] = list[mid++];
    }

    while (num_elements--)
    {
        list[right] = temp[right--];
    }
}
void m_sort( struct DXRubySpriteList *list, struct DXRubySpriteList *temp, int left, int right )
{
    int mid;

    if( right > left )
    {
        mid = (right + left) / 2;
        m_sort( list, temp, left, mid );
        m_sort( list, temp, mid+1, right );

        merge( list, temp, left, mid+1, right );
    }
}
void SortSpriteList( void )
{
    struct DXRubySpriteList *temp;
    int i;

    for( i = 0; i < g_SpriteCount; i++ )
    {
        if( g_SpriteList[i].z != 0 )
        {
            temp = malloc( sizeof(struct DXRubySpriteList)* g_SpriteCount );
            m_sort( g_SpriteList, temp, 0, g_SpriteCount - 1 );
            free(temp);
            break;
        }
    }
}
