#define WINVER 0x0500                                  /* o[W` Windows2000ȏ */
#define DIRECTSOUND_VERSION 0x0900
#define _WIN32_WINNT WINVER

#include "ruby.h"
#ifndef RUBY_ST_H
#include "st.h"
#endif

#include <dmusici.h>

#define DXRUBY_EXTERN 1
#include "dxruby.h"
#include "sound.h"

#ifndef DS3DALG_DEFAULT
GUID DS3DALG_DEFAULT = {0};
#endif

#define WAVE_RECT 0
#define WAVE_SIN 1
#define WAVE_SAW 2
#define WAVE_TRI 3

static VALUE cSound;        /* TEhNX       */
static VALUE cSoundEffect;  /* ʉNX     */

static IDirectMusicPerformance8 *g_pDMPerformance = NULL;       /* DirectMusicPerformance8C^[tFCX */
static IDirectMusicLoader8      *g_pDMLoader = NULL;            /* [_[ */
static LPDIRECTSOUND8           g_pDSound = NULL;               /* DirectSoundC^[tFCX */
static int g_iRefDM = 0; /* DirectMusicptH[}X̎QƃJEg */
static int g_iRefDS = 0; /* DirectSound̎QƃJEg */

/* SoundIuWFNg */
struct DXRubySound {
    IDirectMusicAudioPath8   *pDMDefAudioPath; /* ftHgI[fBIpX */
    IDirectMusicSegment8     *pDMSegment;        /* ZOg       */
    int start;
    int loopstart;
    int loopend;
    int loopcount;
    int midwavflag; /* mid0Awav1 */
    VALUE vbuffer;
};

/* SoundEffectIuWFNg */
struct DXRubySoundEffect {
    LPDIRECTSOUNDBUFFER pDSBuffer;    /* obt@         */
};



/*********************************************************************
 * SoundNX
 *
 * DirectMusicgpĉ炷B
 * Ƃ肠oƊ撣ĂB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void Sound_free( struct DXRubySound *sound )
{
    HRESULT hr;

    /* TEhIuWFNg̊J */
    /* oh */
    if ( sound->pDMSegment )
    {
        hr = sound->pDMSegment->lpVtbl->Unload( sound->pDMSegment, (IUnknown* )sound->pDMDefAudioPath );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "oh̉Ɏs܂ - Unload" );
        }
        /* ZOgJ */
        RELEASE( sound->pDMSegment );
    }

    /* ftHgI[fBIpXJ */
    RELEASE( sound->pDMDefAudioPath );

    g_iRefDM--;

    if( g_iRefDM <= 0 )
    {
        /* t~ */
        if ( g_pDMPerformance )
        {
            hr = g_pDMPerformance->lpVtbl->Stop( g_pDMPerformance, NULL, NULL, 0, 0 );
            if ( FAILED( hr ) )
            {
                rb_raise( eDXRubyError, "ptH[}X̏IɎs܂ - Stop" );
            }
            g_pDMPerformance->lpVtbl->CloseDown( g_pDMPerformance );
        }
        RELEASE(g_pDMPerformance);

        /* [_J */
        RELEASE(g_pDMLoader);
    }
}

static void Sound_mark( struct DXRubySound *sound )
{
    rb_gc_mark( sound->vbuffer );
}

static void Sound_release( struct DXRubySound *sound )
{
    if ( sound->pDMSegment )
    {
        Sound_free( sound );
    }
    free( sound );
    sound = NULL;

    g_iRefAll--;
    if( g_iRefAll == 0 )
    {
        CoUninitialize();
    }
}

#ifdef DXRUBY_USE_TYPEDDATA
const rb_data_type_t Sound_data_type = {
    "Sound",
    {
    Sound_mark,
    Sound_release,
    0,
    },
    NULL, NULL
};
#endif

/*--------------------------------------------------------------------
   SoundNXdisposeB
 ---------------------------------------------------------------------*/
static VALUE Sound_dispose( VALUE self )
{
    struct DXRubySound *sound = DXRUBY_GET_STRUCT( Sound, self );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );
    Sound_free( sound );
    return self;
}

/*--------------------------------------------------------------------
   SoundNXdisposed?B
 ---------------------------------------------------------------------*/
static VALUE Sound_check_disposed( VALUE self )
{
    if( DXRUBY_GET_STRUCT( Sound, self )->pDMSegment == NULL )
    {
        return Qtrue;
    }

    return Qfalse;
}

/*--------------------------------------------------------------------
   SoundNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Sound_allocate( VALUE klass )
{
    VALUE obj;
    struct DXRubySound *sound;

    /* DXRubyImagẽ擾ImageIuWFNg */
    sound = malloc(sizeof(struct DXRubySound));
    if( sound == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - Sound_allocate" );
#ifdef DXRUBY_USE_TYPEDDATA
    obj = TypedData_Wrap_Struct( klass, &Sound_data_type, sound );
#else
    obj = Data_Wrap_Struct(klass, 0, Sound_release, sound);
#endif
    /* Ƃ肠TEhIuWFNgNULLɂĂ */
    sound->pDMSegment = NULL;
    sound->vbuffer = Qnil;

    return obj;
}


/*--------------------------------------------------------------------
   SoundNXload_from_memoryBt@C烍[hB
 ---------------------------------------------------------------------*/
static VALUE Sound_load_from_memory( VALUE klass, VALUE vstr, VALUE vtype )
{
    HRESULT hr;
    WCHAR wstrFileName[MAX_PATH];
    VALUE obj;
    struct DXRubySound *sound;
    CHAR strPath[MAX_PATH];
    DWORD i;
    WCHAR wstrSearchPath[MAX_PATH];
    VALUE vsjisstr;

    g_iRefAll++;

    Check_Type( vstr, T_STRING );

    if( g_iRefDM == 0 )
    {
        /* ptH[}X̍쐬 */
        hr = CoCreateInstance( &CLSID_DirectMusicPerformance, NULL,
                               CLSCTX_INPROC_SERVER, &IID_IDirectMusicPerformance8,
                               (void**)&g_pDMPerformance );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - CoCreateInstance" );
        }

        /* ptH[}X̏ */
        hr = g_pDMPerformance->lpVtbl->InitAudio( g_pDMPerformance,
                                                  NULL,                  /* IDirectMusicC^[tFCX͕sv */
                                                  NULL,                  /* IDirectSoundC^[tFCX͕sv */
                                                  g_hWnd,               /* EBhẼnh */
                                                  DMUS_APATH_SHARED_STEREOPLUSREVERB,  /* ftHg̃I[fBIpXE^Cv */
                                                  64,                    /* ptH[}XE`l̐ */
                                                  DMUS_AUDIOF_ALL,       /* VZTCŰ@\ */
                                                  NULL );                /* I[fBIEp[^ɂ̓ftHggp */
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - InitAudio" );
        }

        /* [_[̍쐬 */
        hr = CoCreateInstance( &CLSID_DirectMusicLoader, NULL, 
                               CLSCTX_INPROC_SERVER, &IID_IDirectMusicLoader8,
                               (void**)&g_pDMLoader );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - CoCreateInstance" );
        }

        /* [_[̏ipXJgEfBNgɐݒj */
        i = GetCurrentDirectory( MAX_PATH, strPath );
        if ( i == 0 || MAX_PATH < i )
        {
            rb_raise( eDXRubyError, "JgEfBNg̎擾Ɏs - GetCurrentDirectory" );
        }

        /* }`EoCgUNICODEɕϊ */
        MultiByteToWideChar( CP_ACP, 0, strPath, -1, wstrSearchPath, MAX_PATH );

        /* [_[ɌpXݒ */
        hr = g_pDMLoader->lpVtbl->SetSearchDirectory( g_pDMLoader, &GUID_DirectMusicAllTypes,
                                                      wstrSearchPath, FALSE );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "pX̐ݒɎs - SetSearchDirectory" );
        }
    }
    g_iRefDM++;

    /* TEhIuWFNg擾 */
    obj = Sound_allocate( klass );
    sound = DXRUBY_GET_STRUCT( Sound, obj );
    if( sound->pDMSegment )
    {
        g_iRefDM++;
        Sound_free( sound );
        g_iRefDM--;
        g_iRefAll--;
    }

    /* I[fBIEpX쐬 */
    hr = g_pDMPerformance->lpVtbl->CreateStandardAudioPath( g_pDMPerformance,
        DMUS_APATH_DYNAMIC_STEREO,      /* pX̎ށB */
        64,                             /* ptH[}X `l̐B */
        TRUE,                           /* ŃANeBuɂȂB */
        &sound->pDMDefAudioPath );      /* I[fBIpX󂯎|C^B */

    if ( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "I[fBIpX̍쐬Ɏs܂ - CreateStandardAudioPath" );
    }

    sound->vbuffer = vstr;

    {
        DMUS_OBJECTDESC desc;

        ZeroMemory( &desc, sizeof(DMUS_OBJECTDESC) );
        desc.dwSize      = sizeof(DMUS_OBJECTDESC);
        desc.dwValidData = DMUS_OBJ_MEMORY | DMUS_OBJ_CLASS;
        desc.guidClass   = CLSID_DirectMusicSegment;
        desc.llMemLength = (LONGLONG)RSTRING_LEN(vstr);      // obt@̃TCY
        desc.pbMemData   = (LPBYTE)RSTRING_PTR(vstr);        // f[^̓Ăobt@

        hr = g_pDMLoader->lpVtbl->GetObject( g_pDMLoader, &desc, &IID_IDirectMusicSegment8, (void**)&sound->pDMSegment );
    }

    if( FAILED( hr ) )
    {
        sound->pDMSegment = NULL;
        rb_raise( eDXRubyError, "t@C̃[hɎs܂ - LoadObjectFromFile" );
    }

    sound->start = 0;
    sound->loopstart = 0;
    sound->loopend = 0;

    /* MIDȈꍇ */
    if( NUM2INT( vtype ) == 0 )
    {
        hr = sound->pDMSegment->lpVtbl->SetParam( sound->pDMSegment, &GUID_StandardMIDIFile,
                                                  0xFFFFFFFF, 0, 0, NULL);
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "t@C̃[hɎs܂ - SetParam" );
        }
        sound->loopcount = DMUS_SEG_REPEAT_INFINITE;
        sound->midwavflag = 0;
        /* [v񐔐ݒ */
        hr = sound->pDMSegment->lpVtbl->SetRepeats( sound->pDMSegment, sound->loopcount );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "[v񐔂̐ݒɎs܂ - SetRepeats" );
        }
    }
    else
    {
        sound->loopcount = 1;
        sound->midwavflag = 1;
    }

    /* oh_E[h */
    hr = sound->pDMSegment->lpVtbl->Download( sound->pDMSegment, (IUnknown* )sound->pDMDefAudioPath );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "oh̃[hɎs܂ - Download" );
    }


    /* ʐݒ */
    hr = sound->pDMDefAudioPath->lpVtbl->SetVolume( sound->pDMDefAudioPath, 230 * 9600 / 255 - 9600 , 0 );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ʂ̐ݒɎs܂ - SetVolume" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   SoundNXinitializeBt@C[hB
 ---------------------------------------------------------------------*/
static VALUE Sound_initialize( VALUE obj, VALUE vfilename )
{
    HRESULT hr;
    WCHAR wstrFileName[MAX_PATH];
    struct DXRubySound *sound;
    CHAR strPath[MAX_PATH];
    DWORD i;
    WCHAR wstrSearchPath[MAX_PATH];
    VALUE vsjisstr;

    g_iRefAll++;

	Check_Type(vfilename, T_STRING);

    if( g_iRefDM == 0 )
	{
	    /* ptH[}X̍쐬 */
	    hr = CoCreateInstance( &CLSID_DirectMusicPerformance, NULL,
	                           CLSCTX_INPROC_SERVER, &IID_IDirectMusicPerformance8,
	                           (void**)&g_pDMPerformance );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - CoCreateInstance" );
	    }

	    /* ptH[}X̏ */
	    hr = g_pDMPerformance->lpVtbl->InitAudio( g_pDMPerformance,
	                                              NULL,                  /* IDirectMusicC^[tFCX͕sv */
	                                              NULL,                  /* IDirectSoundC^[tFCX͕sv */
	                                              g_hWnd,               /* EBhẼnh */
	                                              DMUS_APATH_SHARED_STEREOPLUSREVERB,  /* ftHg̃I[fBIpXE^Cv */
	                                              64,                    /* ptH[}XE`l̐ */
	                                              DMUS_AUDIOF_ALL,       /* VZTCŰ@\ */
	                                              NULL );                /* I[fBIEp[^ɂ̓ftHggp */
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - InitAudio" );
	    }

	    /* [_[̍쐬 */
	    hr = CoCreateInstance( &CLSID_DirectMusicLoader, NULL, 
	                           CLSCTX_INPROC_SERVER, &IID_IDirectMusicLoader8,
	                           (void**)&g_pDMLoader );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "DirectMusic̏Ɏs܂ - CoCreateInstance" );
	    }

	    /* [_[̏ipXJgEfBNgɐݒj */
	    i = GetCurrentDirectory( MAX_PATH, strPath );
	    if ( i == 0 || MAX_PATH < i )
	    {
	        rb_raise( eDXRubyError, "JgEfBNg̎擾Ɏs - GetCurrentDirectory" );
	    }

	    /* }`EoCgUNICODEɕϊ */
	    MultiByteToWideChar( CP_ACP, 0, strPath, -1, wstrSearchPath, MAX_PATH );

	    /* [_[ɌpXݒ */
	    hr = g_pDMLoader->lpVtbl->SetSearchDirectory( g_pDMLoader, &GUID_DirectMusicAllTypes,
	                                                  wstrSearchPath, FALSE );
	    if( FAILED( hr ) )
	    {
	        rb_raise( eDXRubyError, "pX̐ݒɎs - SetSearchDirectory" );
	    }
	}
    g_iRefDM++;

	/* TEhIuWFNg擾 */
    sound = DXRUBY_GET_STRUCT( Sound, obj );
    if( sound->pDMSegment )
    {
        g_iRefDM++;
        Sound_free( sound );
        g_iRefDM--;
        g_iRefAll--;
    }

	/* I[fBIEpX쐬 */
	hr = g_pDMPerformance->lpVtbl->CreateStandardAudioPath( g_pDMPerformance,
		DMUS_APATH_DYNAMIC_STEREO,      /* pX̎ށB */
		64,                             /* ptH[}X `l̐B */
		TRUE,                           /* ŃANeBuɂȂB */
		&sound->pDMDefAudioPath );      /* I[fBIpX󂯎|C^B */

	if ( FAILED( hr ) )
	{
        rb_raise( eDXRubyError, "I[fBIpX̍쐬Ɏs܂ - CreateStandardAudioPath" );
	}

    /* t@C[h */
    if( rb_enc_get_index( vfilename ) != 0 )
    {
        vsjisstr = rb_str_export_to_enc( vfilename, g_enc_sys );
    }
    else
    {
        vsjisstr = vfilename;
    }

    MultiByteToWideChar( CP_ACP, 0, RSTRING_PTR( vsjisstr ), -1, wstrFileName, MAX_PATH );
    hr = g_pDMLoader->lpVtbl->LoadObjectFromFile( g_pDMLoader, &CLSID_DirectMusicSegment,
                                                  &IID_IDirectMusicSegment8,
                                                  wstrFileName,
                                                  (LPVOID*)&sound->pDMSegment );
    if( FAILED( hr ) )
    {
        sound->pDMSegment = NULL;
        rb_raise( eDXRubyError, "t@C̃[hɎs܂ - LoadObjectFromFile" );
    }

    sound->start = 0;
    sound->loopstart = 0;
    sound->loopend = 0;

    /* MIDȈꍇ */
    if( strstr( RSTRING_PTR( vsjisstr ), ".mid" ) != NULL )
    {
        hr = sound->pDMSegment->lpVtbl->SetParam( sound->pDMSegment, &GUID_StandardMIDIFile,
                                                  0xFFFFFFFF, 0, 0, NULL);
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "t@C̃[hɎs܂ - SetParam" );
        }
        sound->loopcount = DMUS_SEG_REPEAT_INFINITE;
        sound->midwavflag = 0;
        /* [v񐔐ݒ */
        hr = sound->pDMSegment->lpVtbl->SetRepeats( sound->pDMSegment, sound->loopcount );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "[v񐔂̐ݒɎs܂ - SetRepeats" );
        }
    }
    else
    {
        sound->loopcount = 1;
        sound->midwavflag = 1;
    }

    /* oh_E[h */
    hr = sound->pDMSegment->lpVtbl->Download( sound->pDMSegment, (IUnknown* )sound->pDMDefAudioPath );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "oh̃[hɎs܂ - Download" );
    }


    /* ʐݒ */
    hr = sound->pDMDefAudioPath->lpVtbl->SetVolume( sound->pDMDefAudioPath, 230 * 9600 / 255 - 9600 , 0 );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ʂ̐ݒɎs܂ - SetVolume" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   Jnʒuݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setStart( VALUE obj, VALUE vstart )
{
    HRESULT hr;
    struct DXRubySound *sound;

    sound = DXRUBY_GET_STRUCT( Sound, obj );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );
    sound->start = NUM2INT( vstart );

    if( sound->midwavflag == 1 && sound->start > 0 )    /* wav̏ꍇ */
    {
        hr = sound->pDMSegment->lpVtbl->SetLength( sound->pDMSegment, sound->start * DMUS_PPQ / 768 + 1 );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "ZOgJnʒu̐ݒɎs܂ - SetLength" );
        }
    }

    /* ZOgĐX^[gʒuݒ */
    hr = sound->pDMSegment->lpVtbl->SetStartPoint( sound->pDMSegment, sound->start * DMUS_PPQ / 768 );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ZOgJnʒu̐ݒɎs܂ - SetStartPoint" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   [vJnʒuݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setLoopStart( VALUE obj, VALUE vloopstart )
{
    HRESULT hr;
    struct DXRubySound *sound;

    sound = DXRUBY_GET_STRUCT( Sound, obj );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );
    sound->loopstart = NUM2INT( vloopstart );

    if( sound->midwavflag == 1 )
    {
        rb_raise( eDXRubyError, "WAVf[^Ƀ[vJnʒu͐ݒł܂ - Sound_loopStart=" );
    }

    if( sound->loopstart <= sound->loopend )
    {
        /* [v͈͐ݒ */
        hr = sound->pDMSegment->lpVtbl->SetLoopPoints( sound->pDMSegment, sound->loopstart * DMUS_PPQ / 768
                                                                        , sound->loopend * DMUS_PPQ / 768 );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "[v͈͂̐ݒɎs܂ - SetLoopPoints" );
        }
    }
    else
    {
        /* [v͈͐ݒ */
        hr = sound->pDMSegment->lpVtbl->SetLoopPoints( sound->pDMSegment, 0, 0 );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "[v͈͂̐ݒɎs܂ - SetLoopPoints" );
        }
    }

    return obj;
}


/*--------------------------------------------------------------------
   [vIʒuݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setLoopEnd( VALUE obj, VALUE vloopend )
{
    HRESULT hr;
    struct DXRubySound *sound;

    sound = DXRUBY_GET_STRUCT( Sound, obj );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );
    sound->loopend = NUM2INT( vloopend );

    if( sound->midwavflag == 1 )
    {
        rb_raise( eDXRubyError, "WAVf[^Ƀ[vIʒu͐ݒł܂ - Sound_loopEnd=" );
    }

    if( sound->loopstart <= sound->loopend )
    {
        /* [v͈͐ݒ */
        hr = sound->pDMSegment->lpVtbl->SetLoopPoints( sound->pDMSegment, sound->loopstart * DMUS_PPQ / 768
                                                                        , sound->loopend * DMUS_PPQ / 768 );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "[v͈͂̐ݒɎs܂ - SetLoopPoints" );
        }
    }
    else
    {
        /* [v͈͐ݒ */
        hr = sound->pDMSegment->lpVtbl->SetLoopPoints( sound->pDMSegment, 0, 0 );

        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "[v͈͂̐ݒɎs܂ - SetLoopPoints" );
        }
    }


    return obj;
}


/*--------------------------------------------------------------------
   [v񐔂ݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setLoopCount( VALUE obj, VALUE vloopcount )
{
    HRESULT hr;
    struct DXRubySound *sound;

    sound = DXRUBY_GET_STRUCT( Sound, obj );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );
    sound->loopcount = NUM2INT( vloopcount );

    /* [v񐔐ݒ */
    hr = sound->pDMSegment->lpVtbl->SetRepeats( sound->pDMSegment, sound->loopcount );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "[v񐔂̐ݒɎs܂ - SetRepeats" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   ʂݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setVolume( int argc, VALUE *argv, VALUE obj )
{
    HRESULT hr;
    struct DXRubySound *sound;
    VALUE vvolume, vtime;
    int volume, time;

    rb_scan_args( argc, argv, "11", &vvolume, &vtime );

    time = vtime == Qnil ? 0 : NUM2INT( vtime );
    volume = NUM2INT( vvolume ) > 255 ? 255 : NUM2INT( vvolume );
    sound = DXRUBY_GET_STRUCT( Sound, obj );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );

    /* ʐݒ */
    hr = sound->pDMDefAudioPath->lpVtbl->SetVolume( sound->pDMDefAudioPath, volume * 9600 / 255 - 9600, time );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "ʂ̐ݒɎs܂ - SetVolume" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   p擾
 ---------------------------------------------------------------------*/
static VALUE Sound_getPan( VALUE self )
{
    HRESULT hr;
    struct DXRubySound *sound;
    IDirectSoundBuffer8* pDS3DBuffer;
    long result;

    sound = DXRUBY_GET_STRUCT( Sound, self );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );

    hr = sound->pDMDefAudioPath->lpVtbl->GetObjectInPath( sound->pDMDefAudioPath, DMUS_PCHANNEL_ALL, DMUS_PATH_BUFFER, 0, &GUID_NULL, 0, &IID_IDirectSoundBuffer8, (LPVOID*) &pDS3DBuffer);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "internal error - GetPan" );
    }

    /* p擾 */
    hr = pDS3DBuffer->lpVtbl->GetPan( pDS3DBuffer, &result );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "pan get error - GetPan" );
    }

    RELEASE( pDS3DBuffer );

    return INT2NUM( result );
}


/*--------------------------------------------------------------------
   pݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setPan( VALUE self, VALUE vpan )
{
    HRESULT hr;
    struct DXRubySound *sound;
    IDirectSoundBuffer8* pDS3DBuffer;

    sound = DXRUBY_GET_STRUCT( Sound, self );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );

    hr = sound->pDMDefAudioPath->lpVtbl->GetObjectInPath( sound->pDMDefAudioPath, DMUS_PCHANNEL_ALL, DMUS_PATH_BUFFER, 0, &GUID_NULL, 0, &IID_IDirectSoundBuffer8, (LPVOID*) &pDS3DBuffer);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "internal error - SetPan" );
    }

    /* pݒ */
    hr = pDS3DBuffer->lpVtbl->SetPan( pDS3DBuffer, NUM2INT( vpan ) );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "pan setting error - SetPan" );
    }

    RELEASE( pDS3DBuffer );

    return self;
}


/*--------------------------------------------------------------------
   g擾
 ---------------------------------------------------------------------*/
static VALUE Sound_getFrequency( VALUE self )
{
    HRESULT hr;
    struct DXRubySound *sound;
    IDirectSoundBuffer8* pDS3DBuffer;
    DWORD result;

    sound = DXRUBY_GET_STRUCT( Sound, self );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );

    hr = sound->pDMDefAudioPath->lpVtbl->GetObjectInPath( sound->pDMDefAudioPath, DMUS_PCHANNEL_ALL, DMUS_PATH_BUFFER, 0, &GUID_NULL, 0, &IID_IDirectSoundBuffer8, (LPVOID*) &pDS3DBuffer);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "internal error - GetPan" );
    }

    /* g擾 */
    hr = pDS3DBuffer->lpVtbl->GetFrequency( pDS3DBuffer, &result );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "frequency get error - getFrequency" );
    }

    RELEASE( pDS3DBuffer );

    return UINT2NUM( result );
}


/*--------------------------------------------------------------------
   gݒ肷
 ---------------------------------------------------------------------*/
static VALUE Sound_setFrequency( VALUE self, VALUE vfrequency )
{
    HRESULT hr;
    struct DXRubySound *sound;
    IDirectSoundBuffer8* pDS3DBuffer;

    sound = DXRUBY_GET_STRUCT( Sound, self );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );

    hr = sound->pDMDefAudioPath->lpVtbl->GetObjectInPath( sound->pDMDefAudioPath, DMUS_PCHANNEL_ALL, DMUS_PATH_BUFFER, 0, &GUID_NULL, 0, &IID_IDirectSoundBuffer8, (LPVOID*) &pDS3DBuffer);

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "internal error - SetPan" );
    }

    /* gݒ */
    hr = pDS3DBuffer->lpVtbl->SetFrequency( pDS3DBuffer, NUM2UINT( vfrequency ) );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "frequency setting error - setFrequency" );
    }

    RELEASE( pDS3DBuffer );

    return self;
}


/*--------------------------------------------------------------------
   炷
 ---------------------------------------------------------------------*/
static VALUE Sound_play( VALUE obj )
{
    HRESULT hr;
    struct DXRubySound *sound;

    sound = DXRUBY_GET_STRUCT( Sound, obj );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );

    /* Đ */
    if( sound->midwavflag == 0 )
    {
        hr = g_pDMPerformance->lpVtbl->PlaySegmentEx( g_pDMPerformance, (IUnknown* )sound->pDMSegment, NULL, NULL,
                                                      DMUS_SEGF_CONTROL, 0, NULL, NULL, (IUnknown* )sound->pDMDefAudioPath );
    }
    else
    {
        hr = g_pDMPerformance->lpVtbl->PlaySegmentEx( g_pDMPerformance, (IUnknown* )sound->pDMSegment, NULL, NULL,
                                                      DMUS_SEGF_SECONDARY, 0, NULL, NULL, (IUnknown* )sound->pDMDefAudioPath );
    }
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - PlaySegmentEx" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   ~߂
 ---------------------------------------------------------------------*/
static VALUE Sound_stop( VALUE obj )
{
    HRESULT hr;
    struct DXRubySound *sound;

    sound = DXRUBY_GET_STRUCT( Sound, obj );
    DXRUBY_CHECK_DISPOSE( sound, pDMSegment );

    /* Đ */
    hr = g_pDMPerformance->lpVtbl->StopEx( g_pDMPerformance, (IUnknown* )sound->pDMSegment, 0, 0 );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̒~Ɏs܂ - StopEx" );
    }

    return obj;

}


/*********************************************************************
 * SoundEffectNX
 *
 * DirectSoundgpĉ炷B
 * Ƃ肠oƊ撣ĂB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void SoundEffect_free( struct DXRubySoundEffect *soundeffect )
{
    /* TEhobt@J */
    RELEASE( soundeffect->pDSBuffer );

    g_iRefDS--;

    if( g_iRefDS == 0 )
    {
        RELEASE( g_pDSound );
    }

}

static void SoundEffect_release( struct DXRubySoundEffect *soundeffect )
{
    if( soundeffect->pDSBuffer )
    {
        SoundEffect_free( soundeffect );
    }
    free( soundeffect );
    soundeffect = NULL;

    g_iRefAll--;
    if( g_iRefAll == 0 )
    {
        CoUninitialize();
    }
}

#ifdef DXRUBY_USE_TYPEDDATA
const rb_data_type_t SoundEffect_data_type = {
    "SoundEffect",
    {
    0,
    SoundEffect_release,
    0,
    },
    NULL, NULL
};
#endif

/*--------------------------------------------------------------------
   SoundEffectNXdisposeB
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_dispose( VALUE self )
{
    struct DXRubySoundEffect *soundeffect = DXRUBY_GET_STRUCT( SoundEffect, self );
    DXRUBY_CHECK_DISPOSE( soundeffect, pDSBuffer );
    SoundEffect_free( soundeffect );
    return self;
}

/*--------------------------------------------------------------------
   SoundEffectNXdisposed?B
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_check_disposed( VALUE self )
{
    if( DXRUBY_GET_STRUCT( SoundEffect, self )->pDSBuffer == NULL )
    {
        return Qtrue;
    }

    return Qfalse;
}

/*--------------------------------------------------------------------
   SoundEffectNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_allocate( VALUE klass )
{
    VALUE obj;
    struct DXRubySoundEffect *soundeffect;

    /* DXRubySoundEffect̃擾SoundEffectIuWFNg */
    soundeffect = malloc(sizeof(struct DXRubySoundEffect));
    if( soundeffect == NULL ) rb_raise( eDXRubyError, "̎擾Ɏs܂ - SoundEffect_allocate" );
#ifdef DXRUBY_USE_TYPEDDATA
    obj = TypedData_Wrap_Struct( klass, &SoundEffect_data_type, soundeffect );
#else
    obj = Data_Wrap_Struct(klass, 0, SoundEffect_release, soundeffect);
#endif

    /* Ƃ肠TEhIuWFNgNULLɂĂ */
    soundeffect->pDSBuffer = NULL;

    return obj;
}


static short calcwave(int type, double vol, double count, double p, double duty)
{
	switch( type )
	{
	case 1: /* TCg */
		return (short)((sin( (3.141592653589793115997963468544185161590576171875f * 2) * (double)count / (double)p )) * (double)vol * 128);
		break;
	case 2: /* mRMg */
		return (short)(((double)count / (double)p - 0.5) * (double)vol * 256);
		break;
	case 3: /* Opg */
		if( count < p / 4 )			/* 1/4 */
		{
			return (short)((double)count / ((double)p / 4) * (double)vol * 128);
		}
		else if( count < p / 2 )		/* 2/4 */
		{
			return (short)(((double)p / 2 - (double)count) / ((double)p / 4) * (double)vol * 128);
		}
		else if( count < p * 3 / 4 )	/* 3/4 */
		{
			return (short)(-((double)count - (double)p / 2)/ ((double)p / 4) * (double)vol * 128);
		}
		else											/* Ō */
		{
			return (short)(-((double)p - (double)count) / ((double)p / 4) * (double)vol * 128);
		}
		break;
	case 0: /* `g */
	default: /* ftHg */
		if( count < p * duty )	/* O */
		{
			return (short)(vol * 128);
		}
		else									/* 㔼 */
		{
		    return (short)(-vol * 128);
		}
		break;
	}
}


/*--------------------------------------------------------------------
   SoundEffectNXinitializeBg`𐶐B
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_initialize( int argc, VALUE *argv, VALUE obj )
{
    HRESULT hr;
    struct DXRubySoundEffect *soundeffect;
    DSBUFFERDESC desc;
    WAVEFORMATEX pcmwf;
    int i;
    short *pointer, *pointer2;
    DWORD size, size2;
    VALUE vf;
    double count, duty = 0.5;
    double vol;
    double f;
    VALUE vsize, vtype, vresolution;
    int type, resolution;

    g_iRefAll++;

    rb_scan_args( argc, argv, "12", &vsize, &vtype, &vresolution );

    type       = vtype       == Qnil ? 0    : NUM2INT( vtype );
    resolution = vresolution == Qnil ? 1000 : (NUM2INT( vresolution ) > 44100 ? 44100 : NUM2INT( vresolution ));

    /* DirectSoundIuWFNg̍쐬 */
    if( g_iRefDS == 0 )
    {
        hr = DirectSoundCreate8( &DSDEVID_DefaultPlayback, &g_pDSound, NULL );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectSound̏Ɏs܂ - DirectSoundCreate8" );
        }

        hr = g_pDSound->lpVtbl->SetCooperativeLevel( g_pDSound, g_hWnd, DSSCL_PRIORITY );
        if( FAILED( hr ) )
        {
            rb_raise( eDXRubyError, "DirectSound̏Ɏs܂ - SetCooperativeLevel" );
        }
    }
    g_iRefDS++;

    /* TEhIuWFNg쐬 */
    soundeffect = DXRUBY_GET_STRUCT( SoundEffect, obj );
    if( soundeffect->pDSBuffer )
    {
        g_iRefDS++;
        SoundEffect_free( soundeffect );
        g_iRefDS--;
        g_iRefAll++;
    }

    /* TEhobt@쐬 */
    pcmwf.wFormatTag = WAVE_FORMAT_PCM;
    pcmwf.nChannels = 1;
    pcmwf.nSamplesPerSec = 44100;
    pcmwf.wBitsPerSample = 16;
    pcmwf.nBlockAlign = pcmwf.nChannels * pcmwf.wBitsPerSample / 8;
    pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
    pcmwf.cbSize = 0;

    desc.dwSize = sizeof(desc);
    desc.dwFlags = DSBCAPS_GLOBALFOCUS;
#ifdef DXRUBY15
    if( TYPE( vsize ) == T_ARRAY )
    {
        desc.dwBufferBytes = RARRAY_LEN( vsize ) * (pcmwf.nChannels * pcmwf.wBitsPerSample / 8);
    }
    else
    {
#endif
        desc.dwBufferBytes = pcmwf.nAvgBytesPerSec / 100 * NUM2INT(vsize) / 10;
#ifdef DXRUBY15
    }
#endif
    desc.dwReserved = 0;
    desc.lpwfxFormat = &pcmwf;
    desc.guid3DAlgorithm = DS3DALG_DEFAULT;

    hr = g_pDSound->lpVtbl->CreateSoundBuffer( g_pDSound, &desc, &soundeffect->pDSBuffer, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̍쐬Ɏs܂ - CreateSoundBuffer" );
    }

    /* bN */
    hr = soundeffect->pDSBuffer->lpVtbl->Lock( soundeffect->pDSBuffer, 0, 0, &pointer, &size, &pointer2, &size2, DSBLOCK_ENTIREBUFFER );
    if( FAILED( hr ) || size2 != 0 )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    if( TYPE( vsize ) == T_ARRAY )
    {
        /* obt@ */
        for( i = 0; i < desc.dwBufferBytes / (pcmwf.wBitsPerSample / 8); i++ )
        {
            double tmp = NUM2DBL( RARRAY_AREF( vsize, i ) );
            if( tmp < 0.0 )
            {
                if( tmp < -1.0 ) tmp = -1.0;
                pointer[i] = (short)(tmp * 32768.0);
            }
            else
            {
                if( tmp > 1.0 ) tmp = 1.0;
                pointer[i] = (short)(tmp * 32767.0);
            }
        }
    }
    else
    {
        /* obt@ */
        for( i = 0; i < desc.dwBufferBytes / (pcmwf.wBitsPerSample / 8); i++ )
        {
            pointer[i] = 0;
        }

        count = 0;

        /* g` */
        for( i = 0; i < desc.dwBufferBytes / (pcmwf.wBitsPerSample / 8); i++ )
        {
            /* w莞ԒPʂŃubNĂяo */
            if ( i % (pcmwf.nSamplesPerSec / resolution) == 0 )
            {
                vf = rb_yield( obj );
                if( TYPE( vf ) != T_ARRAY )
                {
                    soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
                    rb_raise(rb_eTypeError, "invalid value - SoundEffect_initialize");
                    break;
                }
                f = NUM2DBL( rb_ary_entry(vf, 0) );
                vol = NUM2DBL(rb_ary_entry(vf, 1));
                if( RARRAY_LEN( vf ) > 2 )
                {
                    duty = NUM2DBL(rb_ary_entry(vf, 2));
                }
                /* ő/Œgƍő{[̐ */
                f = f > pcmwf.nSamplesPerSec / 2.0f ? pcmwf.nSamplesPerSec / 2.0f : f;
                f = f < 20 ? 20 : f;
                vol = vol > 255 ? 255 : vol;
                vol = vol < 0 ? 0 : vol;
            }
            count = count + f;
            if( count >= pcmwf.nSamplesPerSec )
            {
                count = count - pcmwf.nSamplesPerSec;
            }
            pointer[i] = calcwave(type, vol, count, pcmwf.nSamplesPerSec, duty);
        }
    }

    /* AbN */
    hr = soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    return obj;

}


/*--------------------------------------------------------------------
   g`B
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_add( int argc, VALUE *argv, VALUE obj )
{
    HRESULT hr;
    struct DXRubySoundEffect *soundeffect;
	DSBUFFERDESC desc;
	WAVEFORMATEX pcmwf;
	int i;
	short *pointer, *pointer2;
	DWORD size, size2;
	VALUE vf, vtype, vresolution;
	double count, duty = 0.5;
	double vol;
    double f;
	int type, resolution;
	int data;

	rb_scan_args( argc, argv, "02", &vtype, &vresolution );

	type       = vtype       == Qnil ? 0    : NUM2INT( vtype );
	resolution = vresolution == Qnil ? 1000 : (NUM2INT( vresolution ) > 44100 ? 44100 : NUM2INT( vresolution ));

    /* TEhIuWFNg擾 */
    soundeffect = DXRUBY_GET_STRUCT( SoundEffect, obj );
    DXRUBY_CHECK_DISPOSE( soundeffect, pDSBuffer );

	/* bN */
	hr = soundeffect->pDSBuffer->lpVtbl->Lock( soundeffect->pDSBuffer, 0, 0, &pointer, &size, &pointer2, &size2, DSBLOCK_ENTIREBUFFER );
    if( FAILED( hr ) || size2 != 0 )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

	pcmwf.nChannels = 1;
	pcmwf.nSamplesPerSec = 44100;
	pcmwf.wBitsPerSample = 16;
	pcmwf.nBlockAlign = pcmwf.nChannels * pcmwf.wBitsPerSample / 8;
	pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
	desc.dwBufferBytes = size;

	count = 0;

	/* g` */
	for( i = 0; i < desc.dwBufferBytes / (pcmwf.wBitsPerSample / 8); i++ )
	{
		/* w莞ԒPʂŃubNĂяo */
		if ( i % (pcmwf.nSamplesPerSec / resolution) == 0 )
		{
			vf = rb_yield( obj );
			if( TYPE( vf ) != T_ARRAY )
			{
				soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
			    rb_raise(rb_eTypeError, "invalid value - SoundEffect_add");
				break;
			}
			f = NUM2DBL( rb_ary_entry(vf, 0) );
			vol = NUM2DBL(rb_ary_entry(vf, 1));
            if( RARRAY_LEN( vf ) > 2 )
            {
                duty = NUM2DBL(rb_ary_entry(vf, 2));
            }
			/* ő/Œgƍő{[̐ */
			f = f > pcmwf.nSamplesPerSec / 2.0f ? pcmwf.nSamplesPerSec / 2.0f : f;
			f = f < 20 ? 20 : f;
			vol = vol > 255 ? 255 : vol;
			vol = vol < 0 ? 0 : vol;
		}
		count = count + f;
		if( count >= pcmwf.nSamplesPerSec )
		{
			count = count - pcmwf.nSamplesPerSec;
		}

		data = calcwave(type, vol, count, pcmwf.nSamplesPerSec, duty);

		if( data + (int)pointer[i] > 32767 )
		{
			pointer[i] = 32767;
		}
		else if( data + (int)pointer[i] < -32768 )
		{
			pointer[i] = -32768;
		}
		else
		{
			pointer[i] += data;
		}
	}

	/* AbN */
	hr = soundeffect->pDSBuffer->lpVtbl->Unlock( soundeffect->pDSBuffer, pointer, size, pointer2, size2 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    return obj;

}


/*--------------------------------------------------------------------
   炷
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_play( int argc, VALUE *argv, VALUE self )
{
    HRESULT hr;
    struct DXRubySoundEffect *se = DXRUBY_GET_STRUCT( SoundEffect, self );
    VALUE vflag;
    DXRUBY_CHECK_DISPOSE( se, pDSBuffer );

    rb_scan_args( argc, argv, "01", &vflag );

    /* Ƃ߂ */
    hr = se->pDSBuffer->lpVtbl->Stop( se->pDSBuffer );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - SoundEffect_play" );
    }

    hr = se->pDSBuffer->lpVtbl->SetCurrentPosition( se->pDSBuffer, 0 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - SoundEffect_play" );
    }

    /* Đ */
    hr = se->pDSBuffer->lpVtbl->Play( se->pDSBuffer, 0, 0, RTEST(vflag) ? DSBPLAY_LOOPING : 0 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̍ĐɎs܂ - SoundEffect_play" );
    }
    return self;
}


/*--------------------------------------------------------------------
   ~߂
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_stop( VALUE obj )
{
    HRESULT hr;
    struct DXRubySoundEffect *soundeffect;

    soundeffect = DXRUBY_GET_STRUCT( SoundEffect, obj );
    DXRUBY_CHECK_DISPOSE( soundeffect, pDSBuffer );

    /* Ƃ߂ */
    hr = soundeffect->pDSBuffer->lpVtbl->Stop( soundeffect->pDSBuffer );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "̒~Ɏs܂ - Stop" );
    }

    return obj;
}


/*--------------------------------------------------------------------
   wavt@Co
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_save( VALUE self, VALUE vfilename )
{
    HRESULT hr;
    HANDLE hfile;
    short *pointer, *pointer2;
    DWORD size, size2;
    DWORD tmpl;
    WORD tmps;
    DWORD wsize;
    struct DXRubySoundEffect *se = DXRUBY_GET_STRUCT( SoundEffect, self );

    DXRUBY_CHECK_DISPOSE( se, pDSBuffer );

    /* bN */
    hr = se->pDSBuffer->lpVtbl->Lock( se->pDSBuffer, 0, 0, &pointer, &size, &pointer2, &size2, DSBLOCK_ENTIREBUFFER );
    if( FAILED( hr ) || size2 != 0 )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    hfile = CreateFile( RSTRING_PTR( vfilename ), GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    if( hfile == INVALID_HANDLE_VALUE )
    {
        rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - open" );
    }

    if( !WriteFile( hfile, "RIFF", 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmpl = size + 44 - 8;
    if( !WriteFile( hfile, &tmpl, 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    if( !WriteFile( hfile, "WAVE", 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    if( !WriteFile( hfile, "fmt ", 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmpl = 16;
    if( !WriteFile( hfile, &tmpl, 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmps = 1;
    if( !WriteFile( hfile, &tmps, 2, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmps = 1;
    if( !WriteFile( hfile, &tmps, 2, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmpl = 44100;
    if( !WriteFile( hfile, &tmpl, 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmpl = 44100*2;
    if( !WriteFile( hfile, &tmpl, 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmps = 2;
    if( !WriteFile( hfile, &tmps, 2, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmps = 16;
    if( !WriteFile( hfile, &tmps, 2, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );

    if( !WriteFile( hfile, "data", 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    tmpl = size;
    if( !WriteFile( hfile, &tmpl, 4, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );
    if( !WriteFile( hfile, pointer, size, &wsize, NULL ) ) rb_raise( eDXRubyError, "t@C݂̏Ɏs܂ - write" );

    CloseHandle( hfile );

    /* AbN */
    hr = se->pDSBuffer->lpVtbl->Unlock( se->pDSBuffer, pointer, size, pointer2, size2 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    return self;
}


/*--------------------------------------------------------------------
   z
 ---------------------------------------------------------------------*/
static VALUE SoundEffect_to_a( VALUE self )
{
    HRESULT hr;
    short *pointer, *pointer2;
    DWORD size, size2;
    struct DXRubySoundEffect *se = DXRUBY_GET_STRUCT( SoundEffect, self );
    VALUE ary;
    int i;

    DXRUBY_CHECK_DISPOSE( se, pDSBuffer );

    /* bN */
    hr = se->pDSBuffer->lpVtbl->Lock( se->pDSBuffer, 0, 0, &pointer, &size, &pointer2, &size2, DSBLOCK_ENTIREBUFFER );
    if( FAILED( hr ) || size2 != 0 )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    ary = rb_ary_new2( size / 2 );
    for( i = 0; i < size / 2; i++ )
    {
        double tmp;
        if( pointer[i] < 0 )
        {
            tmp = pointer[i] / 32768.0;
        }
        else
        {
            tmp = pointer[i] / 32767.0;
        }
        rb_ary_push( ary, rb_float_new( tmp ) );
    }

    /* AbN */
    hr = se->pDSBuffer->lpVtbl->Unlock( se->pDSBuffer, pointer, size, pointer2, size2 );
    if( FAILED( hr ) )
    {
        rb_raise( eDXRubyError, "TEhobt@̃bNɎs܂ - Lock" );
    }

    return ary;
}


void Init_dxruby_Sound( void )
{
    /* SoundNX` */
    cSound = rb_define_class_under( mDXRuby, "Sound", rb_cObject );
    rb_define_singleton_method( cSound, "load_from_memory", Sound_load_from_memory, 2 );
    rb_define_singleton_method( cSound, "loadFromMemory", Sound_load_from_memory, 2 );

    /* SoundNXɃ\bho^*/
    rb_define_private_method( cSound, "initialize"   , Sound_initialize   , 1 );
    rb_define_method( cSound, "dispose"      , Sound_dispose   , 0 );
    rb_define_method( cSound, "disposed?"    , Sound_check_disposed, 0 );
    rb_define_method( cSound, "play"         , Sound_play      , 0 );
    rb_define_method( cSound, "stop"         , Sound_stop         , 0 );
    rb_define_method( cSound, "set_volume"   , Sound_setVolume    , -1 );
    rb_define_method( cSound, "setVolume"    , Sound_setVolume    , -1 );
    rb_define_method( cSound, "pan"          , Sound_getPan       , 0 );
    rb_define_method( cSound, "pan="         , Sound_setPan       , 1 );
    rb_define_method( cSound, "frequency"    , Sound_getFrequency , 0 );
    rb_define_method( cSound, "frequency="   , Sound_setFrequency , 1 );
    rb_define_method( cSound, "start="       , Sound_setStart     , 1 );
    rb_define_method( cSound, "loop_start="  , Sound_setLoopStart , 1 );
    rb_define_method( cSound, "loopStart="   , Sound_setLoopStart , 1 );
    rb_define_method( cSound, "loop_end="    , Sound_setLoopEnd   , 1 );
    rb_define_method( cSound, "loopEnd="     , Sound_setLoopEnd   , 1 );
    rb_define_method( cSound, "loop_count="  , Sound_setLoopCount , 1 );
    rb_define_method( cSound, "loopCount="   , Sound_setLoopCount , 1 );

    /* SoundIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cSound, Sound_allocate );


    /* SoundEffectNX` */
    cSoundEffect = rb_define_class_under( mDXRuby, "SoundEffect", rb_cObject );

    /* SoundEffectNXɃ\bho^*/
    rb_define_private_method( cSoundEffect, "initialize", SoundEffect_initialize, -1 );
    rb_define_method( cSoundEffect, "dispose"   , SoundEffect_dispose   , 0 );
    rb_define_method( cSoundEffect, "disposed?" , SoundEffect_check_disposed, 0 );
    rb_define_method( cSoundEffect, "play"      , SoundEffect_play      , -1 );
    rb_define_method( cSoundEffect, "stop"      , SoundEffect_stop      , 0 );
    rb_define_method( cSoundEffect, "add"       , SoundEffect_add       , -1 );
    rb_define_method( cSoundEffect, "save"      , SoundEffect_save      , 1 );
#ifdef DXRUBY15
    rb_define_method( cSoundEffect, "to_a"      , SoundEffect_to_a      , 0 );
#endif
    /* SoundEffectIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cSoundEffect, SoundEffect_allocate );

    rb_define_const( mDXRuby, "WAVE_SIN"     , INT2FIX(WAVE_SIN) );
    rb_define_const( mDXRuby, "WAVE_SAW"     , INT2FIX(WAVE_SAW) );
    rb_define_const( mDXRuby, "WAVE_TRI"     , INT2FIX(WAVE_TRI) );
    rb_define_const( mDXRuby, "WAVE_RECT"    , INT2FIX(WAVE_RECT) );

    rb_define_const( mDXRuby, "TYPE_MIDI"    , INT2FIX(0) );
    rb_define_const( mDXRuby, "TYPE_WAV"     , INT2FIX(1) );
}

