/**
 *  @file		VoiceElement.cpp
 *  @brief		P̃TEhǗNX
 *  @author		Sazanta
 */

// CN[h
#include	"VoiceElement.h"


INT32			CVoiceElement::m_snGlobalVol = cnVoiceElm_VolumeMax;


//!	RXgN^
CVoiceElement::CVoiceElement(void)
{
	m_dwNumber       = 0;
	m_dwUnique       = 0;
	m_bFinishRequest = false;
	m_bPauseRequest  = false;
	m_bPause         = false;
	m_bVolumeFade    = false;
	m_cVolume.SetNowValue(cnVoiceElm_VolumeMax);
	m_cPanpot.SetNowValue(cnVoiceElm_PanpotCenter);
#if defined(NUM_OF_SUB_VOLUME) && (NUM_OF_SUB_VOLUME > 0)
	for (int i = 0; i < NUM_OF_SUB_VOLUME; i++) {
		m_cSubVolume[i].SetNowValue(cnVoiceElm_VolumeMax);
	}
#endif
}


//!	Ꮘ
/**
 *	t[słB<br>
 *	܂Ԋu󂩂Ȃ悤ĂяoĂB<br>
 *
 *	@param	nSyncTick	[in] O񂩂̌oߎ[tick]
 */
void CVoiceElement::Run(INT32 nSyncTick)
{
	INT32	nValue;

	// I[gp
	if (m_cPanpot.Run(nSyncTick, nValue) == true) {
		m_cPanpot.SetNowValue(nValue);
		_SetPan(nValue);
	}

	INT32	nSubVol = cnVoiceElm_VolumeMax;
	bool	bSubChange = false;
#if defined(NUM_OF_SUB_VOLUME) && (NUM_OF_SUB_VOLUME > 0)
	// Tu{[tF[h
	for (int i = 0; i < NUM_OF_SUB_VOLUME; i++) {
		if (m_cSubVolume[i].Run(nSyncTick, nValue) == true) {
			nSubVol *= nValue;
			nSubVol /= cnVoiceElm_VolumeRange;
			m_cSubVolume[i].SetNowValue(nValue);
			bSubChange = true;
		}
	}
#endif

	// C{[tF[h
	if (m_cVolume.Run(nSyncTick, nValue) == true) {
		_SetVolume(nValue * m_snGlobalVol * nSubVol / (cnVoiceElm_VolumeRange * cnVoiceElm_VolumeRange));
		if (m_bVolumeFade == true) {
			m_cVolume.SetNowValue(nValue);
		}
		if (m_cVolume.IsFade() == false) {
			// tF[hI
			if (m_bFinishRequest == true) {
				Stop();
                m_bFinishRequest = false;
			} else if (m_bPauseRequest == true) {
				_Pause();
				m_bPauseRequest = false;
				m_bPause        = true;
			}
			m_bVolumeFade = false;
		}
	} else {
		if (bSubChange != false) {
			_SetVolume(nValue * m_snGlobalVol * nSubVol / (cnVoiceElm_VolumeRange * cnVoiceElm_VolumeRange));
		}
	}
}


//!	f[^̉
/**
 *	f[^̉s܂B<br>
 */
void CVoiceElement::Release(void)
{
	Stop();
	_Release();
}


//!	ĐI`FbN
/**
 *	ĐIĂ邩ǂ擾܂B<br>
 *
 *	@return	IĂꍇtrueԂ
 */
bool CVoiceElement::IsFinished(void)	const
{
	if (_IsFinished() == true) {
		return true;
	}
	if (m_bFinishRequest == true && IsFade() == false) {
		return true;
	}

	return false;
}


//!	tF[h̒f
void	CVoiceElement::AbortFade(void)
{
	if (IsFade() == true) {
		m_cVolume.ResetTime();
		m_bVolumeFade = false;
	}
}


void	CVoiceElement::InternalFade(INT32 nVolume, INT32 nTick, INT32 nStartVolume)
{
	INT32		nSave = m_cVolume.GetNowValue();
	SetVolume(nVolume, nTick, nStartVolume);
	m_cVolume.SetNowValue(nSave);
	m_bVolumeFade = false;
}


INT32 CVoiceElement::InternalGetVolume(void)	const
{
	return (m_cVolume.IsFade() == true && m_bVolumeFade == false)? m_cVolume.GetCalcValue() : m_cVolume.GetNowValue();
}


INT32 CVoiceElement::CalculateSubVolume(void)	const
{
	INT32	nSubVol = cnVoiceElm_VolumeMax;
#if defined(NUM_OF_SUB_VOLUME) && (NUM_OF_SUB_VOLUME > 0)
	for (int i = 0; i < NUM_OF_SUB_VOLUME; i++) {
		nSubVol *= m_cSubVolume[i].GetNowValue() / cnVoiceElm_VolumeRange;
	}
#endif

	return nSubVol;
}


//!	{[̎擾
/**
 *	݂̃{[擾܂B<br>
 *
 *	@return	{[l
 */
INT32 CVoiceElement::GetVolume(void)	const
{
	return m_cVolume.GetNowValue();
}


//!	{[̐ݒ
/**
 *	{[̐ݒs܂B<br>
 *
 *	@param	nVolume			[in] {[(0 ` 100)
 *	@param	nTick			[in] Jڎ[tick]
 *	@param	nStartVolume	[in] X^[g{[(ȗꍇ͌ݒlQ)
 */
void CVoiceElement::SetVolume(INT32 nVolume, INT32 nTick, INT32 nStartVolume)
{
	VolumeClamp(nVolume);
	m_bVolumeFade = false;
	if (nTick > 0) {
		if (nStartVolume < 0) {
			nStartVolume = InternalGetVolume();
		}
		m_cVolume.SetParam(nTick, nStartVolume, nVolume);
		m_bVolumeFade = true;
		nVolume = nStartVolume;
	} else {
		m_cVolume.ResetTime();
	}

	m_cVolume.SetNowValue(nVolume);
	_SetVolume(nVolume * m_snGlobalVol * CalculateSubVolume() / (cnVoiceElm_VolumeRange * cnVoiceElm_VolumeRange));
}


//! Tu{[̎擾
/**
 *	Tu{[l̎擾s܂B
 *
 *	@param	nChannel	[in] Tu{[`l
 *
 *	@return	{[l
 */
INT32 CVoiceElement::GetSubVolume(UINT32 nChannel)	const
{
#if defined(NUM_OF_SUB_VOLUME) && (NUM_OF_SUB_VOLUME > 0)
	return (nChannel < NUM_OF_SUB_VOLUME)? m_cSubVolume[nChannel].GetNowValue() : cnVoiceElm_VolumeMax;
#else
	return cnVoiceElm_VolumeMax;
#endif
}


//! Tu{[̐ݒ
/**
 *	Tu{[l̐ݒs܂B
 *
 *	@param	nChannel		[in] Tu{[`l
 *	@param	nVolume			[in] {[
 *	@param	nTick			[in] Jڎ[tick]
 *	@param	nStartVolume	[in] X^[g{[(ȗꍇ͌ݒlQ)
 */
void CVoiceElement::SetSubVolume(UINT32 nChannel, INT32 nVolume, INT32 nTick, INT32 nStartVolume)
{
#if defined(NUM_OF_SUB_VOLUME) && (NUM_OF_SUB_VOLUME > 0)
	if (nChannel >= NUM_OF_SUB_VOLUME)		return;

	VolumeClamp(nVolume);
	if (nTick > 0) {
		if (nStartVolume < 0) {
			nStartVolume = (m_cSubVolume[nChannel].IsFade() == true)? m_cSubVolume[nChannel].GetCalcValue() : m_cSubVolume[nChannel].GetNowValue();
		}
		m_cSubVolume[nChannel].SetParam(nTick, nStartVolume, nVolume);
		nVolume = nStartVolume;
	} else {
		m_cSubVolume[nChannel].ResetTime();
	}
	m_cSubVolume[nChannel].SetNowValue(nVolume);
	ReflectMasterVolume();
#endif
}


//!	p̎擾
/**
 *	݂̃p擾܂B<br>
 *
 *	@return	pl
 */
INT32 CVoiceElement::GetPan(void)	const
{
	return m_cPanpot.GetNowValue();
}


//!	p̐ݒ
/**
 *	p̐ݒs܂B<br>
 *
 *	@param	nPan		[in] p
 *	@param	nTick		[in] Jڎ
 *	@param	nStartPan	[in] X^[gp(ȗꍇ͌ݒlQ)
 */
void CVoiceElement::SetPan(INT32 nPan, INT32 nTick, INT32 nStartPan)
{
	nPan = (nPan < cnVoiceElm_PanpotMaxL)? cnVoiceElm_PanpotMaxL : ((nPan > cnVoiceElm_PanpotMaxR)? cnVoiceElm_PanpotMaxR : nPan);
	if (nTick > 0) {
		if (nStartPan < cnVoiceElm_PanpotMaxL || nStartPan > cnVoiceElm_PanpotMaxR) {
			nStartPan = m_cPanpot.GetNowValue();
		}
		m_cPanpot.SetParam(nTick, nStartPan, nPan);
		nPan = nStartPan;
	} else {
		m_cPanpot.ResetTime();
	}
	m_cPanpot.SetNowValue(nPan);
	_SetPan(nPan);
}


//!	Đ
/**
 *	Đs܂B<br>
 *	nLoop0w肷ƁA1񉉑tďI܂B<br>
 *	nLoopInSample0ȊOɐݒ肷ƁA[vۂ̃[vJn|Cgݒł܂B<br>
 *	Pʂ̓TvłB<br>
 *
 *	@param	nLoop			[in] [v(LOOP_INFINITYŖ[v)
 *	@param	nVolume			[in] {[
 *	@param	nFadeInTick		[in] tF[hC[tick]
 *	@param	nLoopInSample	[in] [vCTv
 */
void CVoiceElement::Play(UINT32 nLoop, INT32 nVolume, INT32 nFadeInTick, UINT32 nLoopInSample)
{
	Stop();
	SetVolume(nVolume, nFadeInTick, 0);
	m_cVolume.SetNowValue(nVolume);
	m_bVolumeFade = false;

	_Play(nLoop, nLoopInSample);
}


//!	~
/**
 *	~܂B<br>
 *	tF[hAEgԂ0łȂꍇAtF[hI~܂B<br>
 *
 *	@param	fFadeOutTime	[in] tF[hAEg
 */
void CVoiceElement::Stop(INT32 nFadeOutTick)
{
	m_bPauseRequest = false;
	if (nFadeOutTick > 0 && m_bPause == false) {
		InternalFade(0, nFadeOutTick);
		m_bFinishRequest = true;
	} else {
		AbortFade();
		m_bPause = false;
		_Stop();
	}
}


//!	ꎞ~
/**
 *	ꎞ~܂B<br>
 *
 *	@param	bPause		[in] |[YꍇtrueA|[Yꍇfalse
 *	@param	fFadeTime	[in] tF[h
 */
void CVoiceElement::Pause(bool bPause, INT32 nFadeTick)
{
	if (bPause == true) {
		// |[Y
		if (m_bPauseRequest == false && IsPause() == false) {
			m_bFinishRequest = false;
			if (nFadeTick > 0) {
				InternalFade(0, nFadeTick);
				m_bPauseRequest = true;
			} else {
				AbortFade();
				_Pause();
				m_bPause = true;
			}
		}
	} else {
		// |[Y
		if (m_bPauseRequest == true || IsPause() == true) {
			if (IsPause() == true) {
				m_bPause = false;
				InternalFade(m_cVolume.GetNowValue(), nFadeTick, 0);
				_Pause();
			} else {
				InternalFade(m_cVolume.GetNowValue(), nFadeTick);
			}
			m_bPauseRequest = false;
		}
	}
}


/*  Bottom of VoiceElement.cpp  */
