/**
 *  @file		VoiceElement.h
 *  @brief		P̃TEhǗNX
 *  @author		Sazanta
 */
#ifndef __VOICEELEMENT_H__
#define	__VOICEELEMENT_H__
#include	<windows.h>

#define	NUM_OF_SUB_VOLUME	0			//!< Tu{[̐

const	INT32		cnVoiceElm_VolumeMin	= 0;				//!< ŏ{[l
const	INT32		cnVoiceElm_VolumeMax	= 128;				//!< ő{[l
const	INT32		cnVoiceElm_VolumeRange	= (cnVoiceElm_VolumeMax - cnVoiceElm_VolumeMin);	//!< {[͈
const	INT32		cnVoiceElm_PanpotCenter	= 0;				//!< pZ^[l
const	INT32		cnVoiceElm_PanpotMaxR	= 128;				//!< Epől
const	INT32		cnVoiceElm_PanpotMaxL	= -128;				//!< pől
const	INT32		cnVoiceElm_PanpotRange	= (cnVoiceElm_PanpotMaxR - cnVoiceElm_PanpotMaxL);	//!< p͈
const	INT32		cnVoiceElm_PanpotHalfRange	= (cnVoiceElm_PanpotRange / 2);					//!< p͈(n[t)


//! CVoiceElementNX
/**
 *	̃NX́ATEh̃tF[hEI[gpƂԕψʂs߂̃NXłB<br>
 *	|[YɃtF[hsہA{[ۑ̂ŁA|[YɌ̃{[ɖ߂Ƃo܂B<br>
 *	܂}X^[{[T|[g邽߂̋@\Ă܂B<br>
 *	P̃NXɂAP̃{CXǗ邱Ƃo܂B<br>
 *	P̂łgp邱Ƃ͏o܂Aʏ̓TEh}l[WɂĊǗ܂B<br>
 *	̃NX̂́AC^[tFCX񋟂邾ł̂ŁAۂɂ͂̃NXhNX𗘗p܂B<br>
 */
class CVoiceElement
{
	class CFadeValue
	{
		private:
			INT32				m_nNowValue;				//!< ݂̒l
			INT32				m_nNowTick;					//!< ݂̃^C
			INT32				m_nTotalTick;				//!< ^C
			INT32				m_nStartVal;				//!< Jnl
			INT32				m_nDistVal;					//!< ͈͒l

		public:
								CFadeValue(void) {
									m_nNowTick = 0;
								}
								~CFadeValue(void) {}

			bool				IsFade(void)	const	{
									return (m_nNowTick > 0);
								}
			void				ResetTime(void) {
									m_nNowTick = 0;
								}
			INT32				GetNowValue(void)	const	{
									return m_nNowValue;
								}
			void				SetNowValue(INT32 nValue) {
									m_nNowValue = nValue;
								}
			void				SetParam(INT32 nTick, INT32 nStart, INT32 nEnd) {
									m_nNowTick   = nTick;
									m_nTotalTick = nTick;
									m_nStartVal  = nEnd;
									m_nDistVal   = nStart - nEnd;
								}

			INT32				GetCalcValue(void)	const	{
									return ((m_nDistVal * m_nNowTick) / m_nTotalTick) + m_nStartVal;
								}
			bool				Run(INT32 nTick, INT32& nValue) {
									if (m_nNowTick <= 0)		return false;
									m_nNowTick -= nTick;
									if (m_nNowTick < 0) {
										m_nNowTick = 0;
									}
									nValue = GetCalcValue();
									return true;
								}
	};

  protected:
			UINT32				m_dwNumber;					//!< {CXio[
			UINT32				m_dwUnique;					//!< ʂhc
			bool				m_bFinishRequest;			//!< tF[hIv
			bool				m_bPauseRequest;			//!< tF[h|[Yv
			bool				m_bPause;					//!< |[YtO
			bool				m_bVolumeFade;				//!< {[tF[htO

			CFadeValue			m_cVolume;					//!< {[
#if defined(NUM_OF_SUB_VOLUME) && (NUM_OF_SUB_VOLUME > 0)
			CFadeValue			m_cSubVolume[NUM_OF_SUB_VOLUME];	//!< Tu{[
#endif
			CFadeValue			m_cPanpot;					//!< p|bg

	static	INT32				m_snGlobalVol;				//!< O[o{[

  protected:
			void				AbortFade(void);
			void				InternalFade(INT32 nVolume, INT32 nTick = 0, INT32 nStartVolume = -1);
			INT32				InternalGetVolume(void)	const;
			INT32				CalculateSubVolume(void)	const;
			void				VolumeClamp(INT32& nVolume)	const	{
									nVolume = (nVolume < cnVoiceElm_VolumeMin)? cnVoiceElm_VolumeMin : ((nVolume > cnVoiceElm_VolumeMax)? cnVoiceElm_VolumeMax : nVolume);
								}

	virtual	void				_Release(void) {}
	virtual	void				_SetPan(INT32 nPan) {}
	virtual	void				_SetVolume(INT32 nVolume) {}
	virtual	void				_SetSpeedRate(INT32 nRate) {}
	virtual	void				_Pause(void) {}
	virtual	bool				_Load(const char* pSoundData, UINT32 nDataSize, UINT32 nType) {
									return false;
								}
	virtual	bool				_Load(const TCHAR* pFileName, UINT32 nType, UINT32 nOffset, UINT32 nDataSize) {
									return false;
								}
	virtual	bool				_IsPlaying(void)	const	{
									return false;
								}
	virtual	bool				_IsFinished(void)	const	{
									return true;
								}
	virtual	void				_Play(UINT32 nLoop, UINT32 nLoopInSample = 0, UINT32 nStartPos = 0) {}
	virtual	void				_Stop(void) {}
	virtual	void				_Prefetch(void) {}
	virtual	void				_Predecode(void) {}

  public:
								CVoiceElement(void);
								//!	fXgN^
	virtual						~CVoiceElement(void) {}

			void				Run(INT32 nTick);

								//! {CXio[̐ݒ
			void				SetNumber(UINT32 dwNumber) {
									m_dwNumber = dwNumber;
								}
								//! {CXio[̎擾
			UINT32				GetNumber(void)	const	{
									return m_dwNumber;
								}

								//! ID̐ݒ
			void				SetUnique(UINT32 dwUnique) {
									m_dwUnique = dwUnique;
								}
								//! ID̎擾
			UINT32				GetUnique(void)	const	{
									return m_dwUnique;
								}

								//!	f[^̍쐬
								/**
								 *	f[^̍쐬s܂B<br>
								 */
			bool				Load(const char* pSoundData, UINT32 nDataSize, UINT32 nFlag) {
									Release();
									return _Load(pSoundData, nDataSize, nFlag);
								}
								//!	f[^̍쐬
								/**
								 *	f[^̍쐬s܂B<br>
								 */
			bool				Load(const TCHAR* pFileName, UINT32 nFlag, UINT32 nOffset, UINT32 nDataSize) {
									Release();
									return _Load(pFileName, nFlag, nOffset, nDataSize);
								}
			void				Release(void);

								//! Đǂ`FbN
								/**
								 *	Đǂ擾܂B<br>
								 *
								 *	@return	ĐȂtrue
								 */
			bool				IsPlaying(void)	const
								{
									return _IsPlaying();
								}
								//!	~`FbN
								/**
								 *	~ǂ擾܂B<br>
								 *
								 *	@return	~Ȃtrue
								 */
			bool				IsFinished(void)	const;
								//!	tF[hǂ`FbN
								/**
								 *	tF[hǂ擾܂B<br>
								 *
								 *	@return	tF[hȂtrue
								 */
			bool				IsFade(void)	const	{
									return m_cVolume.IsFade();
								}
								//!	|[Yǂ`FbN
								/**
								 *	|[Yǂ擾܂B<br>
								 *
								 *	@return	|[YȂtrue
								 */
			bool				IsPause(void)	const	{
									return m_bPause;
								}

								//!	}X^[{[̔f
								/**
								 *	}X^[{[𑦎f܂B<br>
								 */
			void				ReflectMasterVolume(void) {
									if (IsFade() == false) {
										SetVolume(-1);
									}
								}
			INT32				GetVolume(void)	const;
			void				SetVolume(INT32 nVolume, INT32 nTick = 0, INT32 nStartVolume = -1);
			INT32				GetSubVolume(UINT32 nChannel)	const;
			void				SetSubVolume(UINT32 nChannel, INT32 nVolume, INT32 nTick = 0, INT32 nStartVolume = -1);

			INT32				GetPan(void)	const;
			void				SetPan(INT32 nPan, INT32 nTick = 0, INT32 nStartPan = -(cnVoiceElm_PanpotHalfRange + 1));

			INT32				GetSpeedRate(void)	const	{
									return 4096;
								}
			void				SetSpeedRate(INT32 nRate) {
									_SetSpeedRate(nRate);
								}

			void				Play(UINT32 dwLoop = 0, INT32 nVolume = -1, INT32 nFadeInTick = 0, UINT32 nLoopInSample = 0);
			void				Stop(INT32 nFadeOutTick = 0);
			void				Pause(bool bPause, INT32 nFadeTick = 0);
			void				Prefetch(void) {
                    			    _Prefetch();
								}
			void				Predecode(void) {
                    			    _Predecode();
								}

	static	void				SetGlobalVolume(INT32 nVolume) {
									m_snGlobalVol = (nVolume < cnVoiceElm_VolumeMin)? cnVoiceElm_VolumeMin : ((nVolume > cnVoiceElm_VolumeMax)? cnVoiceElm_VolumeMax : nVolume);
								}
};


#endif		// __VOICEELEMENT_H__
/*  Bottom of VoiceElement.h  */
