unit u_dzDebugVisualizer;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Controls,
  Forms,
  ToolsAPI,
  Menus,
  Contnrs,
  ComCtrls,
  ActnList,
  ExtCtrls,
  u_dzDebugVisualizerEventHooking,
  w_dzDebugVisualizerMultilineString,
  u_dzDebugVisualizerIdeNotifier,
  u_dzDebugVisualizerHandler,
  u_dzDebugVisualizerWatchFormHandler;

type
  TdzDebugVisualizer = class(TIdeNotifierObject, IOTAWizard, IOTANotifier, IOTAIDENotifier)
  protected // IOTAIDENotifier
    procedure FileNotification(NotifyCode: TOTAFileNotification;
      const FileName: string; var Cancel: Boolean); override;
  private // IOTAWizard
    function GetIDString: string;
    procedure Execute;
    function GetName: string;
    function GetState: TWizardState;
  private
    FWatchFormHandler: TDebugVisualizerWatchFormHandler;
    FScreenActiveFormChangedHook: TNotifyEventHook;
    procedure SetUpWatchWindow;
    procedure SetUpEvaluateWindow(_Form: TCustomForm);
    procedure ScreenActiveFormChange(_Sender: TObject);
    procedure WatchFormHandlerDestroy(_Sender: TObject);
  public
    constructor Create;
    destructor Destroy; override;
  end;

procedure Register;

implementation

uses
  TypInfo,
  StdCtrls,
  u_dzDebugVisualizerModifyFormHandler;

constructor TdzDebugVisualizer.Create;
begin
  inherited Create;
  FScreenActiveFormChangedHook := TScreenActiveFormChangeHook.Install(ScreenActiveFormChange);
end;

destructor TdzDebugVisualizer.Destroy;
begin
  TScreenActiveFormChangeHook.Remove(FScreenActiveFormChangedHook);
  FreeAndNil(FWatchFormHandler);
  inherited;
end;

procedure TdzDebugVisualizer.ScreenActiveFormChange(_Sender: TObject);
begin
  if Assigned(Screen) then
    if Assigned(Screen.ActiveCustomForm) then
      if Screen.ActiveCustomForm.ClassNameIs('TEvalDialog') then
        SetUpEvaluateWindow(Screen.ActiveCustomForm);
end;

procedure TdzDebugVisualizer.SetUpEvaluateWindow(_Form: TCustomForm);
const
  VisualizerComponentName = 'dzDebugVisualizer_Component';
var
  ctl: TComponent;
begin
  ctl := _Form.FindComponent(VisualizerComponentName);
  if Assigned(ctl) then
    Exit; //==>

  ctl := TDebugVisualizerModifyFormHandler.Create(_Form);
  ctl.Name := VisualizerComponentName;
end;

procedure TdzDebugVisualizer.SetUpWatchWindow;
const
  VisualizerComponentName = 'dzDebugVisualizer_Component';
var
  i: Integer;
  s: string;
  ctl: TComponent;
  WatchWindow: TForm;
begin
  WatchWindow := nil;
  // iterate the IDE's forms to find the Watch Window
  for i := 0 to Screen.FormCount - 1 do begin
    s := Screen.Forms[i].Name;
    if CompareText(s, 'WatchWindow') = 0 then begin
      WatchWindow := Screen.Forms[i];
      Break;
    end;
  end;
  if not Assigned(WatchWindow) then
    Exit;

  ctl := WatchWindow.FindComponent(VisualizerComponentName);
  if Assigned(ctl) then
    Exit;
  FWatchFormHandler := TDebugVisualizerWatchFormHandler.Create(WatchWindow);
  FWatchFormHandler.Name := VisualizerComponentName;
  FWatchFormHandler.OnDestroyed := WatchFormHandlerDestroy;
end;

procedure TdzDebugVisualizer.WatchFormHandlerDestroy(_Sender: TObject);
begin
  FWatchFormHandler := nil;
end;

procedure TdzDebugVisualizer.FileNotification(NotifyCode: TOTAFileNotification;
  const FileName: string; var Cancel: Boolean);
begin
  if NotifyCode = ofnProjectDesktopLoad then
    SetUpWatchWindow;
end;

procedure TdzDebugVisualizer.Execute;
begin
  // do nothing
end;

function TdzDebugVisualizer.GetIDString: string;
begin
  Result := 'de.dummzeuch.DebugVisualizer';
end;

function TdzDebugVisualizer.GetName: string;
begin
  Result := 'dzDebugVisualizer';
end;

function TdzDebugVisualizer.GetState: TWizardState;
begin
  Result := [wsEnabled];
end;

var
  gblNotifierIndex: Integer = -1;

procedure Register;
var
  Services: IOTAServices;
begin
  Services := BorlandIDEServices as IOTAServices;
  gblNotifierIndex := Services.AddNotifier(TdzDebugVisualizer.Create);
end;

procedure Unregister;
var
  Services: IOTAServices;
begin
  if gblNotifierIndex <> -1 then begin
    Services := BorlandIDEServices as IOTAServices;
    Services.RemoveNotifier(gblNotifierIndex);
  end;
end;

initialization

finalization
  Unregister;
end.
