unit u_dzDebugVisualizerModifyFormHandler;

interface

uses
  Windows,
  SysUtils,
  Classes,
  Controls,
  Forms,
  ComCtrls,
  ActnList,
  ExtCtrls;

type
  TDebugVisualizerModifyFormHandler = class(TComponent)
  private
    FResultLine: TWinControl;
    FExpression: TWinControl;
    FEvalAction: TAction;
    FTimer: TTimer;
    FModifierButton: TToolButton;
    FForm: TForm;
    procedure ModifierButtonClick(_Sender: TObject);
    procedure EvalActionExecute(_Sender: TObject);
    procedure TimerExecuteUnquote(_Sender: TObject);
    procedure TimerExecuteDateTime(_Sender: TObject);
    procedure MenuItemCharacterClick(_Sender: TObject);
    procedure MenuItemStringClick(_Sender: TObject);
    procedure MenuItemDateTimeClick(_Sender: TObject);
    procedure MenuItemDecimalClick(_Sender: TObject);
    procedure MenuItemFloatClick(_Sender: TObject);
    procedure MenuItemHexadecimalClick(_Sender: TObject);
    procedure MenuItemUnquoteClick(_Sender: TObject);
    procedure AppendModifier(_c: Char);
    procedure MenuItemDumpClick(_Sender: TObject);
    procedure MenuItemColorClick(_Sender: TObject);
    procedure TimerExecuteColor(_Sender: TObject);
  public
    constructor Create(_Owner: TComponent); override;
  end;

implementation

uses
  Menus,
  u_dzDebugVisualizerEventHooking,
  u_dzDebugVisualizerHandler;

{ TDebugVisualizerModifyFormHandler }

constructor TDebugVisualizerModifyFormHandler.Create(_Owner: TComponent);
const
  ModifierButtonName = 'dzDebugVisualizer_ToolButtonTest';
var
  tb: TToolBar;
  Hook: TNotifyEventHook;
  ne: TNotifyEvent;
  ctl: TComponent;
  pm: TPopupMenu;
  mi: TMenuItem;
begin
  inherited Create(_Owner);
  FForm := _Owner as TForm;

  ctl := FForm.FindComponent(ModifierButtonName);
  if Assigned(ctl) then
    Exit; //==>

  FModifierButton := FForm.FindComponent(ModifierButtonName) as TToolButton;
  if Assigned(FModifierButton) then
    Exit; //==>

  FResultLine := FForm.FindComponent('ResultLine') as TWinControl;
  if not Assigned(FResultLine) then
    Exit; //==>

  FExpression := FForm.FindComponent('Expression') as TWinControl;
  if not Assigned(FExpression) then
    Exit; //==>

  FTimer := TTimer.Create(FForm);
  FTimer.Enabled := False;
  FTimer.Interval := 100;

  FEvalAction := FForm.FindComponent('EvalAction') as TAction;
  ne := EvalActionExecute;
  Hook := TNotifyEventHook.Create(TMethod(FEvalAction.OnExecute), TMethod(ne));
  FEvalAction.OnExecute := Hook.HandleEvent;

  tb := FForm.FindComponent('ToolBar1') as TToolBar;
  if not Assigned(tb) then
    Exit; //==>

  pm := TPopupMenu.Create(FForm);

  mi := TMenuItem.Create(pm);
  mi.Caption := '&Character';
  mi.OnClick := MenuItemCharacterClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := '&String';
  mi.OnClick := MenuItemStringClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := '&Decimal';
  mi.OnClick := MenuItemDecimalClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := 'He&xadecimal';
  mi.OnClick := MenuItemHexadecimalClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := '&Floating Point (add significant digits 2 to 18)';
  mi.OnClick := MenuItemFloatClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := 'Du&mp';
  mi.OnClick := MenuItemDumpClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := '&Unquote';
  mi.OnClick := MenuItemUnquoteClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := 'Date &Time';
  mi.OnClick := MenuItemDateTimeClick;
  pm.Items.Add(mi);

  mi := TMenuItem.Create(pm);
  mi.Caption := 'Co&lor';
  mi.OnClick := MenuItemColorClick;
  pm.Items.Add(mi);

  FModifierButton := TToolButton.Create(FForm);
  FModifierButton.Name := ModifierButtonName;
  FModifierButton.Parent := tb;
  FModifierButton.Caption := 'Modifiers';
  FModifierButton.Left := FForm.Width;
  FModifierButton.OnClick := ModifierButtonClick;
  FModifierButton.DropdownMenu := pm;
  FModifierButton.EnableDropdown := True;
  FModifierButton.Style := tbsDropDown;
end;

function TCombobox_GetTextW(_cmb: TWinControl): WideString;
var
  Res: Integer;
begin
  Result := '';
  Res := GetWindowTextLengthW(_cmb.Handle);
  if Res = 0 then
    Exit; //==>

  SetLength(Result, Res + 1);
  Res := GetWindowTextW(_cmb.Handle, PWideChar(Result), Length(Result));
  if Res = 0 then
    Exit; //==>
  SetLength(Result, Res);
end;

procedure TDebugVisualizerModifyFormHandler.AppendModifier(_c: Char);
var
  Expression: WideString;
  i: Integer;
  c: WideChar;
begin
  if not Assigned(FExpression) then
    Exit;
  Expression := TCombobox_GetTextW(FExpression);
  i := Length(Expression);
  while (i > 0) do begin
    c := Expression[i];
    case c of
      ',': begin
          Expression := Expression + _c;
          SetWindowTextW(FExpression.Handle, PWideChar(Expression));
          Exit; //==>
        end;
      'a'..'z', 'A'..'Z', '0'..'9': begin
          // do nothing these might be valid modifiers
        end;
    else
      // This is not a valid modifier, so there is most likely no modifier at all
      Break;
    end;
    Dec(i);
  end;
  Expression := Expression + ',' + _c;
  SetWindowTextW(FExpression.Handle, PWideChar(Expression));
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemCharacterClick(_Sender: TObject);
begin
  AppendModifier('C');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemStringClick(_Sender: TObject);
begin
  AppendModifier('S');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemDecimalClick(_Sender: TObject);
begin
  AppendModifier('D');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemHexadecimalClick(_Sender: TObject);
begin
  AppendModifier('X');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemFloatClick(_Sender: TObject);
begin
  AppendModifier('F');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemDumpClick(_Sender: TObject);
begin
  AppendModifier('M');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemUnquoteClick(_Sender: TObject);
begin
  AppendModifier('U');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemDateTimeClick(_Sender: TObject);
begin
  AppendModifier('T');
end;

procedure TDebugVisualizerModifyFormHandler.MenuItemColorClick(_Sender: TObject);
begin
  AppendModifier('L');
end;

procedure TDebugVisualizerModifyFormHandler.EvalActionExecute(_Sender: TObject);
var
  Expression: WideString;
begin
  if not Assigned(FExpression) or not Assigned(FResultLine) then
    Exit; //==>

  Expression := TCombobox_GetTextW(FExpression);
  if Expression = '' then
    Exit; //==>
  Expression := Copy(Expression, Length(Expression) - 1, 2);
  if SameText(Expression, ',U') then begin
    // let the original event do its work and set up a timer so we can modify the result later
    FTimer.OnTimer := TimerExecuteUnquote;
    FTimer.Enabled := True;
  end else if SameText(Expression, ',T') then begin
    FTimer.OnTimer := TimerExecuteDateTime;
    FTimer.Enabled := True;
  end else if SameText(Expression, ',L') then begin
    FTimer.OnTimer := TimerExecuteColor;
    FTimer.Enabled := True;
  end;
end;

procedure TDebugVisualizerModifyFormHandler.TimerExecuteUnquote(_Sender: TObject);
var
  ResultLine: WideString;
begin
  FTimer.Enabled := False;

  ResultLine := TCombobox_GetTextW(FResultLine);
  ResultLine := UnquoteDebuggerString(ResultLine);
  SetWindowTextW(FResultLine.Handle, PWideChar(ResultLine));
end;

procedure TDebugVisualizerModifyFormHandler.TimerExecuteColor(_Sender: TObject);
var
  ResultLine: WideString;
begin
  FTimer.Enabled := False;

  ResultLine := TCombobox_GetTextW(FResultLine);
  ResultLine := DebuggerStringToColor(ResultLine);
  SetWindowTextW(FResultLine.Handle, PWideChar(ResultLine));
end;

procedure TDebugVisualizerModifyFormHandler.TimerExecuteDateTime(_Sender: TObject);
var
  ResultLine: WideString;
begin
  FTimer.Enabled := False;

  ResultLine := TCombobox_GetTextW(FResultLine);
  ResultLine := DebuggerStringToDateTime(ResultLine);
  SetWindowTextW(FResultLine.Handle, PWideChar(ResultLine));
end;

procedure TDebugVisualizerModifyFormHandler.ModifierButtonClick(_Sender: TObject);
var
  pnt: TPoint;
begin
  pnt := FModifierButton.ClientToScreen(Point(0, FModifierButton.Height));
  FModifierButton.DropdownMenu.Popup(pnt.X, pnt.Y);
end;

end.
