unit u_dzAutoCompleteDirs;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  StdCtrls,
  ActiveX,
  i_dzAutoComplete;

type
  TOnGetBaseEvent = procedure(_Sender: TObject; out _Base: string) of object;

type
  ///<summary>
  /// Implementaition of IEnumString for directories </summary>
  TEnumStringDirectories = class(TEnumStringAbstract, IEnumString)
  private
    FOnGetBase: TOnGetBaseEvent;
    FSearchRec: TSearchRec;
    FFindHandle: Integer;
    FBase: string;
    procedure doOnGetBase(out _Base: string);
    function FindNextDir(out _DirName: WideString): Boolean;
  protected
    // IEnumString
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; override;
    function Skip(celt: Longint): HResult; override;
    function Reset: HResult; override;
  public
    constructor Create(_OnGetBase: TOnGetBaseEvent);
    destructor Destroy; override;
  end;

///<summary>
/// Adds autocompletion to the edit by using the text as a directory name.
/// Similar to u_dzVclUtils.TEdit_SetAutocomplete with _Source =acsFileSystem,
/// but will not autocomplete file names. </summary>
procedure TEdit_ActivateAutoCompleteDirectories(_ed: TCustomEdit);

implementation

uses
  ComObj,
  Controls,
  u_dzVclUtils;

{ TEnumStringDirectories }

constructor TEnumStringDirectories.Create(_OnGetBase: TOnGetBaseEvent);
begin
  inherited Create;
  FFindHandle := -1;
  FOnGetBase := _OnGetBase;
end;

destructor TEnumStringDirectories.Destroy;
begin
  if FFindHandle = 0 then begin
    FindClose(FSearchRec);
    FFindHandle := -1;
  end;
  inherited;
end;

procedure TEnumStringDirectories.doOnGetBase(out _Base: string);
begin
  if Assigned(FOnGetBase) then
    FOnGetBase(Self, _Base);
end;

function TEnumStringDirectories.FindNextDir(out _DirName: WideString): Boolean;
begin
  if FFindHandle = -1 then begin
    Result := False;
    Exit; //==>
  end;
  Result := True;
  while (FindNext(FSearchRec) = 0) do begin
    _DirName := FSearchRec.Name;
    if ((faDirectory and FSearchRec.Attr) <> 0) and (_DirName <> '.') and (_DirName <> '..') then
      Exit; //==>
  end;
  Result := False;
end;

function TEnumStringDirectories.Next(celt: Integer; out elt; pceltFetched: PLongint): HResult;
var
  i: Integer;
  wStr: WideString;
begin
  i := 0;
  while (i < celt) and FindNextDir(wStr) do begin
    wStr := FBase + wStr;
    TPointerList(elt)[i] := Pointer(wStr);
    Pointer(wStr) := nil;
    Inc(i);
  end;
  if pceltFetched <> nil then
    pceltFetched^ := i;
  if i = celt then
    Result := S_OK
  else
    Result := S_FALSE;
end;

function TEnumStringDirectories.Reset: HResult;
begin
  doOnGetBase(FBase);
  if FFindHandle = 0 then
    FindClose(FSearchRec);
  FFindHandle := FindFirst(FBase + '*', faDirectory, FSearchRec);
  if FFindHandle = 0 then begin
    Result := S_OK;
  end else
    Result := S_FALSE;
end;

function TEnumStringDirectories.Skip(celt: Integer): HResult;
var
  i: Integer;
  wStr: WideString;
begin
  i := 0;
  while FindNextDir(wStr) do begin
    Inc(i);
    if i < celt then begin
      Result := S_OK;
      Exit; //==>
    end;
  end;
  Result := S_FALSE;
end;

type
  TAutoCompleteHelperDirectories = class(TAutoCompleteHelper)
  private
    procedure HandleOnGetBase(_Sender: TObject; out _Base: string);
  protected
    function CreateEnumStringInt: IEnumString; override;
  end;

procedure TEdit_SetAutoCompleteDirectories(_ed: TCustomEdit);
begin
  TAutoCompleteHelperDirectories.Create(_ed);
end;

procedure TEdit_ActivateAutoCompleteDirectories(_ed: TCustomEdit);
begin
  TAutoCompleteHelperDirectories.Create(_ed);
end;

{ TAutoCompleteHelperDirectories }

function TAutoCompleteHelperDirectories.CreateEnumStringInt: IEnumString;
begin
  Result := TEnumStringDirectories.Create(HandleOnGetBase);
end;

procedure TAutoCompleteHelperDirectories.HandleOnGetBase(_Sender: TObject; out _Base: string);
begin
  _Base := (FCtrl as TCustomEdit).Text;
end;

end.
