unit u_dzMapFileReader;

interface

uses
  Classes;

type
  ///<summary>
  /// Reads and interprets a .map file generated by Delphi
  /// For now only creates a list of units from the "Detailed map of segments" which
  /// is available even hin the smallest variant of that file. </summary>
  TMapFileReader = class
  private
    FFilename: string;
    FContent: TStringList;
    FUnits: TStringList;
    procedure Parse;
    procedure ParseSegments(_StartIdx: Integer);
  public
    constructor Create(const _Filename: string);
    destructor Destroy; override;
    property Filename: string read FFilename;
    property Content: TStringList read FContent;
    property Units: TStringList read FUnits;
  end;

implementation

uses
  SysUtils;

{ TMapFileReader }

constructor TMapFileReader.Create(const _Filename: string);
begin
  inherited Create;
  FFilename := _Filename;
  FUnits := TStringList.Create;
  FUnits.Sorted := True;
  FContent := TStringList.Create;
  FContent.LoadFromFile(FFilename);
  Parse;
end;

destructor TMapFileReader.Destroy;
begin
  FreeAndNil(FContent);
  FreeAndNil(FUnits);
  inherited;
end;

procedure TMapFileReader.Parse;
var
  i: Integer;
  s: string;
begin
  for i := 0 to FContent.Count - 1 do begin
    s := FContent[i];
    if s = 'Detailed map of segments' then begin
      ParseSegments(i + 2);
      Exit;
    end;
  end;
end;

function TryCutAt(const _SubStr: string; var _Str: string): Boolean;
var
  StartPos: Integer;
begin
  StartPos := Pos(_SubStr, _Str);
  Result := (StartPos > 0);
  if Result then
    _Str := Copy(_Str, StartPos + Length(_SubStr));
end;

procedure TMapFileReader.ParseSegments(_StartIdx: Integer);
var
  i: Integer;
  s: string;
  p: Integer;
begin
  for i := _StartIdx to FContent.Count - 1 do begin
    s := FContent[i];
    if s = '' then
      Exit;
    if TryCutAt(' M=', s) then begin
      p := Pos(' ACBP=', s);
      if p > 0 then begin
        s := Copy(s, 1, p);
        s := Trim(s);
        FUnits.add(s);
      end;
    end;
  end;
end;

end.
