unit u_dzTypInfo;

{$INCLUDE 'jedi.inc'}

interface

uses
  SysUtils,
  TypInfo,
  u_dzTranslator;

  // I am not going to proved support for Variant properties here. I hate Variants.

const
  ///<summary> property types that can be converted to string </summary>
  STRING_PROPERTY_TYPES = [
{$IFDEF FPC}
  tkAString,
  tkUString,
{$ENDIF}
{$IFDEF SUPPORTS_UNICODE}
  tkUString,
{$ENDIF SUPPORTS_UNICODE}
  tkChar, tkString, tkWChar, tkLString, tkWString];
  ///<summary> property types that can be converted to float </summary>
  FLOAT_PROPERTY_TYPES = [tkInteger, tkFloat];

const
  NilMethod: TMethod = (Code: nil; Data: nil);

function TryGetStringProperty(_Instance: TObject; const _Name: string; out _Value: string): Boolean;
function GetStringProperty(_Instance: TObject; const _Name: string; const _Default: string): string; overload;
function GetStringProperty(_Instance: TObject; const _Name: string): string; overload;

{$IFDEF SUPPORTS_EXTENDED}
function TryGetFloatProperty(_Instance: TObject; const _Name: string; out _Value: Extended): Boolean; overload;
{$ENDIF}
function TryGetFloatProperty(_Instance: TObject; const _Name: string; out _Value: Double): Boolean; overload;
function TryGetFloatProperty(_Instance: TObject; const _Name: string; out _Value: Single): Boolean; overload;

{$IFDEF SUPPORTS_EXTENDED}
function GetFloatProperty(_Instance: TObject; const _Name: string; const _Default: Extended): Extended; overload;
function GetFloatProperty(_Instance: TObject; const _Name: string): Extended; overload;
{$ELSE}
function GetFloatProperty(_Instance: TObject; const _Name: string; const _Default: Double): Double; overload;
function GetFloatProperty(_Instance: TObject; const _Name: string): Double; overload;
{$ENDIF SUPPORTS_EXTENDED}

function TryGetObjectProperty(_Instance: TObject; const _Name: string; out _Value: TObject): Boolean;
function GetObjectProperty(_Instance: TObject; const _Name: string; _Default: TObject): TObject; overload;
function GetObjectProperty(_Instance: TObject; const _Name: string): TObject; overload;

function TryGetEventProperty(_Instance: TObject; const _Name: string; out _Value: TMethod): Boolean;
function GetEventProperty(_Instance: TObject; const _Name: string; _Default: TMethod): TMethod; overload;
function GetEventProperty(_Instance: TObject; const _Name: string): TMethod; overload;

implementation

function _(const _s: string): string; inline;
begin
  Result := dzlibGetText(_s);
end;

function TryGetStringProperty(_Instance: TObject; const _Name: string; out _Value: string): Boolean;
var
  PropInfo: PPropInfo;
begin
  PropInfo := GetPropInfo(_Instance.ClassInfo, _Name);
  Result := Assigned(PropInfo) and (PropInfo.PropType^.Kind in STRING_PROPERTY_TYPES);
  if Result then
    _Value := GetPropValue(_Instance, PropInfo)
end;

function GetStringProperty(_Instance: TObject; const _Name: string; const _Default: string): string;
begin
  if not TryGetStringProperty(_Instance, _Name, Result) then
    Result := _Default;
end;

function GetStringProperty(_Instance: TObject; const _Name: string): string; overload;
begin
  if not TryGetStringProperty(_Instance, _Name, Result) then
    raise EPropertyError.CreateFmt(_('String property %s not found.'), [_Name]);
end;

{$IFDEF SUPPORTS_EXTENDED}
function TryGetFloatProperty(_Instance: TObject; const _Name: string; out _Value: Extended): Boolean;
var
  PropInfo: PPropInfo;
begin
  PropInfo := GetPropInfo(_Instance.ClassInfo, _Name);
  Result := Assigned(PropInfo) and (PropInfo.PropType^.Kind in FLOAT_PROPERTY_TYPES);
  if Result then
    _Value := GetPropValue(_Instance, PropInfo)
end;
{$ENDIF}

function TryGetFloatProperty(_Instance: TObject; const _Name: string; out _Value: Double): Boolean;
var
  PropInfo: PPropInfo;
begin
  PropInfo := GetPropInfo(_Instance.ClassInfo, _Name);
  Result := Assigned(PropInfo) and (PropInfo.PropType^.Kind in FLOAT_PROPERTY_TYPES);
  if Result then
    _Value := GetPropValue(_Instance, PropInfo)
end;

function TryGetFloatProperty(_Instance: TObject; const _Name: string; out _Value: Single): Boolean;
var
  PropInfo: PPropInfo;
begin
  PropInfo := GetPropInfo(_Instance.ClassInfo, _Name);
  Result := Assigned(PropInfo) and (PropInfo.PropType^.Kind in FLOAT_PROPERTY_TYPES);
  if Result then
    _Value := GetPropValue(_Instance, PropInfo)
end;

{$IFDEF SUPPORTS_EXTENDED}
function GetFloatProperty(_Instance: TObject; const _Name: string; const _Default: Extended): Extended;
begin
  if not TryGetFloatProperty(_Instance, _Name, Result) then
    Result := _Default;
end;

function GetFloatProperty(_Instance: TObject; const _Name: string): Extended;
begin
  if not TryGetFloatProperty(_Instance, _Name, Result) then
    raise EPropertyError.CreateFmt(_('Float property %s not found.'), [_Name]);
end;
{$ELSE}
function GetFloatProperty(_Instance: TObject; const _Name: string; const _Default: Double): Double;
begin
  if not TryGetFloatProperty(_Instance, _Name, Result) then
    Result := _Default;
end;

function GetFloatProperty(_Instance: TObject; const _Name: string): Double;
begin
  if not TryGetFloatProperty(_Instance, _Name, Result) then
    raise EPropertyError.CreateFmt(_('Float property %s not found.'), [_Name]);
end;
{$ENDIF}

function TryGetObjectProperty(_Instance: TObject; const _Name: string; out _Value: TObject): Boolean;
var
  PropInfo: PPropInfo;
begin
  PropInfo := GetPropInfo(_Instance.ClassInfo, _Name);
  Result := Assigned(PropInfo) and (PropInfo.PropType^.Kind = tkClass);
  if Result then
    _Value := TObject(GetOrdProp(_Instance, PropInfo));
end;

function GetObjectProperty(_Instance: TObject; const _Name: string; _Default: TObject): TObject;
begin
  if not TryGetObjectProperty(_Instance, _Name, Result) then
    Result := _Default;
end;

function GetObjectProperty(_Instance: TObject; const _Name: string): TObject;
begin
  if not TryGetObjectProperty(_Instance, _Name, Result) then
    raise EPropertyError.CreateFmt(_('Object property %s not found.'), [_Name]);
end;

function TryGetEventProperty(_Instance: TObject; const _Name: string; out _Value: TMethod): Boolean;
var
  PropInfo: PPropInfo;
begin
  PropInfo := GetPropInfo(_Instance.ClassInfo, _Name);
  Result := Assigned(PropInfo) and (PropInfo.PropType^.Kind = tkMethod);
  if Result then begin
    _Value := GetMethodProp(_Instance, PropInfo);
  end;
end;

function GetEventProperty(_Instance: TObject; const _Name: string; _Default: TMethod): TMethod;
begin
  if not TryGetEventProperty(_Instance, _Name, Result) then
    Result := _Default;
end;

function GetEventProperty(_Instance: TObject; const _Name: string): TMethod;
begin
  if not TryGetEventProperty(_Instance, _Name, Result) then
    raise EPropertyError.CreateFmt(_('Event property %s not found.'), [_Name]);
end;

end.
